/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.TaskTypes;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

class TaskListPanel
extends JPanel
implements Model.Listener {
    private static final long serialVersionUID = 1L;
    private JPanel buttonPanel = null;
    private JCheckBox showClosedTasksCheckBox = null;
    private JCheckBox showSubTasksBox = null;
    private JLabel totalLabel;
    private TableCellRenderer defaultTableCellRenderer;
    private String filterString = "";
    private boolean filterCaseSensitive = false;
    private String projectName = Resource.getResourceString("All");
    private String taskStatus = Resource.getResourceString("All");
    private StripedTable taskTable;

    private JLabel getTotalLabel() {
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel();
        }
        return this.totalLabel;
    }

    public TaskListPanel() {
        TaskModel.getReference().addListener((Model.Listener)this);
        try {
            this.initComponents();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    public TaskListPanel(String projectName) {
        this.setFilterCriteria(projectName, Resource.getResourceString("All"), "", false);
        TaskModel.getReference().addListener((Model.Listener)this);
        try {
            this.initComponents();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    private Integer getSelectedTaskId() {
        int row = this.taskTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TableSorter tm = (TableSorter)this.taskTable.getModel();
        Integer num = (Integer)tm.getValueAt(row, 0);
        return num;
    }

    private void closeActionPerformed() {
        Integer num = this.getSelectedTaskId();
        if (num == null) {
            return;
        }
        try {
            TaskModel.getReference().close(num.intValue());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void deleteActionPerformed() {
        Integer num = this.getSelectedTaskId();
        if (num == null) {
            return;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_delete_number_") + " " + num, "", 0);
        if (ret == 0) {
            try {
                MultiView.getMainView().removeView(Resource.getResourceString("Item_") + " " + TaskModel.getReference().getTask(num.intValue()).getKey());
                TaskModel.getReference().delete(num.intValue());
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            JButton addbutton = new JButton();
            addbutton.setText(Resource.getResourceString("Add"));
            addbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
            addbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskListPanel.this.task_add();
                }
            });
            this.buttonPanel.add((Component)addbutton, null);
            JButton changebutton1 = new JButton();
            changebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Edit16.gif")));
            changebutton1.setText(Resource.getResourceString("Change"));
            changebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Integer num = TaskListPanel.this.getSelectedTaskId();
                    if (num != null) {
                        TaskListPanel.task_change(num);
                    }
                }
            });
            this.buttonPanel.add((Component)changebutton1, null);
            JButton deletebutton1 = new JButton();
            deletebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
            deletebutton1.setText(Resource.getResourceString("Delete"));
            deletebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskListPanel.this.deleteActionPerformed();
                }
            });
            this.buttonPanel.add((Component)deletebutton1, null);
            JButton closebutton1 = new JButton();
            closebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/greenlight.gif")));
            closebutton1.setText(Resource.getResourceString("Close"));
            closebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskListPanel.this.closeActionPerformed();
                }
            });
            this.buttonPanel.add((Component)closebutton1, null);
            JButton clonebutton1 = new JButton();
            clonebutton1.setIcon(new ImageIcon(this.getClass().getResource("/resource/Copy16.gif")));
            clonebutton1.setText(Resource.getResourceString("Clone"));
            clonebutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Integer num = TaskListPanel.this.getSelectedTaskId();
                    if (num != null) {
                        TaskListPanel.task_clone(num);
                    }
                }
            });
            this.buttonPanel.add((Component)clonebutton1, null);
            this.addSubTaskFilter();
        }
        return this.buttonPanel;
    }

    public void addClosedTaskFilter() {
        this.showClosedTasksCheckBox = new JCheckBox();
        this.showClosedTasksCheckBox.setText(Resource.getResourceString("show_closed_tasks"));
        this.showClosedTasksCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskListPanel.this.refresh();
            }
        });
        this.buttonPanel.add(this.showClosedTasksCheckBox);
        this.refresh();
    }

    private void addSubTaskFilter() {
        this.showSubTasksBox = new JCheckBox();
        this.showSubTasksBox.setText(Resource.getResourceString("show_subtasks"));
        this.showSubTasksBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskListPanel.this.refresh();
            }
        });
    }

    private void initComponents() throws Exception {
        this.setLayout(new GridBagLayout());
        this.taskTable = new StripedTable();
        this.defaultTableCellRenderer = this.taskTable.getDefaultRenderer(Integer.class);
        this.taskTable.setDefaultRenderer(Integer.class, new DLRenderer());
        this.taskTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Item_#"), Resource.getResourceString("Status"), Resource.getResourceString("Type"), Resource.getResourceString("Pri"), Resource.getResourceString("Days_Left"), Resource.getResourceString("summary"), Resource.getResourceString("Start_Date"), Resource.getResourceString("Due_Date"), Resource.getResourceString("close_date"), Resource.getResourceString("duration"), Resource.getResourceString("elapsed_time"), Resource.getResourceString("project"), Resource.getResourceString("Category")}, new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, String.class, Date.class, Date.class, Date.class, Integer.class, Integer.class, String.class, String.class}));
        TableSorter tm = (TableSorter)this.taskTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.taskTable);
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        JScrollPane taskScroll = new JScrollPane();
        taskScroll.setViewportView(this.taskTable);
        taskScroll.setBorder(BorderFactory.createBevelBorder(1));
        this.taskTable.setAutoResizeMode(0);
        this.taskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                Integer num = TaskListPanel.this.getSelectedTaskId();
                if (num != null) {
                    TaskListPanel.task_change(num);
                }
            }
        });
        this.taskTable.setSelectionMode(0);
        this.taskTable.getColumnModel().getColumn(8).setPreferredWidth(100);
        this.taskTable.getColumnModel().getColumn(7).setPreferredWidth(100);
        this.taskTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.taskTable.getColumnModel().getColumn(5).setPreferredWidth(400);
        this.taskTable.setPreferredScrollableViewportSize(new Dimension(800, 200));
        new PopupMenuHelper(this.taskTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskListPanel.this.task_add();
            }
        }, "Add"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Integer num = TaskListPanel.this.getSelectedTaskId();
                if (num != null) {
                    TaskListPanel.task_change(num);
                }
            }
        }, "Change"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Integer num = TaskListPanel.this.getSelectedTaskId();
                if (num != null) {
                    TaskListPanel.task_clone(num);
                }
            }
        }, "Clone"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskListPanel.this.deleteActionPerformed();
            }
        }, "Delete"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskListPanel.this.closeActionPerformed();
            }
        }, "Close")});
        this.add((Component)taskScroll, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JPanel midPanel = new JPanel(new BorderLayout());
        midPanel.add((Component)this.getTotalLabel(), "West");
        midPanel.add((Component)this.getButtonPanel(), "Center");
        this.add((Component)midPanel, GridBagConstraintsFactory.create(0, 1, 1));
        this.refresh();
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void print() {
        try {
            TablePrinter.printTable(this.taskTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void refresh() {
        TableSorter tm = (TableSorter)this.taskTable.getModel();
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        Integer projfiltid = null;
        if (!this.projectName.equals(Resource.getResourceString("All"))) {
            try {
                projfiltid = TaskView.getProjectId(this.projectName);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
        }
        String subtaskString = Resource.getResourceString("subtask");
        try {
            TaskTypes tasktypes = TaskModel.getReference().getTaskTypes();
            Collection tasks = TaskModel.getReference().getTasks();
            int totalItems = 0;
            for (Task task : tasks) {
                Project p;
                String st = task.getState();
                if (!this.taskStatus.equals(Resource.getResourceString("All_Open")) ? !this.taskStatus.equals(Resource.getResourceString("All")) && !this.taskStatus.equals(st) : TaskModel.isClosed((Task)task)) continue;
                if (this.showClosedTasksCheckBox != null && !this.showClosedTasksCheckBox.isSelected() && TaskModel.isClosed((Task)task)) continue;
                Integer pid = task.getProject();
                if (projfiltid != null && (pid == null || pid.intValue() != projfiltid.intValue()) || !CategoryModel.getReference().isShown(task.getCategory())) continue;
                if (this.filterString.length() != 0) {
                    String s = task.getSummary();
                    String d = task.getDescription();
                    String r = task.getResolution();
                    if (r == null) {
                        r = "";
                    }
                    if (s == null) {
                        s = "";
                    }
                    if (d == null) {
                        d = "";
                    }
                    if (this.filterCaseSensitive) {
                        if (d.indexOf(this.filterString) == -1 && r.indexOf(this.filterString) == -1 && s.indexOf(this.filterString) == -1) {
                            continue;
                        }
                    } else {
                        String lfilt = this.filterString.toLowerCase();
                        String ld = d.toLowerCase();
                        String lr = r.toLowerCase();
                        String ls = s.toLowerCase();
                        if (ld.indexOf(lfilt) == -1 && lr.indexOf(lfilt) == -1 && ls.indexOf(lfilt) == -1) continue;
                    }
                }
                Object[] ro = new Object[13];
                ro[0] = new Integer(task.getKey());
                ro[1] = task.getState();
                ro[2] = task.getType();
                ro[12] = task.getCategory();
                ro[3] = task.getPriority();
                ro[6] = task.getStartDate();
                ro[7] = task.getDueDate();
                ro[8] = task.getCompletionDate();
                ro[9] = task.getDueDate() != null ? new Integer(TaskModel.daysBetween((Date)task.getStartDate(), (Date)task.getDueDate())) : null;
                Date end = null;
                end = task.getState().equals(tasktypes.getFinalState(task.getType())) ? task.getCompletionDate() : new Date();
                ro[10] = end == null ? null : new Integer(TaskModel.daysBetween((Date)task.getStartDate(), (Date)end));
                if (ro[7] == null || TaskModel.isClosed((Task)task)) {
                    ro[4] = null;
                } else {
                    Date dd = (Date)ro[7];
                    ro[4] = new Integer(TaskModel.daysLeft((Date)dd));
                }
                ro[5] = task.getSummary();
                String ps = "";
                if (pid != null && (p = TaskModel.getReference().getProject(pid.intValue())) != null) {
                    String tt = p.getDescription();
                    for (int i = 0; tt != null && i < tt.length(); ++i) {
                        char c = tt.charAt(i);
                        ps = c == '\n' || c == '\r' ? ps + ' ' : ps + c;
                    }
                }
                ro[11] = ps;
                tm.addRow(ro);
                ++totalItems;
                if (this.showSubTasksBox.isSelected()) {
                    Collection subtasks = TaskModel.getReference().getSubTasks(task.getKey());
                    for (Subtask subtask : subtasks) {
                        ro = new Object[12];
                        ro[0] = null;
                        ro[1] = subtask.getCloseDate() == null ? Resource.getResourceString("OPEN") : Resource.getResourceString("CLOSED");
                        ro[2] = subtaskString;
                        ro[11] = task.getCategory();
                        ro[3] = task.getPriority();
                        ro[6] = subtask.getStartDate();
                        ro[7] = subtask.getDueDate();
                        ro[8] = subtask.getDueDate() != null ? new Integer(TaskModel.daysBetween((Date)subtask.getStartDate(), (Date)subtask.getDueDate())) : null;
                        end = null;
                        end = subtask.getCloseDate() != null ? subtask.getCloseDate() : new Date();
                        ro[9] = end == null ? null : new Integer(TaskModel.daysBetween((Date)subtask.getStartDate(), (Date)end));
                        if (ro[7] == null || subtask.getCloseDate() != null) {
                            ro[4] = null;
                        } else {
                            Date dd = (Date)ro[7];
                            ro[4] = new Integer(TaskModel.daysLeft((Date)dd));
                        }
                        ro[5] = subtask.getDescription();
                        ro[10] = ps;
                        tm.addRow(ro);
                    }
                }
                tm.tableChanged(new TableModelEvent(tm));
            }
            this.getTotalLabel().setText(totalItems + " items");
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        if (!tm.isSorted()) {
            tm.sortByColumn(6);
        } else {
            tm.sort();
        }
    }

    public void setFilterCriteria(String projectName, String status, String filter, boolean caseSensitive) {
        this.projectName = projectName;
        this.taskStatus = status;
        this.filterString = filter;
        this.filterCaseSensitive = caseSensitive;
    }

    private void task_add() {
        try {
            Integer projfiltid = null;
            if (!this.projectName.equals(Resource.getResourceString("All"))) {
                try {
                    projfiltid = TaskView.getProjectId(this.projectName);
                    Project p = TaskModel.getReference().getProject(projfiltid.intValue());
                    if (p == null) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("project_not_found"));
                        return;
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
            new TaskView(null, TaskView.Action.ADD, projfiltid).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static void task_change(int tasknum) {
        try {
            Task task = TaskModel.getReference().getTask(tasknum);
            if (task == null) {
                return;
            }
            new TaskView(task, TaskView.Action.CHANGE, null).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static void task_clone(int tasknum) {
        try {
            Task task = TaskModel.getReference().getTask(tasknum);
            if (task == null) {
                return;
            }
            new TaskView(task, TaskView.Action.CLONE, null).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private class DLRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public DLRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)TaskListPanel.this.defaultTableCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            if (obj == null) {
                l.setText("--");
                l.setHorizontalAlignment(0);
                return l;
            }
            String nm = table.getColumnName(column);
            if (!nm.equals(Resource.getResourceString("Pri")) && !nm.equals(Resource.getResourceString("Days_Left"))) {
                return l;
            }
            if (isSelected) {
                return l;
            }
            this.setText(l.getText());
            this.setHorizontalAlignment(0);
            this.setBackground(l.getBackground());
            this.setForeground(l.getForeground());
            int i = (Integer)obj;
            if (nm.equals(Resource.getResourceString("Pri"))) {
                if (i == 1) {
                    this.setBackground(new Color(255, 120, 120));
                } else if (i == 2) {
                    this.setBackground(new Color(255, 200, 120));
                } else if (i == 3) {
                    this.setBackground(new Color(255, 255, 175));
                } else if (i == 4) {
                    this.setBackground(new Color(220, 220, 255));
                } else if (i == 5) {
                    this.setBackground(new Color(200, 255, 175));
                }
                return this;
            }
            if (i < Prefs.getIntPref(PrefName.YELLOW_DAYS)) {
                this.setBackground(new Color(255, 255, 175));
            }
            if (i < Prefs.getIntPref(PrefName.ORANGE_DAYS)) {
                this.setBackground(new Color(255, 200, 120));
            }
            if (i < Prefs.getIntPref(PrefName.RED_DAYS)) {
                this.setBackground(new Color(255, 120, 120));
            }
            return this;
        }
    }
}

