/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.task.ProjectPanel;
import net.sf.borg.ui.task.ProjectTreePanel;
import net.sf.borg.ui.task.TaskConfigurator;
import net.sf.borg.ui.task.TaskFilterPanel;
import net.sf.borg.ui.task.TaskListPanel;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class TaskModule
extends DockableView
implements MultiView.Module {
    private static final long serialVersionUID = 1L;
    private JTabbedPane taskTabs;
    private boolean isInitialized = false;

    @Override
    public String getModuleName() {
        return Resource.getResourceString("tasks");
    }

    @Override
    public JComponent getComponent() {
        if (!this.isInitialized) {
            this.taskTabs = new JTabbedPane();
            this.taskTabs.addTab(Resource.getResourceString("project_tree"), new ProjectTreePanel());
            this.taskTabs.addTab(Resource.getResourceString("projects"), new ProjectPanel());
            this.taskTabs.addTab(Resource.getResourceString("tasks"), new TaskFilterPanel());
            this.setLayout(new GridBagLayout());
            this.add((Component)this.taskTabs, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/Task16.gif")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.TASK);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.TASK);
            }
        });
        JMenuItem edittypes = new JMenuItem();
        JMenuItem resetst = new JMenuItem();
        ResourceHelper.setText(edittypes, "edit_types");
        edittypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    TaskConfigurator.getReference().setVisible(true);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        MultiView.getMainView().addOptionsMenuItem(edittypes);
        ResourceHelper.setText(resetst, "Reset_Task_States_to_Default");
        resetst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskModule.resetstActionPerformed();
            }
        });
        MultiView.getMainView().addOptionsMenuItem(resetst);
    }

    private static void resetstActionPerformed() {
        try {
            String msg = Resource.getResourceString("reset_state_warning");
            int ret = JOptionPane.showConfirmDialog(null, msg, Resource.getResourceString("Import_WARNING"), 2);
            if (ret != 0) {
                return;
            }
            TaskModel taskmod_ = TaskModel.getReference();
            taskmod_.getTaskTypes().loadDefault();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void print() {
        Component c = this.taskTabs.getSelectedComponent();
        if (c instanceof ProjectPanel) {
            ((ProjectPanel)c).print();
        } else if (c instanceof TaskListPanel) {
            ((TaskListPanel)c).print();
        } else if (c instanceof TaskFilterPanel) {
            ((TaskFilterPanel)c).print();
        } else {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("No_Print"));
        }
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.TASK;
    }

    @Override
    public String getFrameTitle() {
        return this.getModuleName();
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
    }
}

