/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.task;

import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JDateChooserCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.model.entity.Tasklog;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.link.LinkPanel;
import net.sf.borg.ui.util.DateDialog;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.LimitDocument;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TableSorter;

public class TaskView
extends DockableView {
    private static final long serialVersionUID = 1L;
    private LinkPanel linkPanel;
    private JComboBox<String> categoryComboBox = null;
    private JTextField closeDate = null;
    private JTextField daysLeftText = null;
    private TableCellRenderer defaultDateCellRenderer;
    private TableCellRenderer defaultIntegerCellRenderer;
    private JDateChooser dueDateChooser;
    private Integer parentProject = null;
    private JTextField taskIdText;
    private JTabbedPane taskTabbedPanel;
    private JTextField summaryText;
    private JTextArea descriptionText;
    private JTextArea resolutionText;
    private StripedTable logtable = new StripedTable();
    private JTextField personAssignedText;
    private JComboBox<Integer> priorityText;
    private JComboBox<String> projectComboBox = new JComboBox();
    private StripedTable subTaskTable = new StripedTable();
    private JDateChooser startDateChooser;
    private JComboBox<String> statusComboBox;
    private ArrayList<Integer> subTaskIdsToBeDeleted = new ArrayList();
    private String windowTitle = "";
    private JComboBox<String> taskTypeComboBox;

    public static Integer getProjectId(String s) throws Exception {
        int i = s.indexOf(":");
        if (i == -1) {
            throw new Exception("Cannot parse project label");
        }
        String ss = s.substring(0, i);
        int pid = Integer.parseInt(ss);
        return new Integer(pid);
    }

    public static String getProjectString(Project p) {
        String desc = p.getDescription();
        if (desc != null && desc.length() > 20) {
            desc = desc.substring(0, 20) + "...";
        }
        return p.getKey() + ":" + desc;
    }

    public TaskView(Task task, Action function, Integer projectid) throws Exception {
        this.addModel((Model)LinkModel.getReference());
        this.addModel((Model)TaskModel.getReference());
        this.parentProject = projectid;
        this.initComponents();
        this.initSubtaskTable();
        this.initLogTable();
        this.descriptionText.setRows(15);
        this.descriptionText.setColumns(40);
        try {
            Collection cats = CategoryModel.getReference().getCategories();
            Iterator it = cats.iterator();
            while (it.hasNext()) {
                this.categoryComboBox.addItem((String)it.next());
            }
            this.categoryComboBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.showtask(function, task);
        this.refresh();
    }

    @Override
    public String getFrameTitle() {
        return this.windowTitle;
    }

    private Integer[] getSelectedSubtaskIds() {
        TableSorter ts = (TableSorter)this.subTaskTable.getModel();
        int[] indices = this.subTaskTable.getSelectedRows();
        Integer[] ret = new Integer[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            ret[i] = (Integer)ts.getValueAt(index, 1);
        }
        return ret;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        JPanel taskInformationPanel = new JPanel();
        taskInformationPanel.setLayout(new GridBagLayout());
        taskInformationPanel.setBorder(new TitledBorder(Resource.getResourceString("TaskInformation")));
        this.taskIdText = new JTextField();
        JLabel lblItemNum = new JLabel();
        JLabel lblStatus = new JLabel();
        this.startDateChooser = new JDateChooser();
        this.dueDateChooser = new JDateChooser();
        this.priorityText = new JComboBox();
        for (int p = 1; p <= 5; ++p) {
            this.priorityText.addItem(new Integer(p));
        }
        this.personAssignedText = new JTextField(new LimitDocument(10), null, 10);
        JLabel lblStartDate = new JLabel();
        JLabel lblDueDate = new JLabel();
        JLabel lblPri = new JLabel();
        JLabel lblPA = new JLabel();
        JLabel lblType = new JLabel();
        this.statusComboBox = new JComboBox();
        this.taskTypeComboBox = new JComboBox();
        JLabel categoryLabel = new JLabel();
        JLabel closeLabel = new JLabel();
        closeLabel.setText("");
        JLabel daysLeftLabel = new JLabel();
        daysLeftLabel.setText(Resource.getResourceString("Days_Left"));
        this.daysLeftText = new JTextField();
        this.daysLeftText.setEditable(false);
        this.closeDate = new JTextField();
        this.closeDate.setEditable(false);
        ResourceHelper.setText(closeLabel, "close_date");
        JLabel prLabel = new JLabel(Resource.getResourceString("project"));
        this.taskIdText.setText("taskIdText");
        ResourceHelper.setText(lblItemNum, "Item_#");
        lblItemNum.setLabelFor(this.taskIdText);
        ResourceHelper.setText(lblStatus, "Status");
        lblStatus.setLabelFor(this.statusComboBox);
        ResourceHelper.setText(lblStartDate, "Start_Date");
        lblStartDate.setLabelFor((Component)this.startDateChooser);
        ResourceHelper.setText(lblDueDate, "Due_Date");
        lblDueDate.setLabelFor((Component)this.dueDateChooser);
        ResourceHelper.setText(lblPri, "Pri");
        lblPri.setLabelFor(this.priorityText);
        ResourceHelper.setText(lblPA, "PA");
        lblPA.setLabelFor(this.personAssignedText);
        ResourceHelper.setText(lblType, "Type");
        lblType.setLabelFor(this.taskTypeComboBox);
        ResourceHelper.setText(categoryLabel, "Category");
        this.categoryComboBox = new JComboBox();
        categoryLabel.setLabelFor(this.categoryComboBox);
        this.summaryText = new JTextField();
        taskInformationPanel.add((Component)lblItemNum, GridBagConstraintsFactory.create(0, 0, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)lblStatus, GridBagConstraintsFactory.create(0, 1, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)lblType, GridBagConstraintsFactory.create(0, 2, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)this.taskIdText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        taskInformationPanel.add(this.statusComboBox, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        taskInformationPanel.add(this.taskTypeComboBox, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)categoryLabel, GridBagConstraintsFactory.create(2, 0, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)prLabel, GridBagConstraintsFactory.create(2, 1, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)lblPri, GridBagConstraintsFactory.create(2, 2, 1, 0.0, 0.0));
        taskInformationPanel.add(this.categoryComboBox, GridBagConstraintsFactory.create(3, 0, 1, 1.0, 0.0));
        taskInformationPanel.add(this.projectComboBox, GridBagConstraintsFactory.create(3, 1, 1, 1.0, 0.0));
        taskInformationPanel.add(this.priorityText, GridBagConstraintsFactory.create(3, 2, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)lblStartDate, GridBagConstraintsFactory.create(4, 0, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)lblDueDate, GridBagConstraintsFactory.create(4, 1, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)closeLabel, GridBagConstraintsFactory.create(4, 2, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)this.startDateChooser, GridBagConstraintsFactory.create(5, 0, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)this.dueDateChooser, GridBagConstraintsFactory.create(5, 1, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)this.closeDate, GridBagConstraintsFactory.create(5, 2, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)lblPA, GridBagConstraintsFactory.create(6, 0, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)daysLeftLabel, GridBagConstraintsFactory.create(6, 1, 1, 0.0, 0.0));
        taskInformationPanel.add((Component)this.personAssignedText, GridBagConstraintsFactory.create(7, 0, 1, 1.0, 0.0));
        taskInformationPanel.add((Component)this.daysLeftText, GridBagConstraintsFactory.create(7, 1, 1, 1.0, 0.0));
        topPanel.add((Component)taskInformationPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 0.0));
        JLabel l = new JLabel();
        l.setText(Resource.getResourceString("summary"));
        taskInformationPanel.add((Component)l, GridBagConstraintsFactory.create(0, 3, 1));
        GridBagConstraints gbc = GridBagConstraintsFactory.create(1, 3, 1);
        gbc.gridwidth = 0;
        taskInformationPanel.add((Component)this.summaryText, gbc);
        this.taskTabbedPanel = new JTabbedPane();
        JScrollPane descriptionScroll = new JScrollPane();
        this.descriptionText = new JTextArea(new LimitDocument(Prefs.getIntPref(PrefName.MAX_TEXT_SIZE)));
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setName("Description");
        descriptionScroll.setViewportView(this.descriptionText);
        this.taskTabbedPanel.addTab(Resource.getResourceString("Description"), descriptionScroll);
        JScrollPane resolutionScroll = new JScrollPane();
        this.resolutionText = new JTextArea(new LimitDocument(Prefs.getIntPref(PrefName.MAX_TEXT_SIZE)));
        this.resolutionText.setLineWrap(true);
        resolutionScroll.setViewportView(this.resolutionText);
        this.taskTabbedPanel.addTab(Resource.getResourceString("Resolution"), resolutionScroll);
        JScrollPane logPane = new JScrollPane();
        logPane.setViewportView(this.logtable);
        this.taskTabbedPanel.addTab(Resource.getResourceString("history"), logPane);
        this.linkPanel = new LinkPanel();
        this.taskTabbedPanel.addTab(Resource.getResourceString("links"), this.linkPanel);
        JScrollPane subTaskScroll = new JScrollPane();
        subTaskScroll.setPreferredSize(new Dimension(300, 300));
        subTaskScroll.setViewportView(this.subTaskTable);
        JPanel subTaskPanel = new JPanel();
        subTaskPanel.setLayout(new GridBagLayout());
        subTaskPanel.setBorder(new TitledBorder(Resource.getResourceString("SubTasks")));
        subTaskPanel.add((Component)subTaskScroll, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JSplitPane taskSplitPane = new JSplitPane();
        taskSplitPane.setOrientation(0);
        taskSplitPane.setBottomComponent(subTaskPanel);
        taskSplitPane.setPreferredSize(new Dimension(400, 400));
        taskSplitPane.setDividerLocation(200);
        taskSplitPane.setOneTouchExpandable(true);
        taskSplitPane.setTopComponent(this.taskTabbedPanel);
        topPanel.add((Component)taskSplitPane, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
        JPanel buttonPanel = new JPanel();
        JButton savebutton = new JButton();
        topPanel.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 2));
        savebutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(savebutton, "Save");
        savebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskView.this.savetask();
            }
        });
        buttonPanel.add((Component)savebutton, savebutton.getName());
        this.add((Component)topPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
    }

    private void initLogTable() {
        this.logtable.setModel(new TableSorter(new String[]{Resource.getResourceString("Date"), Resource.getResourceString("Description")}, new Class[]{Date.class, String.class}, new boolean[]{false, false}));
        this.logtable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.logtable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.logtable.setDefaultRenderer(Date.class, new LogTableDateRenderer());
        TableSorter ts = (TableSorter)this.logtable.getModel();
        ts.sortByColumn(0);
        ts.addMouseListenerToHeaderInTable(this.logtable);
        new PopupMenuHelper(this.logtable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String tasknum = TaskView.this.taskIdText.getText();
                if (tasknum.equals("CLONE") || tasknum.equals("NEW")) {
                    return;
                }
                String logentry = JOptionPane.showInputDialog(Resource.getResourceString("Enter_Log"));
                if (logentry == null) {
                    return;
                }
                try {
                    TaskModel.getReference().addLog(Integer.parseInt(tasknum), logentry);
                    TaskView.this.loadLog(Integer.parseInt(tasknum));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        }, "Add_Log")});
    }

    private void initSubtaskTable() {
        this.defaultIntegerCellRenderer = this.subTaskTable.getDefaultRenderer(Integer.class);
        this.defaultDateCellRenderer = this.subTaskTable.getDefaultRenderer(Date.class);
        this.subTaskTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Closed"), Resource.getResourceString("subtask_id"), Resource.getResourceString("Description"), Resource.getResourceString("Start_Date"), Resource.getResourceString("Due_Date"), Resource.getResourceString("duration"), Resource.getResourceString("Days_Left"), Resource.getResourceString("close_date")}, new Class[]{Boolean.class, Integer.class, String.class, Date.class, Date.class, Integer.class, Integer.class, Date.class}, new boolean[]{true, false, true, true, true, false, false, false}));
        this.subTaskTable.setDefaultRenderer(Integer.class, new SubtaskIntRenderer());
        this.subTaskTable.setDefaultRenderer(Date.class, new SubTaskDueDateRenderer());
        this.subTaskTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.subTaskTable.getColumnModel().getColumn(1).setPreferredWidth(5);
        this.subTaskTable.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.subTaskTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        this.subTaskTable.getColumnModel().getColumn(4).setPreferredWidth(30);
        this.subTaskTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        this.subTaskTable.getColumnModel().getColumn(6).setPreferredWidth(30);
        this.subTaskTable.getColumnModel().getColumn(7).setPreferredWidth(30);
        this.subTaskTable.setDefaultEditor(Date.class, (TableCellEditor)new JDateChooserCellEditor());
        TableSorter ts = (TableSorter)this.subTaskTable.getModel();
        this.subTaskTable.getSelectionModel().setSelectionMode(0);
        this.subTaskTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getSource() instanceof TableSorter) {
                    return;
                }
                if (arg0.getType() == 1) {
                    return;
                }
                if (arg0.getType() == -1) {
                    return;
                }
                TableSorter model = (TableSorter)TaskView.this.subTaskTable.getModel();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    String text = (String)model.getValueAt(i, 2);
                    if (text != null && !text.isEmpty()) continue;
                    return;
                }
                Object[] o = new Object[]{new Boolean(false), null, null, null, null, null, null};
                model.addRow(o);
            }
        });
        ts.addMouseListenerToHeaderInTable(this.subTaskTable);
        final JPopupMenu stmenu = PopupMenuHelper.createPopupMenu(new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter ts2 = (TableSorter)TaskView.this.subTaskTable.getModel();
                Integer[] ids = TaskView.this.getSelectedSubtaskIds();
                block0: for (int i = 0; i < ids.length; ++i) {
                    if (ids[i] == null) continue;
                    for (int row = 0; row < ts2.getRowCount(); ++row) {
                        Integer rowid = (Integer)ts2.getValueAt(row, 1);
                        if (rowid == null || rowid.intValue() != ids[i].intValue()) continue;
                        ts2.setValueAt(null, row, 4);
                        continue block0;
                    }
                }
            }
        }, "Clear_DueDate"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter ts2 = (TableSorter)TaskView.this.subTaskTable.getModel();
                int[] indices = TaskView.this.subTaskTable.getSelectedRows();
                if (indices.length == 0) {
                    return;
                }
                DateDialog dlg = new DateDialog(null);
                dlg.setCalendar(new GregorianCalendar());
                dlg.setVisible(true);
                Calendar dlgcal = dlg.getCalendar();
                if (dlgcal == null) {
                    return;
                }
                Integer[] ids = TaskView.this.getSelectedSubtaskIds();
                block0: for (int i = 0; i < ids.length; ++i) {
                    if (ids[i] == null) continue;
                    for (int row = 0; row < ts2.getRowCount(); ++row) {
                        Integer rowid = (Integer)ts2.getValueAt(row, 1);
                        if (rowid == null || rowid.intValue() != ids[i].intValue()) continue;
                        ts2.setValueAt(dlgcal.getTime(), row, 4);
                        continue block0;
                    }
                }
            }
        }, "Set_DueDate"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter ts2 = (TableSorter)TaskView.this.subTaskTable.getModel();
                Integer[] ids = TaskView.this.getSelectedSubtaskIds();
                if (ids.length == 0) {
                    return;
                }
                int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
                if (ret != 0) {
                    return;
                }
                block0: for (int i = 0; i < ids.length; ++i) {
                    if (ids[i] == null) continue;
                    TaskView.this.subTaskIdsToBeDeleted.add(ids[i]);
                    for (int row = 0; row < ts2.getRowCount(); ++row) {
                        Integer rowid = (Integer)ts2.getValueAt(row, 1);
                        if (rowid == null || rowid.intValue() != ids[i].intValue()) continue;
                        ts2.setValueAt(new Boolean(false), row, 0);
                        ts2.setValueAt(null, row, 1);
                        ts2.setValueAt(null, row, 2);
                        ts2.setValueAt(null, row, 3);
                        ts2.setValueAt(null, row, 4);
                        ts2.setValueAt(null, row, 5);
                        ts2.setValueAt(null, row, 6);
                        ts2.setValueAt(null, row, 7);
                        continue block0;
                    }
                }
                if (ts2.getRowCount() == 0) {
                    TaskView.this.insertSubtask();
                }
            }
        }, "Delete")});
        this.subTaskTable.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = TaskView.this.subTaskTable.rowAtPoint(e.getPoint());
                    if (row != -1 && !TaskView.this.subTaskTable.isRowSelected(row)) {
                        TaskView.this.subTaskTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    if (TaskView.this.rowsSelected()) {
                        stmenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        });
    }

    private boolean rowsSelected() {
        Integer[] ids = this.getSelectedSubtaskIds();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            return true;
        }
        return false;
    }

    private void insertSubtask() {
        Object[] o = new Object[]{new Boolean(false), null, null, null, null, null, null};
        TableSorter ts = (TableSorter)this.subTaskTable.getModel();
        ts.addRow(o);
    }

    private void loadLog(int taskid) throws Exception {
        TableSorter tslog = (TableSorter)this.logtable.getModel();
        tslog.setRowCount(0);
        Collection logs = TaskModel.getReference().getLogs(taskid);
        for (Tasklog log : logs) {
            Object[] o = new Object[]{log.getLogTime(), log.getDescription()};
            tslog.addRow(o);
        }
    }

    @Override
    public void refresh() {
        if (this.linkPanel != null && this.linkPanel.hasLinks()) {
            this.taskTabbedPanel.setForegroundAt(3, Color.red);
        } else {
            this.taskTabbedPanel.setForegroundAt(3, Color.black);
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
        if (event.getAction() == Model.ChangeEvent.ChangeAction.DELETE && event.getObject() instanceof Task && ((Task)event.getObject()).getKey() == this.getShownId()) {
            try {
                this.showtask(Action.ADD, null);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    private void saveSubtasks(Task task) throws Warning, Exception {
        int tasknum = task.getKey();
        for (Integer id : this.subTaskIdsToBeDeleted) {
            TaskModel.getReference().deleteSubTask(id.intValue());
            TaskModel.getReference().addLog(tasknum, Resource.getResourceString("subtask") + " " + id.toString() + " " + Resource.getResourceString("deleted"));
        }
        this.subTaskIdsToBeDeleted.clear();
        if (this.subTaskTable.isEditing()) {
            this.subTaskTable.getCellEditor().stopCellEditing();
        }
        TableSorter ts = (TableSorter)this.subTaskTable.getModel();
        for (int r = 0; r < this.subTaskTable.getRowCount(); ++r) {
            Object desc = ts.getValueAt(r, 2);
            if (desc == null || desc.equals("")) continue;
            Integer id = (Integer)ts.getValueAt(r, 1);
            Boolean closed = (Boolean)ts.getValueAt(r, 0);
            if (TaskModel.isClosed((Task)task) && id == null && !closed.booleanValue()) continue;
            Date crd = (Date)ts.getValueAt(r, 3);
            if (crd == null && task.getStartDate().before(new Date())) {
                crd = new Date();
            } else if (crd == null) {
                crd = task.getStartDate();
            }
            Date dd = (Date)ts.getValueAt(r, 4);
            Date cd = (Date)ts.getValueAt(r, 7);
            boolean closing = false;
            if (closed.booleanValue() && cd == null) {
                cd = new Date();
                closing = true;
            } else if (!closed.booleanValue() && cd != null) {
                cd = null;
            }
            Subtask s = new Subtask();
            if (id != null) {
                s.setKey(id.intValue());
            }
            s.setDescription((String)desc);
            s.setCloseDate(cd);
            s.setDueDate(dd);
            if (!closed.booleanValue() && dd != null && task.getDueDate() != null && DateUtil.isAfter(dd, task.getDueDate())) {
                String msg = Resource.getResourceString("stdd_warning") + ": " + desc;
                throw new Warning(msg);
            }
            s.setStartDate(crd);
            if (!closed.booleanValue() && crd != null && task.getStartDate() != null && DateUtil.isAfter(task.getStartDate(), crd)) {
                String msg = Resource.getResourceString("stsd_warning") + ": " + desc;
                throw new Warning(msg);
            }
            if (s.getStartDate() != null && s.getDueDate() != null && DateUtil.isAfter(s.getStartDate(), s.getDueDate())) {
                String msg = Resource.getResourceString("sd_dd_warn") + ": " + desc;
                throw new Warning(msg);
            }
            s.setTask(new Integer(tasknum));
            TaskModel.getReference().saveSubTask(s);
            if (id == null || id == 0) {
                TaskModel.getReference().addLog(tasknum, Resource.getResourceString("subtask") + " " + s.getKey() + " " + Resource.getResourceString("created") + ": " + s.getDescription());
            }
            if (!closing) continue;
            TaskModel.getReference().addLog(tasknum, Resource.getResourceString("subtask") + " " + s.getKey() + " " + Resource.getResourceString("Closed") + ": " + s.getDescription());
        }
    }

    private void savetask() {
        if (this.summaryText.getText() == null || this.summaryText.getText().trim().equals("")) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("empty_summ"));
            return;
        }
        try {
            Project p;
            String num = this.taskIdText.getText();
            TaskModel.getReference();
            TaskModel.beginTransaction();
            Task task = TaskModel.getReference().newMR();
            TableSorter ts = (TableSorter)this.subTaskTable.getModel();
            if (num.equals("NEW")) {
                String[] prefDefinedTasks = TaskModel.getReference().getTaskTypes().getSubTasks((String)this.taskTypeComboBox.getSelectedItem());
                for (int i = 0; i < prefDefinedTasks.length; ++i) {
                    Object[] o = new Object[]{new Boolean(false), null, prefDefinedTasks[i], new Date(), null, null};
                    ts.addRow(o);
                }
                task.setState(TaskModel.getReference().getTaskTypes().getInitialState((String)this.taskTypeComboBox.getSelectedItem()));
            } else if (num.equals("CLONE")) {
                task.setState(TaskModel.getReference().getTaskTypes().getInitialState((String)this.taskTypeComboBox.getSelectedItem()));
            } else {
                task.setKey(new Integer(num).intValue());
                task.setState((String)this.statusComboBox.getSelectedItem());
            }
            task.setType((String)this.taskTypeComboBox.getSelectedItem());
            Calendar cal = this.startDateChooser.getCalendar();
            if (cal == null) {
                cal = new GregorianCalendar();
            }
            task.setStartDate(cal.getTime());
            cal = this.dueDateChooser.getCalendar();
            if (cal != null) {
                task.setDueDate(cal.getTime());
            }
            if (task.getDueDate() != null && DateUtil.isAfter(task.getStartDate(), task.getDueDate())) {
                throw new Warning(Resource.getResourceString("sd_dd_warn"));
            }
            Integer pri = (Integer)this.priorityText.getSelectedItem();
            task.setPriority(pri);
            task.setPersonAssigned(this.personAssignedText.getText());
            task.setSummary(this.summaryText.getText());
            task.setDescription(this.descriptionText.getText());
            task.setResolution(this.resolutionText.getText());
            String cat = (String)this.categoryComboBox.getSelectedItem();
            if (cat.equals("") || cat.equals(CategoryModel.UNCATEGORIZED)) {
                task.setCategory(null);
            } else {
                task.setCategory(cat);
            }
            task.setProject(null);
            String proj = (String)this.projectComboBox.getSelectedItem();
            try {
                task.setProject(TaskView.getProjectId(proj));
            }
            catch (Exception e) {
                // empty catch block
            }
            Integer pid = task.getProject();
            if (pid != null && task.getStartDate() != null && (p = TaskModel.getReference().getProject(pid.intValue())).getStartDate() != null && DateUtil.isAfter(p.getStartDate(), task.getStartDate())) {
                throw new Warning(Resource.getResourceString("proj_sd_warning"));
            }
            if (cat.equals("") || cat.equals(CategoryModel.UNCATEGORIZED)) {
                task.setCategory(null);
            } else {
                task.setCategory(cat);
            }
            if (TaskModel.isClosed((Task)task)) {
                for (int r = 0; r < this.subTaskTable.getRowCount(); ++r) {
                    Boolean closed = (Boolean)ts.getValueAt(r, 0);
                    Integer id = (Integer)ts.getValueAt(r, 1);
                    if (id == null || id == 0 || closed.booleanValue()) continue;
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("open_subtasks"));
                    return;
                }
            }
            Task orig = TaskModel.getReference().getTask(task.getKey());
            TaskModel.getReference().savetask(task);
            if (num.equals("NEW") || num.equals("CLONE")) {
                TaskModel.getReference().addLog(task.getKey(), Resource.getResourceString("Task_Created"));
            } else {
                if (orig != null && !orig.getState().equals(task.getState())) {
                    TaskModel.getReference().addLog(task.getKey(), Resource.getResourceString("State_Change") + ": " + orig.getState() + " --> " + task.getState());
                }
                String newd = "null";
                if (task.getDueDate() != null) {
                    newd = DateFormat.getDateInstance().format(task.getDueDate());
                }
                String oldd = "null";
                if (orig != null && orig.getDueDate() != null) {
                    oldd = DateFormat.getDateInstance().format(orig.getDueDate());
                }
                if (orig != null && !newd.equals(oldd)) {
                    TaskModel.getReference().addLog(task.getKey(), Resource.getResourceString("DueDate") + " " + Resource.getResourceString("Change") + ": " + oldd + " --> " + newd);
                }
            }
            this.saveSubtasks(task);
            TaskModel.getReference();
            TaskModel.commitTransaction();
            Container p2 = this.getParent();
            if (p2 instanceof JViewport) {
                this.showtask(Action.CHANGE, task);
            } else {
                this.close();
            }
            MultiView.getMainView().setView(MultiView.ViewType.TASK);
        }
        catch (Warning w) {
            Errmsg.getErrorHandler().notice(w.getMessage());
            try {
                TaskModel.getReference();
                TaskModel.rollbackTransaction();
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            try {
                TaskModel.getReference();
                TaskModel.rollbackTransaction();
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
            }
        }
    }

    @Override
    protected PrefName getFrameSizePref() {
        return new PrefName(Resource.getResourceString("Item") + "_framesize", "-1,-1,800,600,N");
    }

    private void showtask(Action function, Task task) throws Exception {
        TableSorter ts = (TableSorter)this.subTaskTable.getModel();
        ts.setRowCount(0);
        this.subTaskIdsToBeDeleted.clear();
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem("");
        Collection projects = TaskModel.getReference().getProjects();
        if (projects != null) {
            for (Project p : projects) {
                if (!p.getStatus().equals(Resource.getResourceString("OPEN"))) continue;
                this.projectComboBox.addItem(TaskView.getProjectString(p));
            }
        }
        if (task != null) {
            this.taskIdText.setText(Integer.toString(task.getKey()));
            this.taskIdText.setEditable(false);
            this.windowTitle = Resource.getResourceString("Item_") + " " + task.getKey();
            GregorianCalendar gc = new GregorianCalendar();
            Date dd = task.getDueDate();
            if (dd != null) {
                gc.setTime(dd);
                this.dueDateChooser.setCalendar((Calendar)gc);
            }
            GregorianCalendar gc2 = new GregorianCalendar();
            dd = task.getStartDate();
            if (dd != null) {
                gc2.setTime(dd);
            }
            this.startDateChooser.setCalendar((Calendar)gc2);
            this.priorityText.setSelectedItem(task.getPriority());
            this.personAssignedText.setText(task.getPersonAssigned());
            Date cd = task.getCompletionDate();
            if (cd != null) {
                this.closeDate.setText(DateFormat.getDateInstance(2).format(cd));
            }
            int daysleft = TaskModel.daysLeft((Date)task.getDueDate());
            this.daysLeftText.setText(Integer.toString(daysleft));
            String cat = task.getCategory();
            if (cat != null && !cat.equals("")) {
                this.categoryComboBox.setSelectedItem(cat);
            } else {
                this.categoryComboBox.setSelectedIndex(0);
            }
            this.descriptionText.setText(task.getDescription());
            this.summaryText.setText(task.getSummary());
            this.resolutionText.setText(task.getResolution());
            this.statusComboBox.addItem(task.getState());
            this.statusComboBox.setEditable(false);
            String type = task.getType();
            this.taskTypeComboBox.addItem(type);
            this.taskTypeComboBox.setEnabled(false);
            Collection subtasks = TaskModel.getReference().getSubTasks(task.getKey());
            for (Subtask subtask : subtasks) {
                Object[] o = new Object[]{subtask.getCloseDate() == null ? new Boolean(false) : new Boolean(true), new Integer(subtask.getKey()), subtask.getDescription(), subtask.getStartDate(), subtask.getDueDate(), subtask.getDueDate() != null ? new Integer(TaskModel.daysBetween((Date)subtask.getStartDate(), (Date)subtask.getDueDate())) : null, subtask.getDueDate() != null ? new Integer(TaskModel.daysLeft((Date)subtask.getDueDate())) : null, subtask.getCloseDate()};
                ts.addRow(o);
            }
            try {
                this.loadLog(task.getKey());
            }
            catch (Warning w) {
                // empty catch block
            }
            Integer pid = task.getProject();
            if (pid != null) {
                Project p = TaskModel.getReference().getProject(pid.intValue());
                if (TaskModel.isClosed((Project)p)) {
                    this.projectComboBox.addItem(TaskView.getProjectString(p));
                }
                this.projectComboBox.setSelectedItem(TaskView.getProjectString(p));
            }
            this.linkPanel.setOwner((KeyedEntity<?>)task);
        } else {
            this.linkPanel.setOwner(null);
            this.taskIdText.setText("NEW");
            this.taskIdText.setEditable(false);
            this.windowTitle = Resource.getResourceString("NEW_Item");
            this.priorityText.setSelectedItem(new Integer(3));
            this.personAssignedText.setText("");
            this.categoryComboBox.setSelectedIndex(0);
            this.descriptionText.setText("");
            this.resolutionText.setText("");
            Vector tv = TaskModel.getReference().getTaskTypes().getTaskTypes();
            for (int i = 0; i < tv.size(); ++i) {
                this.taskTypeComboBox.addItem((String)tv.elementAt(i));
            }
            if (this.parentProject != null) {
                Date sd;
                Project p = TaskModel.getReference().getProject(this.parentProject.intValue());
                if (p == null) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("project_not_found"));
                    return;
                }
                this.projectComboBox.setSelectedItem(TaskView.getProjectString(p));
                String cat = p.getCategory();
                if (cat != null && !cat.equals("")) {
                    this.categoryComboBox.setSelectedItem(cat);
                } else {
                    this.categoryComboBox.setSelectedIndex(0);
                }
                GregorianCalendar gc = new GregorianCalendar();
                Date dd = p.getDueDate();
                if (dd != null) {
                    gc.setTime(dd);
                    this.dueDateChooser.setCalendar((Calendar)gc);
                }
                if ((sd = p.getStartDate()) != null && sd.after(new Date())) {
                    gc.setTime(sd);
                    this.startDateChooser.setCalendar((Calendar)gc);
                }
            }
        }
        if (task == null) {
            this.statusComboBox.setEnabled(false);
        }
        if (function == Action.CLONE) {
            this.taskIdText.setText("CLONE");
            this.taskIdText.setEditable(false);
            this.statusComboBox.removeAllItems();
            this.statusComboBox.addItem(TaskModel.getReference().getTaskTypes().getInitialState(this.taskTypeComboBox.getSelectedItem().toString()));
            this.statusComboBox.setEnabled(false);
            for (int row = 0; row < this.subTaskTable.getRowCount(); ++row) {
                this.subTaskTable.setValueAt(null, row, 1);
            }
        } else if (function == Action.CHANGE && task != null) {
            String state = task.getState();
            String type = task.getType();
            Collection v = TaskModel.getReference().getTaskTypes().nextStates(type, state);
            this.statusComboBox.removeAllItems();
            for (String s : v) {
                this.statusComboBox.addItem(s);
            }
            this.statusComboBox.setSelectedItem(state);
            this.statusComboBox.setEnabled(true);
        }
        this.insertSubtask();
    }

    public int getShownId() {
        String num = this.taskIdText.getText();
        if (!num.equals("NEW") && !num.equals("CLONE")) {
            return Integer.parseInt(num);
        }
        return -1;
    }

    public static enum Action {
        ADD,
        CHANGE,
        CLONE;

    }

    private class SubtaskIntRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public SubtaskIntRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)TaskView.this.defaultIntegerCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(0);
            this.setForeground(l.getForeground());
            this.setBackground(l.getBackground());
            if (obj != null && obj instanceof Integer) {
                int i = (Integer)obj;
                if (column == 1 && i == 0) {
                    this.setText("--");
                } else {
                    this.setText(Integer.toString(i));
                }
            } else if (obj == null) {
                this.setText("--");
            }
            return this;
        }
    }

    private class SubTaskDueDateRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public SubTaskDueDateRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean closed = (Boolean)table.getModel().getValueAt(row, 0);
            Date dd = (Date)obj;
            JLabel l = (JLabel)TaskView.this.defaultDateCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setBackground(l.getBackground());
            this.setForeground(l.getForeground());
            this.setHorizontalAlignment(l.getHorizontalAlignment());
            if (dd != null) {
                this.setText(DateFormat.getDateInstance().format(dd));
            } else {
                this.setText("--");
                this.setHorizontalAlignment(0);
            }
            String nm = table.getColumnName(column);
            if (closed.booleanValue() || !nm.equals(Resource.getResourceString("Due_Date")) || obj == null) {
                return this;
            }
            int days = TaskModel.daysLeft((Date)dd);
            if (!isSelected) {
                if (days < Prefs.getIntPref(PrefName.YELLOW_DAYS)) {
                    this.setBackground(new Color(255, 255, 175));
                }
                if (days < Prefs.getIntPref(PrefName.ORANGE_DAYS)) {
                    this.setBackground(new Color(255, 200, 120));
                }
                if (days < Prefs.getIntPref(PrefName.RED_DAYS)) {
                    this.setBackground(new Color(255, 120, 120));
                }
            }
            return this;
        }
    }

    private class LogTableDateRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public LogTableDateRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Date d = (Date)obj;
            JLabel l = (JLabel)TaskView.this.defaultDateCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setBackground(l.getBackground());
            this.setForeground(l.getForeground());
            this.setText(DateFormat.getDateTimeInstance(2, 2).format(d));
            return this;
        }
    }
}

