/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class DateTimePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> ampmBox = new JComboBox();
    private DefaultComboBoxModel<String> ampmModel = new DefaultComboBoxModel<String>(new String[]{"AM", "PM"});
    private JDateChooser dateChooser = new JDateChooser();
    private JComboBox<String> hourBox = new JComboBox();
    private DefaultComboBoxModel<String> milHourModel = new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
    private boolean milTime = false;
    private DefaultComboBoxModel<String> minModel = new DefaultComboBoxModel<String>(new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"});
    private JComboBox<String> minuteBox = new JComboBox();
    private DefaultComboBoxModel<String> normHourModel = new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
    private boolean showDate = true;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setContentPane(new DateTimePanel(true, true));
                f.pack();
                f.setVisible(true);
                JFrame f2 = new JFrame();
                f2.setContentPane(new DateTimePanel(false, false));
                f2.pack();
                f2.setVisible(true);
            }
        });
    }

    public DateTimePanel(boolean showDate, boolean milTime) {
        this.showDate = showDate;
        this.milTime = milTime;
        this.initialize();
    }

    public void addTimeListener(ActionListener l) {
        this.hourBox.addActionListener(l);
        this.minuteBox.addActionListener(l);
        this.ampmBox.addActionListener(l);
    }

    public Date getTime() throws Warning {
        Calendar cal = this.dateChooser.getCalendar();
        if (this.milTime) {
            cal.set(11, this.hourBox.getSelectedIndex());
        } else {
            String val;
            int hr = this.hourBox.getSelectedIndex() + 1;
            if (hr == 12) {
                hr = 0;
            }
            if ((val = (String)this.ampmBox.getSelectedItem()).equals("PM")) {
                hr += 12;
            }
            cal.set(11, hr);
        }
        try {
            int min = Integer.parseInt((String)this.minuteBox.getSelectedItem());
            if (min < 0 || min > 59) {
                throw new Warning(Resource.getResourceString("InvalidMinute") + ": " + this.minuteBox.getSelectedItem());
            }
            cal.set(12, min);
        }
        catch (NumberFormatException n) {
            throw new Warning(Resource.getResourceString("InvalidMinute") + ": " + this.minuteBox.getSelectedItem());
        }
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dateChooser, GridBagConstraintsFactory.create(0, 0, 1));
        GridBagConstraints gbc = GridBagConstraintsFactory.create(0, 1, 1, 1.0, 0.0);
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel timePanel = new JPanel();
        timePanel.add(this.hourBox, null);
        this.minuteBox.setModel(this.minModel);
        this.minuteBox.setEditable(true);
        ComboBoxEditor editor = this.minuteBox.getEditor();
        JTextField textField = (JTextField)editor.getEditorComponent();
        textField.setColumns(2);
        timePanel.add(this.minuteBox, null);
        this.ampmBox.setModel(this.ampmModel);
        timePanel.add(this.ampmBox, null);
        this.add((Component)timePanel, gbc);
        this.update(this.showDate, this.milTime);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.hourBox.setEnabled(enabled);
        this.minuteBox.setEnabled(enabled);
        this.ampmBox.setEnabled(enabled);
        this.dateChooser.setEnabled(enabled);
    }

    public void setTime(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        if (d != null) {
            cal.setTime(d);
        }
        this.dateChooser.setCalendar((Calendar)cal);
        if (this.milTime) {
            this.hourBox.setSelectedIndex(cal.get(11));
        } else {
            int hr = cal.get(10);
            if (hr == 0) {
                hr = 12;
            }
            this.hourBox.setSelectedIndex(hr - 1);
        }
        String mins = Integer.toString(cal.get(12));
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        this.minuteBox.setSelectedItem(mins);
        if (cal.get(11) < 12) {
            this.ampmBox.setSelectedItem("AM");
        } else {
            this.ampmBox.setSelectedItem("PM");
        }
    }

    public void update(boolean show_date, boolean mil_Time) {
        if (mil_Time) {
            this.hourBox.setModel(this.milHourModel);
            this.ampmBox.setVisible(false);
        } else {
            this.hourBox.setModel(this.normHourModel);
            this.ampmBox.setVisible(true);
        }
        this.dateChooser.setVisible(show_date);
    }
}

