/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class ScrolledDialog
extends JDialog {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static final long serialVersionUID = 1L;
    public static final int CANCEL = 1;
    private static Exception e_;
    public static final int OK = 0;
    private static int result;
    private JTable tbl_ = null;

    public static void showError(Exception e) {
        e_ = e;
        boolean ss = false;
        String showstack = Prefs.getPref(PrefName.STACKTRACE);
        if (showstack.equals("true")) {
            ss = true;
        }
        new ScrolledDialog(e.toString(), ss, false).setVisible(true);
    }

    public static void showNotice(String text) {
        new ScrolledDialog(text, false, false).setVisible(true);
    }

    public static int showOptionDialog(String message) {
        new ScrolledDialog(message, false, true).setVisible(true);
        return result;
    }

    public static void showTable(JTable tbl) {
        new ScrolledDialog(tbl).setVisible(true);
    }

    private ScrolledDialog(JTable tbl) {
        this.tbl_ = tbl;
        this.initComponents(null, false, false);
        this.setModal(false);
    }

    private ScrolledDialog(String s, boolean stack, boolean option) {
        this.initComponents(s, option, stack);
        this.setModal(true);
    }

    private void initComponents(String text, boolean isOption, boolean isStack) {
        this.setDefaultCloseOperation(2);
        this.setTitle("BORG");
        this.setSize(165, 300);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(new Dimension(600, 200));
        if (this.tbl_ != null) {
            scrollPane.setViewportView(this.tbl_);
        } else {
            JTextArea textArea = new JTextArea();
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setText(text);
            scrollPane.setViewportView(textArea);
        }
        mainPanel.add((Component)scrollPane, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton();
        okButton.setText(Resource.getResourceString("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result = 0;
                ScrolledDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)okButton, null);
        if (isStack) {
            JButton stackButton = new JButton();
            stackButton.setText(Resource.getResourceString("Show_Stack_Trace"));
            stackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(bao);
                    e_.printStackTrace(ps);
                    ScrolledDialog.showNotice(bao.toString());
                    log.severe(bao.toString());
                }
            });
            buttonPanel.add((Component)stackButton, null);
        }
        if (isOption) {
            JButton cancelButton = new JButton();
            cancelButton.setText(Resource.getResourceString("Cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result = 1;
                    ScrolledDialog.this.dispose();
                }
            });
            buttonPanel.add((Component)cancelButton, null);
        }
        mainPanel.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1, 1));
        this.setContentPane(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScrolledDialog.this.windowClose();
            }
        });
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = scrollPane.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
    }

    private void windowClose() {
        this.dispose();
    }
}

