/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.fortuna.ical4j.connector.dav.CalDavConstants;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.apache.jackrabbit.webdav.DavConstants;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ScheduleResponse {
    private String recipient;
    private float requestStatusCode;
    private String requestStatusMessage;
    private Calendar calendarData;

    public ScheduleResponse(Element responseNode) throws IOException, ParserException {
        Element node;
        NodeList recipients = responseNode.getElementsByTagNameNS(CalDavConstants.CALDAV_NAMESPACE.getURI(), CalDavPropertyName.RECIPIENT.getName());
        NodeList status = responseNode.getElementsByTagNameNS(CalDavConstants.CALDAV_NAMESPACE.getURI(), CalDavPropertyName.REQUEST_STATUS.getName());
        NodeList calendars = responseNode.getElementsByTagNameNS(CalDavConstants.CALDAV_NAMESPACE.getURI(), CalDavPropertyName.CALENDAR_DATA.getName());
        int nodesIndex = 0;
        while (nodesIndex < calendars.getLength()) {
            node = (Element)calendars.item(nodesIndex);
            if (node.getFirstChild() != null) {
                CalendarBuilder builder = new CalendarBuilder();
                if (node.getFirstChild() instanceof CDATASection) {
                    CDATASection calData = (CDATASection)node.getFirstChild();
                    StringReader sin = new StringReader(calData.getData());
                    this.calendarData = builder.build((Reader)sin);
                }
                if (node.getFirstChild() instanceof Text) {
                    StringReader sin = new StringReader(((Text)node.getFirstChild()).getTextContent());
                    this.calendarData = builder.build((Reader)sin);
                }
            }
            ++nodesIndex;
        }
        nodesIndex = 0;
        while (nodesIndex < status.getLength()) {
            node = (Element)status.item(nodesIndex);
            String fullStatus = ((Text)node.getFirstChild()).getTextContent();
            String[] split = fullStatus.split(";");
            if (split.length == 2) {
                this.requestStatusCode = new Float(split[0]).floatValue();
                this.requestStatusMessage = split[1];
            }
            ++nodesIndex;
        }
        nodesIndex = 0;
        while (nodesIndex < recipients.getLength()) {
            node = (Element)recipients.item(nodesIndex);
            NodeList childs = node.getElementsByTagNameNS(DavConstants.NAMESPACE.getURI(), "href");
            if (childs != null && childs.item(0) != null && childs.item(0).getFirstChild() != null) {
                this.recipient = childs.item(0).getFirstChild().getTextContent();
            }
            ++nodesIndex;
        }
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public float getRequestStatusCode() {
        return this.requestStatusCode;
    }

    public void setRequestStatusCode(float requestStatusCode) {
        this.requestStatusCode = requestStatusCode;
    }

    public String getRequestStatusMessage() {
        return this.requestStatusMessage;
    }

    public void setRequestStatusMessage(String requestStatusMessage) {
        this.requestStatusMessage = requestStatusMessage;
    }

    public Calendar getCalendarData() {
        return this.calendarData;
    }

    public void setCalendarData(Calendar calendarData) {
        this.calendarData = calendarData;
    }

    public boolean isSuccess() {
        return (double)this.requestStatusCode < 3.0;
    }
}

