/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.Searchable;
import net.sf.borg.model.db.AppointmentDB;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.EntityDB;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.Link;
import net.sf.borg.model.undo.AppointmentUndoItem;
import net.sf.borg.model.undo.UndoLog;

public class AppointmentModel
extends Model
implements Model.Listener,
CategoryModel.CategorySource,
Searchable<Appointment> {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static AppointmentModel self_ = new AppointmentModel();
    private EntityDB<Appointment> db_;
    private HashMap<Integer, Collection<Integer>> map_ = new HashMap();
    private HashMap<Integer, Integer> vacationMap_ = new HashMap();

    public static AppointmentModel getReference() {
        return self_;
    }

    public static SimpleDateFormat getTimeFormat() {
        String mt = Prefs.getPref((PrefName)PrefName.MILTIME);
        if (mt.equals("true")) {
            return new SimpleDateFormat("HH:mm");
        }
        return new SimpleDateFormat("h:mm a");
    }

    public static boolean isNote(Appointment appt) {
        return appt.getUntimed() != null && appt.getUntimed().equals("Y");
    }

    public static boolean isSkipped(Appointment ap, Calendar cal) {
        int dk = DateUtil.dayOfEpoch((Date)cal.getTime());
        String sk = Integer.toString(dk);
        Vector<String> skv = ap.getSkipList();
        return skv != null && skv.contains(sk);
    }

    private AppointmentModel() {
        this.db_ = DBHelper.getFactory().createAppointmentDB();
        CategoryModel.getReference().addSource(this);
        CategoryModel.getReference().addListener(this);
        try {
            this.buildMap();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void buildMap() throws Exception {
        this.map_.clear();
        this.vacationMap_.clear();
        GregorianCalendar cal = new GregorianCalendar();
        int curyr = cal.get(1);
        AppointmentDB kf = (AppointmentDB)this.db_;
        Collection<Integer> rptkeys = kf.getRepeatKeys();
        block0: for (Appointment appt : this.getAllAppts()) {
            if (!CategoryModel.getReference().isShown(appt.getCategory())) continue;
            int dkey = DateUtil.dayOfEpoch((Date)appt.getDate());
            int key = appt.getKey();
            Integer ki = new Integer(key);
            if (!rptkeys.contains(ki)) {
                Collection<Integer> o = this.map_.get(new Integer(dkey));
                if (o == null) {
                    o = new LinkedList<Integer>();
                    this.map_.put(new Integer(dkey), o);
                }
                LinkedList l = (LinkedList)o;
                l.add(new Integer(key));
                if (appt.getVacation() == null || appt.getVacation() == 0) continue;
                this.vacationMap_.put(new Integer(dkey), appt.getVacation());
                continue;
            }
            cal.setTime(appt.getDate());
            Repeat repeat = new Repeat(cal, appt.getFrequency());
            if (!repeat.isRepeating()) continue;
            int tm = Repeat.calculateTimes(appt);
            for (int i = 0; i < tm; ++i) {
                Calendar current = repeat.current();
                if (current == null) {
                    repeat.next();
                    continue;
                }
                int rkey = DateUtil.dayOfEpoch((Date)current.getTime());
                int cyear = current.get(1);
                if (cyear > curyr + 2) continue block0;
                if (!AppointmentModel.isSkipped(appt, current)) {
                    Collection<Integer> o = this.map_.get(new Integer(rkey));
                    if (o == null) {
                        o = new LinkedList<Integer>();
                        this.map_.put(new Integer(rkey), o);
                    }
                    LinkedList l = (LinkedList)o;
                    l.add(new Integer(key));
                    if (appt.getVacation() != null && appt.getVacation() != 0) {
                        this.vacationMap_.put(new Integer(rkey), appt.getVacation());
                    }
                }
                repeat.next();
            }
        }
    }

    public void delAppt(Appointment appt) {
        this.delAppt(appt, false);
    }

    public void delAppt(Appointment appt, boolean undo) {
        Appointment orig_appt = null;
        try {
            orig_appt = this.getAppt(appt.getKey());
            LinkModel.getReference().deleteLinksFromEntity(appt);
            LinkModel.getReference().deleteLinksToEntity(appt);
            this.db_.delete(appt.getKey());
            if (!undo) {
                UndoLog.getReference().addItem(AppointmentUndoItem.recordDelete(orig_appt));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        try {
            this.buildMap();
            this.refreshListeners(new Model.ChangeEvent(appt, Model.ChangeEvent.ChangeAction.DELETE));
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    public void delAppt(int key) {
        try {
            Appointment appt = this.getAppt(key);
            if (appt != null) {
                this.delAppt(appt);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void delOneOnly(int key, Date rptDate) {
        try {
            int rkey = DateUtil.dayOfEpoch((Date)rptDate);
            Appointment appt = this.db_.readObj(key);
            Vector<String> vect = appt.getSkipList();
            if (vect == null) {
                vect = new Vector();
            }
            vect.add(Integer.toString(rkey));
            appt.setSkipList(vect);
            this.saveAppt(appt, false);
            Date nt = appt.getNextTodo();
            if (nt == null) {
                nt = appt.getDate();
            }
            if (rkey == DateUtil.dayOfEpoch((Date)nt)) {
                this.do_todo(appt.getKey(), false);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    public void do_todo(int key, boolean del) throws Exception {
        this.do_todo(key, del, null);
    }

    public void do_todo(int key, boolean del, Date date) throws Exception {
        Appointment appt = this.db_.readObj(key);
        Date curtodo = appt.getNextTodo();
        Date d = appt.getDate();
        if (curtodo == null) {
            curtodo = d;
        }
        if (date != null) {
            curtodo = date;
        }
        Date newtodo = null;
        int tm = Repeat.calculateTimes(appt);
        String rpt = Repeat.getFreq(appt.getFrequency());
        if (tm > 1 && rpt != null && Repeat.isRepeating(appt)) {
            GregorianCalendar ccal = new GregorianCalendar();
            Calendar ncal = new GregorianCalendar();
            ccal.setTime(curtodo);
            ncal.setTime(d);
            Repeat repeat = new Repeat(ncal, appt.getFrequency());
            block0: for (int i = 1; i < tm; ++i) {
                if (ncal != null && ncal.get(1) == ccal.get(1) && ncal.get(2) == ccal.get(2) && ncal.get(5) == ccal.get(5)) {
                    while ((ncal = repeat.next()) != null) {
                        if (AppointmentModel.isSkipped(appt, ncal)) continue;
                        newtodo = ncal.getTime();
                        break block0;
                    }
                    break;
                }
                ncal = repeat.next();
            }
        }
        if (newtodo != null) {
            appt.setNextTodo(newtodo);
            this.saveAppt(appt, false);
        } else if (del) {
            this.delAppt(appt);
        } else {
            appt.setTodo(false);
            appt.setColor("strike");
            this.saveAppt(appt, false);
        }
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Appointment = this.getAllAppts();
        m.marshal((Object)container, fw);
    }

    public Collection<Appointment> get_todos() {
        ArrayList<Appointment> av = new ArrayList<Appointment>();
        try {
            AppointmentDB kf = (AppointmentDB)this.db_;
            Collection<Integer> keycol = kf.getTodoKeys();
            for (Integer ki : keycol) {
                int key = ki;
                Appointment appt = this.db_.readObj(key);
                if (!CategoryModel.getReference().isShown(appt.getCategory())) continue;
                av.add(appt);
            }
        }
        catch (Exception ee) {
            Errmsg.getErrorHandler().errmsg(ee);
        }
        return av;
    }

    public Collection<Appointment> getAllAppts() throws Exception {
        Collection<Appointment> appts = this.db_.readAll();
        return appts;
    }

    public Appointment getAppt(int key) throws Exception {
        Appointment appt = this.db_.readObj(key);
        return appt;
    }

    public List<Integer> getAppts(Date d) {
        return (List)this.map_.get(new Integer(DateUtil.dayOfEpoch((Date)d)));
    }

    @Override
    public Collection<String> getCategories() {
        TreeSet<String> dbcat = new TreeSet<String>();
        dbcat.add(CategoryModel.UNCATEGORIZED);
        try {
            for (Appointment ap : this.getAllAppts()) {
                String cat = ap.getCategory();
                if (cat == null || cat.equals("")) continue;
                dbcat.add(cat);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return dbcat;
    }

    @Deprecated
    public EntityDB<Appointment> getDB() {
        return this.db_;
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.Appointment == null) {
            return;
        }
        try {
            int nextkey = this.db_.nextkey();
            boolean use_keys = nextkey == 1;
            for (Appointment appt : container.Appointment) {
                if (!use_keys) {
                    appt.setKey(nextkey++);
                }
                if (appt.getPriority() != null && (appt.getPriority() > 10 || appt.getPriority() < 1)) {
                    appt.setPriority(null);
                    log.warning("XML Import: Ignoring invalid priority for appointment: " + appt.getKey() + ":" + appt.getClearText());
                }
                if (appt.getCreateTime() == null) {
                    appt.setCreateTime(new Date());
                }
                if (appt.getLastMod() == null) {
                    appt.setLastMod(new Date());
                }
                this.db_.addObj(appt);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().notice(e + "\n" + Resource.getResourceString((String)"Import_XML_error"));
            e.printStackTrace();
        }
        this.buildMap();
        CategoryModel.getReference().sync();
        this.refreshListeners();
    }

    public Appointment newAppt() {
        Appointment appt = this.db_.newObj();
        return appt;
    }

    @Override
    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public void refresh() {
        try {
            this.buildMap();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refreshListeners();
    }

    public void saveAppt(Appointment r) {
        this.saveAppt(r, false);
    }

    public void saveAppt(Appointment r, boolean undo) {
        Model.ChangeEvent.ChangeAction action = Model.ChangeEvent.ChangeAction.ADD;
        try {
            String cat;
            Appointment orig_appt = null;
            if (r.getKey() != -1) {
                orig_appt = this.getAppt(r.getKey());
            }
            if (orig_appt == null) {
                if (!undo) {
                    r.setKey(this.db_.nextkey());
                }
                r.setCreateTime(new Date());
                r.setLastMod(r.getCreateTime());
                if (r.getUid() == null) {
                    r.setUid(Integer.toString(r.getKey()) + "@BORGA-" + r.getCreateTime().getTime());
                }
                this.db_.addObj(r);
                if (!undo) {
                    UndoLog.getReference().addItem(AppointmentUndoItem.recordAdd(r));
                }
            } else {
                if (r.getCreateTime() == null) {
                    r.setCreateTime(new Date());
                }
                r.setLastMod(new Date());
                if (r.getUid() == null) {
                    r.setUid(Integer.toString(r.getKey()) + "@BORGA-" + r.getCreateTime().getTime());
                }
                action = Model.ChangeEvent.ChangeAction.CHANGE;
                this.db_.updateObj(r);
                if (!undo) {
                    UndoLog.getReference().addItem(AppointmentUndoItem.recordUpdate(orig_appt));
                }
            }
            if ((cat = r.getCategory()) != null && !cat.equals("")) {
                CategoryModel.getReference().addCategory(cat);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        try {
            this.buildMap();
            this.refreshListeners(new Model.ChangeEvent(r, action));
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    @Override
    public void sync() {
        this.db_.sync();
        try {
            this.buildMap();
            this.refreshListeners();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
    }

    public double vacationCount(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        cal.set(5, 1);
        cal.set(2, 0);
        int dk = DateUtil.dayOfEpoch((Date)d);
        int yearStartKey = DateUtil.dayOfEpoch((Date)cal.getTime());
        double count = 0.0;
        Set<Integer> vkeys = this.vacationMap_.keySet();
        for (Integer i : vkeys) {
            int vdaykey = i;
            if (vdaykey < yearStartKey || vdaykey > dk) continue;
            Integer vnum = this.vacationMap_.get(i);
            if (vnum == 2) {
                count += 0.5;
                continue;
            }
            count += 1.0;
        }
        return count;
    }

    public void saveDefaultAppointment(Appointment appt) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Appointment.class});
            Marshaller m = jc.createMarshaller();
            StringWriter sw = new StringWriter();
            m.marshal((Object)appt, (Writer)sw);
            Prefs.putPref((PrefName)PrefName.DEFAULT_APPT, (Object)sw.toString());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public Appointment getDefaultAppointment() {
        String defApptXml = Prefs.getPref((PrefName)PrefName.DEFAULT_APPT);
        if (!defApptXml.equals("")) {
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Appointment.class});
                Unmarshaller u = jc.createUnmarshaller();
                String xmlString = defApptXml.toString();
                Appointment ap = (Appointment)u.unmarshal((Reader)new StringReader(xmlString));
                if (ap.getDate() == null) {
                    return null;
                }
                return ap;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        return null;
    }

    @Override
    public Collection<Appointment> search(SearchCriteria criteria) {
        ArrayList<Appointment> res = new ArrayList<Appointment>();
        try {
            Collection<Appointment> allappts = this.getAllAppts();
            for (Appointment appt : allappts) {
                if (!CategoryModel.getReference().isShown(appt.getCategory()) || appt.isEncrypted()) continue;
                String tx = appt.getText();
                Date d = appt.getDate();
                if (d == null || tx == null || !criteria.search(tx) || criteria.isRepeating() && !appt.isRepeatFlag() || criteria.isTodo() && !appt.isTodo()) continue;
                Integer ii = appt.getVacation();
                if (criteria.isVacation() && (ii == null || ii != 1)) continue;
                ii = appt.getHoliday();
                if (criteria.isHoliday() && (ii == null || ii != 1) || criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && appt.getCategory() != null && !appt.getCategory().equals(CategoryModel.UNCATEGORIZED) || !criteria.getCategory().equals("") && !criteria.getCategory().equals(CategoryModel.UNCATEGORIZED) && !criteria.getCategory().equals(appt.getCategory()) || criteria.getStartDate() != null && appt.getDate().before(criteria.getStartDate()) || criteria.getEndDate() != null && appt.getDate().after(criteria.getEndDate())) continue;
                if (criteria.hasLinks()) {
                    LinkModel lm = LinkModel.getReference();
                    try {
                        Collection<Link> lnks = lm.getLinks(appt);
                        if (lnks.isEmpty()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
                res.add(appt);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return res;
    }

    @Override
    public String getExportName() {
        return "APPTS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"appointments") + ": " + this.getAllAppts().size();
    }

    public List<Appointment> getAppointmentsByText(String text) throws Exception {
        AppointmentDB apdb = (AppointmentDB)this.db_;
        return apdb.getAppointmentsByText(text);
    }

    public Appointment getApptByUid(String uid) throws Exception {
        AppointmentDB apdb = (AppointmentDB)this.db_;
        return apdb.getAppointmentByUid(uid);
    }

    @XmlRootElement(name="APPTS")
    private static class XmlContainer {
        public Collection<Appointment> Appointment;

        private XmlContainer() {
        }
    }
}

