/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.db.CheckListDB;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.entity.CheckList;
import net.sf.borg.model.undo.CheckListUndoItem;
import net.sf.borg.model.undo.UndoLog;

public class CheckListModel
extends Model {
    private CheckListDB db_ = DBHelper.getFactory().createCheckListDB();
    private static CheckListModel self_ = new CheckListModel();

    public static CheckListModel getReference() {
        return self_;
    }

    public CheckListDB getDB() {
        return this.db_;
    }

    public Collection<CheckList> getCheckLists() throws Exception {
        return this.db_.readAll();
    }

    public Collection<String> getNames() throws Exception {
        return this.db_.getNames();
    }

    private CheckListModel() {
    }

    public void delete(String name, boolean undo) {
        try {
            CheckList m = this.getCheckList(name);
            LinkModel.getReference().deleteLinksToEntity(m);
            if (m == null) {
                return;
            }
            CheckList orig = m.clone();
            this.db_.delete(m.getCheckListName());
            if (!undo) {
                UndoLog.getReference().addItem(CheckListUndoItem.recordDelete(orig));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    public void saveCheckList(CheckList checkList) {
        this.saveCheckList(checkList, false);
    }

    public void saveCheckList(CheckList checkList, boolean undo) {
        try {
            String name = checkList.getCheckListName();
            CheckList old = this.db_.readCheckList(name);
            if (old == null) {
                this.db_.addCheckList(checkList);
                if (!undo) {
                    UndoLog.getReference().addItem(CheckListUndoItem.recordAdd(checkList));
                }
            } else {
                this.db_.updateCheckList(checkList);
                if (!undo) {
                    UndoLog.getReference().addItem(CheckListUndoItem.recordUpdate(old));
                }
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    public CheckList getCheckList(String name) throws Exception {
        return this.db_.readCheckList(name);
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.CheckList = this.getCheckLists();
        m.marshal((Object)container, fw);
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.CheckList == null) {
            return;
        }
        for (CheckList checkList : container.CheckList) {
            this.saveCheckList(checkList, true);
        }
        this.refresh();
    }

    public void refresh() {
        this.refreshListeners();
    }

    @Override
    public String getExportName() {
        return "CHECKLISTS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"CheckLists") + ": " + this.getCheckLists().size();
    }

    @XmlRootElement(name="CHECKLISTS")
    private static class XmlContainer {
        public Collection<CheckList> CheckList;

        private XmlContainer() {
        }
    }
}

