/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.LabelEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;

public class Day {
    private int holiday = 0;
    private TreeSet<CalendarEntity> items = new TreeSet<CalendarEntity>(new apcompare());
    private int vacation = 0;

    private static void addToDay(Day day, Collection<Integer> l, int year, int month, int date) throws Exception {
        boolean pub = false;
        boolean priv = false;
        String sp = Prefs.getPref((PrefName)PrefName.SHOWPUBLIC);
        if (sp.equals("true")) {
            pub = true;
        }
        if ((sp = Prefs.getPref((PrefName)PrefName.SHOWPRIVATE)).equals("true")) {
            priv = true;
        }
        if (l != null) {
            for (Integer ik : l) {
                Appointment appt = AppointmentModel.getReference().getAppt(ik);
                if (!appt.isPrivate() ? !pub : !priv) continue;
                String color = appt.getColor();
                if (color == null) {
                    appt.setColor("black");
                }
                day.addItem(appt);
                Integer v = appt.getVacation();
                if (v != null && v != 0) {
                    day.setVacation(v);
                }
                if ((v = appt.getHoliday()) == null || v != 1) continue;
                day.setHoliday(1);
            }
        }
    }

    public static Day getDay(int year, int month, int day) throws Exception {
        Collection<Address> addrs;
        Collection<Subtask> sts;
        LabelEntity hol;
        String show_can_hols;
        LabelEntity hol2;
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        Day ret = new Day();
        List<Integer> l = AppointmentModel.getReference().getAppts(cal.getTime());
        Day.addToDay(ret, l, year, month, day);
        GregorianCalendar gc = new GregorianCalendar(year, month, day, 11, 0);
        boolean dstNow = TimeZone.getDefault().inDaylightTime(gc.getTime());
        gc.add(5, -1);
        boolean dstYesterday = TimeZone.getDefault().inDaylightTime(gc.getTime());
        if (dstNow && !dstYesterday) {
            hol2 = new LabelEntity();
            hol2.setColor("black");
            hol2.setText(Resource.getResourceString((String)"Daylight_Savings_Time"));
            ret.addItem(hol2);
        } else if (!dstNow && dstYesterday) {
            hol2 = new LabelEntity();
            hol2.setColor("black");
            hol2.setText(Resource.getResourceString((String)"Standard_Time"));
            ret.addItem(hol2);
        }
        String show_us_hols = Prefs.getPref((PrefName)PrefName.SHOWUSHOLIDAYS);
        if (show_us_hols.equals("true")) {
            LabelEntity hol3 = new LabelEntity();
            hol3.setDate(new GregorianCalendar(year, month, day, 0, 0).getTime());
            hol3.setColor("purple");
            hol3.setText(null);
            if (month == 9 && day == 31) {
                hol3.setText(Resource.getResourceString((String)"Halloween"));
            } else if (month == 6 && day == 4) {
                hol3.setText(Resource.getResourceString((String)"Independence_Day"));
                ret.setHoliday(1);
            } else if (month == 1 && day == 2) {
                hol3.setText(Resource.getResourceString((String)"Ground_Hog_Day"));
            } else if (month == 1 && day == 14) {
                hol3.setText(Resource.getResourceString((String)"Valentine's_Day"));
            } else if (month == 2 && day == 17) {
                hol3.setText(Resource.getResourceString((String)"St._Patrick's_Day"));
            } else if (month == 10 && day == 11) {
                hol3.setText(Resource.getResourceString((String)"Veteran's_Day"));
            } else if (month == 8 && day == Day.nthdom(year, month, 2, 1)) {
                hol3.setText(Resource.getResourceString((String)"Labor_Day"));
                ret.setHoliday(1);
            } else if (month == 0 && day == Day.nthdom(year, month, 2, 3)) {
                hol3.setText(Resource.getResourceString((String)"Martin_Luther_King_Day"));
            } else if (month == 1 && day == Day.nthdom(year, month, 2, 3)) {
                hol3.setText(Resource.getResourceString((String)"Presidents_Day"));
            } else if (month == 4 && day == Day.nthdom(year, month, 2, -1)) {
                hol3.setText(Resource.getResourceString((String)"Memorial_Day"));
                ret.setHoliday(1);
            } else if (month == 9 && day == Day.nthdom(year, month, 2, 2)) {
                hol3.setText(Resource.getResourceString((String)"Columbus_Day"));
            } else if (month == 4 && day == Day.nthdom(year, month, 1, 2)) {
                hol3.setText(Resource.getResourceString((String)"Mother's_Day"));
            } else if (month == 5 && day == Day.nthdom(year, month, 1, 3)) {
                hol3.setText(Resource.getResourceString((String)"Father's_Day"));
            } else if (month == 10 && day == Day.nthdom(year, month, 5, 4)) {
                hol3.setText(Resource.getResourceString((String)"Thanksgiving"));
                ret.setHoliday(1);
            }
            if (hol3.getText() != null) {
                ret.addItem(hol3);
            }
        }
        if ((show_can_hols = Prefs.getPref((PrefName)PrefName.SHOWCANHOLIDAYS)).equals("true")) {
            hol = new LabelEntity();
            hol.setDate(new GregorianCalendar(year, month, day, 0, 0).getTime());
            hol.setColor("purple");
            hol.setText(null);
            if (month == 6 && day == 1) {
                hol.setText(Resource.getResourceString((String)"Canada_Day"));
            } else if (month == 11 && day == 26) {
                hol.setText(Resource.getResourceString((String)"Boxing_Day"));
            } else if (month == 7 && day == Day.nthdom(year, month, 2, 1)) {
                hol.setText(Resource.getResourceString((String)"Civic_Holiday"));
            } else if (month == 10 && day == 11) {
                hol.setText(Resource.getResourceString((String)"Remembrance_Day"));
            } else if (month == 8 && day == Day.nthdom(year, month, 2, 1)) {
                hol.setText(Resource.getResourceString((String)"Labour_Day_(Can)"));
            } else if (month == 2 && day == Day.nthdom(year, month, 2, 2)) {
                hol.setText(Resource.getResourceString((String)"Commonwealth_Day"));
            } else if (month == 9 && day == Day.nthdom(year, month, 2, 2)) {
                hol.setText(Resource.getResourceString((String)"Thanksgiving_(Can)"));
            } else if (month == 4) {
                gc = new GregorianCalendar(year, month, 25);
                int diff = gc.get(7);
                if ((diff += 5) > 7) {
                    diff -= 7;
                }
                if (day == 25 - diff) {
                    hol.setText(Resource.getResourceString((String)"Victoria_Day"));
                }
            }
            if (hol.getText() != null) {
                ret.addItem(hol);
            }
        }
        if (show_can_hols.equals("true") || show_us_hols.equals("true")) {
            hol = new LabelEntity();
            hol.setDate(new GregorianCalendar(year, month, day, 0, 0).getTime());
            hol.setColor("purple");
            hol.setText(null);
            if (month == 0 && day == 1) {
                hol.setText(Resource.getResourceString((String)"New_Year's_Day"));
                ret.setHoliday(1);
            } else if (month == 11 && day == 25) {
                hol.setText(Resource.getResourceString((String)"Christmas"));
                ret.setHoliday(1);
            }
            if (hol.getText() != null) {
                ret.addItem(hol);
            }
        }
        if (Prefs.getBoolPref((PrefName)PrefName.CAL_SHOW_TASKS)) {
            Collection<Task> tasks;
            Collection<Project> pcol = TaskModel.getReference().get_projects(cal.getTime());
            if (pcol != null) {
                for (Project pj : pcol) {
                    ret.addItem(pj);
                }
            }
            if ((tasks = TaskModel.getReference().get_tasks(cal.getTime())) != null) {
                for (Task task : tasks) {
                    ret.addItem(task);
                }
            }
        }
        if (Prefs.getBoolPref((PrefName)PrefName.CAL_SHOW_SUBTASKS) && (sts = TaskModel.getReference().get_subtasks(cal.getTime())) != null) {
            for (Subtask st : sts) {
                ret.addItem(st);
            }
        }
        if ((addrs = AddressModel.getReference().getAddresses(new GregorianCalendar(year, month, day, 0, 0).getTime())) != null) {
            for (Address addr : addrs) {
                LabelEntity info = new LabelEntity();
                String color = info.getColor();
                if (color == null) {
                    info.setColor("brick");
                }
                Date bd = addr.getBirthday();
                GregorianCalendar g = new GregorianCalendar();
                g.setTime(bd);
                int bdyear = g.get(1);
                int yrs = year - bdyear;
                if (yrs < 0) continue;
                String tx = Resource.getResourceString((String)"Birthday") + ": " + addr.getFirstName() + " " + addr.getLastName() + "(" + yrs + ")";
                info.setText(tx);
                info.setDate(new GregorianCalendar(year, month, day, 0, 0).getTime());
                ret.addItem(info);
            }
        }
        return ret;
    }

    private static int nthdom(int year, int month, int dayofweek, int week) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        cal.set(7, dayofweek);
        cal.set(8, week);
        return cal.get(5);
    }

    private Day() {
    }

    private void addItem(CalendarEntity info) {
        this.items.add(info);
    }

    public int getHoliday() {
        return this.holiday;
    }

    public Collection<CalendarEntity> getItems() {
        return this.items;
    }

    public int getVacation() {
        return this.vacation;
    }

    public void setHoliday(int i) {
        this.holiday = i;
    }

    public void setVacation(int i) {
        this.vacation = i;
    }

    private static class apcompare
    implements Comparator<CalendarEntity> {
        private apcompare() {
        }

        @Override
        public int compare(CalendarEntity so1, CalendarEntity so2) {
            GregorianCalendar cal;
            String s1 = so1.getText();
            String s2 = so2.getText();
            String psort = Prefs.getPref((PrefName)PrefName.PRIORITY_SORT);
            if (psort.equals("true")) {
                Integer p1 = so1.getPriority();
                Integer p2 = so2.getPriority();
                if (p1 != null && p2 != null) {
                    if (p1.intValue() != p2.intValue()) {
                        return p1 > p2 ? 1 : -1;
                    }
                } else {
                    if (p1 != null) {
                        return -1;
                    }
                    if (p2 != null) {
                        return 1;
                    }
                }
            }
            Date dt1 = null;
            Date dt2 = null;
            if (so1 instanceof Appointment && !AppointmentModel.isNote((Appointment)so1)) {
                cal = new GregorianCalendar();
                cal.setTime(((Appointment)so1).getDate());
                cal.set(1, 1, 2000);
                dt1 = cal.getTime();
            }
            if (so2 instanceof Appointment && !AppointmentModel.isNote((Appointment)so2)) {
                cal = new GregorianCalendar();
                cal.setTime(((Appointment)so2).getDate());
                cal.set(1, 1, 2000);
                dt2 = cal.getTime();
            }
            if (dt1 != null && dt2 != null) {
                return dt1.after(dt2) ? 1 : -1;
            }
            if (dt1 != null) {
                return -1;
            }
            if (dt2 != null) {
                return 1;
            }
            int res = s1.compareTo(s2);
            if (res != 0) {
                return res;
            }
            return 1;
        }
    }
}

