/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import biz.source_code.base64Coder.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.SendJavaMail;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.Task;

public class EmailReminder {
    private static final Logger log = Logger.getLogger("net.sf.borg");

    public static void sendDailyEmailReminder(Calendar emailday) throws Exception {
        String email = Prefs.getPref((PrefName)PrefName.EMAILENABLED);
        if (email.equals("false")) {
            return;
        }
        String host = Prefs.getPref((PrefName)PrefName.EMAILSERVER);
        String addr = Prefs.getPref((PrefName)PrefName.EMAILADDR);
        String from = Prefs.getPref((PrefName)PrefName.EMAILFROM);
        if (host.equals("") || addr.equals("")) {
            return;
        }
        Calendar cal = new GregorianCalendar();
        int doy = -1;
        if (emailday == null) {
            int lastday = Prefs.getIntPref((PrefName)PrefName.EMAILLAST);
            doy = cal.get(6);
            if (doy == lastday) {
                return;
            }
            cal.add(5, 1);
        } else {
            cal = emailday;
        }
        String ap_tx = "Appointments for " + DateFormat.getDateInstance().format(cal.getTime()) + "\n";
        String tx = "";
        List<Integer> l = AppointmentModel.getReference().getAppts(cal.getTime());
        if (l != null) {
            for (Integer ik : l) {
                try {
                    String s;
                    int ii;
                    Appointment appt = AppointmentModel.getReference().getAppt(ik);
                    if (appt.isPrivate()) continue;
                    if (!AppointmentModel.isNote(appt)) {
                        Date d = appt.getDate();
                        SimpleDateFormat df = AppointmentModel.getTimeFormat();
                        tx = tx + df.format(d) + " ";
                    }
                    tx = appt.isEncrypted() ? tx + Resource.getResourceString((String)"EncryptedItemShort") : ((ii = (s = appt.getText()).indexOf(10)) != -1 ? tx + s.substring(0, ii) : tx + s);
                    tx = tx + "\n";
                }
                catch (Exception e) {
                    log.severe(e.toString());
                    return;
                }
            }
        }
        Collection<Task> tasks = TaskModel.getReference().get_tasks(cal.getTime());
        if (l != null && tasks != null) {
            for (Task task : tasks) {
                tx = tx + "Task[" + task.getKey() + "] ";
                tx = tx + task.getSummary();
                tx = tx + "\n";
            }
        }
        if (!tx.equals("")) {
            tx = ap_tx + tx;
            StringTokenizer stk = new StringTokenizer(addr, ",;");
            while (stk.hasMoreTokens()) {
                String a = stk.nextToken();
                String f = from == null || from.isEmpty() ? a.trim() : from;
                if (a.equals("")) continue;
                SendJavaMail.sendMail((String)host, (String)tx, (String)Resource.getResourceString((String)"Reminder_Notice"), (String)f, (String)a.trim(), (String)Prefs.getPref((PrefName)PrefName.EMAILUSER), (String)EmailReminder.gep());
            }
        }
        if (doy != -1) {
            Prefs.putPref((PrefName)PrefName.EMAILLAST, (Object)new Integer(doy));
        }
    }

    public static String gep() throws Exception {
        String p1 = Prefs.getPref((PrefName)PrefName.EMAILPASS2);
        String p2 = Prefs.getPref((PrefName)PrefName.EMAILPASS);
        if ("".equals(p2)) {
            return p2;
        }
        if ("".equals(p1)) {
            EmailReminder.sep(p2);
            return p2;
        }
        byte[] ba = Base64Coder.decode((String)p1);
        SecretKeySpec key = new SecretKeySpec(ba, "AES");
        Cipher dec = Cipher.getInstance("AES");
        dec.init(2, key);
        byte[] decba = Base64Coder.decode((String)p2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, dec);
        ((OutputStream)os).write(decba);
        ((OutputStream)os).close();
        return baos.toString();
    }

    public static void sep(String s) throws Exception {
        SecretKey key;
        if ("".equals(s)) {
            Prefs.putPref((PrefName)PrefName.EMAILPASS, (Object)s);
            return;
        }
        String p1 = Prefs.getPref((PrefName)PrefName.EMAILPASS2);
        if ("".equals(p1)) {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            key = keyGen.generateKey();
            p1 = new String(Base64Coder.encode((byte[])key.getEncoded()));
            Prefs.putPref((PrefName)PrefName.EMAILPASS2, (Object)p1);
        }
        byte[] ba = Base64Coder.decode((String)p1);
        key = new SecretKeySpec(ba, "AES");
        Cipher enc = Cipher.getInstance("AES");
        enc.init(1, key);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, enc);
        ((OutputStream)os).write(s.getBytes());
        ((OutputStream)os).close();
        ba = baos.toByteArray();
        Prefs.putPref((PrefName)PrefName.EMAILPASS, (Object)new String(Base64Coder.encode((byte[])ba)));
    }
}

