/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.Searchable;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.MemoDB;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.undo.MemoUndoItem;
import net.sf.borg.model.undo.UndoLog;

public class MemoModel
extends Model
implements Searchable<Memo> {
    private static SimpleDateFormat normalDateFormat_ = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
    private MemoDB db_ = DBHelper.getFactory().createMemoDB();
    private static MemoModel self_ = new MemoModel();

    public static MemoModel getReference() {
        return self_;
    }

    public MemoDB getDB() {
        return this.db_;
    }

    public Collection<Memo> getMemos() throws Exception {
        Collection<Memo> memos = this.db_.readAll();
        for (Memo memo : memos) {
            MemoModel.parseOutDates(memo);
        }
        return memos;
    }

    public Collection<String> getNames() throws Exception {
        return this.db_.getNames();
    }

    private MemoModel() {
    }

    public void delete(String name, boolean undo) {
        try {
            Memo m = this.getMemo(name);
            LinkModel.getReference().deleteLinksToEntity(m);
            if (m == null) {
                return;
            }
            Memo orig = (Memo)m.copy();
            this.db_.delete(m.getMemoName());
            if (!undo) {
                UndoLog.getReference().addItem(MemoUndoItem.recordDelete(orig));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    public void saveMemo(Memo memo) {
        this.saveMemo(memo, false);
    }

    public void saveMemo(Memo memo, boolean undo) {
        try {
            Date now = new Date();
            if (memo.getCreated() == null) {
                memo.setCreated(now);
            }
            memo.setUpdated(now);
            MemoModel.addDateString(memo);
            String name = memo.getMemoName();
            Memo old = this.db_.readMemo(name);
            if (old == null) {
                this.db_.addMemo(memo);
                if (!undo) {
                    UndoLog.getReference().addItem(MemoUndoItem.recordAdd(memo));
                }
            } else {
                this.db_.updateMemo(memo);
                if (!undo) {
                    UndoLog.getReference().addItem(MemoUndoItem.recordUpdate(old));
                }
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.refresh();
    }

    private static void addDateString(Memo m) {
        String text;
        if (m.getCreated() == null || m.getUpdated() == null) {
            return;
        }
        if (m.getMemoText() == null) {
            m.setMemoText("");
        }
        if ((text = m.getMemoText()).startsWith("TS;")) {
            int idx1 = 2;
            int idx2 = text.indexOf(59, idx1 + 1);
            int idx3 = text.indexOf(59, idx2 + 1);
            if (idx2 != -1 && idx3 != -1) {
                m.setMemoText(text.substring(idx3 + 1));
            }
        }
        m.setMemoText("TS;" + normalDateFormat_.format(m.getCreated()) + ";" + normalDateFormat_.format(m.getUpdated()) + ";" + m.getMemoText());
    }

    private static void parseOutDates(Memo m) {
        String text = m.getMemoText();
        if (text == null) {
            return;
        }
        if (text.startsWith("TS;")) {
            int idx1 = 2;
            int idx2 = text.indexOf(59, idx1 + 1);
            int idx3 = text.indexOf(59, idx2 + 1);
            if (idx2 != -1 && idx3 != -1) {
                try {
                    Date create = normalDateFormat_.parse(text.substring(idx1 + 1, idx2));
                    Date update = normalDateFormat_.parse(text.substring(idx2 + 1, idx3));
                    if (create != null) {
                        m.setCreated(create);
                    }
                    if (update != null) {
                        m.setUpdated(update);
                    }
                    m.setMemoText(text.substring(idx3 + 1));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public Memo getMemo(String name) throws Exception {
        Memo m = this.db_.readMemo(name);
        if (m == null) {
            return null;
        }
        MemoModel.parseOutDates(m);
        return m;
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Memo = this.getMemos();
        m.marshal((Object)container, fw);
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.Memo == null) {
            return;
        }
        for (Memo memo : container.Memo) {
            memo.setKey(-1);
            this.saveMemo(memo, true);
        }
        this.refresh();
    }

    public void refresh() {
        this.refreshListeners();
    }

    @Override
    public Collection<Memo> search(SearchCriteria criteria) {
        ArrayList<Memo> res = new ArrayList<Memo>();
        try {
            if (!criteria.getCategory().equals("") && !criteria.getCategory().equals(CategoryModel.UNCATEGORIZED)) {
                return res;
            }
            Collection<Memo> memos = this.getMemos();
            for (Memo memo : memos) {
                String tx;
                if (memo.isEncrypted() || !criteria.search(tx = memo.getMemoName() + " " + memo.getMemoText())) continue;
                res.add(memo);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return res;
    }

    @Override
    public String getExportName() {
        return "MEMOS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"Memos") + ": " + this.getMemos().size();
    }

    @XmlRootElement(name="MEMOS")
    private static class XmlContainer {
        public Collection<Memo> Memo;

        private XmlContainer() {
        }
    }
}

