/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.Searchable;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.OptionDB;
import net.sf.borg.model.entity.Option;

public class OptionModel
extends Model
implements Searchable<Option> {
    private OptionDB db_ = DBHelper.getFactory().createOptionDB();
    private static OptionModel self_ = new OptionModel();

    public static OptionModel getReference() {
        return self_;
    }

    public Collection<Option> getOptions() throws Exception {
        return this.db_.getOptions();
    }

    private OptionModel() {
    }

    public void setOption(Option option) throws Exception {
        this.db_.setOption(option);
    }

    public String getOption(String name) throws Exception {
        return this.db_.getOption(name);
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.Option = this.getOptions();
        m.marshal((Object)container, fw);
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.Option == null) {
            return;
        }
        for (Option option : container.Option) {
            this.setOption(option);
        }
        this.refresh();
    }

    public void importOptions(Collection<Option> options) throws Exception {
        for (Option option : options) {
            this.setOption(option);
        }
        this.refresh();
    }

    public void refresh() {
        this.refreshListeners();
    }

    @Override
    public String getExportName() {
        return "OPTIONS";
    }

    @Override
    public String getInfo() throws Exception {
        return Resource.getResourceString((String)"Options") + ": " + this.getOptions().size();
    }

    @Override
    public Collection<Option> search(SearchCriteria criteria) {
        return null;
    }

    @XmlRootElement(name="OPTIONS")
    private static class XmlContainer {
        public Collection<Option> Option;

        private XmlContainer() {
        }
    }
}

