/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.borg.common.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@XmlRootElement(name="TaskTypes")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TaskTypes {
    @XmlElement(name="TaskType")
    private HashSet<TaskType> taskTypes = new HashSet();

    public void addNextState(String type, String state, String nextstate) {
        TaskState st = this.getState(type, state);
        if (st != null) {
            st.nextStates.add(nextstate);
        }
    }

    public void addState(String type, String state) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            TaskState ts = new TaskState();
            ts.name = state;
            tt.states.add(ts);
        }
    }

    public void addSubtask(String type, String value) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            tt.defaultSubtasks.add(value);
        }
    }

    public void addType(String type) {
        TaskType tt = new TaskType();
        tt.name = type;
        this.addState(type, "OPEN");
        this.addState(type, "CLOSED");
        this.addNextState(type, "OPEN", "CLOSED");
        this.taskTypes.add(tt);
        if (this.getTaskTypes().contains(type)) {
            return;
        }
    }

    public void changeState(String type, String state, String newstate) {
        TaskState ts = this.getState(type, state);
        if (ts != null) {
            ts.name = newstate;
        }
    }

    public void changeType(String type, String newtype) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            tt.name = newtype;
        }
    }

    public TaskTypes copy() throws Exception {
        String s = this.toXml();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TaskTypes.class});
        Unmarshaller u = jc.createUnmarshaller();
        TaskTypes tt = (TaskTypes)u.unmarshal((Reader)new StringReader(s));
        return tt;
    }

    public void deleteNextState(String type, String state, String nextstate) {
        TaskState st = this.getState(type, state);
        if (st != null) {
            st.nextStates.remove(nextstate);
        }
    }

    public void deleteState(String type, String state) {
        TaskType tt = this.getType(type);
        TaskState ts = this.getState(type, state);
        if (tt != null && ts != null) {
            tt.states.remove(ts);
        }
    }

    public void deleteSubtask(String type, String value) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            tt.defaultSubtasks.remove(value);
        }
    }

    public void deleteType(String type) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            this.taskTypes.remove(tt);
        }
    }

    public void fillFromLegacyXml(String xml) throws Exception {
        this.taskTypes.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document stateModel = builder.parse(new InputSource(new StringReader(xml)));
        ArrayList<Element> types = TaskTypes.getChildElements(stateModel.getDocumentElement());
        for (Element type : types) {
            TaskType taskType = new TaskType();
            taskType.name = type.getNodeName();
            ArrayList<Element> typeChildren = TaskTypes.getChildElements(type);
            for (Element typeChild : typeChildren) {
                if (typeChild.getNodeName().equals("CB")) {
                    if (!typeChild.getTextContent().equals("---------------")) {
                        taskType.defaultSubtasks.add(typeChild.getTextContent());
                    }
                } else {
                    TaskState state = new TaskState();
                    state.name = typeChild.getNodeName();
                    ArrayList<Element> stateChildren = TaskTypes.getChildElements(typeChild);
                    for (Element stateChild : stateChildren) {
                        if (stateChild.getNodeName().equals("__INIT__")) {
                            taskType.initialState = state.name;
                            continue;
                        }
                        if (stateChild.getNodeName().equals("__FINAL__")) {
                            taskType.finalState = state.name;
                            continue;
                        }
                        state.nextStates.add(stateChild.getNodeName());
                    }
                    taskType.states.add(state);
                }
                this.taskTypes.add(taskType);
            }
        }
    }

    public void fromString(String xmlString) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TaskTypes.class});
        Unmarshaller u = jc.createUnmarshaller();
        TaskTypes tt = (TaskTypes)u.unmarshal((Reader)new StringReader(xmlString));
        this.taskTypes = tt.taskTypes;
    }

    public void fromXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TaskTypes.class});
        Unmarshaller u = jc.createUnmarshaller();
        TaskTypes tt = (TaskTypes)u.unmarshal(is);
        this.taskTypes = tt.taskTypes;
    }

    private static ArrayList<Element> getChildElements(Node n) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            ret.add((Element)node);
        }
        return ret;
    }

    public String getFinalState(String type) {
        TaskType tt = this.getType(type);
        if (tt != null && tt.finalState != null) {
            return tt.finalState;
        }
        return "CLOSED";
    }

    public String getInitialState(String type) {
        TaskType tt = this.getType(type);
        if (tt != null && tt.initialState != null) {
            return tt.initialState;
        }
        return "OPEN";
    }

    private TaskState getState(String type, String state) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            for (TaskState ts : tt.states) {
                if (!ts.name.equals(state)) continue;
                return ts;
            }
        }
        return null;
    }

    public Collection<String> getStates(String type) {
        ArrayList<String> v = new ArrayList<String>();
        TaskType tt = this.getType(type);
        if (tt != null) {
            for (TaskState ts : tt.states) {
                v.add(ts.name);
            }
        }
        return v;
    }

    public String[] getSubTasks(String type) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            return tt.defaultSubtasks.toArray(new String[0]);
        }
        return new String[0];
    }

    public Vector<String> getTaskTypes() {
        Vector<String> v = new Vector<String>();
        for (TaskType tt : this.taskTypes) {
            v.add(tt.name);
        }
        return v;
    }

    private TaskType getType(String type) {
        for (TaskType tt : this.taskTypes) {
            if (!tt.name.equals(type)) continue;
            return tt;
        }
        return null;
    }

    public void loadDefault() throws Exception {
        URL tsurl = this.getClass().getResource("/task_states.xml");
        this.fromXml(tsurl.openStream());
    }

    public Collection<String> nextStates(String type, String state) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(state);
        TaskState ts = this.getState(type, state);
        if (ts != null) {
            ret.addAll(ts.nextStates);
        }
        return ret;
    }

    public void setInitialState(String type, String state) {
        TaskType tt = this.getType(type);
        if (tt != null) {
            tt.initialState = state;
        }
    }

    public String toXml() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TaskTypes.class});
        Marshaller m = jc.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)this, (Writer)sw);
        return sw.toString();
    }

    public void validate() throws Exception {
        Vector<String> types = this.getTaskTypes();
        for (String type : types) {
            String init = this.getInitialState(type);
            Collection<String> states = this.getStates(type);
            if (!init.equals("OPEN") || states.contains("OPEN")) continue;
            throw new Exception(Resource.getResourceString((String)"NoOpenState") + type);
        }
    }

    private static class TaskType {
        @XmlElement(name="DefaultSubtask")
        public HashSet<String> defaultSubtasks = new HashSet();
        @XmlElement(name="FinalState")
        public String finalState;
        @XmlElement(name="InitialState")
        public String initialState;
        @XmlElement(name="Name")
        public String name;
        @XmlElement(name="State")
        public HashSet<TaskState> states = new HashSet();

        private TaskType() {
        }
    }

    private static class TaskState {
        @XmlElement(name="Name")
        public String name;
        @XmlElement(name="NextState")
        public HashSet<String> nextStates = new HashSet();

        private TaskState() {
        }
    }
}

