/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Warning;
import net.sf.borg.model.Model;
import net.sf.borg.model.OptionModel;
import net.sf.borg.model.entity.Option;

@XmlRootElement(name="Theme")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Theme {
    private static PrefName CURRENT_THEME = new PrefName("current_theme", (Object)"BORG");
    private static final String DEFAULT_THEME_NAME = "BORG";
    private static Map<String, Theme> themes = null;
    private int birthdayTextColor = 0x990000;
    private int defaultBg = 0xF0F0F0;
    private int defaultFg = 0;
    private int halfdayBg = 0xCCCCFF;
    private int holidayBg = 16769476;
    private int holidayTextColor = 0x9900CC;
    private String name;
    private int reminderBg = 0xFFFF99;
    private int stripeBg = 0xF0FAFA;
    private int taskTextColor = 13158;
    private int textColor1 = 0xCC0033;
    private int textColor2 = 0x6600CC;
    private int textColor3 = 39168;
    private int textColor4 = 13107;
    private int textColor5 = 16250609;
    private int todayBg = 0xFFC8C8;
    private int vacationBg = 0xCCFFCC;
    private int weekdayBg = 0xFFFFCC;
    private int weekendBg = 16769476;
    private int trayIconBg = 0xFFFFFF;
    private int trayIconFg = 153;

    public static void delete(String name) throws Exception {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.equals(DEFAULT_THEME_NAME)) {
            return;
        }
        if (themes == null) {
            Theme.loadThemes();
        }
        themes.remove(name);
        Option option = new Option(Theme.getKey(name), null);
        OptionModel.getReference().setOption(option);
        if (name.equals(Prefs.getPref((PrefName)CURRENT_THEME))) {
            Prefs.putPref((PrefName)CURRENT_THEME, (Object)DEFAULT_THEME_NAME);
        }
    }

    public static final Theme getCurrentTheme() {
        String cur = Prefs.getPref((PrefName)CURRENT_THEME);
        Theme t = Theme.getTheme(cur);
        if (t == null) {
            t = new Theme();
            t.setName(cur);
        }
        return t;
    }

    private static String getKey(String name) {
        return "THEME_" + name;
    }

    public static final Theme getTheme(String name) {
        if (themes == null) {
            Theme.loadThemes();
        }
        return themes.get(name);
    }

    public static Collection<String> getThemeNames() {
        if (themes == null) {
            Theme.loadThemes();
        }
        return themes.keySet();
    }

    public static void sync() {
        Theme.loadThemes();
        Prefs.notifyListeners();
    }

    private static void loadThemes() {
        themes = new HashMap<String, Theme>();
        try {
            Collection<Option> options = OptionModel.getReference().getOptions();
            for (Option option : options) {
                if (!option.getKey().startsWith("THEME_")) continue;
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Theme.class});
                Unmarshaller u = context.createUnmarshaller();
                Theme theme = (Theme)u.unmarshal((Reader)new StringReader(option.getValue()));
                themes.put(theme.getName(), theme);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        if (themes.isEmpty()) {
            Theme t = new Theme();
            t.setName(DEFAULT_THEME_NAME);
            themes.put(t.getName(), t);
            try {
                t.save();
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
            Prefs.putPref((PrefName)CURRENT_THEME, (Object)DEFAULT_THEME_NAME);
        }
    }

    public static void setCurrentTheme(Theme t) throws Warning, Exception {
        String name = t.getName();
        if (name == null) {
            return;
        }
        if (Theme.getTheme(name) == null) {
            t.save();
        }
        Prefs.putPref((PrefName)CURRENT_THEME, (Object)name);
    }

    public void save() throws Exception {
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        if (themes == null) {
            Theme.loadThemes();
        }
        themes.put(this.name, this);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Theme.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter sw = new StringWriter();
        m.marshal((Object)this, (Writer)sw);
        Option option = new Option(Theme.getKey(this.name), sw.toString());
        OptionModel.getReference().setOption(option);
    }

    public int getBirthdayTextColor() {
        return this.birthdayTextColor;
    }

    public int getDefaultBg() {
        return this.defaultBg;
    }

    public int getDefaultFg() {
        return this.defaultFg;
    }

    public int getHalfdayBg() {
        return this.halfdayBg;
    }

    public int getHolidayBg() {
        return this.holidayBg;
    }

    public int getHolidayTextColor() {
        return this.holidayTextColor;
    }

    public String getName() {
        return this.name;
    }

    public int getReminderBg() {
        return this.reminderBg;
    }

    public int getStripeBg() {
        return this.stripeBg;
    }

    public int getTaskTextColor() {
        return this.taskTextColor;
    }

    public int getTextColor1() {
        return this.textColor1;
    }

    public int getTextColor2() {
        return this.textColor2;
    }

    public int getTextColor3() {
        return this.textColor3;
    }

    public int getTextColor4() {
        return this.textColor4;
    }

    public int getTextColor5() {
        return this.textColor5;
    }

    public int getTodayBg() {
        return this.todayBg;
    }

    public int getVacationBg() {
        return this.vacationBg;
    }

    public int getWeekdayBg() {
        return this.weekdayBg;
    }

    public int getWeekendBg() {
        return this.weekendBg;
    }

    public int getTrayIconBg() {
        return this.trayIconBg;
    }

    public int getTrayIconFg() {
        return this.trayIconFg;
    }

    public void setBirthdayTextColor(int birthdayTextColor) {
        this.birthdayTextColor = birthdayTextColor;
    }

    public void setDefaultBg(int defaultBg) {
        this.defaultBg = defaultBg;
    }

    public void setDefaultFg(int defaultFg) {
        this.defaultFg = defaultFg;
    }

    public void setHalfdayBg(int halfdayBg) {
        this.halfdayBg = halfdayBg;
    }

    public void setHolidayBg(int holidayBg) {
        this.holidayBg = holidayBg;
    }

    public void setHolidayTextColor(int holidayTextColor) {
        this.holidayTextColor = holidayTextColor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReminderBg(int reminderBg) {
        this.reminderBg = reminderBg;
    }

    public void setStripeBg(int stripeBg) {
        this.stripeBg = stripeBg;
    }

    public void setTaskTextColor(int taskTextColor) {
        this.taskTextColor = taskTextColor;
    }

    public void setTextColor1(int textColor1) {
        this.textColor1 = textColor1;
    }

    public void setTextColor2(int textColor2) {
        this.textColor2 = textColor2;
    }

    public void setTextColor3(int textColor3) {
        this.textColor3 = textColor3;
    }

    public void setTextColor4(int textColor4) {
        this.textColor4 = textColor4;
    }

    public void setTextColor5(int textColor5) {
        this.textColor5 = textColor5;
    }

    public void setTodayBg(int todayBg) {
        this.todayBg = todayBg;
    }

    public void setVacationBg(int vacationBg) {
        this.vacationBg = vacationBg;
    }

    public void setWeekdayBg(int weekdayBg) {
        this.weekdayBg = weekdayBg;
    }

    public void setWeekendBg(int weekendBg) {
        this.weekendBg = weekendBg;
    }

    public void setTrayIconBg(int trayIconBg) {
        this.trayIconBg = trayIconBg;
    }

    public void setTrayIconFg(int trayIconFg) {
        this.trayIconFg = trayIconFg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Theme)) {
            return false;
        }
        Theme other = (Theme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBirthdayTextColor() != other.getBirthdayTextColor()) {
            return false;
        }
        if (this.getDefaultBg() != other.getDefaultBg()) {
            return false;
        }
        if (this.getDefaultFg() != other.getDefaultFg()) {
            return false;
        }
        if (this.getHalfdayBg() != other.getHalfdayBg()) {
            return false;
        }
        if (this.getHolidayBg() != other.getHolidayBg()) {
            return false;
        }
        if (this.getHolidayTextColor() != other.getHolidayTextColor()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getReminderBg() != other.getReminderBg()) {
            return false;
        }
        if (this.getStripeBg() != other.getStripeBg()) {
            return false;
        }
        if (this.getTaskTextColor() != other.getTaskTextColor()) {
            return false;
        }
        if (this.getTextColor1() != other.getTextColor1()) {
            return false;
        }
        if (this.getTextColor2() != other.getTextColor2()) {
            return false;
        }
        if (this.getTextColor3() != other.getTextColor3()) {
            return false;
        }
        if (this.getTextColor4() != other.getTextColor4()) {
            return false;
        }
        if (this.getTextColor5() != other.getTextColor5()) {
            return false;
        }
        if (this.getTodayBg() != other.getTodayBg()) {
            return false;
        }
        if (this.getVacationBg() != other.getVacationBg()) {
            return false;
        }
        if (this.getWeekdayBg() != other.getWeekdayBg()) {
            return false;
        }
        if (this.getWeekendBg() != other.getWeekendBg()) {
            return false;
        }
        if (this.getTrayIconBg() != other.getTrayIconBg()) {
            return false;
        }
        return this.getTrayIconFg() == other.getTrayIconFg();
    }

    public boolean canEqual(Object other) {
        return other instanceof Theme;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getBirthdayTextColor();
        result = result * 31 + this.getDefaultBg();
        result = result * 31 + this.getDefaultFg();
        result = result * 31 + this.getHalfdayBg();
        result = result * 31 + this.getHolidayBg();
        result = result * 31 + this.getHolidayTextColor();
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        result = result * 31 + this.getReminderBg();
        result = result * 31 + this.getStripeBg();
        result = result * 31 + this.getTaskTextColor();
        result = result * 31 + this.getTextColor1();
        result = result * 31 + this.getTextColor2();
        result = result * 31 + this.getTextColor3();
        result = result * 31 + this.getTextColor4();
        result = result * 31 + this.getTextColor5();
        result = result * 31 + this.getTodayBg();
        result = result * 31 + this.getVacationBg();
        result = result * 31 + this.getWeekdayBg();
        result = result * 31 + this.getWeekendBg();
        result = result * 31 + this.getTrayIconBg();
        result = result * 31 + this.getTrayIconFg();
        return result;
    }

    public String toString() {
        return "Theme(birthdayTextColor=" + this.getBirthdayTextColor() + ", defaultBg=" + this.getDefaultBg() + ", defaultFg=" + this.getDefaultFg() + ", halfdayBg=" + this.getHalfdayBg() + ", holidayBg=" + this.getHolidayBg() + ", holidayTextColor=" + this.getHolidayTextColor() + ", name=" + this.getName() + ", reminderBg=" + this.getReminderBg() + ", stripeBg=" + this.getStripeBg() + ", taskTextColor=" + this.getTaskTextColor() + ", textColor1=" + this.getTextColor1() + ", textColor2=" + this.getTextColor2() + ", textColor3=" + this.getTextColor3() + ", textColor4=" + this.getTextColor4() + ", textColor5=" + this.getTextColor5() + ", todayBg=" + this.getTodayBg() + ", vacationBg=" + this.getVacationBg() + ", weekdayBg=" + this.getWeekdayBg() + ", weekendBg=" + this.getWeekendBg() + ", trayIconBg=" + this.getTrayIconBg() + ", trayIconFg=" + this.getTrayIconFg() + ")";
    }

    static {
        new OptionListener();
    }

    private static class OptionListener
    implements Model.Listener {
        public OptionListener() {
            OptionModel.getReference().addListener(this);
        }

        @Override
        public void update(Model.ChangeEvent event) {
            Theme.sync();
        }
    }
}

