/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.borg.model.entity.KeyedEntity;

abstract class JdbcBeanDB<T extends KeyedEntity<T>> {
    private boolean objectCacheOn_ = true;
    private HashMap<Integer, T> objectCache_ = new HashMap();

    JdbcBeanDB() {
    }

    public void sync() {
        this.emptyCache();
    }

    protected void writeCache(T bean) {
        if (this.objectCacheOn_) {
            this.objectCache_.put(new Integer(((KeyedEntity)bean).getKey()), ((KeyedEntity)bean).copy());
        }
    }

    protected void emptyCache() {
        if (this.objectCacheOn_) {
            this.objectCache_.clear();
        }
    }

    protected void delCache(int key) {
        if (this.objectCacheOn_) {
            this.objectCache_.remove(new Integer(key));
        }
    }

    protected T readCache(int key) {
        KeyedEntity o;
        if (this.objectCacheOn_ && (o = (KeyedEntity)this.objectCache_.get(new Integer(key))) != null) {
            return (T)((KeyedEntity)o.copy());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> readAll() throws Exception {
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            stmt = this.getPSAll();
            r = stmt.executeQuery();
            ArrayList<T> lst = new ArrayList<T>();
            while (r.next()) {
                T bean = this.createFrom(r);
                lst.add(bean);
                this.writeCache(bean);
            }
            ArrayList<T> arrayList = lst;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readObj(int key) throws Exception {
        T bean = this.readCache(key);
        if (bean != null) {
            return bean;
        }
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            stmt = this.getPSOne(key);
            r = stmt.executeQuery();
            if (r.next()) {
                bean = this.createFrom(r);
                this.writeCache(bean);
            }
            T t = bean;
            return t;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    abstract PreparedStatement getPSOne(int var1) throws SQLException;

    abstract PreparedStatement getPSAll() throws SQLException;

    abstract T createFrom(ResultSet var1) throws SQLException;
}

