/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.borg.model.db.LinkDB;
import net.sf.borg.model.db.jdbc.JdbcBeanDB;
import net.sf.borg.model.db.jdbc.JdbcDB;
import net.sf.borg.model.entity.Link;

class LinkJdbcDB
extends JdbcBeanDB<Link>
implements LinkDB {
    LinkJdbcDB() {
    }

    @Override
    public void addObj(Link att) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("INSERT INTO links ( id, linktype, ownerkey, ownertype, path)  VALUES ( ?, ?, ?, ?, ?)");
        stmt.setInt(1, att.getKey());
        stmt.setString(2, att.getLinkType());
        stmt.setInt(3, JdbcDB.toInt(att.getOwnerKey()));
        stmt.setString(4, att.getOwnerType());
        stmt.setString(5, att.getPath());
        stmt.executeUpdate();
        stmt.close();
        this.writeCache(att);
    }

    @Override
    public void delete(int key) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("DELETE FROM links WHERE id = ?");
        stmt.setInt(1, key);
        stmt.executeUpdate();
        stmt.close();
        this.delCache(key);
    }

    public Collection<Integer> getKeys() throws Exception {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT id FROM links");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            keys.add(new Integer(rs.getInt("id")));
        }
        rs.close();
        stmt.close();
        return keys;
    }

    @Override
    public int nextkey() throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT MAX(id) FROM links");
        ResultSet r = stmt.executeQuery();
        int maxKey = 0;
        if (r.next()) {
            maxKey = r.getInt(1);
        }
        r.close();
        stmt.close();
        return ++maxKey;
    }

    @Override
    public Link newObj() {
        return new Link();
    }

    @Override
    PreparedStatement getPSOne(int key) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM links WHERE id = ?");
        stmt.setInt(1, key);
        return stmt;
    }

    @Override
    PreparedStatement getPSAll() throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * FROM links");
        return stmt;
    }

    @Override
    Link createFrom(ResultSet r) throws SQLException {
        Link att = new Link();
        att.setKey(r.getInt("id"));
        att.setLinkType(r.getString("linktype"));
        att.setOwnerKey(new Integer(r.getInt("ownerkey")));
        att.setOwnerType(r.getString("ownertype"));
        att.setPath(r.getString("path"));
        return att;
    }

    @Override
    public void updateObj(Link att) throws Exception {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("UPDATE links SET linktype = ?, ownerkey = ?, ownertype = ?, path = ? WHERE id = ?");
        stmt.setString(1, att.getLinkType());
        stmt.setInt(2, att.getOwnerKey());
        stmt.setString(3, att.getOwnerType());
        stmt.setString(4, att.getPath());
        stmt.setInt(5, att.getKey());
        stmt.executeUpdate();
        stmt.close();
        this.delCache(att.getKey());
        this.writeCache(att);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Link> getLinks(int ownerkey, String ownertype) throws SQLException {
        PreparedStatement stmt = JdbcDB.getConnection().prepareStatement("SELECT * from links where ownerkey = ? and ownertype = ?");
        ResultSet r = null;
        ArrayList<Link> lst = new ArrayList<Link>();
        try {
            stmt.setInt(1, ownerkey);
            stmt.setString(2, ownertype);
            r = stmt.executeQuery();
            while (r.next()) {
                Link s = this.createFrom(r);
                lst.add(s);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return lst;
    }
}

