/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.entity;

import java.util.Date;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.EncryptionHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.EncryptableEntity;

@XmlRootElement(name="Appointment")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Appointment
extends EncryptableEntity<Appointment>
implements CalendarEntity {
    private static final long serialVersionUID = 7225675837209156249L;
    private Date Date;
    private Integer Duration = 0;
    private String Text;
    private Vector<String> SkipList;
    private Date NextTodo;
    private Integer Vacation = 0;
    private Integer Holiday = 0;
    private boolean Private;
    private Integer Times = 0;
    private String Frequency;
    private boolean Todo;
    private String Color;
    private boolean RepeatFlag;
    private String Category;
    private String ReminderTimes;
    private String Untimed;
    private Date repeatUntil;
    private Integer priority = 5;
    private Date createTime;
    private Date lastMod;
    private String uid;

    @Override
    protected Appointment clone() {
        Appointment dst = new Appointment();
        dst.setKey(this.getKey());
        dst.setDate(this.getDate());
        dst.setDuration(this.getDuration());
        dst.setText(this.getText());
        Vector<String> v = this.getSkipList();
        if (v != null) {
            dst.setSkipList((Vector)v.clone());
        }
        dst.setNextTodo(this.getNextTodo());
        dst.setVacation(this.getVacation());
        dst.setHoliday(this.getHoliday());
        dst.setPrivate(this.isPrivate());
        dst.setTimes(this.getTimes());
        dst.setFrequency(this.getFrequency());
        dst.setTodo(this.isTodo());
        dst.setColor(this.getColor());
        dst.setRepeatFlag(this.isRepeatFlag());
        dst.setCategory(this.getCategory());
        dst.setReminderTimes(this.getReminderTimes());
        dst.setUntimed(this.getUntimed());
        dst.setEncrypted(this.isEncrypted());
        dst.setRepeatUntil(this.getRepeatUntil());
        dst.setPriority(this.getPriority());
        dst.setCreateTime(this.getCreateTime());
        dst.setLastMod(this.getLastMod());
        dst.setUid(this.getUid());
        return dst;
    }

    @Override
    public void decrypt(String password) throws Exception {
        if (!this.isEncrypted()) {
            return;
        }
        EncryptionHelper helper = new EncryptionHelper(Prefs.getPref((PrefName)PrefName.KEYSTORE), password);
        String clearText = helper.decrypt(this.getText(), Prefs.getPref((PrefName)PrefName.KEYALIAS));
        this.setText(clearText);
        this.setEncrypted(false);
    }

    @Override
    public void encrypt(String password) throws Exception {
        if (this.isEncrypted()) {
            return;
        }
        EncryptionHelper helper = new EncryptionHelper(Prefs.getPref((PrefName)PrefName.KEYSTORE), password);
        String cipherText = helper.encrypt(this.getText(), Prefs.getPref((PrefName)PrefName.KEYALIAS));
        this.setText(cipherText);
        this.setEncrypted(true);
    }

    public String getClearText() {
        if (this.isEncrypted()) {
            return Resource.getResourceString((String)"EncryptedItemShort");
        }
        return this.getText();
    }

    @Override
    public Date getDate() {
        return this.Date;
    }

    @Override
    public Integer getDuration() {
        return this.Duration;
    }

    @Override
    public String getText() {
        return this.Text;
    }

    public Vector<String> getSkipList() {
        return this.SkipList;
    }

    @Override
    public Date getNextTodo() {
        return this.NextTodo;
    }

    public Integer getVacation() {
        return this.Vacation;
    }

    public Integer getHoliday() {
        return this.Holiday;
    }

    public boolean isPrivate() {
        return this.Private;
    }

    public Integer getTimes() {
        return this.Times;
    }

    public String getFrequency() {
        return this.Frequency;
    }

    @Override
    public boolean isTodo() {
        return this.Todo;
    }

    @Override
    public String getColor() {
        return this.Color;
    }

    public boolean isRepeatFlag() {
        return this.RepeatFlag;
    }

    public String getCategory() {
        return this.Category;
    }

    public String getReminderTimes() {
        return this.ReminderTimes;
    }

    public String getUntimed() {
        return this.Untimed;
    }

    public Date getRepeatUntil() {
        return this.repeatUntil;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastMod() {
        return this.lastMod;
    }

    public String getUid() {
        return this.uid;
    }

    public void setDate(Date Date2) {
        this.Date = Date2;
    }

    public void setDuration(Integer Duration) {
        this.Duration = Duration;
    }

    public void setText(String Text) {
        this.Text = Text;
    }

    public void setSkipList(Vector<String> SkipList) {
        this.SkipList = SkipList;
    }

    public void setNextTodo(Date NextTodo) {
        this.NextTodo = NextTodo;
    }

    public void setVacation(Integer Vacation) {
        this.Vacation = Vacation;
    }

    public void setHoliday(Integer Holiday) {
        this.Holiday = Holiday;
    }

    public void setPrivate(boolean Private) {
        this.Private = Private;
    }

    public void setTimes(Integer Times) {
        this.Times = Times;
    }

    public void setFrequency(String Frequency) {
        this.Frequency = Frequency;
    }

    public void setTodo(boolean Todo) {
        this.Todo = Todo;
    }

    public void setColor(String Color) {
        this.Color = Color;
    }

    public void setRepeatFlag(boolean RepeatFlag) {
        this.RepeatFlag = RepeatFlag;
    }

    public void setCategory(String Category2) {
        this.Category = Category2;
    }

    public void setReminderTimes(String ReminderTimes2) {
        this.ReminderTimes = ReminderTimes2;
    }

    public void setUntimed(String Untimed) {
        this.Untimed = Untimed;
    }

    public void setRepeatUntil(Date repeatUntil) {
        this.repeatUntil = repeatUntil;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setLastMod(Date lastMod) {
        this.lastMod = lastMod;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public String toString() {
        return "Appointment(Date=" + this.getDate() + ", Duration=" + this.getDuration() + ", Text=" + this.getText() + ", SkipList=" + this.getSkipList() + ", NextTodo=" + this.getNextTodo() + ", Vacation=" + this.getVacation() + ", Holiday=" + this.getHoliday() + ", Private=" + this.isPrivate() + ", Times=" + this.getTimes() + ", Frequency=" + this.getFrequency() + ", Todo=" + this.isTodo() + ", Color=" + this.getColor() + ", RepeatFlag=" + this.isRepeatFlag() + ", Category=" + this.getCategory() + ", ReminderTimes=" + this.getReminderTimes() + ", Untimed=" + this.getUntimed() + ", repeatUntil=" + this.getRepeatUntil() + ", priority=" + this.getPriority() + ", createTime=" + this.getCreateTime() + ", lastMod=" + this.getLastMod() + ", uid=" + this.getUid() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Appointment)) {
            return false;
        }
        Appointment other = (Appointment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$Date = this.getDate();
        Date other$Date = other.getDate();
        if (this$Date == null ? other$Date != null : !((Object)this$Date).equals(other$Date)) {
            return false;
        }
        Integer this$Duration = this.getDuration();
        Integer other$Duration = other.getDuration();
        if (this$Duration == null ? other$Duration != null : !((Object)this$Duration).equals(other$Duration)) {
            return false;
        }
        String this$Text = this.getText();
        String other$Text = other.getText();
        if (this$Text == null ? other$Text != null : !this$Text.equals(other$Text)) {
            return false;
        }
        Vector<String> this$SkipList = this.getSkipList();
        Vector<String> other$SkipList = other.getSkipList();
        if (this$SkipList == null ? other$SkipList != null : !((Object)this$SkipList).equals(other$SkipList)) {
            return false;
        }
        Date this$NextTodo = this.getNextTodo();
        Date other$NextTodo = other.getNextTodo();
        if (this$NextTodo == null ? other$NextTodo != null : !((Object)this$NextTodo).equals(other$NextTodo)) {
            return false;
        }
        Integer this$Vacation = this.getVacation();
        Integer other$Vacation = other.getVacation();
        if (this$Vacation == null ? other$Vacation != null : !((Object)this$Vacation).equals(other$Vacation)) {
            return false;
        }
        Integer this$Holiday = this.getHoliday();
        Integer other$Holiday = other.getHoliday();
        if (this$Holiday == null ? other$Holiday != null : !((Object)this$Holiday).equals(other$Holiday)) {
            return false;
        }
        if (this.isPrivate() != other.isPrivate()) {
            return false;
        }
        Integer this$Times = this.getTimes();
        Integer other$Times = other.getTimes();
        if (this$Times == null ? other$Times != null : !((Object)this$Times).equals(other$Times)) {
            return false;
        }
        String this$Frequency = this.getFrequency();
        String other$Frequency = other.getFrequency();
        if (this$Frequency == null ? other$Frequency != null : !this$Frequency.equals(other$Frequency)) {
            return false;
        }
        if (this.isTodo() != other.isTodo()) {
            return false;
        }
        String this$Color = this.getColor();
        String other$Color = other.getColor();
        if (this$Color == null ? other$Color != null : !this$Color.equals(other$Color)) {
            return false;
        }
        if (this.isRepeatFlag() != other.isRepeatFlag()) {
            return false;
        }
        String this$Category = this.getCategory();
        String other$Category = other.getCategory();
        if (this$Category == null ? other$Category != null : !this$Category.equals(other$Category)) {
            return false;
        }
        String this$ReminderTimes = this.getReminderTimes();
        String other$ReminderTimes = other.getReminderTimes();
        if (this$ReminderTimes == null ? other$ReminderTimes != null : !this$ReminderTimes.equals(other$ReminderTimes)) {
            return false;
        }
        String this$Untimed = this.getUntimed();
        String other$Untimed = other.getUntimed();
        if (this$Untimed == null ? other$Untimed != null : !this$Untimed.equals(other$Untimed)) {
            return false;
        }
        Date this$repeatUntil = this.getRepeatUntil();
        Date other$repeatUntil = other.getRepeatUntil();
        if (this$repeatUntil == null ? other$repeatUntil != null : !((Object)this$repeatUntil).equals(other$repeatUntil)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        return !(this$uid == null ? other$uid != null : !this$uid.equals(other$uid));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Appointment;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Date $Date = this.getDate();
        result = result * 31 + ($Date == null ? 0 : ((Object)$Date).hashCode());
        Integer $Duration = this.getDuration();
        result = result * 31 + ($Duration == null ? 0 : ((Object)$Duration).hashCode());
        String $Text = this.getText();
        result = result * 31 + ($Text == null ? 0 : $Text.hashCode());
        Vector<String> $SkipList = this.getSkipList();
        result = result * 31 + ($SkipList == null ? 0 : ((Object)$SkipList).hashCode());
        Date $NextTodo = this.getNextTodo();
        result = result * 31 + ($NextTodo == null ? 0 : ((Object)$NextTodo).hashCode());
        Integer $Vacation = this.getVacation();
        result = result * 31 + ($Vacation == null ? 0 : ((Object)$Vacation).hashCode());
        Integer $Holiday = this.getHoliday();
        result = result * 31 + ($Holiday == null ? 0 : ((Object)$Holiday).hashCode());
        result = result * 31 + (this.isPrivate() ? 1231 : 1237);
        Integer $Times = this.getTimes();
        result = result * 31 + ($Times == null ? 0 : ((Object)$Times).hashCode());
        String $Frequency = this.getFrequency();
        result = result * 31 + ($Frequency == null ? 0 : $Frequency.hashCode());
        result = result * 31 + (this.isTodo() ? 1231 : 1237);
        String $Color = this.getColor();
        result = result * 31 + ($Color == null ? 0 : $Color.hashCode());
        result = result * 31 + (this.isRepeatFlag() ? 1231 : 1237);
        String $Category = this.getCategory();
        result = result * 31 + ($Category == null ? 0 : $Category.hashCode());
        String $ReminderTimes = this.getReminderTimes();
        result = result * 31 + ($ReminderTimes == null ? 0 : $ReminderTimes.hashCode());
        String $Untimed = this.getUntimed();
        result = result * 31 + ($Untimed == null ? 0 : $Untimed.hashCode());
        Date $repeatUntil = this.getRepeatUntil();
        result = result * 31 + ($repeatUntil == null ? 0 : ((Object)$repeatUntil).hashCode());
        Integer $priority = this.getPriority();
        result = result * 31 + ($priority == null ? 0 : ((Object)$priority).hashCode());
        String $uid = this.getUid();
        result = result * 31 + ($uid == null ? 0 : $uid.hashCode());
        return result;
    }
}

