/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.entity;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.KeyedEntity;

@XmlRootElement(name="Task")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Task
extends KeyedEntity<Task>
implements CalendarEntity {
    private static final long serialVersionUID = -8980203293028263282L;
    private Date StartDate;
    private Date CompletionDate;
    private Date DueDate;
    private String PersonAssigned;
    private Integer Priority;
    private String State;
    private String Type;
    private String Description;
    private String Resolution;
    private String Category;
    private Integer Project;
    private String summary;

    @Override
    public String getColor() {
        return "navy";
    }

    @Override
    public Integer getDuration() {
        return new Integer(0);
    }

    @Override
    public Date getDate() {
        return this.getDueDate();
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public Date getNextTodo() {
        return null;
    }

    @Override
    public String getText() {
        String showabb = Prefs.getPref((PrefName)PrefName.TASK_SHOW_ABBREV);
        String abb = "";
        if (showabb.equals("true")) {
            abb = "BT" + this.getKey() + " ";
        }
        return abb + this.getSummary();
    }

    public String getSummary() {
        if (this.summary != null && !this.summary.isEmpty()) {
            return this.summary;
        }
        if (this.Description != null && !this.Description.isEmpty()) {
            String de = this.Description;
            if (de.indexOf(10) != -1) {
                de = de.substring(0, de.indexOf(10));
            }
            return de;
        }
        return "";
    }

    @Override
    protected Task clone() {
        Task dst = new Task();
        dst.setKey(this.getKey());
        dst.setStartDate(this.getStartDate());
        dst.setCompletionDate(this.getCompletionDate());
        dst.setDueDate(this.getDueDate());
        dst.setPersonAssigned(this.getPersonAssigned());
        dst.setPriority(this.getPriority());
        dst.setState(this.getState());
        dst.setType(this.getType());
        dst.setDescription(this.getDescription());
        dst.setResolution(this.getResolution());
        dst.setCategory(this.getCategory());
        dst.setProject(this.getProject());
        dst.setSummary(this.getSummary());
        return dst;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public Date getCompletionDate() {
        return this.CompletionDate;
    }

    public Date getDueDate() {
        return this.DueDate;
    }

    public String getPersonAssigned() {
        return this.PersonAssigned;
    }

    @Override
    public Integer getPriority() {
        return this.Priority;
    }

    public String getState() {
        return this.State;
    }

    public String getType() {
        return this.Type;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getResolution() {
        return this.Resolution;
    }

    public String getCategory() {
        return this.Category;
    }

    public Integer getProject() {
        return this.Project;
    }

    public void setStartDate(Date StartDate) {
        this.StartDate = StartDate;
    }

    public void setCompletionDate(Date CompletionDate) {
        this.CompletionDate = CompletionDate;
    }

    public void setDueDate(Date DueDate) {
        this.DueDate = DueDate;
    }

    public void setPersonAssigned(String PersonAssigned) {
        this.PersonAssigned = PersonAssigned;
    }

    public void setPriority(Integer Priority) {
        this.Priority = Priority;
    }

    public void setState(String State) {
        this.State = State;
    }

    public void setType(String Type2) {
        this.Type = Type2;
    }

    public void setDescription(String Description) {
        this.Description = Description;
    }

    public void setResolution(String Resolution) {
        this.Resolution = Resolution;
    }

    public void setCategory(String Category2) {
        this.Category = Category2;
    }

    public void setProject(Integer Project2) {
        this.Project = Project2;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String toString() {
        return "Task(StartDate=" + this.getStartDate() + ", CompletionDate=" + this.getCompletionDate() + ", DueDate=" + this.getDueDate() + ", PersonAssigned=" + this.getPersonAssigned() + ", Priority=" + this.getPriority() + ", State=" + this.getState() + ", Type=" + this.getType() + ", Description=" + this.getDescription() + ", Resolution=" + this.getResolution() + ", Category=" + this.getCategory() + ", Project=" + this.getProject() + ", summary=" + this.getSummary() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Date this$StartDate = this.getStartDate();
        Date other$StartDate = other.getStartDate();
        if (this$StartDate == null ? other$StartDate != null : !((Object)this$StartDate).equals(other$StartDate)) {
            return false;
        }
        Date this$CompletionDate = this.getCompletionDate();
        Date other$CompletionDate = other.getCompletionDate();
        if (this$CompletionDate == null ? other$CompletionDate != null : !((Object)this$CompletionDate).equals(other$CompletionDate)) {
            return false;
        }
        Date this$DueDate = this.getDueDate();
        Date other$DueDate = other.getDueDate();
        if (this$DueDate == null ? other$DueDate != null : !((Object)this$DueDate).equals(other$DueDate)) {
            return false;
        }
        String this$PersonAssigned = this.getPersonAssigned();
        String other$PersonAssigned = other.getPersonAssigned();
        if (this$PersonAssigned == null ? other$PersonAssigned != null : !this$PersonAssigned.equals(other$PersonAssigned)) {
            return false;
        }
        Integer this$Priority = this.getPriority();
        Integer other$Priority = other.getPriority();
        if (this$Priority == null ? other$Priority != null : !((Object)this$Priority).equals(other$Priority)) {
            return false;
        }
        String this$State = this.getState();
        String other$State = other.getState();
        if (this$State == null ? other$State != null : !this$State.equals(other$State)) {
            return false;
        }
        String this$Type = this.getType();
        String other$Type = other.getType();
        if (this$Type == null ? other$Type != null : !this$Type.equals(other$Type)) {
            return false;
        }
        String this$Description = this.getDescription();
        String other$Description = other.getDescription();
        if (this$Description == null ? other$Description != null : !this$Description.equals(other$Description)) {
            return false;
        }
        String this$Resolution = this.getResolution();
        String other$Resolution = other.getResolution();
        if (this$Resolution == null ? other$Resolution != null : !this$Resolution.equals(other$Resolution)) {
            return false;
        }
        String this$Category = this.getCategory();
        String other$Category = other.getCategory();
        if (this$Category == null ? other$Category != null : !this$Category.equals(other$Category)) {
            return false;
        }
        Integer this$Project = this.getProject();
        Integer other$Project = other.getProject();
        if (this$Project == null ? other$Project != null : !((Object)this$Project).equals(other$Project)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        return !(this$summary == null ? other$summary != null : !this$summary.equals(other$summary));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        Date $StartDate = this.getStartDate();
        result = result * 31 + ($StartDate == null ? 0 : ((Object)$StartDate).hashCode());
        Date $CompletionDate = this.getCompletionDate();
        result = result * 31 + ($CompletionDate == null ? 0 : ((Object)$CompletionDate).hashCode());
        Date $DueDate = this.getDueDate();
        result = result * 31 + ($DueDate == null ? 0 : ((Object)$DueDate).hashCode());
        String $PersonAssigned = this.getPersonAssigned();
        result = result * 31 + ($PersonAssigned == null ? 0 : $PersonAssigned.hashCode());
        Integer $Priority = this.getPriority();
        result = result * 31 + ($Priority == null ? 0 : ((Object)$Priority).hashCode());
        String $State = this.getState();
        result = result * 31 + ($State == null ? 0 : $State.hashCode());
        String $Type = this.getType();
        result = result * 31 + ($Type == null ? 0 : $Type.hashCode());
        String $Description = this.getDescription();
        result = result * 31 + ($Description == null ? 0 : $Description.hashCode());
        String $Resolution = this.getResolution();
        result = result * 31 + ($Resolution == null ? 0 : $Resolution.hashCode());
        String $Category = this.getCategory();
        result = result * 31 + ($Category == null ? 0 : $Category.hashCode());
        Integer $Project = this.getProject();
        result = result * 31 + ($Project == null ? 0 : ((Object)$Project).hashCode());
        String $summary = this.getSummary();
        result = result * 31 + ($summary == null ? 0 : $summary.hashCode());
        return result;
    }
}

