/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.ical;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.IOHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;

public class AppointmentIcalAdapter {
    private static final Logger log = Logger.getLogger("net.sf.borg");

    public static void exportIcalToFile(String filename, java.util.Date after) throws Exception {
        Calendar cal = AppointmentIcalAdapter.exportIcal(after, true);
        OutputStream oostr = IOHelper.createOutputStream((String)filename);
        CalendarOutputter op = new CalendarOutputter();
        op.output(cal, oostr);
        oostr.close();
    }

    public static String exportIcalToString(java.util.Date after) throws Exception {
        Calendar cal = AppointmentIcalAdapter.exportIcal(after, true);
        CalendarOutputter op = new CalendarOutputter();
        StringWriter sw = new StringWriter();
        op.output(cal, (Writer)sw);
        return sw.toString();
    }

    public static Component toIcal(Appointment ap, boolean export_todos) throws Exception {
        DtStart dts;
        TextList catlist = new TextList();
        Object ve = null;
        ve = ap.isTodo() && export_todos ? new VToDo() : new VEvent();
        String uidval = ap.getUid();
        if (uidval == null || uidval.isEmpty()) {
            uidval = Integer.toString(ap.getKey()) + "@BORGA-" + ap.getCreateTime().getTime();
        }
        Uid uid = new Uid(uidval);
        ve.getProperties().add((Property)uid);
        ve.getProperties().add((Property)new Created(new DateTime(ap.getCreateTime())));
        ve.getProperties().add((Property)new LastModified(new DateTime(ap.getLastMod())));
        String appttext = ap.getText();
        Summary sum = null;
        Description desc = null;
        int ii = appttext.indexOf(10);
        if (ii != -1) {
            sum = new Summary(appttext.substring(0, ii));
            desc = new Description(appttext.substring(ii + 1));
        } else {
            sum = new Summary(appttext);
        }
        ve.getProperties().add((Property)sum);
        if (desc != null) {
            ve.getProperties().add(desc);
        }
        ParameterList pl = new ParameterList();
        if (ve instanceof VToDo) {
            Due due;
            VToDo todo;
            DtStart dtd;
            java.util.Date nt = ap.getNextTodo();
            if (nt == null) {
                nt = ap.getDate();
            }
            if (AppointmentModel.isNote(ap)) {
                pl.add((Parameter)Value.DATE);
                dtd = new DtStart(pl, new Date(nt));
                ve.getProperties().add((Property)dtd);
                todo = (VToDo)ve;
                due = new Due(pl, new Date(nt));
                todo.getProperties().add((Property)due);
            } else {
                pl.add((Parameter)Value.DATE_TIME);
                dtd = new DtStart(pl, new Date(nt));
                ve.getProperties().add((Property)dtd);
                todo = (VToDo)ve;
                due = new Due(pl, new Date(nt));
                todo.getProperties().add((Property)due);
            }
        } else if (AppointmentModel.isNote(ap)) {
            pl.add((Parameter)Value.DATE);
            dts = new DtStart(pl, new Date(ap.getDate()));
            ve.getProperties().add((Property)dts);
            java.util.Date end = new java.util.Date(ap.getDate().getTime() + 86400000L);
            DtEnd dte = new DtEnd(pl, new Date(end));
            ve.getProperties().add((Property)dte);
        } else {
            pl.add((Parameter)Value.DATE_TIME);
            dts = new DtStart(pl, (Date)new DateTime(ap.getDate()));
            dts.setUtc(true);
            ve.getProperties().add((Property)dts);
        }
        if (ap.getDuration() != null && ap.getDuration() != 0) {
            ve.getProperties().add((Property)new Duration(new Dur(0, 0, ap.getDuration().intValue(), 0)));
        }
        if (ap.getVacation() != null && ap.getVacation() == 1) {
            catlist.add("Vacation");
        } else if (ap.getVacation() != null && ap.getVacation() == 2) {
            catlist.add("HalfDay");
        }
        if (ap.getHoliday() != null && ap.getHoliday() != 0) {
            catlist.add("Holidays");
        }
        if (ap.isPrivate()) {
            ve.getProperties().add((Property)Clazz.PRIVATE);
            catlist.add("Private");
        }
        if (ap.getColor() != null && (ap.getColor().equals("black") || ap.getColor().equals("blue") || ap.getColor().equals("green") || ap.getColor().equals("red") || ap.getColor().equals("white"))) {
            catlist.add(ap.getColor());
        }
        if (ap.getCategory() != null && !ap.getCategory().equals("")) {
            catlist.add(ap.getCategory());
        }
        if (ap.isTodo()) {
            catlist.add("ToDo");
        }
        if (!catlist.isEmpty()) {
            ve.getProperties().add((Property)new Categories(catlist));
        }
        if (ap.isRepeatFlag()) {
            GregorianCalendar gc;
            java.util.Date dd;
            String rec = "FREQ=";
            String freq = Repeat.getFreq(ap.getFrequency());
            if (freq == null || freq.equals("daily")) {
                rec = rec + "DAILY";
            } else if (freq.equals("weekly")) {
                rec = rec + "WEEKLY";
            } else if (freq.equals("biweekly")) {
                rec = rec + "WEEKLY;INTERVAL=2";
            } else if (freq.equals("monthly")) {
                dd = ap.getDate();
                gc = new GregorianCalendar();
                gc.setTime(dd);
                rec = rec + "MONTHLY;BYMONTHDAY=" + gc.get(5);
            } else if (freq.equals("monthly_day")) {
                dd = ap.getDate();
                gc = new GregorianCalendar();
                gc.setTime(dd);
                int dayOfWeek = gc.get(7);
                int dayOfWeekMonth = gc.get(8);
                String[] days = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
                rec = rec + "MONTHLY;BYDAY=" + dayOfWeekMonth + days[dayOfWeek - 1];
            } else if (freq.equals("yearly")) {
                rec = rec + "YEARLY";
            } else if (freq.equals("ndays")) {
                rec = rec + "DAILY;INTERVAL=" + Repeat.getNValue(ap.getFrequency());
            } else if (freq.equals("nweeks")) {
                rec = rec + "WEEKLY;INTERVAL=" + Repeat.getNValue(ap.getFrequency());
            } else if (freq.equals("nmonths")) {
                rec = rec + "MONTHLY;INTERVAL=" + Repeat.getNValue(ap.getFrequency());
            } else if (freq.equals("nyears")) {
                rec = rec + "YEARLY;INTERVAL=" + Repeat.getNValue(ap.getFrequency());
            } else if (freq.equals("weekdays")) {
                rec = rec + "WEEKLY;BYDAY=MO,TU,WE,TH,FR";
            } else if (freq.equals("mwf")) {
                rec = rec + "WEEKLY;BYDAY=MO,WE,FR";
            } else if (freq.equals("weekends")) {
                rec = rec + "WEEKLY;BYDAY=SU,SA";
            } else if (freq.equals("tth")) {
                rec = rec + "WEEKLY;BYDAY=TU,TH";
            } else if (freq.equals("dlist")) {
                String[] days = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
                rec = rec + "WEEKLY;BYDAY=";
                Collection<Integer> c = Repeat.getDaylist(ap.getFrequency());
                Iterator<Integer> it = c.iterator();
                while (it.hasNext()) {
                    Integer i = it.next();
                    rec = rec + days[i - 1];
                    if (!it.hasNext()) continue;
                    rec = rec + ",";
                }
            } else {
                log.warning("Could not export appt " + ap.getKey() + ap.getText());
                return null;
            }
            if (ap.getTimes() != 9999) {
                rec = rec + ";COUNT=" + Repeat.calculateTimes(ap);
            }
            ve.getProperties().add((Property)new RRule(new Recur(rec)));
            if (ap.getSkipList() != null) {
                long start_epoch = DateUtil.dayOfEpoch((java.util.Date)ap.getDate());
                if (AppointmentModel.isNote(ap)) {
                    DateList dl = new DateList(Value.DATE);
                    for (String rkey : ap.getSkipList()) {
                        long skip_epoch = Long.parseLong(rkey);
                        long real_skip = (skip_epoch - start_epoch) * 24L * 60L * 60L * 1000L + ap.getDate().getTime();
                        java.util.Date skdate = new java.util.Date(real_skip);
                        dl.add(new Date(skdate));
                    }
                    dl.setUtc(true);
                    ve.getProperties().add((Property)new ExDate(dl));
                } else {
                    DateList dl = new DateList(Value.DATE_TIME);
                    for (String rkey : ap.getSkipList()) {
                        long skip_epoch = Long.parseLong(rkey);
                        long real_skip = (skip_epoch - start_epoch) * 24L * 60L * 60L * 1000L + ap.getDate().getTime();
                        DateTime skdate = new DateTime(real_skip);
                        dl.add((Date)new DateTime((java.util.Date)skdate));
                    }
                    dl.setUtc(true);
                    ve.getProperties().add((Property)new ExDate(dl));
                }
            }
        }
        if (ap.getReminderTimes() != null && !ap.getReminderTimes().isEmpty() && ap.getReminderTimes().contains("Y") && (ap.isRepeatFlag() || ap.getDate().after(new java.util.Date()))) {
            VAlarm va = new VAlarm(new Dur(0, 0, -30, 0));
            va.getProperties().add((Property)Action.DISPLAY);
            va.getProperties().add((Property)new Description(ap.getText()));
            va.getProperties().add((Property)new net.fortuna.ical4j.model.property.Repeat(2));
            va.getProperties().add((Property)new Duration(new Dur(0, 0, 15, 0)));
            if (ve instanceof VEvent) {
                ve.getAlarms().add((Component)va);
            } else {
                ((VToDo)ve).getAlarms().add((Component)va);
            }
        }
        return ve;
    }

    public static Calendar exportIcal(java.util.Date after, boolean tasks) throws Exception {
        ComponentList clist = new ComponentList();
        AppointmentIcalAdapter.exportAppointments(clist, after);
        if (tasks) {
            AppointmentIcalAdapter.exportProjects(clist);
            AppointmentIcalAdapter.exportTasks(clist);
            AppointmentIcalAdapter.exportSubTasks(clist);
        }
        PropertyList pl = new PropertyList();
        pl.add((Property)new ProdId("BORG Calendar"));
        pl.add((Property)Version.VERSION_2_0);
        Calendar cal = new Calendar(pl, clist);
        cal.validate();
        return cal;
    }

    private static void exportAppointments(ComponentList clist, java.util.Date after) throws Exception {
        boolean export_todos = Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO);
        for (Appointment ap : AppointmentModel.getReference().getAllAppts()) {
            Component ve;
            java.util.Date latestInstance;
            if (after != null && (latestInstance = Repeat.calculateLastRepeat(ap)) != null && latestInstance.before(after) || (ve = AppointmentIcalAdapter.toIcal(ap, export_todos)) == null) continue;
            clist.add(ve);
        }
    }

    private static void exportTasks(ComponentList clist) throws Exception {
        boolean export_todos = Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO);
        for (Task t : TaskModel.getReference().getTasks()) {
            java.util.Date due;
            if (TaskModel.isClosed(t) || (due = t.getDueDate()) == null) continue;
            Object ve = null;
            ve = export_todos ? new VToDo() : new VEvent();
            long updated = new java.util.Date().getTime();
            String uidval = Integer.toString(t.getKey()) + "@BORGT" + updated;
            Uid uid = new Uid(uidval);
            ve.getProperties().add((Property)uid);
            ve.getProperties().add((Property)new Summary("[T]" + t.getSummary()));
            if (t.getDescription() != null && !t.getDescription().isEmpty()) {
                ve.getProperties().add((Property)new Description(t.getDescription()));
            }
            ParameterList pl = new ParameterList();
            pl.add((Parameter)Value.DATE);
            DtStart dts = new DtStart(pl, new Date(due));
            ve.getProperties().add((Property)dts);
            java.util.Date end = new java.util.Date(due.getTime() + 86400000L);
            DtEnd dte = new DtEnd(pl, new Date(end));
            ve.getProperties().add((Property)dte);
            clist.add((Component)ve);
        }
    }

    private static void exportProjects(ComponentList clist) throws Exception {
        boolean export_todos = Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO);
        for (Project t : TaskModel.getReference().getProjects()) {
            java.util.Date due;
            if (TaskModel.isClosed(t) || (due = t.getDueDate()) == null) continue;
            Object ve = null;
            ve = export_todos ? new VToDo() : new VEvent();
            long updated = new java.util.Date().getTime();
            String uidval = Integer.toString(t.getKey()) + "@BORGP" + updated;
            Uid uid = new Uid(uidval);
            ve.getProperties().add((Property)uid);
            ve.getProperties().add((Property)new Summary("[P]" + t.getDescription()));
            ParameterList pl = new ParameterList();
            pl.add((Parameter)Value.DATE);
            DtStart dts = new DtStart(pl, new Date(due));
            ve.getProperties().add((Property)dts);
            java.util.Date end = new java.util.Date(due.getTime() + 86400000L);
            DtEnd dte = new DtEnd(pl, new Date(end));
            ve.getProperties().add((Property)dte);
            clist.add((Component)ve);
        }
    }

    private static void exportSubTasks(ComponentList clist) throws Exception {
        boolean export_todos = Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO);
        for (Subtask t : TaskModel.getReference().getSubTasks()) {
            java.util.Date due;
            if (t.getCloseDate() != null || (due = t.getDueDate()) == null) continue;
            Object ve = null;
            ve = export_todos ? new VToDo() : new VEvent();
            long updated = new java.util.Date().getTime();
            String uidval = Integer.toString(t.getKey()) + "@BORGS" + updated;
            Uid uid = new Uid(uidval);
            ve.getProperties().add((Property)uid);
            ve.getProperties().add((Property)new Summary("[S]" + t.getDescription()));
            ParameterList pl = new ParameterList();
            pl.add((Parameter)Value.DATE);
            DtStart dts = new DtStart(pl, new Date(due));
            ve.getProperties().add((Property)dts);
            java.util.Date end = new java.util.Date(due.getTime() + 86400000L);
            DtEnd dte = new DtEnd(pl, new Date(end));
            ve.getProperties().add((Property)dte);
            clist.add((Component)ve);
        }
    }

    public static String importIcalFromUrl(String urlString) throws Exception {
        IOHelper.setProxy();
        CalendarBuilder builder = new CalendarBuilder();
        URL url = new URL(urlString);
        InputStream is = url.openStream();
        Calendar cal = builder.build(is);
        is.close();
        return AppointmentIcalAdapter.importIcal(cal);
    }

    public static String importIcalFromFile(String file) throws Exception {
        CalendarBuilder builder = new CalendarBuilder();
        FileInputStream is = new FileInputStream(file);
        Calendar cal = builder.build((InputStream)is);
        ((InputStream)is).close();
        return AppointmentIcalAdapter.importIcal(cal);
    }

    private static String importIcal(Calendar cal) throws Exception {
        int skipped = 0;
        StringBuffer dups = new StringBuffer();
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        StringBuffer warning = new StringBuffer();
        try {
            cal.validate();
        }
        catch (ValidationException e) {
            Errmsg.getErrorHandler().notice("Ical4j validation error: " + e.getLocalizedMessage());
        }
        ArrayList<Appointment> aplist = new ArrayList<Appointment>();
        AppointmentModel amodel = AppointmentModel.getReference();
        ComponentList clist = cal.getComponents();
        for (Component comp : clist) {
            Appointment ap = AppointmentIcalAdapter.toBorg(comp);
            if (ap == null) continue;
            aplist.add(ap);
        }
        int imported = 0;
        int dup_count = 0;
        for (Appointment ap : aplist) {
            List<Appointment> appts = AppointmentModel.getReference().getAppointmentsByText(ap.getText());
            if (appts.contains(ap)) {
                ++dup_count;
                dups.append("DUP: " + ap.getText() + "\n");
                continue;
            }
            ++imported;
            amodel.saveAppt(ap);
        }
        warning.append("Imported: " + imported + "\n");
        warning.append("Skipped: " + skipped + "\n");
        warning.append("Duplicates: " + dup_count + "\n");
        warning.append(dups.toString());
        if (warning.length() == 0) {
            return null;
        }
        return warning.toString();
    }

    private static int tzOffset(long date) {
        return TimeZone.getDefault().getOffset(date);
    }

    public static Appointment toBorg(Component comp) {
        if (comp instanceof VEvent || comp instanceof VToDo) {
            Clazz clazz;
            Duration dur;
            int durdays;
            AppointmentModel amodel = AppointmentModel.getReference();
            Appointment ap = amodel.getDefaultAppointment();
            if (ap == null) {
                ap = amodel.newAppt();
            }
            ap.setCategory(null);
            PropertyList pl = comp.getProperties();
            String appttext = "";
            String summary = "";
            Property prop = pl.getProperty("SUMMARY");
            if (prop != null) {
                summary = prop.getValue();
                appttext = appttext + prop.getValue();
            }
            if ((prop = pl.getProperty("LOCATION")) != null) {
                appttext = appttext + "\nLocation: " + prop.getValue();
            }
            if ((prop = pl.getProperty("DESCRIPTION")) != null) {
                appttext = appttext + "\n" + prop.getValue();
            }
            ap.setUntimed("Y");
            ap.setText(appttext);
            prop = pl.getProperty("DTSTART");
            if (prop != null) {
                DtStart dts = (DtStart)prop;
                Date d = dts.getDate();
                java.util.Date utc = new java.util.Date();
                utc.setTime(d.getTime());
                if (!dts.isUtc() && !dts.getValue().contains("T")) {
                    long u = d.getTime() - (long)AppointmentIcalAdapter.tzOffset(d.getTime());
                    utc.setTime(u);
                }
                ap.setDate(utc);
                if (!dts.getValue().contains("T") || dts.getValue().contains("T000000")) {
                    ap.setUntimed("Y");
                } else {
                    ap.setUntimed("N");
                    prop = pl.getProperty("DTEND");
                    if (prop != null) {
                        DtEnd dte = (DtEnd)prop;
                        Date de = dte.getDate();
                        long dur2 = (de.getTime() - d.getTime()) / 60000L;
                        ap.setDuration(new Integer((int)dur2));
                    }
                }
            }
            if (comp instanceof VToDo) {
                ap.setTodo(true);
            }
            Uid uid = (Uid)pl.getProperty("UID");
            ap.setUid(uid.getValue());
            LastModified lm = (LastModified)pl.getProperty("LAST-MODIFIED");
            if (lm != null) {
                ap.setLastMod((java.util.Date)lm.getDateTime());
            } else {
                ap.setLastMod(new java.util.Date());
            }
            Created cr = (Created)pl.getProperty("CREATED");
            if (cr != null) {
                ap.setCreateTime((java.util.Date)cr.getDateTime());
            } else {
                ap.setCreateTime(new java.util.Date());
            }
            prop = pl.getProperty("DURATION");
            if (prop != null && (durdays = (dur = (Duration)prop).getDuration().getDays()) < 1) {
                ap.setDuration(new Integer(dur.getDuration().getMinutes()));
            }
            if ((prop = pl.getProperty("CATEGORIES")) != null) {
                Categories cats = (Categories)prop;
                TextList catlist = cats.getCategories();
                for (String cat : catlist) {
                    if (cat.equals("Holidays")) {
                        ap.setHoliday(new Integer(1));
                        continue;
                    }
                    if (cat.equals("Vacation")) {
                        ap.setVacation(new Integer(1));
                        continue;
                    }
                    if (cat.equals("HalfDay")) {
                        ap.setVacation(new Integer(2));
                        continue;
                    }
                    if (cat.equals("Private")) {
                        ap.setPrivate(true);
                        continue;
                    }
                    if (cat.equals("ToDo")) {
                        ap.setTodo(true);
                        continue;
                    }
                    if (cat.equals("black") | cat.equals("red") || cat.equals("green") || cat.equals("blue") || cat.equals("white")) {
                        ap.setColor(cat);
                        continue;
                    }
                    ap.setCategory(cat);
                }
            }
            if ((prop = pl.getProperty("CLASS")) != null && (clazz = (Clazz)prop).getValue().equals(Clazz.PRIVATE)) {
                ap.setPrivate(true);
            }
            if ((prop = pl.getProperty("RRULE")) != null) {
                RRule rr = (RRule)prop;
                Recur recur = rr.getRecur();
                String freq = recur.getFrequency();
                int interval = recur.getInterval();
                if (freq.equals("DAILY")) {
                    ap.setFrequency("daily");
                } else if (freq.equals("WEEKLY")) {
                    if (interval == 2) {
                        ap.setFrequency("biweekly");
                    } else {
                        ap.setFrequency("weekly");
                    }
                    WeekDayList dl = recur.getDayList();
                    if (dl != null && !dl.isEmpty()) {
                        String f = "dlist";
                        f = f + ",";
                        for (Object o : dl) {
                            WeekDay wd = (WeekDay)o;
                            f = f + WeekDay.getCalendarDay((WeekDay)wd);
                        }
                        ap.setFrequency(f);
                    }
                } else if (freq.equals("MONTHLY")) {
                    ap.setFrequency("monthly");
                } else if (freq.equals("YEARLY")) {
                    ap.setFrequency("yearly");
                } else {
                    log.warning("WARNING: Cannot handle frequency of [" + freq + "], for appt [" + summary + "], adding first occurrence only\n");
                    return ap;
                }
                Date until = recur.getUntil();
                if (until != null) {
                    long u = until.getTime() - (long)AppointmentIcalAdapter.tzOffset(until.getTime());
                    ap.setRepeatUntil(new java.util.Date(u));
                } else {
                    int times = recur.getCount();
                    if (times < 1) {
                        times = 9999;
                    }
                    ap.setTimes(new Integer(times));
                }
                ap.setRepeatFlag(true);
                ExDate ex = (ExDate)pl.getProperty("EXDATE");
                if (ex != null) {
                    Vector<String> vect = new Vector<String>();
                    DateList dl = ex.getDates();
                    dl.setUtc(true);
                    for (Object o : dl) {
                        if (!(o instanceof Date)) continue;
                        int rkey = (int)(((Date)o).getTime() / 1000L / 60L / 60L / 24L);
                        vect.add(Integer.toString(rkey));
                    }
                    ap.setSkipList(vect);
                }
            }
            return ap;
        }
        return null;
    }
}

