/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.ical;

import biz.source_code.base64Coder.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.CalDavCalendarStore;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.sf.borg.common.IOHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.ical.AppointmentIcalAdapter;
import net.sf.borg.model.ical.SyncEvent;
import net.sf.borg.model.ical.SyncLog;

public class CalDav {
    private static final String PRODID = "-//MBCSoft/BORG//EN";
    private static final Logger log = Logger.getLogger("net.sf.borg");

    public static boolean isSyncing() {
        String server = Prefs.getPref((PrefName)PrefName.CALDAV_SERVER);
        return server != null && !server.isEmpty();
    }

    private static void addEvent(CalDavCalendarCollection collection, Component comp) {
        log.info("SYNC: addEvent: " + comp.toString());
        Calendar mycal = new Calendar();
        mycal.getProperties().add((Property)new ProdId(PRODID));
        mycal.getProperties().add((Property)Version.VERSION_2_0);
        mycal.getComponents().add(comp);
        try {
            collection.addCalendar(mycal);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    private static CalDavCalendarStore connect() throws Exception {
        IOHelper.setProxy();
        URL url = new URL("http", Prefs.getPref((PrefName)PrefName.CALDAV_SERVER), -1, "/");
        IOHelper.sendLogMessage((String)("SYNC: connect to " + url.toString()));
        log.info("SYNC: connect to " + url.toString());
        CalDavCalendarStore store = new CalDavCalendarStore("-", url, (PathResolver)new BaikalPathResolver());
        if (store.connect(Prefs.getPref((PrefName)PrefName.CALDAV_USER), CalDav.gep().toCharArray())) {
            return store;
        }
        return null;
    }

    public static void export(Integer years) throws Exception {
        String cal2;
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        java.util.Date after = null;
        if (years != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(1, -1 * years);
            after = cal.getTime();
        }
        Calendar calendar = AppointmentIcalAdapter.exportIcal(after, false);
        String calname = Prefs.getPref((PrefName)PrefName.CALDAV_CAL);
        CalDavCalendarStore store = CalDav.connect();
        if (store == null) {
            throw new Exception("Failed to connect to CalDav Store");
        }
        String cal_id = new BaikalPathResolver().getUserPath(Prefs.getPref((PrefName)PrefName.CALDAV_USER)) + "/" + calname;
        try {
            store.removeCollection(cal_id);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        CalDavCalendarCollection collection = store.addCollection(cal_id, calname, calname, new String[]{"VEVENT", "VTODO"}, null);
        ComponentList clist = calendar.getComponents();
        for (Component comp : clist) {
            CalDav.addEvent(collection, comp);
        }
        if (Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO) && !(cal2 = Prefs.getPref((PrefName)PrefName.CALDAV_CAL2)).isEmpty()) {
            String cal_id2 = new BaikalPathResolver().getUserPath(Prefs.getPref((PrefName)PrefName.CALDAV_USER)) + "/" + cal2;
            try {
                store.removeCollection(cal_id2);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
            CalDavCalendarCollection collection2 = store.addCollection(cal_id2, cal2, cal2, new String[]{"VEVENT", "VTODO"}, null);
            ComponentList clist2 = calendar.getComponents();
            for (Component comp : clist2) {
                if (!(comp instanceof VToDo)) continue;
                Appointment ap = AppointmentIcalAdapter.toBorg(comp);
                ap.setUid(ap.getUid() + "TD");
                Component ve = AppointmentIcalAdapter.toIcal(ap, false);
                CalDav.addEvent(collection2, ve);
            }
        }
    }

    public static String gep() throws Exception {
        String p1 = Prefs.getPref((PrefName)PrefName.CALDAV_PASSWORD2);
        String p2 = Prefs.getPref((PrefName)PrefName.CALDAV_PASSWORD);
        if ("".equals(p2)) {
            return p2;
        }
        if ("".equals(p1)) {
            CalDav.sep(p2);
            return p2;
        }
        byte[] ba = Base64Coder.decode((String)p1);
        SecretKeySpec key = new SecretKeySpec(ba, "AES");
        Cipher dec = Cipher.getInstance("AES");
        dec.init(2, key);
        byte[] decba = Base64Coder.decode((String)p2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, dec);
        ((OutputStream)os).write(decba);
        ((OutputStream)os).close();
        return baos.toString();
    }

    private static CalDavCalendarCollection getCollection(CalDavCalendarStore store, String calName) throws Exception {
        String cal_id = new BaikalPathResolver().getUserPath(Prefs.getPref((PrefName)PrefName.CALDAV_USER)) + "/" + calName;
        return store.getCollection(cal_id);
    }

    private static Component getEvent(CalDavCalendarCollection collection, String uid) {
        Calendar cal = collection.getCalendar(uid);
        if (cal == null) {
            return null;
        }
        ComponentList clist = cal.getComponents();
        for (Component comp : clist) {
            if (!(comp instanceof VEvent) && !(comp instanceof VToDo)) continue;
            return comp;
        }
        return null;
    }

    public static void processSyncMap(CalDavCalendarCollection collection, CalDavCalendarCollection collection2) throws Exception {
        boolean export_todos = Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO);
        List<SyncEvent> syncEvents = SyncLog.getReference().getAll();
        IOHelper.sendLogMessage((String)("SYNC: Process " + syncEvents.size() + " Outgoing Items"));
        log.info("SYNC: Process " + syncEvents.size() + " Outgoing Items");
        for (SyncEvent se : syncEvents) {
            if (se.getObjectType() != SyncEvent.ObjectType.APPOINTMENT) continue;
            try {
                Component comp;
                if (se.getAction().equals((Object)Model.ChangeEvent.ChangeAction.ADD)) {
                    Appointment ap = AppointmentModel.getReference().getAppt(se.getId());
                    if (ap == null) continue;
                    Component ve1 = AppointmentIcalAdapter.toIcal(ap, export_todos);
                    CalDav.addEvent(collection, ve1);
                    if (collection2 != null && ap.isTodo()) {
                        Component ve = AppointmentIcalAdapter.toIcal(ap, false);
                        Uid uid = (Uid)ve.getProperty("UID");
                        uid.setValue(uid.getValue() + "TD");
                        ve.getProperty("DTSTART").setValue(ve1.getProperty("DTSTART").getValue());
                        CalDav.addEvent(collection2, ve);
                    }
                } else if (se.getAction().equals((Object)Model.ChangeEvent.ChangeAction.CHANGE)) {
                    Uid uid;
                    Component ve;
                    Component ve1;
                    comp = CalDav.getEvent(collection, se.getUid());
                    Appointment ap = AppointmentModel.getReference().getAppt(se.getId());
                    if (comp == null) {
                        ve1 = AppointmentIcalAdapter.toIcal(ap, export_todos);
                        CalDav.addEvent(collection, ve1);
                        if (collection2 != null && ap.isTodo()) {
                            ve = AppointmentIcalAdapter.toIcal(ap, false);
                            uid = (Uid)ve.getProperty("UID");
                            uid.setValue(uid.getValue() + "TD");
                            ve.getProperty("DTSTART").setValue(ve1.getProperty("DTSTART").getValue());
                            CalDav.addEvent(collection2, ve);
                        }
                    } else {
                        ve1 = AppointmentIcalAdapter.toIcal(ap, export_todos);
                        CalDav.updateEvent(collection, ve1);
                        if (collection2 != null && ap.isTodo()) {
                            ve = AppointmentIcalAdapter.toIcal(ap, false);
                            uid = (Uid)ve.getProperty("UID");
                            uid.setValue(uid.getValue() + "TD");
                            ve.getProperty("DTSTART").setValue(ve1.getProperty("DTSTART").getValue());
                            CalDav.updateEvent(collection2, ve);
                        }
                    }
                } else if (se.getAction().equals((Object)Model.ChangeEvent.ChangeAction.DELETE)) {
                    comp = CalDav.getEvent(collection, se.getUid());
                    if (comp != null) {
                        log.info("SYNC: removeEvent: " + comp.toString());
                        collection.removeCalendar(se.getUid());
                        if (collection2 != null && comp instanceof VToDo) {
                            collection2.removeCalendar(se.getUid() + "TD");
                        }
                    } else {
                        log.info("Deleted Appt: " + se.getUid() + " not found on server");
                    }
                }
                SyncLog.getReference().delete(se.getId(), se.getObjectType());
            }
            catch (Exception e) {
                IOHelper.sendLogMessage((String)("SYNC ERROR for: " + se.toString() + ":" + e.getMessage()));
                log.severe("SYNC ERROR for: " + se.toString() + ":" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void sep(String s) throws Exception {
        SecretKey key;
        if ("".equals(s)) {
            Prefs.putPref((PrefName)PrefName.CALDAV_PASSWORD, (Object)s);
            return;
        }
        String p1 = Prefs.getPref((PrefName)PrefName.CALDAV_PASSWORD2);
        if ("".equals(p1)) {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            key = keyGen.generateKey();
            p1 = new String(Base64Coder.encode((byte[])key.getEncoded()));
            Prefs.putPref((PrefName)PrefName.CALDAV_PASSWORD2, (Object)p1);
        }
        byte[] ba = Base64Coder.decode((String)p1);
        key = new SecretKeySpec(ba, "AES");
        Cipher enc = Cipher.getInstance("AES");
        enc.init(1, key);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CipherOutputStream os = new CipherOutputStream(baos, enc);
        ((OutputStream)os).write(s.getBytes());
        ((OutputStream)os).close();
        ba = baos.toByteArray();
        Prefs.putPref((PrefName)PrefName.CALDAV_PASSWORD, (Object)new String(Base64Coder.encode((byte[])ba)));
    }

    public static void sync(Integer years, boolean outward_only) throws Exception {
        String cal2;
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        CalDavCalendarStore store = CalDav.connect();
        if (store == null) {
            throw new Exception("Failed to connect to CalDav Store");
        }
        log.info("SYNC: Get Collection");
        String calname = Prefs.getPref((PrefName)PrefName.CALDAV_CAL);
        CalDavCalendarCollection collection = CalDav.getCollection(store, calname);
        CalDavCalendarCollection collection2 = null;
        if (Prefs.getBoolPref((PrefName)PrefName.ICAL_EXPORT_TODO) && !(cal2 = Prefs.getPref((PrefName)PrefName.CALDAV_CAL2)).isEmpty()) {
            collection2 = CalDav.getCollection(store, cal2);
        }
        CalDav.processSyncMap(collection, collection2);
        if (!outward_only) {
            CalDav.syncFromServer(collection, years);
            CalDav.processSyncMap(collection, collection2);
        }
        log.info("SYNC: Done");
    }

    public static void processRecurrence(Component comp, String uid) throws Exception {
        RecurrenceId rid = (RecurrenceId)comp.getProperty("RECURRENCE-ID");
        Appointment ap = AppointmentModel.getReference().getApptByUid(uid);
        if (ap != null) {
            java.util.Date nt;
            if (comp instanceof VEvent) {
                log.warning("SYNC: ignoring Vevent for single recurrence - cannot process\n" + comp.toString());
                IOHelper.sendLogMessage((String)("SYNC: ignoring Vevent for single recurrence - cannot process\n" + comp.toString()));
                return;
            }
            Completed cpltd = (Completed)comp.getProperty("COMPLETED");
            if (cpltd == null) {
                log.warning("SYNC: ignoring VToDo for single recurrence - cannot process\n" + comp.toString());
                IOHelper.sendLogMessage((String)("SYNC: ignoring VToDo for single recurrence - cannot process\n" + comp.toString()));
                return;
            }
            Date riddate = rid.getDate();
            java.util.Date utc = new java.util.Date();
            utc.setTime(riddate.getTime());
            if (!rid.isUtc() && !rid.getValue().contains("T")) {
                long u = riddate.getTime() - (long)TimeZone.getDefault().getOffset(riddate.getTime());
                utc.setTime(u);
            }
            if ((nt = ap.getNextTodo()) == null) {
                nt = ap.getDate();
            }
            if (!utc.before(nt)) {
                log.warning("SYNC: completing Todo\n" + comp.toString());
                IOHelper.sendLogMessage((String)("SYNC: completing Todo\n" + comp.toString()));
                AppointmentModel.getReference().do_todo(ap.getKey(), false, utc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int syncCalendar(Calendar cal, ArrayList<String> serverUids) throws Exception {
        int count = 0;
        ComponentList clist = cal.getComponents();
        for (Component comp : clist) {
            Appointment ap;
            if (!(comp instanceof VEvent) && !(comp instanceof VToDo)) continue;
            String uid = comp.getProperty("UID").getValue();
            serverUids.add(uid);
            RecurrenceId rid = (RecurrenceId)comp.getProperty("RECURRENCE-ID");
            if (rid != null) {
                CalDav.processRecurrence(comp, uid);
                continue;
            }
            Appointment newap = AppointmentIcalAdapter.toBorg(comp);
            if (newap == null) continue;
            if (comp instanceof VToDo) {
                newap.setTodo(true);
            }
            if ((ap = AppointmentModel.getReference().getApptByUid(uid)) == null) {
                try {
                    SyncLog.getReference().setProcessUpdates(comp instanceof VToDo);
                    ++count;
                    log.info("SYNC save: " + comp.toString());
                    log.info("SYNC save: " + newap.toString());
                    AppointmentModel.getReference().saveAppt(newap);
                    continue;
                }
                finally {
                    SyncLog.getReference().setProcessUpdates(true);
                    continue;
                }
            }
            if (!newap.getLastMod().after(ap.getLastMod())) continue;
            try {
                newap.setKey(ap.getKey());
                SyncLog.getReference().setProcessUpdates(comp instanceof VToDo);
                ++count;
                log.info("SYNC save: " + comp.toString());
                log.info("SYNC save: " + newap.toString());
                AppointmentModel.getReference().saveAppt(newap);
            }
            finally {
                SyncLog.getReference().setProcessUpdates(true);
            }
        }
        return count;
    }

    public static void syncFromServer(CalDavCalendarCollection collection, Integer years) throws Exception {
        IOHelper.sendLogMessage((String)"SYNC: Start Incoming Sync");
        log.info("SYNC: Start Incoming Sync");
        java.util.Date after = null;
        if (years != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(1, -1 * years);
            after = cal.getTime();
        }
        ArrayList<String> serverUids = new ArrayList<String>();
        Calendar[] cals = collection.getEvents();
        IOHelper.sendLogMessage((String)("SYNC: found " + cals.length + " Event Calendars on server"));
        log.info("SYNC: found " + cals.length + " Event Calendars on server");
        int count = 0;
        for (Calendar cal : cals) {
            count += CalDav.syncCalendar(cal, serverUids);
        }
        IOHelper.sendLogMessage((String)("SYNC: processed " + count + " new/changed Events"));
        count = 0;
        Calendar[] tcals = collection.getTasks();
        IOHelper.sendLogMessage((String)("SYNC: found " + tcals.length + " Todo Calendars on server"));
        log.info("SYNC: found " + tcals.length + " Todo Calendars on server");
        for (Calendar cal : tcals) {
            count += CalDav.syncCalendar(cal, serverUids);
        }
        IOHelper.sendLogMessage((String)("SYNC: processed " + count + " new/changed Tasks"));
        log.fine(serverUids.toString());
        IOHelper.sendLogMessage((String)"SYNC: check for deletes");
        log.info("SYNC: check for deletes");
        for (Appointment ap : AppointmentModel.getReference().getAllAppts()) {
            if (ap.getDate().before(after) || serverUids.contains(ap.getUid())) continue;
            IOHelper.sendLogMessage((String)("Appointment Not Found in Borg - Deleting: " + ap.toString()));
            log.info("Appointment Not Found in Borg - Deleting: " + ap.toString());
            SyncLog.getReference().setProcessUpdates(false);
            AppointmentModel.getReference().delAppt(ap.getKey());
            SyncLog.getReference().setProcessUpdates(true);
        }
    }

    private static void updateEvent(CalDavCalendarCollection collection, Component comp) {
        log.info("SYNC: updateEvent: " + comp.toString());
        Calendar mycal = new Calendar();
        mycal.getProperties().add((Property)new ProdId(PRODID));
        mycal.getProperties().add((Property)Version.VERSION_2_0);
        mycal.getComponents().add(comp);
        try {
            collection.updateCalendar(mycal);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public static class BaikalPathResolver
    extends PathResolver {
        public String getPrincipalPath(String username) {
            return "/bkal/cal.php/principals/" + username;
        }

        public String getUserPath(String username) {
            return "/bkal/cal.php/calendars/" + username;
        }
    }
}

