/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.ical;

import java.io.InputStream;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.jdbc.JdbcDBUpgrader;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.ical.CalDav;
import net.sf.borg.model.ical.SyncEvent;

public class SyncLog
extends Model
implements Model.Listener,
Prefs.Listener {
    private static SyncLog singleton = null;
    private boolean processUpdates = true;

    public static SyncLog getReference() {
        if (singleton == null) {
            singleton = new SyncLog();
        }
        return singleton;
    }

    public SyncLog() {
        this.setProcessUpdates(CalDav.isSyncing());
        new JdbcDBUpgrader("select id from syncmap", "CREATE CACHED TABLE syncmap (id integer NOT NULL,uid longvarchar, objtype varchar(25) NOT NULL,action varchar(25) NOT NULL,PRIMARY KEY (id,objtype))").upgrade();
        AppointmentModel.getReference().addListener(this);
        TaskModel.getReference().addListener(this);
        Prefs.addListener((Prefs.Listener)this);
    }

    @Override
    public void update(Model.ChangeEvent borgEvent) {
        if (!this.isProcessUpdates()) {
            return;
        }
        if (borgEvent == null || borgEvent.getObject() == null || borgEvent.getAction() == null) {
            return;
        }
        try {
            Object obj = borgEvent.getObject();
            SyncEvent newEvent = new SyncEvent();
            if (!(obj instanceof Appointment)) {
                return;
            }
            newEvent.setId(new Integer(((Appointment)obj).getKey()));
            newEvent.setObjectType(SyncEvent.ObjectType.APPOINTMENT);
            newEvent.setUid(((Appointment)obj).getUid());
            newEvent.setAction(borgEvent.getAction());
            Integer id = newEvent.getId();
            SyncEvent.ObjectType type = newEvent.getObjectType();
            SyncEvent existingEvent = this.get(id, type);
            String uid = newEvent.getUid();
            if (existingEvent == null) {
                this.insert(newEvent);
            } else if (existingEvent.getAction() == Model.ChangeEvent.ChangeAction.ADD && newEvent.getAction() == Model.ChangeEvent.ChangeAction.DELETE) {
                this.delete(id, type);
            } else if (existingEvent.getAction() == Model.ChangeEvent.ChangeAction.CHANGE && newEvent.getAction() == Model.ChangeEvent.ChangeAction.DELETE) {
                SyncEvent event = new SyncEvent(id, uid, Model.ChangeEvent.ChangeAction.DELETE, type);
                this.delete(id, type);
                this.insert(event);
            } else if (existingEvent.getAction() == Model.ChangeEvent.ChangeAction.DELETE && newEvent.getAction() == Model.ChangeEvent.ChangeAction.ADD) {
                SyncEvent event = new SyncEvent(id, uid, Model.ChangeEvent.ChangeAction.CHANGE, type);
                this.delete(id, type);
                this.insert(event);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static SyncEvent createFrom(ResultSet r) throws SQLException {
        int id = r.getInt("id");
        Model.ChangeEvent.ChangeAction action = Model.ChangeEvent.ChangeAction.valueOf(r.getString("action"));
        String uid = r.getString("uid");
        String type = r.getString("objtype");
        SyncEvent.ObjectType otype = SyncEvent.ObjectType.valueOf(type);
        SyncEvent event = new SyncEvent(new Integer(id), uid, action, otype);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncEvent get(int id, SyncEvent.ObjectType type) throws Exception {
        SyncEvent ret = null;
        PreparedStatement stmt = DBHelper.getController().getConnection().prepareStatement("SELECT * FROM syncmap WHERE id = ? and objtype = ?");
        stmt.setInt(1, id);
        stmt.setString(2, type.toString());
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            if (r.next()) {
                ret = SyncLog.createFrom(r);
            }
            SyncEvent syncEvent = ret;
            return syncEvent;
        }
        finally {
            if (r != null) {
                r.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SyncEvent> getAll() throws Exception {
        ArrayList<SyncEvent> ret = new ArrayList<SyncEvent>();
        PreparedStatement stmt = DBHelper.getController().getConnection().prepareStatement("SELECT * FROM syncmap");
        ResultSet r = null;
        try {
            r = stmt.executeQuery();
            while (r.next()) {
                ret.add(SyncLog.createFrom(r));
            }
            ArrayList<SyncEvent> arrayList = ret;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void insert(SyncEvent event) throws Exception {
        PreparedStatement stmt = DBHelper.getController().getConnection().prepareStatement("INSERT INTO syncmap ( id, uid, action, objtype)  VALUES ( ?, ?, ?, ?)");
        stmt.setInt(1, event.getId());
        stmt.setString(2, event.getUid().toString());
        stmt.setString(3, event.getAction().toString());
        stmt.setString(4, event.getObjectType().toString());
        stmt.executeUpdate();
        stmt.close();
        this.refreshListeners();
    }

    public void delete(int id, SyncEvent.ObjectType type) throws Exception {
        PreparedStatement stmt = DBHelper.getController().getConnection().prepareStatement("DELETE FROM syncmap WHERE id = ? and objtype = ?");
        stmt.setInt(1, id);
        stmt.setString(2, type.toString());
        stmt.executeUpdate();
        stmt.close();
        this.refreshListeners();
    }

    public void deleteAll() throws Exception {
        PreparedStatement stmt = DBHelper.getController().getConnection().prepareStatement("DELETE FROM syncmap");
        stmt.executeUpdate();
        stmt.close();
        this.refreshListeners();
    }

    @Override
    public void export(Writer fw) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Marshaller m = jc.createMarshaller();
        XmlContainer container = new XmlContainer();
        container.SyncEvents = this.getAll();
        m.marshal((Object)container, fw);
    }

    @Override
    public void importXml(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlContainer.class});
        Unmarshaller u = jc.createUnmarshaller();
        XmlContainer container = (XmlContainer)u.unmarshal(is);
        if (container.SyncEvents == null) {
            return;
        }
        for (SyncEvent evt : container.SyncEvents) {
            this.insert(evt);
        }
    }

    @Override
    public String getExportName() {
        return "SYNCMAP";
    }

    @Override
    public String getInfo() throws Exception {
        return "Synclogs: " + this.getAll().size();
    }

    public boolean isProcessUpdates() {
        return this.processUpdates;
    }

    public void setProcessUpdates(boolean processUpdates) {
        this.processUpdates = processUpdates;
    }

    public void prefsChanged() {
        this.setProcessUpdates(CalDav.isSyncing());
    }

    @XmlRootElement(name="SYNCMAP")
    private static class XmlContainer {
        public Collection<SyncEvent> SyncEvents;

        private XmlContainer() {
        }
    }
}

