/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.undo.UndoItem;

public class AddressUndoItem
extends UndoItem<Address> {
    @Override
    public void executeUndo() {
        if (this.action == UndoItem.actionType.DELETE) {
            AddressModel.getReference().saveAddress((Address)this.item, true);
        } else if (this.action == UndoItem.actionType.UPDATE) {
            AddressModel.getReference().saveAddress((Address)this.item, true);
        } else if (this.action == UndoItem.actionType.ADD) {
            AddressModel.getReference().delete((Address)this.item, true);
        }
    }

    private AddressUndoItem() {
    }

    private static String addrString(Address addr) {
        return addr.getFirstName() + " " + addr.getLastName();
    }

    public static AddressUndoItem recordUpdate(Address addr) {
        AddressUndoItem undoItem = new AddressUndoItem();
        undoItem.item = addr;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"Address") + " " + AddressUndoItem.addrString(addr));
        return undoItem;
    }

    public static AddressUndoItem recordAdd(Address addr) {
        AddressUndoItem undoItem = new AddressUndoItem();
        undoItem.item = addr;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"Address") + " " + AddressUndoItem.addrString(addr));
        return undoItem;
    }

    public static AddressUndoItem recordDelete(Address addr) {
        AddressUndoItem undoItem = new AddressUndoItem();
        undoItem.item = addr;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"Address") + " " + AddressUndoItem.addrString(addr));
        return undoItem;
    }
}

