/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import net.sf.borg.common.Resource;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.undo.UndoItem;

public class MemoUndoItem
extends UndoItem<Memo> {
    @Override
    public void executeUndo() {
        if (this.action == UndoItem.actionType.DELETE) {
            MemoModel.getReference().saveMemo((Memo)this.item, true);
        } else if (this.action == UndoItem.actionType.UPDATE) {
            MemoModel.getReference().saveMemo((Memo)this.item, true);
        } else if (this.action == UndoItem.actionType.ADD) {
            MemoModel.getReference().delete(((Memo)this.item).getMemoName(), true);
        }
    }

    private MemoUndoItem() {
    }

    private static String memoString(Memo memo) {
        return memo.getMemoName();
    }

    public static MemoUndoItem recordUpdate(Memo memo) {
        MemoUndoItem undoItem = new MemoUndoItem();
        undoItem.item = memo;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"memo") + " " + MemoUndoItem.memoString(memo));
        return undoItem;
    }

    public static MemoUndoItem recordAdd(Memo memo) {
        MemoUndoItem undoItem = new MemoUndoItem();
        undoItem.item = memo;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"memo") + " " + MemoUndoItem.memoString(memo));
        return undoItem;
    }

    public static MemoUndoItem recordDelete(Memo memo) {
        MemoUndoItem undoItem = new MemoUndoItem();
        undoItem.item = memo;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"memo") + " " + MemoUndoItem.memoString(memo));
        return undoItem;
    }
}

