/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.undo.UndoItem;

public class ProjectUndoItem
extends UndoItem<Project> {
    @Override
    public void executeUndo() {
        try {
            if (this.action == UndoItem.actionType.DELETE) {
                TaskModel.getReference().saveProject((Project)this.item, true);
            } else if (this.action == UndoItem.actionType.UPDATE) {
                TaskModel.getReference().saveProject((Project)this.item, true);
            } else if (this.action == UndoItem.actionType.ADD) {
                TaskModel.getReference().deleteProject(((Project)this.item).getKey());
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private ProjectUndoItem() {
    }

    private static String itemString(Project st) {
        return st.getDescription();
    }

    public static ProjectUndoItem recordUpdate(Project project) {
        ProjectUndoItem undoItem = new ProjectUndoItem();
        undoItem.item = project;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"project") + " " + ProjectUndoItem.itemString(project));
        return undoItem;
    }

    public static ProjectUndoItem recordAdd(Project project) {
        ProjectUndoItem undoItem = new ProjectUndoItem();
        undoItem.item = project;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"project") + " " + ProjectUndoItem.itemString(project));
        return undoItem;
    }
}

