/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.model.undo;

import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.undo.TaskUndoItem;
import net.sf.borg.model.undo.UndoItem;

public class SubtaskUndoItem
extends UndoItem<Subtask> {
    @Override
    public void executeUndo() {
        try {
            if (this.action == UndoItem.actionType.DELETE) {
                TaskModel.getReference().saveSubTask((Subtask)this.item, true);
            } else if (this.action == UndoItem.actionType.UPDATE) {
                TaskModel.getReference().saveSubTask((Subtask)this.item, true);
            } else if (this.action == UndoItem.actionType.ADD) {
                TaskModel.getReference().deleteSubTask(((Subtask)this.item).getKey(), true);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private SubtaskUndoItem() {
    }

    private static String itemString(Subtask st) {
        return st.getDescription();
    }

    public static SubtaskUndoItem recordUpdate(Subtask subtask) {
        SubtaskUndoItem undoItem = new SubtaskUndoItem();
        undoItem.item = subtask;
        undoItem.action = UndoItem.actionType.UPDATE;
        undoItem.setDescription(Resource.getResourceString((String)"Change") + " " + Resource.getResourceString((String)"subtask") + " " + SubtaskUndoItem.itemString(subtask));
        TaskUndoItem ti = TaskUndoItem.getLastTaskItem();
        if (ti != null) {
            ti.addSubtask(undoItem);
        }
        return undoItem;
    }

    public static SubtaskUndoItem recordAdd(Subtask subtask) {
        SubtaskUndoItem undoItem = new SubtaskUndoItem();
        undoItem.item = subtask;
        undoItem.action = UndoItem.actionType.ADD;
        undoItem.setDescription(Resource.getResourceString((String)"Add") + " " + Resource.getResourceString((String)"subtask") + " " + SubtaskUndoItem.itemString(subtask));
        TaskUndoItem ti = TaskUndoItem.getLastTaskItem();
        if (ti != null) {
            ti.addSubtask(undoItem);
        }
        return undoItem;
    }

    public static SubtaskUndoItem recordDelete(Subtask subtask) {
        SubtaskUndoItem undoItem = new SubtaskUndoItem();
        undoItem.item = subtask;
        undoItem.action = UndoItem.actionType.DELETE;
        undoItem.setDescription(Resource.getResourceString((String)"Delete") + " " + Resource.getResourceString((String)"subtask") + " " + SubtaskUndoItem.itemString(subtask));
        TaskUndoItem ti = TaskUndoItem.getLastTaskItem();
        if (ti != null) {
            ti.addSubtask(undoItem);
        }
        return undoItem;
    }
}

