/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class ByteType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Byte ZERO = new Byte(0);

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        return new Byte(rs.getByte(name));
    }

    public Class getPrimitiveClass() {
        return Byte.TYPE;
    }

    public Class getReturnedClass() {
        return Byte.class;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setByte(index, (Byte)value);
    }

    public int sqlType() {
        return -6;
    }

    public String getName() {
        return "byte";
    }

    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    public Object stringToObject(String xml) throws Exception {
        return new Byte(xml);
    }

    public Object fromStringValue(String xml) {
        return new Byte(xml);
    }

    public Object next(Object current, SessionImplementor session) {
        return new Byte((byte)((Byte)current + 1));
    }

    public Object seed(SessionImplementor session) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }
}

