/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.mydragonfly.pj.AboutDialog;
import org.mydragonfly.pj.EntryForm;
import org.mydragonfly.pj.JournalView;
import org.mydragonfly.pj.MoveJournalEntryDialog;
import org.mydragonfly.pj.NewJournalDialog;
import org.mydragonfly.pj.OptionsDialog;
import org.mydragonfly.pj.PasswordChangeDialog;
import org.mydragonfly.pj.SelectJournalDialog;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.service.JournalService;
import org.mydragonfly.pj.service.TagService;
import org.mydragonfly.pj.service.exception.DatabaseLockedException;
import org.mydragonfly.pj.util.AppIOUtil;
import org.mydragonfly.pj.util.StringUtil;

public class DragonflyJournal
extends SingleFrameApplication {
    private static final String RESET_PREFS = "reset-prefs";
    private static final String HELP = "help";
    private static final String HIBERNATE_SQL_PKG = "org.hibernate.SQL";
    private static final String SHOW_SQL = "show_sql";
    public static final String APP_PACKAGE = "org.mydragonfly.pj";
    private static final String DEBUG = "debug";
    private static final String DEBUG_ALL = "debug_all";
    private static final String USAGE_STRING = "usage: DragonflyJournal [help|debug_all|debug|show_sql|reset-prefs]";
    private static final String APP_ICON = "org/mydragonfly/pj/resources/icons/journal.png";
    private static final String encPassword = "gh908th874fu3r67se57y64trf";
    protected static StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
    private static final String USER_PREFS = "UserPrefs";
    private static final String ENTRY_PANEL = "ENTRY";
    private static final String JOURNAL_PANEL = "JOURNAL";
    private static final String DICTIONARY_DIR = "dict";
    private static final String DICTIONARY_FILE = "pjDefaultEnglish_Am.zip";
    static Logger logger;
    private JMenuBar menuBar;
    private JMenuItem jMenuItem8;
    private JMenu jMenu1;
    private JMenuItem HelpMenuItem;
    private JMenuItem AboutMenuItem;
    private JMenu HelpjMenu;
    private JPanel topPanel;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem4;
    private JMenu editMenu;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem1;
    private JMenu journalMenu;
    private JSeparator jSeparator;
    private JSeparator jSeparator2;
    private JButton saveButton;
    private JButton openButton;
    private JButton newButton;
    private JButton journalEntriesButton;
    private JButton entriesButton;
    private JToolBar toolBar;
    private JPanel toolBarPanel;
    private EntryForm entryPanel;
    private JournalView journalPanel;
    private JMenuItem jMenuItem9;
    private JMenu entryMenu;
    private JMenuItem deleteEntry_MenuItem;
    private JMenuItem OptionsMenuItem;
    private JMenuItem jMenuItem10;
    private JMenuItem showJournalEntriesMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem jMenuItem11;
    private Journal currentJournal = null;
    private CardLayout viewCards;
    private JPanel entryContainer;
    private JMenuItem showEntryMenuItem;
    private SpellDictionaryHashMap dictionary;
    private SpellDictionaryHashMap userDictionary;
    protected HashMap<String, Object> userPrefs;
    String dbErrorMsg;
    String dbErrorMsgTitle;
    public Date loadTime;
    private boolean firstRun = true;
    private List<Journal> journalList;
    private JMenuItem moveEntry_MenuItem;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            Logger logger;
            boolean bl;
            Arrays.sort(stringArray);
            if (Arrays.binarySearch(stringArray, HELP) > -1) {
                System.out.println(USAGE_STRING);
                System.exit(0);
            }
            boolean bl2 = bl = Arrays.binarySearch(stringArray, DEBUG_ALL) > -1;
            if (bl || Arrays.binarySearch(stringArray, DEBUG) > -1) {
                logger = Logger.getLogger((String)APP_PACKAGE);
                logger.setLevel(Level.DEBUG);
            }
            if (bl || Arrays.binarySearch(stringArray, SHOW_SQL) > -1) {
                logger = Logger.getLogger((String)HIBERNATE_SQL_PKG);
                logger.setLevel(Level.DEBUG);
            }
        }
        logger.debug((Object)"Launching Dragonfly Jorunal...");
        if (!DragonflyJournal.javaVersionOK()) {
            System.exit(-1);
        }
        Application.launch(DragonflyJournal.class, stringArray);
    }

    private static boolean javaVersionOK() {
        String string = System.getProperty("java.version");
        char c = string.charAt(2);
        char c2 = string.charAt(4);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Java version is:" + string + " minor=" + c + " point=" + c2));
        }
        if (Integer.parseInt("" + c) < 6) {
            JOptionPane.showMessageDialog(null, "Dragonfly Journal can not launch because it requires Java 1.6 or higher you are currently running " + string + " \nPlease upgrade at http:\\www.java.com.", "Incorrect JDE", 0);
            return false;
        }
        return true;
    }

    @Override
    protected void initialize(String[] stringArray) {
        super.initialize(stringArray);
        this.loadTime = new Date();
        boolean bl = Arrays.binarySearch(stringArray, RESET_PREFS) > -1;
        this.dbErrorMsg = Application.getInstance().getContext().getResourceMap().getString("dbErrorMsg", new Object[0]);
        this.dbErrorMsgTitle = Application.getInstance().getContext().getResourceMap().getString("dbErrorMsgTitle", new Object[0]);
        this.getMainFrame().addWindowListener(new DragonflyCloseListener());
        this.configureApplication(bl);
        new DictionaryLoaderTask(this).execute();
        logger.info((Object)("init compleate in secs: " + StringUtil.getTimeDifToNow(this.loadTime)));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        String string = "" + this.userPrefs.get(UserOptionParams.LookAndFeel.name());
        logger.debug((Object)("prefLAF==" + string));
        if (string == null) {
            string = "none";
        }
        String string2 = null;
        logger.debug((Object)"the following LAFs are available:");
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray) {
            logger.debug((Object)("\t" + lookAndFeelInfo.getName() + "  - " + lookAndFeelInfo.getClassName()));
            if (!lookAndFeelInfo.getClassName().toLowerCase().contains(string.toLowerCase())) continue;
            string2 = lookAndFeelInfo.getClassName();
        }
        try {
            if (string2 != null) {
                UIManager.setLookAndFeel(string2);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)("couldnt set LAF " + exception));
        }
    }

    @Override
    protected void startup() {
        URL uRL = ClassLoader.getSystemResource(APP_ICON);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(uRL);
        this.getMainFrame().setIconImage(image);
        this.getMainFrame().setMinimumSize(new Dimension(800, 718));
        this.topPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.topPanel.setLayout(borderLayout);
        this.viewCards = new CardLayout();
        this.entryContainer = new JPanel();
        this.entryContainer.setLayout(this.viewCards);
        this.entryPanel = new EntryForm();
        this.entryContainer.add((Component)this.entryPanel, ENTRY_PANEL);
        this.journalPanel = new JournalView();
        this.entryContainer.add((Component)this.journalPanel, JOURNAL_PANEL);
        this.topPanel.add((Component)this.entryContainer, "Center");
        this.viewCards.show(this.entryContainer, ENTRY_PANEL);
        this.toolBarPanel = new JPanel();
        this.topPanel.add((Component)this.toolBarPanel, "North");
        BorderLayout borderLayout2 = new BorderLayout();
        this.toolBarPanel.setLayout(borderLayout2);
        this.toolBar = new JToolBar();
        this.toolBarPanel.add((Component)this.toolBar, "Center");
        this.openButton = new JButton();
        this.toolBar.add(this.openButton);
        this.openButton.setAction(this.getAppActionMap().get("openJournal"));
        this.openButton.setName("openButton");
        this.openButton.setFocusable(false);
        this.newButton = new JButton();
        this.toolBar.add(this.newButton);
        this.newButton.setAction(this.getAppActionMap().get("newEntry"));
        this.newButton.setName("newButton");
        this.newButton.setFocusable(false);
        this.saveButton = new JButton();
        this.toolBar.add(this.saveButton);
        this.saveButton.setAction(this.getAppActionMap().get("saveEntry"));
        this.saveButton.setName("saveButton");
        this.saveButton.setFocusable(false);
        this.entriesButton = new JButton();
        this.toolBar.add(this.entriesButton);
        this.entriesButton.setAction(this.getAppActionMap().get("showEntryView"));
        this.entriesButton.setName("entriesButton");
        this.entriesButton.setFocusable(false);
        this.journalEntriesButton = new JButton();
        this.toolBar.add(this.journalEntriesButton);
        this.journalEntriesButton.setAction(this.getAppActionMap().get("showJournalEntries"));
        this.journalEntriesButton.setName("journalEntriesButton");
        this.journalEntriesButton.setFocusable(false);
        this.menuBar = new JMenuBar();
        this.journalMenu = new JMenu();
        this.menuBar.add(this.journalMenu);
        this.journalMenu.setName("journalMenu");
        this.jMenuItem1 = new JMenuItem();
        this.journalMenu.add(this.jMenuItem1);
        this.jMenuItem1.setAction(this.getAppActionMap().get("openJournal"));
        this.jMenuItem1.setName("jMenuItem1");
        this.jMenuItem2 = new JMenuItem();
        this.journalMenu.add(this.jMenuItem2);
        this.jMenuItem2.setAction(this.getAppActionMap().get("newJournal"));
        this.jMenuItem2.setName("jMenuItem2");
        this.jMenuItem9 = new JMenuItem();
        this.journalMenu.add(this.jMenuItem9);
        this.jMenuItem9.setAction(this.getAppActionMap().get("deleteJournal"));
        this.jMenuItem9.setName("jMenuItem9");
        this.jMenuItem3 = new JMenuItem();
        this.journalMenu.add(this.jMenuItem3);
        this.jMenuItem3.setAction(this.getAppActionMap().get("changePassword"));
        this.jMenuItem3.setName("jMenuItem3");
        this.showJournalEntriesMenuItem = new JMenuItem();
        this.journalMenu.add(this.showJournalEntriesMenuItem);
        this.showJournalEntriesMenuItem.setAction(this.getAppActionMap().get("showJournalEntries"));
        this.showJournalEntriesMenuItem.setName("showJournalEntriesMenuItem");
        this.jSeparator = new JSeparator();
        this.journalMenu.add(this.jSeparator);
        this.exitMenuItem = new JMenuItem();
        this.journalMenu.add(this.exitMenuItem);
        this.exitMenuItem.setAction(this.getAppActionMap().get("exitApp"));
        this.exitMenuItem.setName("exitMenuItem");
        this.entryMenu = new JMenu();
        this.menuBar.add(this.entryMenu);
        this.entryMenu.setName("entryMenu");
        this.showEntryMenuItem = new JMenuItem();
        this.entryMenu.add(this.showEntryMenuItem);
        this.showEntryMenuItem.setAction(this.getAppActionMap().get("showEntryView"));
        this.showEntryMenuItem.setName("showEntryMenuItem");
        this.jSeparator = new JSeparator();
        this.entryMenu.add(this.jSeparator);
        this.jMenuItem10 = new JMenuItem();
        this.entryMenu.add(this.jMenuItem10);
        this.jMenuItem10.setAction(this.getAppActionMap().get("newEntry"));
        this.jMenuItem10.setName("jMenuItem10");
        this.jMenuItem11 = new JMenuItem();
        this.entryMenu.add(this.jMenuItem11);
        this.jMenuItem11.setAction(this.getAppActionMap().get("saveEntry"));
        this.jMenuItem11.setName("jMenuItem11");
        this.deleteEntry_MenuItem = new JMenuItem();
        this.entryMenu.add(this.deleteEntry_MenuItem);
        this.deleteEntry_MenuItem.setName("deleteEntry_MenuItem");
        this.deleteEntry_MenuItem.setAction(this.getAppActionMap().get("deleteEntry"));
        this.jSeparator2 = new JSeparator();
        this.entryMenu.add(this.jSeparator2);
        this.moveEntry_MenuItem = new JMenuItem();
        this.entryMenu.add(this.moveEntry_MenuItem);
        this.moveEntry_MenuItem.setName("moveEntry_MenuItem");
        this.moveEntry_MenuItem.setAction(this.getAppActionMap().get("moveEntry"));
        this.editMenu = new JMenu();
        this.menuBar.add(this.editMenu);
        this.editMenu.setName("editMenu");
        this.jMenuItem4 = new JMenuItem();
        this.editMenu.add(this.jMenuItem4);
        this.jMenuItem4.setAction(this.getAppActionMap().get("copy"));
        this.jMenuItem5 = new JMenuItem();
        this.editMenu.add(this.jMenuItem5);
        this.jMenuItem5.setAction(this.getAppActionMap().get("cut"));
        this.jMenuItem6 = new JMenuItem();
        this.editMenu.add(this.jMenuItem6);
        this.jMenuItem6.setAction(this.getAppActionMap().get("paste"));
        this.jMenuItem7 = new JMenuItem();
        this.editMenu.add(this.jMenuItem7);
        this.jMenuItem7.setAction(this.getAppActionMap().get("delete"));
        this.jMenu1 = new JMenu();
        this.menuBar.add(this.jMenu1);
        this.jMenu1.setName("jMenu1");
        this.jMenuItem8 = new JMenuItem();
        this.jMenu1.add(this.jMenuItem8);
        this.jMenuItem8.setAction(this.getAppActionMap().get("spellCheck"));
        this.jMenuItem8.setName("jMenuItem8");
        this.OptionsMenuItem = new JMenuItem();
        this.jMenu1.add(this.OptionsMenuItem);
        this.OptionsMenuItem.setAction(this.getAppActionMap().get("showOptions"));
        this.OptionsMenuItem.setName("OptionsMenuItem");
        this.HelpjMenu = new JMenu();
        this.menuBar.add(this.HelpjMenu);
        this.HelpjMenu.setName("HelpjMenu");
        this.AboutMenuItem = new JMenuItem();
        this.HelpjMenu.add(this.AboutMenuItem);
        this.AboutMenuItem.setAction(this.getAppActionMap().get("openAbout"));
        this.AboutMenuItem.setName("AboutMenuItem");
        this.HelpMenuItem = new JMenuItem();
        this.HelpjMenu.add(this.HelpMenuItem);
        this.HelpMenuItem.setAction(this.getAppActionMap().get("showHelp"));
        this.HelpMenuItem.setName("HelpMenuItem");
        this.getMainFrame().setJMenuBar(this.menuBar);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Done setting up form, call show - secs: " + StringUtil.getTimeDifToNow(this.loadTime)));
        }
    }

    @Override
    protected void ready() {
        super.ready();
        logger.debug((Object)("main size=" + this.getMainFrame().getSize()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Open Journal Select Dialog - secs: " + StringUtil.getTimeDifToNow(this.loadTime)));
        }
        this.openJournal();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Open Journal Loaded - secs: " + StringUtil.getTimeDifToNow(this.loadTime)));
        }
    }

    Journal getCurrentJournal() {
        return this.currentJournal;
    }

    public void setCurrentJournal(Journal journal) {
        logger.debug((Object)"Journal Set");
        this.currentJournal = journal;
        this.entryPanel.setCurrentJournal(journal);
        this.journalPanel.setCurrentJournal(journal);
    }

    private ActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap(this);
    }

    @Action
    public void spellCheck() {
        final JTextComponentSpellChecker jTextComponentSpellChecker = new JTextComponentSpellChecker((SpellDictionary)this.dictionary, (SpellDictionary)this.userDictionary, "Spellcheck");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    jTextComponentSpellChecker.spellCheck((JTextComponent)((DragonflyJournal)DragonflyJournal.this).entryPanel.desc_textField);
                    jTextComponentSpellChecker.spellCheck((JTextComponent)((DragonflyJournal)DragonflyJournal.this).entryPanel.entry_textField);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    @Action
    public void openJournal() {
        try {
            SelectJournalDialog selectJournalDialog = new SelectJournalDialog(this.getMainFrame(), this.firstRun);
            selectJournalDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            selectJournalDialog.pack();
            selectJournalDialog.setLocationRelativeTo(null);
            if (this.firstRun) {
                this.show(this.topPanel);
                this.firstRun = false;
            }
            selectJournalDialog.setVisible(true);
            logger.debug((Object)"Open J done");
        }
        catch (DatabaseLockedException databaseLockedException) {
            this.errorExit();
        }
    }

    @Action
    public void newJournal() {
        try {
            NewJournalDialog newJournalDialog = new NewJournalDialog(this.getMainFrame());
            newJournalDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            newJournalDialog.pack();
            newJournalDialog.setLocationRelativeTo(null);
            newJournalDialog.setVisible(true);
        }
        catch (DatabaseLockedException databaseLockedException) {
            this.errorExit();
        }
    }

    @Action
    public void deleteJournal() {
        if (this.currentJournal != null) {
            if (JOptionPane.showConfirmDialog(this.getMainFrame(), "Delete Current Journal: " + this.currentJournal.getTitle() + "?", "Delete Journal", 0, 2) == 0) {
                JournalService.deleteJournal(this.currentJournal);
                this.setCurrentJournal(null);
            }
        } else {
            JOptionPane.showMessageDialog(this.getMainFrame(), "No Journal has been loaded, can't delete.", "Can't Delete Journal", 1);
        }
    }

    @Action
    public void changePassword() {
        if (this.currentJournal != null) {
            PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(this.getMainFrame());
            passwordChangeDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            passwordChangeDialog.pack();
            passwordChangeDialog.setLocationRelativeTo(null);
            passwordChangeDialog.setVisible(true);
            if (!passwordChangeDialog.isCancel()) {
                Journal journal = JournalService.updatePassword(this.currentJournal, passwordChangeDialog.getOldPassword(), passwordChangeDialog.getNewPassword());
                if (journal == null) {
                    JOptionPane.showMessageDialog(this.getMainFrame(), "Password has not been changed, old Password was incorrect.", "Incorrect Password", 1);
                } else {
                    this.currentJournal = journal;
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.getMainFrame(), "No Journal has been loaded, can't alter password.", "No Journal Loaded", 1);
        }
    }

    @Action
    public void saveEntry() {
        logger.debug((Object)"ENTER Save Entry");
        if (this.journalCheck()) {
            Entry entry = this.entryPanel.getCurrentEntry();
            if (entry == null) {
                logger.error((Object)"current Entry is NULL and should not be null!!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Entry} id=" + entry.getId() + " desc=" + entry.getDescription()));
            }
            entry.setCreateDate(this.entryPanel.getDateValue());
            entry.setDescription(this.entryPanel.getDescriptionValue());
            entry.setContent(this.entryPanel.getEntryValue());
            entry.setPrivateEntry(this.entryPanel.getPrivateValue());
            entry.setTags(TagService.toTagSet(this.entryPanel.getTagValues()));
            this.entryPanel.setCurrentEntry(entry);
            if (entry.getJournalId() == null) {
                entry.setJournalId(this.currentJournal);
            }
            String string = this.validateEntry(entry);
            if (logger.isDebugEnabled()) {
                if (this.currentJournal.getEntries() == null) {
                    logger.debug((Object)"Entries are NULL");
                } else {
                    logger.debug((Object)("entry ct=" + this.currentJournal.getEntries().size()));
                }
            }
            if (string.length() == 0) {
                logger.debug((Object)"Updating Entry..");
                logger.debug((Object)this.entryPanel.getCurrentEntry());
                logger.debug((Object)"REconstituting Tags");
                try {
                    entry.setTags(TagService.getTagsByName(this.entryPanel.getTagValues()));
                }
                catch (DatabaseLockedException databaseLockedException) {
                    // empty catch block
                }
                int n = JournalService.saveEntry(entry);
                this.entryPanel.setCurrentEntry(JournalService.getEntry(this.currentJournal, n));
                try {
                    this.currentJournal = JournalService.getJournal(this.currentJournal.getId());
                }
                catch (DatabaseLockedException databaseLockedException) {
                    // empty catch block
                }
                this.journalPanel.setCurrentJournal(this.currentJournal);
                logger.debug((Object)"Entry Saved");
                if (this.currentJournal != null) {
                    JOptionPane.showMessageDialog(this.getMainFrame(), "Entry saved.", "Save Sucessful", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.getMainFrame(), string, "Journal Entry Error", 2);
            }
        }
    }

    private String validateEntry(Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        if (entry.getDescription() == null || entry.getDescription().length() <= 0) {
            stringBuilder.append("A Description must be provided for the Journal entry to be saved.\n");
        }
        if (entry.getCreateDate() == null) {
            stringBuilder.append("The date field can't be empty when saving the Journal entry, please provide a date.");
        }
        return stringBuilder.toString();
    }

    protected EntryForm getEntryPanel() {
        return this.entryPanel;
    }

    @Action
    public void deleteEntry() {
        if (this.journalCheck()) {
            int n = JOptionPane.showConfirmDialog(this.getMainFrame(), "Clear or Delete the current Entry?", "Delete Entry", 0, 2);
            if (n == 1) {
                return;
            }
            if (this.entryPanel.getCurrentEntry().getId() > 0) {
                JournalService.removeEntry(this.getCurrentJournal(), this.entryPanel.getCurrentEntry());
                try {
                    this.setCurrentJournal(JournalService.getJournal(this.getCurrentJournal().getId()));
                }
                catch (DatabaseLockedException databaseLockedException) {
                    // empty catch block
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting entry id= " + this.entryPanel.getCurrentEntry().getId()));
                }
            }
            this.entryPanel.setCurrentEntry(null);
        }
    }

    @Action
    public void moveEntry() {
        try {
            MoveJournalEntryDialog moveJournalEntryDialog = new MoveJournalEntryDialog(this.getMainFrame());
            moveJournalEntryDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            moveJournalEntryDialog.pack();
            moveJournalEntryDialog.setLocationRelativeTo(null);
            moveJournalEntryDialog.setVisible(true);
        }
        catch (DatabaseLockedException databaseLockedException) {
            this.errorExit();
        }
    }

    @Action
    public void newEntry() {
        if (this.journalCheck()) {
            this.entryPanel.setCurrentEntry(null);
            this.showEntryView();
        }
    }

    @Action
    public void showJournalEntries() {
        this.viewCards.show(this.entryContainer, JOURNAL_PANEL);
    }

    @Action
    public void showEntryView() {
        this.viewCards.show(this.entryContainer, ENTRY_PANEL);
    }

    @Action
    public void exitApp() {
        this.doBackUp();
        this.saveUserPrefs();
        this.exit();
    }

    private boolean journalCheck() {
        if (this.currentJournal == null) {
            JOptionPane.showMessageDialog(this.getMainFrame(), "You must first open or create a new Journal taking any action.", "No Open Journal", 0);
            return false;
        }
        return true;
    }

    void saveUserPrefs() {
        LocalStorage localStorage = this.getContext().getLocalStorage();
        try {
            logger.debug((Object)("save UserPrefs" + this.userPrefs));
            localStorage.save(this.userPrefs, USER_PREFS);
        }
        catch (IOException iOException) {
            logger.warn((Object)"Failed to save user preferences", (Throwable)iOException);
            iOException.printStackTrace();
        }
    }

    @Action
    public void openAbout() {
        AboutDialog aboutDialog = new AboutDialog(this.getMainFrame());
        aboutDialog.pack();
        aboutDialog.setLocationRelativeTo(null);
        aboutDialog.setVisible(true);
    }

    @Action
    public void showHelp() {
        JOptionPane.showMessageDialog(this.getMainFrame(), "I know, no help. I am Sorry. \n\nIt's not that I don't care, just programmers void writing help, it's in the genetic make up I'm sure.. \n\nHelp is coming, probably in the next major release, if you want to write help, let me know!");
    }

    @Action
    public void showOptions() {
        OptionsDialog optionsDialog = new OptionsDialog(this.getMainFrame());
        optionsDialog.pack();
        optionsDialog.setLocationRelativeTo(null);
        optionsDialog.setVisible(true);
    }

    private void initDictionary() {
        try {
            File file = new File(DICTIONARY_DIR + File.separator + DICTIONARY_FILE);
            this.dictionary = new SpellDictionaryHashMap();
            if (file.exists()) {
                Object object;
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    this.dictionary.addDictionary((Reader)new InputStreamReader(zipFile.getInputStream((ZipEntry)object)));
                }
                object = new File((String)this.userPrefs.get(UserOptionParams.UserDictionaryLoc.name()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("userDict=" + object));
                }
                if (((File)object).exists() && ((File)object).isFile()) {
                    this.userDictionary = new SpellDictionaryHashMap((File)object);
                } else {
                    this.userPrefs.put(UserOptionParams.UserDictionaryLoc.name(), UserOptionParams.UserDictionaryLoc.dafalutValue());
                    object = new File((String)UserOptionParams.UserDictionaryLoc.dafalutValue());
                    ((File)object).createNewFile();
                }
            } else {
                logger.warn((Object)"Dictionary Zip File is missing, can not run spell check!");
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackUp() {
        Object object;
        BackupSchedules backupSchedules;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.userPrefs.get(UserOptionParams.BACKUP_LAST_DATE.name());
        try {
            backupSchedules = (BackupSchedules)((Object)this.userPrefs.get(UserOptionParams.BackupSch.name()));
        }
        catch (Exception exception) {
            backupSchedules = BackupSchedules.Never;
        }
        boolean bl = false;
        switch (backupSchedules) {
            case Weekly: {
                object = GregorianCalendar.getInstance();
                ((Calendar)gregorianCalendar).add(5, 7);
                if (!((Calendar)object).before(gregorianCalendar)) break;
                bl = true;
                break;
            }
            case Prompt_on_Close: {
                bl = JOptionPane.showConfirmDialog(this.getMainFrame(), "Back up your Data?", "Backup Dragonfly Journal", 0) == 0;
                break;
            }
            case On_Close: {
                bl = true;
                break;
            }
        }
        if (bl) {
            object = System.getProperty("user.home");
            logger.debug((Object)("Default Home Dir=" + (String)object));
            String string = (String)this.userPrefs.get((Object)UserOptionParams.BACKUP_LAST_DATE);
            File file = new File((String)object + File.separator + "Dragonfly_Backup");
            if (string != null && string.length() > 1) {
                file = new File(string);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File((String)this.userPrefs.get(UserOptionParams.DatabaseLocation.name()));
            for (String string2 : file2.list()) {
                File file3 = new File(file.getAbsolutePath() + File.separator + string2);
                File file4 = new File(file2.getAbsolutePath() + File.separator + string2);
                logger.debug((Object)("backing up file :" + file4 + "\ntto:" + file3));
                FileReader fileReader = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    int n;
                    fileReader = new FileReader(file4);
                    outputStreamWriter = new FileWriter(file3);
                    while ((n = fileReader.read()) != -1) {
                        outputStreamWriter.write(n);
                    }
                    fileReader.close();
                    outputStreamWriter.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.error((Object)("Could not back up data file:" + file4), (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    logger.error((Object)("Could not back up data file:" + file4), (Throwable)iOException);
                }
                finally {
                    try {
                        fileReader.close();
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.userPrefs.put(UserOptionParams.BACKUP_LAST_DATE.name(), GregorianCalendar.getInstance());
            this.userPrefs.put(UserOptionParams.BackupDir.name(), file.getAbsolutePath());
        }
    }

    private void configureApplication(boolean bl) {
        LocalStorage localStorage = this.getContext().getLocalStorage();
        try {
            this.userPrefs = (HashMap)localStorage.load(USER_PREFS);
            if (this.userPrefs == null || bl) {
                this.setUpUserPrefs(localStorage);
            }
            this.mergeOldUserPrefs(localStorage);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UserPref settings" + this.userPrefs));
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"Exception while opening the App User Prefs file", (Throwable)iOException);
        }
        File file = new File(this.userPrefs.get(UserOptionParams.DatabaseLocation.name().toString()).toString());
        if (!file.exists() || file.listFiles().length == 0) {
            file.mkdirs();
            if (logger.isDebugEnabled()) {
                logger.info((Object)("DB location missing -  " + file.getAbsolutePath()));
            }
            this.buildDatabase();
        }
    }

    private void setUpUserPrefs(LocalStorage localStorage) throws IOException {
        this.userPrefs = new HashMap();
        for (UserOptionParams userOptionParams : UserOptionParams.values()) {
            this.userPrefs.put(userOptionParams.name(), userOptionParams.dafalutValue());
        }
        localStorage.save(this.userPrefs, USER_PREFS);
    }

    private void mergeOldUserPrefs(LocalStorage localStorage) throws IOException {
        if ((String)this.userPrefs.get((Object)UserOptionParams.UserPrefsVersion) != UserOptionParams.UserPrefsVersion.dafalutValue()) {
            this.userPrefs.put(UserOptionParams.UserPrefsVersion.name(), UserOptionParams.UserPrefsVersion.dafalutValue());
            for (UserOptionParams userOptionParams : UserOptionParams.values()) {
                if (this.userPrefs.containsKey(userOptionParams.name())) continue;
                this.userPrefs.put(userOptionParams.name(), userOptionParams.dafalutValue());
            }
            localStorage.save(this.userPrefs, USER_PREFS);
        }
    }

    public void errorExit() {
        JOptionPane.showMessageDialog(this.getMainFrame(), this.dbErrorMsg, this.dbErrorMsgTitle, 0);
        this.exitApp();
    }

    private void buildDatabase() {
        logger.info((Object)"Building Database...");
        AppIOUtil.outputFileFromAppPath(this.getClass(), "resources/database/Journals.script", (String)this.userPrefs.get(UserOptionParams.DatabaseLocation.name()) + File.separator + "Journals.script");
    }

    public List<Journal> getJournalList() {
        return this.journalList;
    }

    static {
        encryptor.setPassword(encPassword);
        logger = Logger.getLogger(DragonflyJournal.class);
    }

    class DragonflyCloseListener
    extends WindowAdapter {
        DragonflyCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            DragonflyJournal.this.doBackUp();
            DragonflyJournal.this.saveUserPrefs();
        }
    }

    class DictionaryLoaderTask
    extends Task {
        public DictionaryLoaderTask(Application application) {
            super(application);
        }

        @Override
        protected void finished() {
            super.finished();
            logger.debug((Object)"finished DictionaryLoaderTask");
        }

        @Override
        protected Object doInBackground() throws Exception {
            Date date = new Date();
            logger.debug((Object)"Dictionary Task Running");
            DragonflyJournal.this.initDictionary();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dictionary Task Running secs:" + StringUtil.getTimeDifToNow(DragonflyJournal.this.loadTime, date)));
            }
            return null;
        }
    }

    public static enum BackupSchedules {
        On_Close,
        Weekly,
        Prompt_on_Close,
        Never;


        public String toString() {
            return this.name().replaceAll("_", " ");
        }

        public static BackupSchedules getByName(String string) {
            for (int i = 0; i < BackupSchedules.values().length; ++i) {
                if (!BackupSchedules.values()[i].name().equals(string)) continue;
                return BackupSchedules.values()[i];
            }
            return Never;
        }
    }

    protected static enum UserOptionParams {
        UserPrefsVersion("3"),
        UserDictionaryLoc("dict/user.0"),
        DatabaseLocation("data"),
        EntryAlwaysPrivate("true"),
        LookAndFeel("nimbus"),
        BackupDir(""),
        BackupSch((Object)((Object)BackupSchedules.Never)),
        BACKUP_LAST_DATE(GregorianCalendar.getInstance());

        private final Object defaultValue;

        private UserOptionParams(Object object) {
            this.defaultValue = object;
        }

        public Object dafalutValue() {
            return this.defaultValue;
        }
    }
}

