/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import java.awt.Dialog;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.mydragonfly.pj.DragonflyJournal;
import org.mydragonfly.pj.NewJournalDialog;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.data.Tag;
import org.mydragonfly.pj.service.JournalService;
import org.mydragonfly.pj.service.TagService;
import org.mydragonfly.pj.service.exception.DatabaseLockedException;
import org.mydragonfly.pj.util.StringUtil;

public class MoveJournalEntryDialog
extends JDialog
implements KeyListener {
    private static final Logger logger = Logger.getLogger(MoveJournalEntryDialog.class);
    private static final long serialVersionUID = 5017326027963368605L;
    private JLabel jLabel2;
    private JPasswordField jPasswordField1;
    private JCheckBox jCheckBox1;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel jLabel3;
    private JLabel jLabel1;
    private JComboBox journalCBX;
    private List<Journal> journals;
    private boolean firstrun;

    public MoveJournalEntryDialog(JFrame jFrame) throws DatabaseLockedException {
        super(jFrame);
        this.initGUI();
        this.setUpCombo();
    }

    private void setUpCombo() throws DatabaseLockedException {
        DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
        this.journals = JournalService.getJournals();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("db init done in secs:" + StringUtil.getTimeDifToNow(dragonflyJournal.loadTime)));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Journal journal : this.journals) {
            arrayList.add(journal.getTitle());
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.journalCBX.setModel(defaultComboBoxModel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("done cbx pop in secs:" + StringUtil.getTimeDifToNow(dragonflyJournal.loadTime)));
        }
    }

    private void initGUI() throws DatabaseLockedException {
        try {
            this.setTitle("Open Journal");
            GroupLayout groupLayout = new GroupLayout((JComponent)this.getContentPane());
            this.getContentPane().setLayout(groupLayout);
            this.journalCBX = new JComboBox();
            this.jLabel1 = new JLabel();
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.jLabel2.setName("jLabel2");
            this.jPasswordField1 = new JPasswordField(30);
            this.jPasswordField1.setName("jPasswordField1");
            this.jPasswordField1.addKeyListener(this);
            this.jLabel3 = new JLabel();
            this.jLabel3.setName("jLabel3");
            this.jCheckBox1 = new JCheckBox();
            this.jCheckBox1.setName("copyCheckBox");
            this.okButton = new JButton();
            this.okButton.setName("okButton");
            this.okButton.setAction(this.getAppActionMap().get("okButton"));
            this.cancelButton = new JButton();
            this.cancelButton.setName("cancelButton");
            this.cancelButton.setAction(this.getAppActionMap().get("cancel"));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.journalCBX, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.jLabel1, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField1, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.jLabel2, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(18).addGroup(groupLayout.createParallelGroup().addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, -2, -2).addComponent(this.jCheckBox1, GroupLayout.Alignment.LEADING, -2, -2, -2)).addGap(0, 21, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.cancelButton, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addContainerGap());
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.okButton, -2, 80, -2).addGap(37).addComponent(this.cancelButton, -2, 80, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, 124, -2).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -2, 124, -2).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -2, 124, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.jCheckBox1, -2, 180, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPasswordField1, -2, 180, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.journalCBX, -2, 180, -2))))).addContainerGap(19, Short.MAX_VALUE));
            groupLayout.linkSize(0, this.jCheckBox1, this.jPasswordField1, this.journalCBX);
            groupLayout.linkSize(0, this.jLabel2, this.jLabel1, this.jLabel3);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents(this.getContentPane());
            if (!this.firstrun) {
                this.pack();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Action
    public void okButton() {
        Journal journal = JournalService.validatePassword((String)this.journalCBX.getSelectedItem(), new String(this.jPasswordField1.getPassword()));
        if (journal != null) {
            DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
            Entry entry = dragonflyJournal.getEntryPanel().getCurrentEntry();
            if (entry != null) {
                if (entry.getId() < 1) {
                    JOptionPane.showMessageDialog(this, "Can't move an unsaved or new entry, please save entry before moving it.", "Can't Move Entry", 0);
                } else {
                    Set<Tag> set = TagService.parseTags(TagService.tagSetToString(entry.getTags()));
                    Entry entry2 = new Entry(journal, entry.getCreateDate(), entry.getPrivateEntry(), entry.getDescription(), entry.getContent(), set);
                    logger.debug((Object)"Move Entry");
                    logger.debug((Object)entry2);
                    JournalService.saveNewEntry(entry2);
                    if (!this.jCheckBox1.isSelected()) {
                        JournalService.removeEntry(dragonflyJournal.getCurrentJournal(), dragonflyJournal.getEntryPanel().getCurrentEntry());
                        try {
                            dragonflyJournal.setCurrentJournal(JournalService.getJournal(dragonflyJournal.getCurrentJournal().getId()));
                        }
                        catch (DatabaseLockedException databaseLockedException) {
                            // empty catch block
                        }
                    }
                    this.dispose();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Password is incorrect, please try again.", "Access error", 0);
        }
    }

    @Action
    public void cancel() {
        this.dispose();
    }

    @Action
    public void newJournal() throws DatabaseLockedException {
        NewJournalDialog newJournalDialog = new NewJournalDialog(null);
        newJournalDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        newJournalDialog.pack();
        newJournalDialog.setLocationRelativeTo(null);
        newJournalDialog.setVisible(true);
        if (newJournalDialog.isNewJournalCreated()) {
            this.dispose();
        }
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap(this);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okButton();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

