/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RoundedLabel
extends JLabel {
    private static final long serialVersionUID = -6490253133478970696L;

    public RoundedLabel(String string) {
        super(string);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, n, n2, Math.round((float)n * 0.5f), n2);
        super.paintComponent(graphics);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("RoundedLabel Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setBackground(Color.GRAY);
        RoundedLabel roundedLabel = new RoundedLabel("Test 1");
        roundedLabel.setBackground(Color.LIGHT_GRAY);
        jFrame.getContentPane().add(roundedLabel);
        roundedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                System.out.println("I've been clicked!");
                System.out.println(mouseEvent);
            }
        });
        FormLayout formLayout = new FormLayout("4dlu, pref, 4dlu, 50dlu:grow(0.9),8dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref:grow(0.9), 2dlu");
        jFrame.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        jFrame.getContentPane().add((Component)roundedLabel, cellConstraints.xy(2, 2, CellConstraints.LEFT, CellConstraints.CENTER));
        jFrame.setSize(200, 100);
        jFrame.setVisible(true);
    }
}

