/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.JCalendarComboBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class JCalendarCellEditor
implements TableCellEditor {
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private Date originalValue;
    private JCalendarComboBox calendar;

    public JCalendarCellEditor(JCalendarComboBox jCalendarComboBox) {
        this.calendar = jCalendarComboBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            return this.calendar;
        }
        if (object instanceof Date) {
            this.calendar.setDate((Date)object);
        } else {
            Date date = new Date();
            this.calendar.setDate(date);
        }
        jTable.setRowSelectionInterval(n, n);
        jTable.setColumnSelectionInterval(n2, n2);
        this.originalValue = this.calendar.getDate();
        this.calendar.setSize(jTable.getColumnModel().getColumn(n2).getWidth(), this.calendar.getHeight());
        return this.calendar;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.calendar.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    protected void fireEditingCanceled() {
        this.calendar.setDate(this.originalValue);
        this.calendar.getCalendar().setTime(this.originalValue);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingStopped(changeEvent);
        }
    }
}

