/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.DayLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMonthPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel table;
    private boolean _enabled = true;
    private boolean unset = false;
    private Calendar _cal;
    private Locale _locale;
    private ArrayList<DayLabel> _days;
    private ArrayList<ChangeListener> _changeListener = new ArrayList();
    private boolean _fireingChangeEvent = false;
    public static final Color BACKGROUND_COLOR = UIManager.getColor("TextField.background");
    public static final Color FONT_COLOR = UIManager.getColor("TextField.foreground");
    public static final Color SELECTED_BACKGROUND_COLOR = UIManager.getColor("TextField.selectionBackground");
    public static final Color SELECTED_FONT_COLOR = UIManager.getColor("TextField.selectionForeground");
    public static final Color HEADER_BACKGROUND_COLOR = UIManager.getColor("TextField.inactiveForeground");
    public static final Color HEADER_FONT_COLOR = UIManager.getColor("TextField.inactiveBackground");

    public JMonthPanel() {
        this.init(Calendar.getInstance(), Locale.getDefault());
    }

    public JMonthPanel(Calendar calendar) {
        this.init(calendar, Locale.getDefault());
    }

    public JMonthPanel(Locale locale) {
        this.init(Calendar.getInstance(locale), locale);
    }

    public JMonthPanel(Calendar calendar, Locale locale) {
        this.init(calendar, locale);
    }

    private void init(Calendar calendar, Locale locale) {
        this._cal = Calendar.getInstance(locale);
        this._cal.set(5, calendar.get(5));
        this._cal.set(2, calendar.get(2));
        this._cal.set(1, calendar.get(1));
        this._locale = locale;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createHeader(), "North");
        this.add((Component)this.createTable(), "Center");
        this.refreshGUI();
    }

    private JPanel createHeader() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 7, 1, 1));
        jPanel.setBackground(HEADER_BACKGROUND_COLOR);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E", this._locale);
        Calendar calendar = (Calendar)this._cal.clone();
        char[] cArray = new char[7];
        for (n = 0; n < 7; ++n) {
            cArray[calendar.get((int)7) - 1] = simpleDateFormat.format(calendar.getTime()).charAt(0);
            calendar.set(5, calendar.get(5) + 1);
        }
        n = calendar.getFirstDayOfWeek() - 1;
        for (int i = 0; i < 7; ++i) {
            JLabel jLabel = new JLabel(String.valueOf(cArray[n]));
            if (++n > 6) {
                n = 0;
            }
            jLabel.setHorizontalAlignment(4);
            jLabel.setForeground(HEADER_FONT_COLOR);
            jPanel.add(jLabel);
        }
        return jPanel;
    }

    private JPanel createTable() {
        this._days = new ArrayList();
        this.table = new JPanel();
        this.table.setLayout(new GridLayout(6, 7, 1, 1));
        return this.table;
    }

    private void refreshGUI() {
        this.table.removeAll();
        this._days.clear();
        int n = 0;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)this._cal.clone();
        calendar2.set(5, 1);
        int n2 = calendar2.get(2);
        int n3 = calendar2.get(7);
        n3 = n3 == 0 ? --n3 : (n3 -= calendar2.getFirstDayOfWeek());
        if (n3 < 0) {
            n3 += 7;
        }
        while (n < n3) {
            JLabel jLabel = new JLabel();
            this.table.add(jLabel);
            ++n;
        }
        int n4 = this._cal.get(5);
        while (n < 42 && calendar2.get(2) == n2) {
            boolean bl = false;
            if (calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2) && calendar2.get(5) == calendar.get(5)) {
                bl = true;
            }
            DayLabel dayLabel = new DayLabel(calendar2.get(5), bl, this);
            this.table.add(dayLabel);
            this._days.add(dayLabel);
            if (!this.unset && n4 == calendar2.get(5)) {
                dayLabel.setSelected(true);
            }
            ++n;
            calendar2.set(5, calendar2.get(5) + 1);
        }
        while (n < 42) {
            JLabel jLabel = new JLabel();
            this.table.add(jLabel);
            ++n;
        }
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setCalendar(null);
        } else {
            this._cal.setTime(date);
            this.setCalendar(this._cal);
        }
    }

    public Date getDate() {
        if (this.unset) {
            return null;
        }
        return this.getCalendar().getTime();
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            this.unset = true;
            calendar = Calendar.getInstance(this._locale);
        } else {
            this.unset = false;
        }
        this._cal.set(5, calendar.get(5));
        this._cal.set(2, calendar.get(2));
        this._cal.set(1, calendar.get(1));
        this.refreshGUI();
        this.updateUI();
        DayLabel dayLabel = this._days.get(calendar.get(5) - 1);
        dayLabel.grabFocus();
        this.fireChangeEvent();
    }

    @Override
    public void grabFocus() {
        super.grabFocus();
        DayLabel dayLabel = this._days.get(this._cal.get(5) - 1);
        dayLabel.grabFocus();
    }

    public Calendar getCalendar() {
        return this._cal;
    }

    public void setSelectedDayOfMonth(int n) {
        if (this._enabled && n > 0 && n <= this._days.size()) {
            int n2 = this._cal.get(5);
            DayLabel dayLabel = this._days.get(n2 - 1);
            dayLabel.setSelected(false);
            this._cal.set(5, n);
            dayLabel = this._days.get(n - 1);
            dayLabel.setSelected(true);
            this.unset = false;
            this.updateUI();
            this.fireChangeEvent();
        }
    }

    public int getSelectedDayOfMonth() {
        return this._cal.get(5);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListener.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListener.remove(changeListener);
    }

    public ChangeListener[] getChangeListener() {
        return (ChangeListener[])this._changeListener.toArray();
    }

    protected void fireChangeEvent() {
        if (!this._fireingChangeEvent) {
            this._fireingChangeEvent = true;
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this._changeListener.size(); ++i) {
                this._changeListener.get(i).stateChanged(changeEvent);
            }
            this._fireingChangeEvent = false;
        }
    }

    public boolean isUnset() {
        return this.unset;
    }

    @Override
    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }
}

