/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;

public class GlobalProperties {
    public static final String DATE_FORMAT = "dateFormat";
    public static final String SHOW_ALL_ACTIONS = "showAllActions";
    public static final String SHOW_CLOSED_FOLDERS = "showClosedFolders";
    public static final String PROJECT_EDITOR_PREFERED_SIZE = "projectEditorPreferedSize";
    public static final String SHOW_OVERVIEW_TAB = "showOverviewTab";
    public static final String SHOW_QUICK_COLLECT = "showQuickCollectBar";
    public static final String AUTO_SAVE = "autoSave";
    public static final String DATABASE = "database";
    public static final String DATABASE_VALUE_XML = "xml";
    public static final String DATABASE_VALUE_ODB = "odb";
    public static final String SHOW_TRAY_ICON = "showTrayIcon";
    public static final String SHOW_EMPTY_FOLDERS = "showEmptyFolders";
    public static final String SHUTDOWN_BACKUP_XML = "shutdownBuckupXML";
    public static final String SHUTDOWN_BACKUP_ODB = "shutdownBuckupODB";
    public static final String PAGE_SIZE_NAME = "pageSizeName";
    public static final String PAGE_ORIENTATION = "pageOrientation";
    public static final String PAGE_PRINTABLE_AREA = "pagePrintableArea";
    private Properties prop = new Properties();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(s, l);
    }

    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(s, l);
    }

    public void putProperty(String s, Object v) {
        Object old = null;
        old = v == null ? this.prop.remove(s) : this.prop.put(s, v);
        this.pcs.firePropertyChange(s, old, v);
    }

    public Object getProperty(String s) {
        return this.prop.get(s);
    }

    public Object getProperty(String s, Object defaultValue) {
        Object o = this.prop.get(s);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public boolean getBoolean(String s) {
        return this.getBoolean(s, false);
    }

    public boolean getBoolean(String s, boolean def) {
        Object o = this.prop.get(s);
        if (o == null) {
            return def;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        Boolean b = Boolean.valueOf(o.toString());
        this.prop.put(s, b);
        return b;
    }

    public Integer getInteger(String s) {
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            Integer b = Integer.valueOf(o.toString());
            this.prop.put(s, b);
            return b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void load(Reader r) throws IOException {
        this.prop.load(r);
    }

    public void store(BufferedWriter w) throws IOException {
        Properties p = new Properties();
        for (Object s : this.prop.keySet()) {
            int i;
            StringBuilder sb;
            Object[] ii;
            Object o = this.prop.get(s);
            if (o instanceof int[]) {
                ii = (int[])o;
                sb = new StringBuilder();
                if (ii.length > 0) {
                    sb.append(ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append(ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o instanceof double[]) {
                ii = (double[])o;
                sb = new StringBuilder();
                if (ii.length > 0) {
                    sb.append((double)ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append((double)ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o instanceof boolean[]) {
                ii = (boolean[])o;
                sb = new StringBuilder(ii.length * 6);
                if (ii.length > 0) {
                    sb.append(ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append(ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o == null) continue;
            p.put(s, o.toString());
        }
        p.store(w, "");
    }

    public int[] getIntegerArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            ArrayList<Integer> il = new ArrayList<Integer>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i].trim();
                if (ss[i].length() <= 0) continue;
                try {
                    il.add(Integer.valueOf(ss[i]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int[] ii = new int[il.size()];
            for (int i = 0; i < ii.length; ++i) {
                ii[i] = (Integer)il.get(i);
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }

    public boolean[] getBooleanArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            boolean[] ii = new boolean[ss.length];
            for (int i = 0; i < ii.length; ++i) {
                try {
                    ii[i] = Boolean.valueOf(ss[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }

    public double[] getDoubleArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            ArrayList<Double> il = new ArrayList<Double>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i].trim();
                if (ss[i].length() <= 0) continue;
                try {
                    il.add(Double.valueOf(ss[i]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            double[] ii = new double[il.size()];
            for (int i = 0; i < ii.length; ++i) {
                ii[i] = (Double)il.get(i);
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }
}

