/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import de.wannawork.jcalendar.JCalendarComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.gui.JournalEntryPanel;
import org.gtdfree.journal.JournalEntry;
import org.gtdfree.journal.JournalTools;

public class JournalPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel entriesPanel;
    private long day;
    private Date date;
    private GTDFreeEngine engine;
    private JCalendarComboBox datePicker;
    private boolean setting = false;
    private AbstractAction newJournalEntryAction;

    public JournalPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        JButton b = new JButton("<<");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JournalPane.this.setDay(JournalPane.this.day - 7L);
            }
        });
        b.setToolTipText("Previous week");
        jp.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        b = new JButton("<");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JournalPane.this.setDay(JournalPane.this.day - 1L);
            }
        });
        b.setToolTipText("Previous day");
        jp.add((Component)b, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.datePicker = new JCalendarComboBox();
        this.datePicker.setDateFormat(new SimpleDateFormat("EEE, d MMM yyyy"));
        this.datePicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JournalPane.this.setting = true;
                JournalPane.this.setDate(JournalPane.this.datePicker.getDate());
                JournalPane.this.setting = false;
            }
        });
        jp.add((Component)this.datePicker, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        b = new JButton(">");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JournalPane.this.setDay(JournalPane.this.day + 1L);
            }
        });
        b.setToolTipText("Next day");
        jp.add((Component)b, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        b = new JButton(">>");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JournalPane.this.setDay(JournalPane.this.day + 7L);
            }
        });
        b.setToolTipText("Next week");
        jp.add((Component)b, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.entriesPanel = new JPanel();
        this.entriesPanel.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.entriesPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        b = new JButton(this.getNewJournalEntryAction());
        jp.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)jp, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addNewjournalEntry() {
        JournalEntry en = this.engine.getJournalModel().addEntry(this.day);
        this.addEntry(en, true);
    }

    private void addEntry(JournalEntry en, boolean last) {
        JournalEntryPanel ep = new JournalEntryPanel(en);
        if (this.entriesPanel.getComponentCount() > 0 && last) {
            this.entriesPanel.remove(this.entriesPanel.getComponentCount() - 1);
        }
        this.entriesPanel.add((Component)ep, new GridBagConstraints(0, this.entriesPanel.getComponentCount(), 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (last) {
            this.entriesPanel.add((Component)new JPanel(), new GridBagConstraints(0, this.entriesPanel.getComponentCount(), 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.validate();
        }
    }

    private Action getNewJournalEntryAction() {
        if (this.newJournalEntryAction == null) {
            this.newJournalEntryAction = new AbstractAction("New Journal Entry"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JournalPane.this.addNewjournalEntry();
                }
            };
            this.newJournalEntryAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_add));
        }
        return this.newJournalEntryAction;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.setDay(JournalTools.today());
    }

    public void setDate(Date date) {
        this.setDay(JournalTools.toDay(date.getTime()));
    }

    public void setDay(long day) {
        if (this.day == day) {
            return;
        }
        this.day = day;
        this.date = JournalTools.toDate(day);
        if (!this.setting) {
            this.datePicker.setDate(this.date);
        }
        for (Component component : this.entriesPanel.getComponents()) {
            if (!(component instanceof JournalEntryPanel)) continue;
            ((JournalEntryPanel)component).release();
        }
        this.entriesPanel.removeAll();
        JournalEntry[] entries = this.engine.getJournalModel().getEntries(day);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.addEntry(entries[i], i == entries.length - 1);
            }
        }
        this.entriesPanel.validate();
        this.entriesPanel.repaint();
    }
}

