/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb;

import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBServer;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.impl.main.LocalODB;
import org.neodatis.odb.impl.main.ODBDefaultServer;
import org.neodatis.odb.impl.main.RemoteODBClient;
import org.neodatis.odb.impl.main.ThreadSafeLocalODB;

public class ODBFactory {
    private ODBFactory() {
    }

    public static ODB open(String fileName, String user, String password) {
        ODB odBase = LocalODB.getInstance(fileName, user, password);
        if (OdbConfiguration.isMultiThread()) {
            odBase = new ThreadSafeLocalODB(odBase);
        }
        return odBase;
    }

    public static ODB open(String fileName) {
        ODB odBase = LocalODB.getInstance(fileName);
        if (OdbConfiguration.isMultiThread()) {
            odBase = new ThreadSafeLocalODB(odBase);
        }
        return odBase;
    }

    public static ODBServer openServer(int port) {
        return new ODBDefaultServer(port);
    }

    public static ODB openClient(String hostName, int port, String baseIdentifier) {
        return new RemoteODBClient(hostName, port, baseIdentifier);
    }

    public static ODB openClient(String hostName, int port, String baseIdentifier, String user, String password) {
        return new RemoteODBClient(hostName, port, baseIdentifier, user, password);
    }
}

