/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.classbrowser;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.GuiConfiguration;
import org.neodatis.odb.gui.classbrowser.ClassAttributeInfoWrapper;
import org.neodatis.odb.gui.classbrowser.ClassInfoWrapper;

public class ClassHierarchyModel
extends DefaultTreeModel {
    private IStorageEngine engine;

    public ClassHierarchyModel(IStorageEngine engine, TreeNode node) {
        super(node);
        this.engine = engine;
    }

    public void updateEngine(IStorageEngine engine) {
        this.engine = engine;
        this.fireTreeStructureChanged(this.getRoot(), new Object[]{this.getRoot()}, new int[]{0}, new Object[]{this.getChild(this.getRoot(), 0)});
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            if (GuiConfiguration.displayAllClasses()) {
                return new ClassInfoWrapper(this.engine.getSession(true).getMetaModel().getAllClasses().get(index));
            }
            return new ClassInfoWrapper(this.engine.getSession(true).getMetaModel().slowGetUserClassInfo(index));
        }
        if (parent instanceof ClassInfoWrapper) {
            ClassInfoWrapper ciw = (ClassInfoWrapper)parent;
            ClassAttributeInfo cai = ciw.getCi().getAttributes().get(index);
            return new ClassAttributeInfoWrapper(cai, ciw.getCi());
        }
        if (parent instanceof ClassAttributeInfoWrapper) {
            ClassAttributeInfoWrapper caiw = (ClassAttributeInfoWrapper)parent;
            ClassAttributeInfo cai = caiw.getCai();
            String name = cai.getFullClassname();
            if (cai.getAttributeType().isArray()) {
                name = String.format("%s of %s", cai.getFullClassname(), cai.getAttributeType().getSubType().getName());
            }
            switch (index) {
                case 0: {
                    return name;
                }
            }
            return "unkown";
        }
        return "unknown";
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            if (GuiConfiguration.displayAllClasses()) {
                return this.engine.getSession(true).getMetaModel().getNumberOfClasses();
            }
            return this.engine.getSession(true).getMetaModel().getNumberOfUserClasses();
        }
        if (parent instanceof ClassInfoWrapper) {
            ClassInfoWrapper ciw = (ClassInfoWrapper)parent;
            return ciw.getCi().getAttributes().size();
        }
        if (parent instanceof ClassAttributeInfoWrapper) {
            return 1;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node instanceof String;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof String) {
            if (GuiConfiguration.displayAllClasses()) {
                return this.engine.getSession(true).getMetaModel().getAllClasses().indexOf(child);
            }
            return this.engine.getSession(true).getMetaModel().slowGetUserClassInfoIndex((ClassInfo)child);
        }
        if (parent instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)parent;
            return ci.getAttributes().indexOf(child);
        }
        if (parent instanceof ClassAttributeInfo) {
            return 0;
        }
        return 0;
    }
}

