package org.infoml.infocardOrganizer;

/*

Copyright 2006 by Gregg Williams. Programming by Andrei Stoiculescu and Gregg Williams.

This file is part of Infocard Organizer.

Infocard Organizer is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or(at your option) any later version.

Infocard Organizer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with Infocard Organizer; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.

*/

import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;
import javax.swing.plaf.metal.*;
import java.io.*;

public class MyRenderer extends DefaultTreeCellRenderer
{
	static boolean small = true;

	 public Component getTreeCellRendererComponent(
             JTree tree,
             Object value,
             boolean sel,
             boolean expanded,
             boolean leaf,
             int row,
             boolean hasFocus) {

		 super.getTreeCellRendererComponent(
             tree, value, sel,
             expanded, leaf, row,
             hasFocus);

		 DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;

		 if (node.getUserObject() == null)
			 setIcon(null);
		 else
		 {

		   if (small)
			 if (node.getChildCount() == 0)
				 setIcon(new ImageIcon("resources" + File.separator + "TreeMinus.gif"));
			 else
				 setIcon(new ImageIcon("resources" + File.separator + "TreePlus.gif"));
		   else
			 if (node.getChildCount() == 0)
				 setIcon(new ImageIcon("resources" + File.separator + "TreeMinus2.gif"));
			 else
				 setIcon(new ImageIcon("resources" + File.separator + "TreePlus2.gif"));
		 }

        return this;
	 }

}
