/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractClippedImages {
    public static boolean outputMessages = false;
    private static String processed_dir = "processed";
    private static String inputDir = "";
    private static int outputCount;
    private static float[] outputSizes;
    private static String[] outputDirectories;
    PdfDecoder decode_pdf = null;
    private static final String separator;
    private String output_dir = "clippedImages";
    private String imageType = "tiff";
    private static RenderingHints hint;

    public ExtractClippedImages(String string) {
        this.processFiles(string);
    }

    private void processFiles(String string) {
        File file;
        if (!string.endsWith("\\") && !string.endsWith("/")) {
            string = string + separator;
        }
        if (!processed_dir.endsWith(separator)) {
            processed_dir = processed_dir + separator;
        }
        if (!(file = new File(string)).isDirectory()) {
            ExtractClippedImages.exit("No root directory " + string);
        }
        String[] stringArray = null;
        try {
            File file2 = new File(string);
            System.out.println(file2.getAbsolutePath());
            if (!file2.isDirectory()) {
                System.err.println(string + " is not a directory. Exiting program");
            }
            stringArray = file2.list();
        }
        catch (Exception exception) {
            ExtractClippedImages.exit("Exception trying to access file " + exception.getMessage());
        }
        long l = stringArray.length;
        int n = 0;
        while ((long)n < l) {
            if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                if (outputMessages) {
                    System.out.println(string + stringArray[n]);
                }
                this.decode(string + stringArray[n], 72);
                File file3 = new File(string + stringArray[n]);
                file3.renameTo(new File(processed_dir + stringArray[n]));
            }
            ++n;
        }
    }

    private static void exit(String string) {
        System.out.println("Exit message " + string);
        LogWriter.writeLog("Exit message " + string);
    }

    private void decode(String string, int n) {
        String string2 = "demo";
        LogWriter.writeLog("==================");
        LogWriter.writeLog("File " + string);
        int n2 = string.lastIndexOf(separator);
        if (n2 != -1) {
            string2 = string.substring(n2 + 1, string.length() - 4);
        }
        try {
            this.decode_pdf = new PdfDecoder(false);
            this.decode_pdf.setExtractionMode(36, n, 1.0f);
            this.decode_pdf.openPdfFile(string);
        }
        catch (Exception exception) {
            ExtractClippedImages.exit(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.OpeningPdfFiles"));
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            ExtractClippedImages.exit(Messages.getMessage("PdfViewerError.EncryptedNotSupported"));
        } else {
            int n3 = 1;
            int n4 = this.decode_pdf.getPageCount();
            try {
                for (int i = n3; i < n4 + 1; ++i) {
                    LogWriter.writeLog(Messages.getMessage("PdfViewerDecoding.page") + ' ' + i);
                    this.decode_pdf.decodePage(i);
                    PdfImageData pdfImageData = this.decode_pdf.getPdfImageData();
                    int n5 = pdfImageData.getImageCount();
                    if (n5 > 0) {
                        LogWriter.writeLog("page " + i + "contains " + n5 + " images");
                    } else {
                        LogWriter.writeLog("No bitmapped images on page " + i);
                    }
                    LogWriter.writeLog("Writing out images");
                    for (int j = 0; j < n5; ++j) {
                        String string3 = pdfImageData.getImageName(j);
                        float f = pdfImageData.getImageXCoord(j);
                        float f2 = pdfImageData.getImageYCoord(j);
                        float f3 = pdfImageData.getImageWidth(j);
                        float f4 = pdfImageData.getImageHeight(j);
                        for (int k = 0; k < outputCount; ++k) {
                            try {
                                Object object;
                                Object object2;
                                String string4 = this.decode_pdf.getObjectStore().getImageType(string3);
                                BufferedImage bufferedImage = this.decode_pdf.getObjectStore().loadStoredImage("CLIP_" + string3);
                                int n6 = string.lastIndexOf(92);
                                if (n6 == -1) {
                                    n6 = string.lastIndexOf(47);
                                }
                                if (n6 == -1) {
                                    n6 = 0;
                                }
                                String string5 = string.substring(n6, string.length() - 4);
                                String string6 = outputDirectories[k] + string5 + '_' + i + '_' + j;
                                float f5 = 1.0f;
                                int n7 = bufferedImage.getHeight();
                                if (outputSizes[k] > 0.0f) {
                                    f5 = outputSizes[k] / (float)n7;
                                    if (f5 > 1.0f) {
                                        f5 = 1.0f;
                                    } else {
                                        object2 = bufferedImage.getScaledInstance(-1, (int)outputSizes[k], 4);
                                        bufferedImage = new BufferedImage(((Image)object2).getWidth(null), ((Image)object2).getHeight(null), 2);
                                        Graphics2D graphics2D = bufferedImage.createGraphics();
                                        graphics2D.drawImage((Image)object2, 0, 0, null);
                                    }
                                }
                                boolean bl = (object2 = System.getProperty("compress_tiff")) != null;
                                JAIHelper.confirmJAIOnClasspath();
                                if (bl && JAIHelper.isJAIused()) {
                                    object = null;
                                    object = new TIFFEncodeParam();
                                    object.setCompression(32946);
                                    FileOutputStream fileOutputStream = new FileOutputStream(string6 + ".tif");
                                    JAI.create((String)"encode", (RenderedImage)bufferedImage, (Object)fileOutputStream, (Object)"TIFF", (Object)object);
                                    fileOutputStream.flush();
                                    fileOutputStream.close();
                                } else {
                                    this.decode_pdf.getObjectStore().saveStoredImage(string6, bufferedImage, true, false, this.imageType);
                                }
                                object = new OutputStreamWriter((OutputStream)new FileOutputStream(string6 + ".xml"), "UTF-8");
                                ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                                ((Writer)object).write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                                ((Writer)object).write("(x1,y1 is top left corner)\n");
                                ((Writer)object).write("(origin is bottom left corner)  -->\n");
                                ((Writer)object).write("\n\n<META>\n");
                                ((Writer)object).write("<PAGELOCATION x1=\"" + f + "\" " + "y1=\"" + (f2 + f4) + "\" " + "x2=\"" + (f + f3) + "\" " + "y2=\"" + f2 + "\" />\n");
                                ((Writer)object).write("<FILE>" + string + "</FILE>\n");
                                ((Writer)object).write("<ORIGINALHEIGHT>" + n7 + "</ORIGINALHEIGHT>\n");
                                ((Writer)object).write("<SCALEDHEIGHT>" + bufferedImage.getHeight() + "</SCALEDHEIGHT>\n");
                                ((Writer)object).write("<SCALING>" + f5 + "</SCALING>\n");
                                ((Writer)object).write("</META>\n");
                                ((OutputStreamWriter)object).close();
                                continue;
                            }
                            catch (Exception exception) {
                                LogWriter.writeLog("Exception " + exception + " in extracting images");
                            }
                        }
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception exception) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog("Exception " + exception.getMessage());
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    public static void main(String[] stringArray) {
        Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        if (outputMessages) {
            System.out.println("Simple demo to extract images from a page at various heights");
        }
        if ((stringArray.length & 1) == 0 | stringArray.length < 5) {
            LogWriter.writeLog("Values read");
            LogWriter.writeLog("inputDir=" + inputDir);
            LogWriter.writeLog("processedDir=" + processed_dir);
            LogWriter.writeLog("logFile=" + LogWriter.log_name);
            LogWriter.writeLog("Directory and height pair values");
            for (int i = 3; i < outputCount; ++i) {
                LogWriter.writeLog(stringArray[i]);
            }
            if (stringArray.length < 5 | (stringArray.length & 1) == 0) {
                System.out.println("Requires");
                System.out.println("inputDir processedDir logFile");
                System.out.println("height Directory (as many pairs as you like)");
                ExtractClippedImages.exit("Not enough parameters passed to software");
            } else {
                ExtractClippedImages.exit("Incorrect number of values");
            }
        }
        inputDir = stringArray[0];
        processed_dir = stringArray[1];
        File file = new File(inputDir);
        File file2 = new File(processed_dir);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            ExtractClippedImages.exit("Directory " + inputDir + " not found");
        }
        outputCount = (stringArray.length - 3) / 2;
        outputSizes = new float[outputCount];
        outputDirectories = new String[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            try {
                ExtractClippedImages.outputSizes[i] = Float.parseFloat(stringArray[3 + i * 2]);
            }
            catch (Exception exception) {
                ExtractClippedImages.exit("Exception " + exception + " reading integer " + stringArray[3 + i * 2]);
            }
            try {
                File file3;
                ExtractClippedImages.outputDirectories[i] = stringArray[4 + i * 2];
                if (!outputDirectories[i].endsWith("\\") && !outputDirectories[i].endsWith("/")) {
                    ExtractClippedImages.outputDirectories[i] = outputDirectories[i] + separator;
                }
                if ((file3 = new File(outputDirectories[i])).exists()) continue;
                file3.mkdirs();
                continue;
            }
            catch (Exception exception) {
                ExtractClippedImages.exit("Exception " + exception + " with directory " + stringArray[4 + i * 2]);
            }
        }
        ExtractClippedImages extractClippedImages = new ExtractClippedImages(inputDir);
        LogWriter.writeLog("Process completed");
    }

    static {
        separator = System.getProperty("file.separator");
        hint = null;
        hint = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hint.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hint.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
    }
}

