/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.Strip;

public class PDFStitching
extends PDFGenericFunction
implements PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds;
    private float[] encode;
    private int n;
    private Map tintTransform;
    private float[] domain;
    private float[] range;

    public String getType() {
        return "STITCHING";
    }

    public PDFStitching(Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        this.range = fArray2;
        this.domain = fArray;
        this.tintTransform = map;
        this.setBounds(pdfObjectReader);
        this.setEncode(pdfObjectReader);
        this.setFunctions(pdfObjectReader);
        this.n = this.encode.length / 2;
    }

    public String[] compute(float[] fArray) {
        int n = this.n;
        if (this.range != null) {
            n = this.range.length / 2;
        }
        String[] stringArray = new String[n];
        float[] fArray2 = new float[n];
        try {
            int n2;
            float f = this.min(this.max(fArray[0], this.domain[0]), this.domain[1]);
            for (n2 = this.bounds.length - 1; n2 >= 0 && !(f >= this.bounds[n2]); --n2) {
            }
            float[] fArray3 = new float[1];
            float f2 = this.domain[0];
            float f3 = this.domain[1];
            if (++n2 > 0) {
                f2 = this.bounds[n2 - 1];
            }
            if (n2 < this.bounds.length) {
                f3 = this.bounds[n2];
            }
            float f4 = this.encode[n2 * 2];
            float f5 = this.encode[n2 * 2 + 1];
            fArray3[0] = this.interpolate(f, f2, f3, f4, f5);
            fArray2 = this.functions[n2].computeFloat(fArray3);
            stringArray = new String[fArray2.length];
            if (this.range != null) {
                for (int i = 0; i != this.range.length / 2; ++i) {
                    stringArray[i] = String.valueOf(this.min(this.max(fArray2[i], this.range[0]), this.range[1]));
                }
            } else {
                for (int i = 0; i != fArray2.length; ++i) {
                    stringArray[i] = String.valueOf(fArray2[i]);
                }
            }
            return stringArray;
        }
        catch (Exception exception) {
            System.out.println("Compute error " + exception);
            exception.printStackTrace();
            return stringArray;
        }
    }

    public float[] computeFloat(float[] fArray) {
        int n = this.n;
        if (this.range != null) {
            n = this.range.length / 2;
        }
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        try {
            int n2;
            float f = this.min(this.max(fArray[0], this.domain[0]), this.domain[1]);
            for (n2 = this.bounds.length - 1; n2 >= 0 && !(f >= this.bounds[n2]); --n2) {
            }
            float[] fArray4 = new float[1];
            float f2 = this.domain[0];
            float f3 = this.domain[1];
            if (++n2 > 0) {
                f2 = this.bounds[n2 - 1];
            }
            if (n2 < this.bounds.length) {
                f3 = this.bounds[n2];
            }
            float f4 = this.encode[n2 * 2];
            float f5 = this.encode[n2 * 2 + 1];
            fArray4[0] = this.interpolate(f, f2, f3, f4, f5);
            fArray2 = this.functions[n2].computeFloat(fArray4);
            fArray3 = new float[fArray2.length];
            for (int i = 0; i != this.range.length / 2; ++i) {
                fArray3[i] = this.range != null ? this.min(this.max(fArray2[i], this.range[0]), this.range[1]) : fArray2[i];
            }
            return fArray3;
        }
        catch (Exception exception) {
            System.out.println("Compute error " + exception);
            exception.printStackTrace();
            return fArray3;
        }
    }

    private void setBounds(PdfObjectReader pdfObjectReader) {
        String string = pdfObjectReader.getValue((String)this.tintTransform.get("Bounds"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.bounds = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.bounds[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
    }

    private void setEncode(PdfObjectReader pdfObjectReader) {
        String string = pdfObjectReader.getValue((String)this.tintTransform.get("Encode"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.encode = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.encode[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        }
    }

    private void setFunctions(PdfObjectReader pdfObjectReader) {
        String string = (String)this.tintTransform.get("Functions");
        if (string.indexOf(91) == -1) {
            string = (String)pdfObjectReader.readObject(string, false, null).get("rawValue");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators(string), "R");
        int n = stringTokenizer.countTokens();
        Map[] mapArray = new Map[n];
        for (int i = 0; i < n; ++i) {
            String string2 = (stringTokenizer.nextToken() + 'R').trim();
            Map map = pdfObjectReader.readObject(string2, false, null);
            pdfObjectReader.readStream(string2, true);
            mapArray[i] = map;
        }
        this.setFunctionDomainRange(pdfObjectReader, mapArray);
    }

    private void setFunctionDomainRange(PdfObjectReader pdfObjectReader, Map[] mapArray) {
        this.functions = new PDFFunction[mapArray.length];
        int n = mapArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            StringTokenizer stringTokenizer;
            if (mapArray[i].containsKey("CachedStream")) {
                pdfObjectReader.readStreamIntoMemory(mapArray[i]);
            }
            byte[] byArray = (byte[])mapArray[i].get("DecodedStream");
            int n3 = Integer.parseInt((String)mapArray[i].get("FunctionType"));
            float[] fArray = null;
            float[] fArray2 = null;
            String string = (String)mapArray[i].get("Domain");
            if (string != null) {
                stringTokenizer = new StringTokenizer(string, "[] ");
                fArray = new float[stringTokenizer.countTokens()];
                n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
                    ++n2;
                }
            }
            if ((string = (String)mapArray[i].get("Range")) != null) {
                stringTokenizer = new StringTokenizer(string, "[] ");
                fArray2 = new float[stringTokenizer.countTokens()];
                n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fArray2[n2] = Float.parseFloat(stringTokenizer.nextToken());
                    ++n2;
                }
                if (i == 0) {
                    this.n = fArray2.length / 2;
                }
            }
            this.functions[i] = FunctionFactory.getFunction(byArray, mapArray[i], fArray, fArray2, n3, pdfObjectReader);
        }
    }
}

