/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.StoryData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.FontFactory;
import org.jpedal.parser.StreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfStreamDecoder
implements StreamDecoder {
    public static boolean useShading = true;
    private boolean TRFlagged = false;
    ImageHandler customImageHandler = null;
    boolean rejectSuperimposedImages = false;
    private int optionsApplied = 0;
    private boolean generateGlyphOnRender = false;
    static final int[] prefixes = new int[]{60, 40};
    static final int[] suffixes = new int[]{62, 41};
    boolean isMask = true;
    private boolean pageSuccessful = true;
    private String pageErrorMessages = "";
    private StringBuffer textData;
    private StatusBar statusBar = null;
    public static float currentThreshold = 0.6f;
    public static Map currentThresholdValues;
    private Map rawColorspaceValues = new HashMap();
    private Map colorspaceObjects = new HashMap();
    private int textPrint = 0;
    private Map rawShadingValues = new HashMap();
    protected boolean multipleTJs = false;
    private PdfObjectReader currentPdfFile;
    private boolean isClip = false;
    private static final float THOUSAND = 1000.0f;
    private boolean renderText = false;
    private boolean renderImages = false;
    private boolean renderPage = false;
    private boolean rawImagesExtracted = true;
    private boolean finalImagesExtracted = true;
    private boolean xFormMetadata = true;
    private boolean clippedImagesExtracted = true;
    private boolean markedContentExtracted = false;
    private StructuredContentHandler contentHandler;
    private boolean textExtracted = true;
    private boolean textColorExtracted = false;
    private boolean colorExtracted = false;
    private static final String[] hex;
    private PdfData pdfData = new PdfData();
    private String font_as_string = "";
    protected GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    protected GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean createScaledVersion = true;
    private PdfImageData pdfImages = new PdfImageData();
    private int tokenNumber = 0;
    private boolean isPageContent = true;
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object clipStack;
    private Vector_Object textStateStack;
    private PageLines pageLines = new PageLines();
    private PdfShape currentDrawShape = new PdfShape();
    private static final int MAXOPS = 50;
    private int currentOp = 0;
    private int operandCount = 0;
    private String[] operand = new String[50];
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    protected int moveCommand = 0;
    private String currentFont = "";
    private String currentImage = "";
    private Map currentXObjectValues = new Hashtable();
    private Map localXObjects = new Hashtable();
    private Map currentPatternValues = new Hashtable();
    protected float charSpacing = 0.0f;
    protected GraphicsState currentGraphicsState = new GraphicsState();
    protected TextState currentTextState = new TextState();
    protected PdfFont currentFontData;
    private Map fonts = new Hashtable();
    private int textLength = 0;
    private boolean useHiResImageForDisplay = false;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private PdfPageData pageData = new PdfPageData();
    protected DynamicVectorRenderer current;
    protected GlyphFactory factory = null;
    private int pageNum;
    private static String fontsInFile;
    private String currentColor = "<color C='1' M='1' Y='1' K='1'>";
    private int T3maxWidth;
    private int T3maxHeight;
    private boolean legacyTextMode = false;
    private boolean extractRawCMYK = false;
    protected boolean renderDirectly;
    protected Graphics2D g2;
    private Shape defaultClip;
    private boolean hasEmbeddedFonts = false;
    private boolean includeImagesInData = false;
    protected int lastFontSize = -1;
    public boolean ignoreColors = false;
    private static String ellipsis;
    private boolean isPrinting;
    private String fileName = "";
    private ObjectStore objectStoreStreamRef;
    private String lastFormID = null;
    private int pageH;
    private int formLevel = 0;
    private boolean requestExit = false;
    private boolean exited = false;
    private Map gs_state = new HashMap();
    private boolean imagesProcessedFully;
    private boolean keepRaw = false;
    public static boolean runningStoryPad;
    private static boolean testFontSupport;
    private Map scalings = new HashMap();
    private boolean isType3Font;
    private Map TRfunctionsCache = new HashMap();
    private Map TRPDFfunctionsCache = new HashMap();
    private Map imposedImages;
    private static boolean shadingMessageDisplayed;
    public static boolean showInvisibleText;
    public static boolean useTextPrintingForNonEmbeddedFonts;

    public void setName(String string) {
        if (string != null) {
            this.fileName = string.toLowerCase();
            int n = this.fileName.lastIndexOf(47);
            if (n != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(n + 1);
            }
            if ((n = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, n);
            }
        }
    }

    public void setStore(ObjectStore objectStore) {
        this.objectStoreStreamRef = objectStore;
        this.current = new DynamicVectorRenderer(this.pageNum, this.objectStoreStreamRef, this.isPrinting);
        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        if (this.customImageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(this.customImageHandler);
        }
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader, boolean bl, boolean bl2) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = pdfObjectReader;
        this.useHiResImageForDisplay = bl;
        this.isType3Font = bl2;
        String string = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = string != null && string.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = pdfObjectReader;
        String string = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = string != null && string.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder() {
        String string;
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.rejectSuperimposedImages = (string = System.getProperty("org.jpedal.rejectsuperimposedimages")) != null && string.toLowerCase().indexOf("true") != -1;
    }

    public void print(Graphics2D graphics2D, AffineTransform affineTransform, boolean bl) {
        if (bl) {
            this.current.setBackgroundColor(null);
        }
        this.current.paint(graphics2D, null, affineTransform, null, false, false);
    }

    public PdfStreamDecoder(boolean bl) {
        String string;
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.rejectSuperimposedImages = (string = System.getProperty("org.jpedal.rejectsuperimposedimages")) != null && string.toLowerCase().indexOf("true") != -1;
    }

    public void setDefaultColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.strokeColorSpace.setColor(pdfPaint);
        this.nonstrokeColorSpace.setColor(pdfPaint2);
        this.currentGraphicsState.setStrokeColor(pdfPaint);
        this.currentGraphicsState.setNonstrokeColor(pdfPaint2);
    }

    public void optimiseDisplayForPrinting() {
        this.isPrinting = true;
    }

    public PdfData getText() {
        return this.pdfData;
    }

    public PdfImageData getImages() {
        return this.pdfImages;
    }

    private final BufferedImage processImageXObject(String string, Map map, boolean bl, byte[] byArray) throws PdfException {
        String string2;
        Map map2;
        Object v;
        LogWriter.writeMethod("{processImageXObject}" + map, 0);
        boolean bl2 = false;
        String string3 = "";
        BufferedImage bufferedImage = null;
        string = this.fileName + '-' + string;
        String string4 = this.currentPdfFile.getValue((String)map.get("Filter"));
        String string5 = (String)map.get("ColorSpace");
        if (string5 != null) {
            string5 = Strip.removeArrayDeleminators(string5);
        }
        int n = Integer.parseInt((String)map.get("Width"));
        String string6 = (String)map.get("Height");
        if (string6.indexOf(82) != -1 && (v = (map2 = this.currentPdfFile.readObject(string6, false, null)).get("rawValue")) != null) {
            string6 = (String)v;
        }
        int n2 = Integer.parseInt(string6);
        int n3 = 1;
        String string7 = (String)map.get("BitsPerComponent");
        if (string7 != null) {
            n3 = Integer.parseInt(string7);
        }
        if ((string2 = (String)map.get("Decode")) != null) {
            string3 = string2;
        }
        if ((string2 = (String)map.get("ImageMask")) != null) {
            bl2 = Boolean.valueOf(string2);
            this.isMask = true;
        } else {
            this.isMask = false;
        }
        GenericColorSpace genericColorSpace = new GenericColorSpace();
        if (string5 != null) {
            if (string5.startsWith("/")) {
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string5, null, this.currentPdfFile);
            } else {
                Map map3 = this.currentPdfFile.getSubDictionary(string5);
                string5 = (String)map3.get("rawValue");
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string5, map3, this.currentPdfFile);
            }
        }
        string2 = (String)map.get("Intent");
        genericColorSpace.setIntent(string2);
        if (string5 == null) {
            string5 = "/RGB (Default)";
        }
        LogWriter.writeLog("Processing XObject: " + string + " width=" + n + " Height=" + n2 + " Depth=" + n3 + " filter=" + string4 + " colorspace=" + string5);
        if (this.customImageHandler != null) {
            map.put("stream", byArray);
            bufferedImage = this.customImageHandler.processImageData(map, this.currentGraphicsState);
        }
        if (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            bufferedImage = this.processImage(genericColorSpace, string5, byArray, string, n, n2, n3, string4, string3, bl2, bl, map);
        }
        return bufferedImage;
    }

    private final BufferedImage processImage(GenericColorSpace genericColorSpace, String string, byte[] byArray, String string2, int n, int n2, int n3, String string3, String string4, boolean bl, boolean bl2, Map map) throws PdfException {
        Object v;
        String string5;
        Object object;
        Object object2;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{process_image}");
        }
        boolean bl3 = false;
        BufferedImage bufferedImage = null;
        String string6 = "jpg";
        int n4 = genericColorSpace.getID();
        byte[] byArray2 = new byte[4];
        if (bl) {
            this.getMaskColor(byArray2);
        }
        if (string4.length() != 0 && (string3 == null || string3.indexOf("JPXDecode") == -1 && string3.indexOf("DCT") == -1)) {
            this.applyDecodeArray(byArray, n3, string4, n4);
        }
        if (bl) {
            if (n == 1 && n2 == 1) {
                float f;
                float f2 = this.currentGraphicsState.CTM[1][1];
                if (f2 == 0.0f) {
                    f2 = this.currentGraphicsState.CTM[1][0];
                }
                if (f2 < 0.0f) {
                    f2 = -f2;
                }
                if ((f = this.currentGraphicsState.CTM[0][0]) == 0.0f) {
                    f = this.currentGraphicsState.CTM[0][1];
                }
                if (f < 0.0f) {
                    f = -f;
                }
                if (f < 1.0f) {
                    f = 1.0f;
                }
                if (f2 < 1.0f) {
                    f2 = 1.0f;
                }
                bufferedImage = new BufferedImage((int)f, (int)f2, 2);
                object2 = bufferedImage.createGraphics();
                ((Graphics2D)object2).setPaint(this.nonstrokeColorSpace.getColor());
                ((Graphics)object2).fillRect(0, 0, (int)f, (int)f2);
            } else {
                Object object3;
                boolean bl4 = this.current.hasObjectsBehind(this.currentGraphicsState.CTM);
                if (byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0 && !bl4 && !this.isType3Font) {
                    object3 = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, 1, null);
                    bufferedImage = new BufferedImage(n, n2, 12);
                    bufferedImage.setData((Raster)object3);
                } else {
                    object3 = new byte[]{byArray2[0], byArray2[1], byArray2[2], -1, -1, -1};
                    bufferedImage = this.convertIndexedToFlat(genericColorSpace.getID(), 1, n, n2, byArray, (byte[])object3, ((Object)object3).length, true);
                }
            }
        } else if (string3 == null) {
            LogWriter.writeLog("Image " + string2 + ' ' + n + "W * " + n2 + "H with No Compression at BPC " + n3 + " and Colorspace=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
        } else if (string3.indexOf("DCT") != -1) {
            LogWriter.writeLog("JPeg Image " + string2 + ' ' + n + "W * " + n2 + 'H');
            if (n4 == 3 && this.extractRawCMYK) {
                LogWriter.writeLog("Raw CMYK image " + string2 + " saved.");
                if (!this.objectStoreStreamRef.saveRawCMYKImage(byArray, string2)) {
                    this.addPageFailureMessage("Problem saving Raw CMYK image " + string2);
                }
            }
            try {
                bufferedImage = genericColorSpace.JPEGToRGBImage(byArray, n, n2, string4);
                bl3 = ColorSpaceConvertor.wasRemoved;
            }
            catch (Exception exception) {
                this.addPageFailureMessage("Problem converting " + string2 + " to JPEG");
                exception.printStackTrace();
                bufferedImage = null;
            }
            string6 = "jpg";
        } else if (string3.indexOf("JPXDecode") != -1) {
            LogWriter.writeLog("JPeg 2000 Image " + string2 + ' ' + n + "W * " + n2 + 'H');
            if (JAIHelper.isJAIused()) {
                bufferedImage = genericColorSpace.JPEG2000ToRGBImage(byArray);
                string6 = "jpg";
            } else {
                LogWriter.writeLog("JPeg 2000 Image needs JAI on classpath and enabled in JPedal");
            }
        } else {
            LogWriter.writeLog(string2 + ' ' + n + "W * " + n2 + "H  with " + string3 + " BPC=" + n3 + " CS=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
            if (n3 == 8 | this.nonstrokeColorSpace.getID() == 2 | this.nonstrokeColorSpace.getID() == 7) {
                string6 = "jpg";
            }
        }
        if (bufferedImage != null) {
            Object object4;
            Object object5;
            Object object6;
            String string7 = (String)map.get("Mask");
            Object v2 = map.get("SMask");
            if (v2 != null) {
                object2 = null;
                object = "";
                if (v2 instanceof Map) {
                    object2 = (Map)v2;
                } else {
                    object = (String)v2;
                    object2 = this.currentPdfFile.readObject((String)object, false, null);
                }
                object6 = this.currentPdfFile.readStream((Map)object2, (String)object, true, true, this.keepRaw, false);
                if (object6 != null) {
                    object5 = this.processImageXObject(string2, (Map)object2, false, (byte[])object6);
                    object4 = (Map)object2.get("DecodeParms");
                    if (object4 == null || !object4.containsKey("Colors")) {
                        bufferedImage = this.applySmask(bufferedImage, (BufferedImage)object5, (String)object2.get("ColorSpace"));
                    }
                }
            } else if (string7 != null) {
                if (string7.indexOf(91) != -1) {
                    int n5;
                    int n6;
                    string7 = Strip.removeArrayDeleminators(string7);
                    int n7 = genericColorSpace.getColorComponentCount();
                    object = genericColorSpace.getIndexedMap();
                    if (object != null) {
                        object6 = new StringTokenizer(string7);
                        StringBuffer stringBuffer = new StringBuffer();
                        int n8 = ((StringTokenizer)object6).countTokens();
                        while (((StringTokenizer)object6).hasMoreTokens()) {
                            n6 = Integer.parseInt(((StringTokenizer)object6).nextToken());
                            for (n5 = 0; n5 < n7; ++n5) {
                                stringBuffer.append(String.valueOf(object[n6 * n7 + n5] & 0xFF));
                                stringBuffer.append(' ');
                            }
                        }
                        string7 = stringBuffer.toString();
                    }
                    object6 = new StringTokenizer(string7);
                    int n9 = ((StringTokenizer)object6).countTokens() / n7;
                    object4 = new int[n9][n7];
                    for (n6 = 0; n6 < n9; ++n6) {
                        for (n5 = 0; n5 < n7; ++n5) {
                            int n10 = Integer.parseInt(((StringTokenizer)object6).nextToken());
                            if (n7 == 1) {
                                object4[n6][0] = n10;
                                object4[n6][1] = n10;
                                object4[n6][2] = n10;
                                continue;
                            }
                            if (n7 != 3) continue;
                            object4[n6][n5] = n10;
                        }
                    }
                    bufferedImage = this.convertPixelsToTransparent(bufferedImage, n7, n9, (int[][])object4);
                } else if (string7.endsWith(" R") && (object = (Object)this.currentPdfFile.readStream((Map)(object2 = this.currentPdfFile.readObject(string7, false, null)), string7, true, true, this.keepRaw, false)) != null) {
                    bufferedImage = this.overlayImage(bufferedImage, (byte[])object);
                }
            }
            if (n4 == 3 && this.currentGraphicsState.getNonStrokeOP() && this.currentGraphicsState.getOPM() == 1.0f && (bufferedImage = this.simulateOP(bufferedImage)) == null) {
                return null;
            }
            byArray = null;
            if (bufferedImage.getSampleModel().getNumBands() == 1) {
                string6 = "tif";
            }
            if (this.isPageContent && (this.clippedImagesExtracted || this.finalImagesExtracted || this.rawImagesExtracted)) {
                if (this.currentPdfFile.isExtractionAllowed()) {
                    if (!runningStoryPad) {
                        this.objectStoreStreamRef.saveStoredImage(string2, this.addBackgroundToMask(bufferedImage), false, bl2, string6);
                    }
                } else if (PdfDecoder.dpi != 72) {
                    int n11 = bufferedImage.getType();
                    if (n11 == 0) {
                        n11 = 1;
                    }
                    object = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n11);
                    ((BufferedImage)object).createGraphics().drawImage(bufferedImage, null, null);
                    float f = (float)PdfDecoder.dpi / 72.0f;
                    object5 = new AffineTransform();
                    ((AffineTransform)object5).scale(f, f);
                    object4 = new AffineTransformOp((AffineTransform)object5, ColorSpaces.hints);
                    object = ((AffineTransformOp)object4).filter((BufferedImage)object, null);
                    this.objectStoreStreamRef.saveStoredImage(string2, this.addBackgroundToMask((BufferedImage)object), false, bl2, string6);
                } else {
                    this.objectStoreStreamRef.saveStoredImage(string2, this.addBackgroundToMask(bufferedImage), false, bl2, string6);
                }
            }
        }
        if (bufferedImage == null && !bl3) {
            this.imagesProcessedFully = false;
        }
        if ((string5 = this.currentGraphicsState.getTR()) != null && string5.endsWith("R")) {
            bufferedImage = this.applyTR(bufferedImage, string5);
        }
        if (map != null && (v = map.get("DecodeParms")) instanceof Map && (object2 = (Map)v) != null && (object = object2.get("Blend")) != null) {
            bufferedImage = this.makeWhiteTransparent(bufferedImage);
        }
        return bufferedImage;
    }

    private BufferedImage overlayImage(BufferedImage bufferedImage, byte[] byArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = (bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage)).getWidth();
        int n2 = n;
        if ((n2 & 7) != 0) {
            n2 += 8;
        }
        n2 >>= 3;
        int n3 = 0;
        int[] nArray = new int[]{0, 0, 255, 0};
        int[] nArray2 = new int[]{0, 2, 4, 8, 16, 32, 64, 128};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl;
                int n4 = j >> 3;
                byte by = byArray[n3 + n4];
                boolean bl2 = bl = (by & nArray2[j & 7]) == 0;
                if (bl) continue;
                bufferedImage.getRaster().setPixel(j, i, nArray);
            }
            n3 += n2;
        }
        return bufferedImage;
    }

    private BufferedImage convertPixelsToTransparent(BufferedImage bufferedImage, int n, int n2, int[][] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int[] nArray2 = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int[] nArray3 = new int[4];
                writableRaster.getPixel(j, i, nArray3);
                boolean bl = true;
                for (int k = 0; k < n2; ++k) {
                    bl = false;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (nArray[k][i2] == nArray3[i2]) continue;
                        i2 = n;
                        bl = true;
                    }
                    if (bl) continue;
                    bufferedImage.getRaster().setPixel(j, i, nArray2);
                    k = n2;
                }
            }
        }
        return bufferedImage;
    }

    private BufferedImage simulateOP(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        boolean bl = false;
        int[] nArray = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                boolean bl2;
                int[] nArray2 = new int[4];
                writableRaster.getPixel(j, i, nArray2);
                boolean bl3 = bl2 = nArray2[1] == 0 && nArray2[2] == 0 && nArray2[3] == 0;
                if (bl2) {
                    bufferedImage.getRaster().setPixel(j, i, nArray);
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            return bufferedImage;
        }
        return null;
    }

    private BufferedImage makeWhiteTransparent(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int[] nArray = new int[]{255, 0, 0, 0};
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                boolean bl;
                int[] nArray2 = new int[4];
                writableRaster.getPixel(j, i, nArray2);
                boolean bl2 = bl = nArray2[0] > 250 && nArray2[1] > 252 && nArray2[2] > 252;
                if (!bl) continue;
                bufferedImage.getRaster().setPixel(j, i, nArray);
            }
        }
        return bufferedImage;
    }

    private BufferedImage applyTR(BufferedImage bufferedImage, String string) {
        Object[] objectArray;
        float[] fArray;
        int n;
        Object object;
        PDFFunction[] pDFFunctionArray;
        Object v = this.TRfunctionsCache.get(string);
        Object v2 = this.TRPDFfunctionsCache.get(string);
        if (v != null) {
            pDFFunctionArray = (PDFFunction[])v2;
        } else {
            pDFFunctionArray = new PDFFunction[4];
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "R");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = (stringTokenizer.nextToken() + 'R').trim();
                object = this.currentPdfFile.readObject(string2, false, null);
                if (object != null) {
                    int n3;
                    Object object2;
                    n = Integer.parseInt((String)object.get("FunctionType"));
                    fArray = null;
                    objectArray = null;
                    String string3 = (String)object.get("Domain");
                    if (string3 != null) {
                        object2 = new StringTokenizer(string3, "[] ");
                        fArray = new float[((StringTokenizer)object2).countTokens()];
                        n3 = 0;
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            fArray[n3] = Float.parseFloat(((StringTokenizer)object2).nextToken());
                            ++n3;
                        }
                    }
                    if ((string3 = (String)object.get("Range")) != null) {
                        object2 = new StringTokenizer(string3, "[] ");
                        objectArray = new float[((StringTokenizer)object2).countTokens()];
                        n3 = 0;
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            objectArray[n3] = (String)Float.parseFloat(((StringTokenizer)object2).nextToken());
                            ++n3;
                        }
                    }
                    object2 = null;
                    object2 = string2 != null ? (Object)this.currentPdfFile.readStream(string2, true) : (Object)((byte[])object.get("DecodedStream"));
                    pDFFunctionArray[n2] = FunctionFactory.getFunction((byte[])object2, (Map)object, fArray, (float[])objectArray, n, this.currentPdfFile);
                }
                ++n2;
            }
            this.TRPDFfunctionsCache.put(string, pDFFunctionArray);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                object = new int[4];
                writableRaster.getPixel(j, i, (int[])object);
                for (n = 0; n < 3; ++n) {
                    fArray = new float[]{(float)object[n] / 255.0f};
                    objectArray = null;
                    objectArray = pDFFunctionArray[n].compute(fArray);
                    object[n] = (int)(255.0f * Float.parseFloat(objectArray[0]));
                }
                bufferedImage.getRaster().setPixel(j, i, (int[])object);
            }
        }
        return bufferedImage;
    }

    private BufferedImage applySmask(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 0, 0, 0};
        if (string != null && string.equals("/DeviceGray")) {
            bufferedImage2 = ColorSpaceConvertor.convertColorspace(bufferedImage2, 10);
            nArray2 = nArray;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int n = bufferedImage2.getColorModel().getNumComponents();
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int[] nArray4 = new int[n];
                writableRaster2.getPixel(j, i, nArray4);
                boolean bl = true;
                bl = false;
                if (n == 1) {
                    if (nArray4[0] > 127) {
                        bl = true;
                    }
                } else {
                    for (int k = 0; k < n; ++k) {
                        if (nArray4[k] == nArray2[k]) continue;
                        k = n;
                        bl = true;
                    }
                }
                if (bl) continue;
                bufferedImage.getRaster().setPixel(j, i, nArray3);
            }
        }
        return bufferedImage;
    }

    private void getMaskColor(byte[] byArray) {
        int n = this.nonstrokeColorSpace.getColor().getRGB();
        byArray[0] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
    }

    private void applyDecodeArray(byte[] byArray, int n, String string, int n2) {
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[ ]");
        int n4 = stringTokenizer.countTokens();
        int n5 = 0;
        float[] fArray = new float[n4];
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            fArray[n5] = Float.parseFloat(stringTokenizer.nextToken());
            if ((float)n6 < fArray[n5]) {
                n6 = (int)fArray[n5];
            }
            ++n5;
        }
        boolean bl = true;
        int n7 = fArray.length;
        for (n3 = 0; n3 < n7; n3 += 2) {
            if (fArray[n3] == 0.0f && (fArray[n3 + 1] == 1.0f || fArray[n3 + 1] == 255.0f)) continue;
            bl = false;
            n3 = n7;
        }
        if (bl) {
            return;
        }
        if (n == 1) {
            n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                byArray[i] = ~byArray[i];
            }
        } else if (n == 8 && n6 > 1 && (n2 == 2 || n2 == 5 || n2 == 3)) {
            n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n8 = byArray[i] & 0xFF;
                if ((float)n8 < fArray[n3]) {
                    n8 = (int)fArray[n3];
                } else if ((float)n8 > fArray[n3 + 1]) {
                    n8 = (int)fArray[n3 + 1];
                }
                if ((n3 += 2) == fArray.length) {
                    n3 = 0;
                }
                byArray[i] = (byte)n8;
            }
        } else {
            n6 = n << 1;
            n3 = n6 - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 1;
                for (int j = 7; j > -1; --j) {
                    int n13 = by >> j & 1;
                    if ((n13 = (int)(fArray[n11] + (float)n13 * ((fArray[n12] - fArray[n11]) / (float)n3))) > n6) {
                        n13 = n6;
                    }
                    if (n13 < 0) {
                        n13 = 0;
                    }
                    n13 = (n13 & 1) << j;
                    n10 += n13;
                    if ((n9 += 2) == n4) {
                        n9 = 0;
                        n11 = 0;
                        n12 = 1;
                        continue;
                    }
                    n11 += 2;
                    n12 += 2;
                }
                byArray[i] = (byte)n10;
            }
        }
    }

    public void init(boolean bl, boolean bl2, int n, int n2, PdfPageData pdfPageData, int n3, DynamicVectorRenderer dynamicVectorRenderer, PdfObjectReader pdfObjectReader, Map map, Map map2) throws PdfException {
        if (dynamicVectorRenderer != null) {
            this.current = dynamicVectorRenderer;
        }
        this.pageNum = n3;
        this.pageData = pdfPageData;
        this.isPageContent = bl;
        this.currentPdfFile = pdfObjectReader;
        if (this.customImageHandler != null && dynamicVectorRenderer != null) {
            dynamicVectorRenderer.setCustomImageHandler(this.customImageHandler);
        }
        this.pageH = this.pageData.getMediaBoxHeight(n3);
        this.pageLines.setMaxWidth(this.pageData.getCropBoxWidth(n3) - this.pageData.getCropBoxX(n3), this.pageData.getCropBoxHeight(n3) - this.pageData.getCropBoxY(n3));
        this.textExtracted = (n2 & 1) == 1;
        this.renderPage = bl2;
        this.renderText = bl2 && (n & 1) == 1;
        this.renderImages = bl2 && (n & 2) == 2;
        this.clippedImagesExtracted = (n2 & 0x80) == 128;
        this.extractRawCMYK = this.clippedImagesExtracted;
        this.rawImagesExtracted = (n2 & 2) == 2;
        this.clippedImagesExtracted = (n2 & 0x20) == 32;
        this.finalImagesExtracted = (n2 & 4) == 4;
        this.xFormMetadata = (n2 & 0x100) == 256;
        this.textColorExtracted = (n2 & 0x40) == 64;
        boolean bl3 = this.colorExtracted = (n2 & 0x200) == 512;
        if (this.legacyTextMode && this.textExtracted && PdfDecoder.currentHeightLookupData == null) {
            PdfDecoder.currentHeightLookupData = new PdfHeightTable();
        }
        if (this.textColorExtracted) {
            this.pdfData.enableTextColorDataExtraction();
        }
        this.createScaledVersion = this.finalImagesExtracted | this.renderImages;
        this.currentFontData = new PdfFont(pdfObjectReader);
        this.strokeColorSpace = new DeviceRGBColorSpace();
        this.nonstrokeColorSpace = new DeviceRGBColorSpace();
        if (map != null) {
            this.readResources(true, map, true);
        }
        if (map2 != null) {
            this.readResources(true, map2, true);
        }
    }

    private final BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray) {
        int n4;
        Object object;
        boolean bl;
        LogWriter.writeMethod("{makeImage}", 0);
        ColorSpace colorSpace = genericColorSpace.getColorSpace();
        int n5 = genericColorSpace.getID();
        int n6 = colorSpace.getNumComponents();
        BufferedImage bufferedImage = null;
        byte[] byArray2 = genericColorSpace.getIndexedMap();
        this.optionsApplied = 0;
        boolean bl2 = (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isInverted(this.currentGraphicsState.CTM);
        boolean bl3 = bl = (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isRotated(this.currentGraphicsState.CTM);
        if (bl && bl2) {
            if (this.currentGraphicsState.CTM[0][1] > 0.0f && this.currentGraphicsState.CTM[1][0] < 0.0f) {
                bl2 = false;
                bl = false;
            } else if (this.currentGraphicsState.CTM[0][1] < 0.0f && this.currentGraphicsState.CTM[1][0] > 0.0f) {
                bl = false;
                bl2 = true;
            }
        }
        if (bl2 && bl) {
            object = ImageOps.rotateImage(byArray, n, n2, n3, n6, byArray2);
            if (object != null && (object = ImageOps.rotateImage(object, n = (n4 = n2), n2 = n, n3, n6, byArray2)) != null) {
                n4 = n2;
                n2 = n;
                n = n4;
            }
            if (object == null) {
                bl2 = false;
            } else {
                byArray = object;
                ++this.optionsApplied;
            }
        } else if (bl2) {
            object = ImageOps.invertImage(byArray, n, n2, n3, n6, byArray2);
            if (object == null) {
                bl2 = false;
            } else {
                byArray = object;
                ++this.optionsApplied;
            }
        }
        if (bl) {
            object = ImageOps.rotateImage(byArray, n, n2, n3, n6, byArray2);
            if (object == null) {
                bl = false;
            } else {
                byArray = object;
                this.optionsApplied += 2;
                n4 = n2;
                n2 = n;
                n = n4;
            }
        }
        object = new DataBufferByte(byArray, byArray.length);
        if (byArray2 != null) {
            if (n6 == 4) {
                n6 = 3;
            }
            byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
            n4 = genericColorSpace.getIndexSize() + 1;
            if (n3 == 4 && n4 > 16) {
                n4 = 16;
            }
            bufferedImage = this.convertIndexedToFlat(genericColorSpace.getID(), n3, n, n2, byArray, byArray2, n4, false);
        } else if (n3 == 1) {
            WritableRaster writableRaster = Raster.createPackedRaster((DataBuffer)object, n, n2, n3, null);
            bufferedImage = new BufferedImage(n, n2, 12);
            bufferedImage.setData(writableRaster);
        } else if (n5 == 10 | n5 == 11) {
            LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n5 == 6) {
            LogWriter.writeLog("Converting lab colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n6 == 4) {
            bufferedImage = n5 == 3 ? ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(byArray, n, n2) : ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray, colorSpace);
        } else if (n6 == 3) {
            if (n * n2 == byArray.length) {
                if (n3 == 8 && byArray2 != null) {
                    bufferedImage = this.convertIndexedToFlat(genericColorSpace.getID(), n3, n, n2, byArray, byArray2, byArray2.length, false);
                } else {
                    int[] nArray = new int[]{0};
                    bufferedImage = new BufferedImage(n, n2, 10);
                    WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n, 1, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
            } else {
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n6 == 1 && (n3 == 8 || n3 == 4)) {
            if (n3 == 4) {
                n4 = byArray.length;
                int n7 = n * n2;
                byte[] byArray3 = new byte[n7];
                int n8 = 0;
                int n9 = 0;
                boolean bl4 = (n & 1) == 1;
                for (int i = 0; i < n4; ++i) {
                    byte by = byArray[i];
                    byArray3[n8] = (byte)(by & 0xF0);
                    ++n8;
                    if (bl4 && (n9 += 2) > n) {
                        n9 = 0;
                    } else {
                        byArray3[n8] = (byte)((by & 0xF) << 4);
                        ++n8;
                    }
                    if (n8 != n7) continue;
                    i = n4;
                }
                object = new DataBufferByte(byArray3, byArray3.length);
            }
            bufferedImage = new BufferedImage(n, n2, 10);
            int[] nArray = new int[]{0};
            WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n, 1, nArray, null);
            bufferedImage.setData(writableRaster);
        } else {
            LogWriter.writeLog("Image " + colorSpace.getType() + " not currently supported with components " + n6);
        }
        return bufferedImage;
    }

    private BufferedImage convertIndexedToFlat(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int n5, boolean bl) {
        int[] nArray;
        int[] nArray2 = new int[]{0, 1, 2};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        int n6 = 3;
        int n7 = 0;
        if (bl) {
            nArray = nArray3;
            n6 = 4;
        } else {
            nArray = nArray2;
        }
        int n8 = n3 * n4 * n6;
        byte[] byArray3 = new byte[n8];
        if (n2 == 8) {
            for (int i = 0; i < byArray.length - 1; ++i) {
                int n9 = (byArray[i] & 0xFF) * 3;
                if (n7 < n8) {
                    byArray3[n7++] = byArray2[n9];
                    byArray3[n7++] = byArray2[n9 + 1];
                    byArray3[n7++] = byArray2[n9 + 2];
                    if (!bl) continue;
                    byArray3[n7++] = n9 == 0 ? -1 : 0;
                    continue;
                }
                break;
            }
        } else if (n2 == 4) {
            int[] nArray4 = new int[]{4, 0};
            int n10 = 0;
            block1: for (int i = 0; i < byArray.length; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n11 = (byArray[i] >> nArray4[j] & 0xF) * 3;
                    if (n7 >= n8) continue block1;
                    byArray3[n7++] = byArray2[n11];
                    byArray3[n7++] = byArray2[n11 + 1];
                    byArray3[n7++] = byArray2[n11 + 2];
                    if (bl) {
                        byArray3[n7++] = n11 == 0 ? (byte)0 : 0;
                    }
                    if (++n10 != n3) continue;
                    n10 = 0;
                    j = 8;
                }
            }
        } else if (n2 == 1) {
            int n12 = 0;
            block3: for (int i = 0; i < byArray.length - 1; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int n13 = (byArray[i] >> 7 - j & 1) * 3;
                    if (n7 >= n8) continue block3;
                    byArray3[n7++] = byArray2[n13];
                    byArray3[n7++] = byArray2[n13 + 1];
                    byArray3[n7++] = byArray2[n13 + 2];
                    if (bl) {
                        byArray3[n7++] = n13 == 0 ? -1 : 0;
                    }
                    if (++n12 != n3) continue;
                    n12 = 0;
                    j = 8;
                }
            }
        } else if (n2 == 2) {
            block5: for (int i = 0; i < byArray.length - 1; ++i) {
                for (int j = 0; j < 8; j += 2) {
                    int n14 = (byArray[i] & 3 << j >> j) * 3;
                    if (bl) {
                        byArray3[n7++] = n14 == 0 ? -1 : 0;
                    }
                    if (n7 >= n8) continue block5;
                    byArray3[n7++] = byArray2[n14];
                    byArray3[n7++] = byArray2[n14 + 1];
                    byArray3[n7++] = byArray2[n14 + 2];
                }
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
        BufferedImage bufferedImage = bl ? new BufferedImage(n3, n4, 2) : new BufferedImage(n3, n4, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * n6, n6, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private final void processXObjects(Map map, boolean bl) {
        LogWriter.writeMethod("{processXObjects}", 0);
        String string = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof Map) {
                if (bl) {
                    this.currentXObjectValues.put(string, v);
                    continue;
                }
                this.localXObjects.put(string, v);
                continue;
            }
            if (bl) {
                this.currentXObjectValues.put(string, v);
                continue;
            }
            this.localXObjects.put(string, v);
        }
    }

    private final void processPatterns(Map map) {
        LogWriter.writeMethod("{processPatterns}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.currentPatternValues.put(string, string2);
        }
    }

    private final void readFonts(boolean bl, Map map, boolean bl2) throws PdfException {
        LogWriter.writeMethod("{readFonts}", 0);
        Map map2 = new HashMap();
        String string = "";
        if (bl) {
            fontsInFile = "";
        }
        map.remove("PageNumber");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            PdfFont pdfFont;
            string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof String) {
                map2 = this.currentPdfFile != null ? this.currentPdfFile.readObject((String)map.get(string), false, null) : map;
            } else if (v instanceof Map) {
                map2 = (Map)v;
            }
            if ((pdfFont = this.createFont(map2, string, bl2)) == null) continue;
            this.fonts.put(string, pdfFont);
        }
    }

    private PdfFont createFont(Map map, String string, boolean bl) throws PdfException {
        LogWriter.writeMethod("{createFont}", 0);
        String string2 = "";
        String string3 = (String)map.get("Type");
        String string4 = null;
        if (string3 == null) {
            return null;
        }
        if (string3.equals("/Font")) {
            String string5;
            Object object;
            String string6;
            string2 = (String)map.get("Subtype");
            Map map2 = null;
            boolean bl2 = false;
            if (FontMappings.fontSubstitutionTable != null) {
                Map map3;
                string6 = null;
                object = map.get("DescendantFonts");
                if (object != null) {
                    map3 = this.readDescendantFontObject(object, map);
                    string6 = map3.get("FontDescriptor");
                } else {
                    string6 = map.get("FontDescriptor");
                }
                map3 = new HashMap();
                if (string6 instanceof Map) {
                    map3 = (Map)((Object)string6);
                } else if (string6 instanceof String) {
                    map3 = this.currentPdfFile.readObject(string6, false, null);
                }
                if (map3 != null) {
                    boolean bl3 = bl2 = map3.get("FontFile") != null || map3.get("FontFile2") != null || map3.get("FontFile3") != null;
                }
            }
            if (FontMappings.fontSubstitutionTable != null && !bl2 && bl) {
                String string7;
                int n;
                string6 = (String)map.get("BaseFont");
                if (string6 == null) {
                    string6 = (String)map.get("Name");
                }
                if (string6 == null) {
                    string6 = string;
                } else if (string6.startsWith("/")) {
                    string6 = string6.substring(1);
                }
                object = string6.toLowerCase();
                if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                if ((n = ((String)object).indexOf(43)) == 6) {
                    object = ((String)object).substring(7);
                }
                if ((string7 = (String)FontMappings.fontSubstitutionTable.get(string5 = ((String)object).toLowerCase())) == null) {
                    String string8;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    while ((string8 = (String)FontMappings.fontSubstitutionAliasTable.get(string5)) != null) {
                        string5 = string8;
                        if (hashMap.containsKey(string5)) {
                            StringBuffer stringBuffer = new StringBuffer("[PDF] Circular font mapping for fonts");
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                stringBuffer.append(' ');
                                stringBuffer.append(iterator.next());
                            }
                            throw new PdfException(stringBuffer.toString());
                        }
                        hashMap.put(string8, "x");
                    }
                    if (string5 != null) {
                        string7 = (String)FontMappings.fontSubstitutionTable.get(string5);
                    }
                }
                if (string7 != null) {
                    string2 = string7;
                    string4 = (String)FontMappings.fontSubstitutionLocation.get(string5);
                } else if (PdfDecoder.enforceFontSubstitution) {
                    LogWriter.writeLog("baseFont=" + (String)object + " fonts added= " + FontMappings.fontSubstitutionTable);
                    throw new PdfFontException("No substitute Font found for " + (String)object);
                }
            }
            int n = 0;
            object = null;
            boolean bl4 = false;
            if (string2.equals("/Type1") || string2.equals("/Type1C") || string2.equals("/MMType1")) {
                n = 1;
            } else if (string2.equals("/TrueType")) {
                n = 2;
            } else if (string2.equals("/Type3")) {
                n = 3;
            } else if (string2.equals("/Type0")) {
                bl4 = true;
                string5 = map.get("DescendantFonts");
                if (string5 == null) {
                    LogWriter.writeLog("[PDF] No Descender font for CID font");
                } else {
                    map2 = this.readDescendantFontObject(string5, map);
                    string2 = (String)map2.get("Subtype");
                    n = string2.equals("/CIDFontType0") ? 4 : 5;
                }
            } else {
                LogWriter.writeLog("Font type " + string2 + " not supported");
                this.currentFontData = new PdfFont(this.currentPdfFile);
            }
            try {
                this.currentFontData = FontFactory.createFont(this.currentGraphicsState, string2, n, this.currentPdfFile, string4);
                if (PdfDecoder.defaultFont != null) {
                    this.currentFontData.setDefaultDisplayFont(PdfDecoder.defaultFont);
                }
                this.currentFontData.createFont(map, string, this.renderPage, map2, this.objectStoreStreamRef);
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + string2 + " in " + this.fileName);
                this.addPageFailureMessage("Problem " + exception + " reading Font type " + string2 + " in " + this.fileName);
            }
            if (fontsInFile == null) {
                fontsInFile = "";
            }
            if (this.currentFontData.isFontSubstituted()) {
                fontsInFile = string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + "  Substituted (" + string4 + ' ' + string2 + ")\n" + fontsInFile;
            } else if (this.currentFontData.isFontEmbedded) {
                this.hasEmbeddedFonts = true;
                fontsInFile = this.currentFontData.is1C() ? string + "  " + this.currentFontData.getFontName() + " Type1C  Embedded\n" + fontsInFile : string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + "  Embedded\n" + fontsInFile;
            } else {
                fontsInFile = string + "  " + this.currentFontData.getFontName() + "  " + string2.substring(1) + '\n' + fontsInFile;
            }
        } else {
            LogWriter.writeLog("Not a font object");
        }
        return this.currentFontData;
    }

    private Map readDescendantFontObject(Object object, Map map) {
        Map map2;
        LogWriter.writeMethod("{readDescendantFontObject}" + object + ' ' + map, 0);
        if (object instanceof String) {
            String string = (String)map.get("DescendantFonts");
            if (string.startsWith("[")) {
                string = Strip.removeArrayDeleminators(string);
            }
            map2 = string.indexOf("<<") != -1 ? this.currentPdfFile.directValuesToMap(string, false) : this.currentPdfFile.readObject(string, false, null);
        } else {
            map2 = (Map)((Map)object).get("rawValue");
        }
        String string = (String)map2.get("rawValue");
        if (string != null) {
            map2 = this.currentPdfFile.readObject(Strip.removeArrayDeleminators(string), false, null);
        }
        return map2;
    }

    public final void readResources(boolean bl, Map map, boolean bl2) throws PdfException {
        Map map2;
        LogWriter.writeMethod("{readResources}", 0);
        Object v = map.get("ColorSpace");
        if (v != null && (map2 = this.currentPdfFile.getSubDictionary(v)) != null) {
            this.readColorSpaceSettings(map2);
        }
        if ((v = map.get("Font")) != null && (map2 = this.currentPdfFile.getSubDictionary(v)) != null) {
            this.readFonts(bl, map2, true);
        }
        if ((v = map.get("XObject")) != null && (map2 = this.currentPdfFile.getSubDictionary(v)) != null) {
            this.processXObjects(map2, bl2);
        }
        try {
            v = map.get("Shading");
            if (v != null && (map2 = this.currentPdfFile.getSubDictionary(v)) != null) {
                this.readShadingSettings(map2);
            }
            if ((v = map.get("Pattern")) != null && (map2 = this.currentPdfFile.getSubDictionary(v)) != null) {
                this.processPatterns(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        v = map.get("ExtGState");
        if (v != null) {
            try {
                map2 = this.currentPdfFile.getSubDictionary(v);
                if (map2 != null) {
                    this.readGraphicsState(map2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void readResourcesForForm(Map map) throws PdfException {
        LogWriter.writeMethod("{readResourcesForForm}", 0);
        Map map2 = (Map)map.get("ColorSpace");
        if (map2 != null) {
            this.readColorSpaceSettings(map2);
        }
        if ((map2 = (Map)map.get("Font")) != null) {
            this.readFonts(false, map2, false);
        }
        if ((map2 = (Map)map.get("XObject")) != null) {
            this.processXObjects(map2, true);
        }
        try {
            map2 = (Map)map.get("Shading");
            if (map2 != null) {
                this.readShadingSettings(map2);
            }
            if ((map2 = (Map)map.get("Pattern")) != null) {
                this.processPatterns(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            map2 = this.currentPdfFile.getSubDictionary(map.get("ExtGState"));
            if (map2 != null) {
                this.readGraphicsState(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void readColorSpaceSettings(Map map) {
        LogWriter.writeMethod("{readColorSpaces}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.rawColorspaceValues.put(string, string2);
        }
    }

    private Object getObjectFromCache(Map map, Map map2, String string) {
        Object object = map.get(string);
        if (object == null) {
            String string2 = (String)map2.get(string);
            object = string2 != null && string2.endsWith(" R") ? this.currentPdfFile.readObject(string2, false, null) : string2;
            map.put(string2, object);
        }
        return object;
    }

    private final void readShadingSettings(Map map) {
        LogWriter.writeMethod("{readShadingSettings}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = map.get(string);
            Map map2 = string2 instanceof String && string2.toString().endsWith(" R") ? this.currentPdfFile.readObject(string2, false, null) : (Map)((Object)string2);
            this.rawShadingValues.put(string, map2);
        }
    }

    public final T3Size decodePageContent(String string, int n, int n2, GraphicsState graphicsState) throws PdfException {
        byte[] byArray;
        LogWriter.writeMethod("{decodePageContent " + string + '}', 0);
        this.requestExit = false;
        this.exited = false;
        this.imagesProcessedFully = true;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
        }
        this.currentGraphicsState = graphicsState != null ? graphicsState : new GraphicsState(n, n2);
        if (this.renderPage) {
            if (this.current == null) {
                throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
            }
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
            }
        }
        if ((byArray = this.readPageIntoStream(string)).length > 0) {
            this.decodeStreamIntoObjects(byArray);
        }
        if (this.requestExit) {
            this.current.flush();
            this.exited = true;
        }
        T3Size t3Size = new T3Size();
        t3Size.x = this.T3maxWidth;
        t3Size.y = this.T3maxHeight;
        return t3Size;
    }

    public final void decodeStreamIntoObjects(byte[] byArray) {
        int n;
        LogWriter.writeMethod("{decodeStreamIntoObjects}", 0);
        int n2 = prefixes.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        if (this.requestExit) {
            this.exited = true;
            return;
        }
        int n6 = n = byArray.length;
        int n7 = 255;
        int n8 = 0;
        int n9 = 0;
        if (byArray.length == 0) {
            return;
        }
        int n10 = 0;
        int n11 = byArray[0];
        int n12 = -1;
        do {
            int n13;
            int n14;
            int n15;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 100 * n8 / n;
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            n10 = n11;
            if (n10 == 13 || n10 == 10 || n10 == 32) {
                ++n8;
                while (n8 != n6 && ((n10 = byArray[n8]) == 13 || n10 == 10 || n10 == 32)) {
                    ++n8;
                }
            }
            if (n8 == n6) break;
            boolean bl = false;
            int n16 = 0;
            n16 = n10 == 60 && byArray[n8 + 1] == 60 ? 1 : (n10 == 91 ? 2 : (n10 >= 97 && n10 <= 122 ? 3 : (n10 >= 65 && n10 <= 90 ? 3 : (n10 == 39 || n10 == 34 ? 3 : (n10 == 32 ? 4 : 0)))));
            if (n16 == 3) {
                n3 = n8;
                while (++n8 != n5 && (n10 = byArray[n8]) != 13 && n10 != 10 && n10 != 32 && n10 != 40 && n10 != 47 && n10 != 91) {
                }
                n4 = n8 - 1;
                n15 = byArray[n4];
                if (n15 == 47 || n15 == 91) {
                    --n4;
                }
                n12 = -1;
                if (n4 - n3 < 3) {
                    n14 = 0;
                    n13 = 0;
                    for (int i = n4; i > n3 - 1; --i) {
                        n14 += byArray[i] << n13;
                        n13 += 8;
                    }
                    n12 = Cmd.getCommandID(n14);
                }
                if (n12 == -1) {
                    this.opStart[this.currentOp] = n3;
                    this.opEnd[this.currentOp] = n4;
                    ++this.currentOp;
                    if (this.currentOp == 50) {
                        this.currentOp = 0;
                    }
                    ++this.operandCount;
                } else {
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    try {
                        n9 = n8 = this.processToken(n12, byArray, n9, n8);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] " + exception);
                        LogWriter.writeLog("Processing token >" + Cmd.getCommandAsString(n12) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.addPageFailureMessage("Memory error decoding token stream");
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                }
            } else if (n16 != 4) {
                n3 = n8;
                if (n16 == 1 || n16 == 2) {
                    n15 = 0;
                    bl = true;
                    n14 = 32;
                    do {
                        n14 = n14 == 92 && n10 == 92 ? 120 : n10;
                        if (++n8 == n5) break;
                        n10 = byArray[n8];
                        if (n10 == 13 || n10 == 10) {
                            n10 = 32;
                        }
                        n13 = 0;
                        if (n10 == 62 && n14 == 62 && n16 == 1) {
                            n13 = 1;
                        }
                        if (n16 != 2) continue;
                        if (n10 == 40 && n14 != 92) {
                            n15 = 1;
                        } else if (n10 == 41 && n14 != 92) {
                            n15 = 0;
                        }
                        if (n15 != 0 || n10 != 93 || n14 == 92) continue;
                        n13 = 1;
                    } while (n13 == 0);
                    n4 = n8;
                }
                if (!bl) {
                    n15 = 32;
                    for (n14 = 0; n14 < n2; ++n14) {
                        if (n10 != prefixes[n14]) continue;
                        bl = true;
                        n3 = n8;
                        n13 = 0;
                        while (true) {
                            n15 = n15 == 92 && n10 == 92 ? 120 : n10;
                            if (++n8 == n5) break;
                            n10 = byArray[n8];
                            if (n10 == 13 | n10 == 10) {
                                n10 = 32;
                            }
                            if (n10 == prefixes[n14] && n15 != 92) {
                                ++n13;
                            }
                            if (n10 != suffixes[n14] || n15 == 92) continue;
                            if (n13 == 0) break;
                            --n13;
                        }
                        n14 = n2;
                    }
                    n4 = n8;
                }
                if (!bl) {
                    n3 = n8;
                    while (++n8 != n5 && (n10 = byArray[n8]) != 13 && n10 != 10 && n10 != 32 && n10 != 40 && n10 != 47 && n10 != 91) {
                    }
                    n4 = n8;
                }
                if (n4 >= byArray.length || (n15 = byArray[n4]) == 47 || n15 == 91) {
                    // empty if block
                }
                this.opStart[this.currentOp] = n3;
                this.opEnd[this.currentOp] = --n4;
                ++this.currentOp;
                if (this.currentOp == 50) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
            if (n8 >= n6 || (n11 = byArray[n8]) == 47 || n11 == 40 || n11 == 91 || ++n8 >= n6) continue;
            n11 = byArray[n8];
        } while (n6 > n8);
    }

    private final void d1(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ignoreColors = true;
        this.T3maxWidth = (int)f3;
        this.T3maxWidth = f3 == 0.0f ? (int)(f2 - f) : (int)f3;
        this.T3maxHeight = (int)f6;
        this.T3maxHeight = f6 == 0.0f ? (int)(f4 - f5) : (int)f6;
    }

    private final void d0(int n, int n2) {
        this.ignoreColors = false;
        this.T3maxWidth = n;
        this.T3maxHeight = n2;
    }

    private final void TD(boolean bl, float f, float f2) {
        this.relativeMove(f, f2);
        if (!bl) {
            float f3 = -f2;
            this.currentTextState.setLeading(f3);
        }
        this.multipleTJs = false;
    }

    private final byte[] readPageIntoStream(String string) {
        Object object;
        LogWriter.writeMethod("{readPageIntoStream}", 0);
        byte[] byArray = new byte[]{};
        byte[] byArray2 = null;
        this.currentTextState = new TextState();
        if (string != null && !string.startsWith("[")) {
            object = this.currentPdfFile.readObject(string, false, null);
            byArray2 = this.currentPdfFile.readStream((Map)object, string, true, true, false, false);
            if (byArray2 == null) {
                string = (String)object.get("rawValue");
            } else {
                byArray = byArray2;
            }
        }
        if (string != null && byArray2 == null) {
            String string2;
            string = Strip.removeArrayDeleminators(string).trim();
            object = new StringTokenizer(string, "R");
            while (((StringTokenizer)object).hasMoreTokens() && (string2 = ((StringTokenizer)object).nextToken().trim()).length() != 0) {
                byArray2 = this.currentPdfFile.readStream(string2 + " R", true);
                if (byArray2 == null) continue;
                int n = byArray.length + 1;
                int n2 = byArray2.length;
                if (n2 <= 0) continue;
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    private String generateOpAsString(int n, byte[] byArray) {
        String string = "";
        int n2 = this.opStart[n];
        int n3 = this.opEnd[n];
        while (byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10) {
            --n3;
        }
        int n4 = n3 - n2 + 1;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i <= 0 || byArray[n2 + i] != 32 && byArray[n2 + i] != 13 && byArray[n2 + i] != 10 || byArray[n2 + i - 1] != 32 && byArray[n2 + i - 1] != 13 && byArray[n2 + i - 1] != 10) continue;
            ++n5;
        }
        char[] cArray = new char[n4 - n5];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i > 0 && (byArray[n2 + i] == 32 || byArray[n2 + i] == 13 || byArray[n2 + i] == 10) && (byArray[n2 + i - 1] == 32 || byArray[n2 + i - 1] == 13 || byArray[n2 + i - 1] == 10)) continue;
            cArray[n6] = byArray[n2 + i] == 10 || byArray[n2 + i] == 13 ? 32 : (char)byArray[n2 + i];
            ++n6;
        }
        string = String.copyValueOf(cArray);
        return string;
    }

    private final void BT() {
        this.currentTextState.resetTm();
        this.currentTextState.setTMAtLineStart();
        this.currentFont = this.currentTextState.getFontName();
        this.currentTextState.setCurrentFontSize(0);
        this.lastFontSize = -1;
        if (this.renderPage) {
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
                this.current.drawTR(2);
            }
        }
    }

    private final void restoreGraphicsState() {
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else {
            this.currentGraphicsState = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            this.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            this.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            Object object = this.clipStack.pull();
            if (object == null) {
                this.currentGraphicsState.setClippingShape(null);
            } else {
                this.currentGraphicsState.setClippingShape((Area)object);
            }
            if (this.renderPage) {
                if (this.renderDirectly) {
                    this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.currentGraphicsState);
                    this.current.resetOnColorspaceChange();
                    this.current.drawFillColor(this.currentGraphicsState.getNonstrokeColor());
                    this.current.drawStrokeColor(this.currentGraphicsState.getStrokeColor());
                    this.current.setGraphicsState(2, this.currentGraphicsState.getNonStrokeAlpha());
                    this.current.setGraphicsState(1, this.currentGraphicsState.getStrokeAlpha());
                }
            }
        }
    }

    private final void L(float f, float f2) {
        this.currentDrawShape.lineTo(f, f2);
    }

    private final void F(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.currentDrawShape.closeShape();
        Shape shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.getClippingShape(), this.currentGraphicsState.CTM, this.isClip, this.pageLines, true, this.nonstrokeColorSpace.getColor(), this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.renderPage && shape != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(2);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void TC(float f) {
        this.currentTextState.setCharacterSpacing(f);
    }

    private final void CM(float[][] fArray) {
        this.currentGraphicsState.CTM = Matrix.multiply(fArray, this.currentGraphicsState.CTM);
        this.multipleTJs = false;
    }

    protected final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(fArray, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
        this.moveCommand = 2;
    }

    private final void S(boolean bl) {
        Shape shape;
        if (bl) {
            this.currentDrawShape.closeShape();
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, this.isClip, this.pageLines, false, null, this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1))) != null) {
            if (shape.getBounds().getWidth() <= 1.0) {
                shape = shape.getBounds2D();
            }
            if (this.renderPage) {
                this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
                this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
                this.currentGraphicsState.setFillType(1);
                if (this.renderDirectly) {
                    this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
                } else {
                    this.current.drawShape(shape, this.currentGraphicsState);
                }
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void I() {
    }

    private final void D(byte[] byArray) {
        String string = "";
        int n = this.operandCount;
        if (n == 1) {
            string = this.generateOpAsString(0, byArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n - 1; i > -1; --i) {
                stringBuffer.append(this.generateOpAsString(i, byArray));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        if (string.equals("[ ] 0 ") | string.equals("[]0") | string.equals("[] 0 ")) {
            this.currentGraphicsState.setDashPhase(0);
            this.currentGraphicsState.setDashArray(new float[0]);
        } else {
            int n2 = string.indexOf(93);
            String string2 = string.substring(0, n2);
            int n3 = (int)Float.parseFloat(string.substring(n2 + 1, string.length()).trim());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[ ]");
            int n4 = stringTokenizer.countTokens();
            float[] fArray = new float[n4];
            for (int i = 0; i < n4; ++i) {
                fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
            this.currentGraphicsState.setDashArray(fArray);
            this.currentGraphicsState.setDashPhase(n3);
        }
    }

    private final void SCN(boolean bl, byte[] byArray) {
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl) {
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private final void B(boolean bl, boolean bl2) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        if (bl2) {
            this.currentDrawShape.closeShape();
        }
        Shape shape = this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, this.isClip, this.pageLines, false, null, this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.renderPage && shape != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(3);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void mm(int n) {
        this.currentGraphicsState.setMitreLimit(n);
    }

    private final void M(float f, float f2) {
        this.currentDrawShape.moveTo(f, f2);
    }

    private final void J(boolean bl, int n) {
        int n2 = 0;
        if (!bl) {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setJoinStyle(n2);
        } else {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setCapStyle(n2);
        }
    }

    private final void RG(boolean bl, byte[] byArray) {
        this.current.resetOnColorspaceChange();
        boolean bl2 = !bl;
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl2) {
            if (this.strokeColorSpace.getID() != 2) {
                this.strokeColorSpace = new DeviceRGBColorSpace();
            }
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 2) {
                this.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private final void Y(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveY(f3, f4, f, f2);
    }

    private final void TZ(float f) {
        this.currentTextState.setHorizontalScaling(f / 100.0f);
    }

    private final void RE(float f, float f2, float f3, float f4) {
        this.currentDrawShape.appendRectangle(f, f2, f3, f4);
    }

    private final void ET() {
        this.current.resetOnColorspaceChange();
    }

    private final void pushGraphicsState() {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.clipStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(this.currentGraphicsState.clone());
        Area area = this.currentGraphicsState.getClippingShape();
        if (area == null) {
            this.clipStack.push(null);
        } else {
            this.clipStack.push(area.clone());
        }
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(this.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(this.strokeColorSpace.clone());
        this.current.resetOnColorspaceChange();
    }

    private final void MP() {
        if (this.markedContentExtracted) {
            this.contentHandler.MP();
        }
    }

    private final void DP(int n, int n2, byte[] byArray, String string) {
        if (this.markedContentExtracted) {
            Map map = new HashMap();
            if (string.endsWith(" R")) {
                map = this.currentPdfFile.readObject(string, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, map, n - 1, byArray, false, new HashMap(), n2);
            }
            this.contentHandler.DP(map);
        }
    }

    private final void EMC() {
        if (this.markedContentExtracted) {
            this.contentHandler.EMC();
        }
    }

    private final void TJ(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = this.processTextArray(byArray, n, n2);
        if (stringBuffer != null && this.isPageContent) {
            if (!this.markedContentExtracted) {
                if (this.textColorExtracted) {
                    this.currentColor = (this.currentGraphicsState.getTextRenderType() & 2) == 2 ? this.nonstrokeColorSpace.getXMLColorToken() : this.strokeColorSpace.getXMLColorToken();
                }
                if (this.textExtracted) {
                    this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2, this.y2, this.moveCommand, stringBuffer, this.tokenNumber, this.textLength, this.currentColor);
                }
            } else {
                this.contentHandler.setText(stringBuffer, this.x1, this.y1, this.x2, this.y2);
            }
        }
        this.moveCommand = -1;
    }

    private final void G(boolean bl, byte[] byArray) {
        this.current.resetOnColorspaceChange();
        boolean bl2 = !bl;
        String[] stringArray = this.getValues(this.operandCount, byArray);
        if (bl2) {
            if (this.strokeColorSpace.getID() != 1) {
                this.strokeColorSpace = new DeviceGrayColorSpace();
            }
            this.strokeColorSpace.setColor(stringArray, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1) {
                this.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
        }
    }

    private void TL(float f) {
        this.currentTextState.setLeading(f);
    }

    public void readGraphicsState(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            Map map2 = v instanceof String ? this.currentPdfFile.readObject((String)v, false, null) : (Map)v;
            this.gs_state.put('/' + string, map2);
        }
    }

    private void BDC(int n, int n2, byte[] byArray, String string) {
        if (this.markedContentExtracted) {
            Map map = new HashMap();
            if (string.endsWith(" R")) {
                map = this.currentPdfFile.readObject(string, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, map, n - 1, byArray, false, new HashMap(), n2);
            }
            this.contentHandler.BDC(map);
        }
    }

    private void BMC(String string) {
        if (this.markedContentExtracted) {
            this.contentHandler.BMC(string);
        }
    }

    final float parseFloat(int n, byte[] byArray) {
        int n2;
        int n3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = this.opStart[n];
        int n5 = n3 = this.opEnd[n] - n4;
        int n6 = 0;
        boolean bl = false;
        for (n2 = n3 - 1; n2 > -1; --n2) {
            if (byArray[n4 + n2] != 46) continue;
            n5 = n2;
            break;
        }
        n2 = n5;
        if (byArray[n4] == 43) {
            --n2;
            ++n6;
        } else if (byArray[n4] == 45) {
            ++n6;
            bl = true;
        }
        int n7 = n2 - n6;
        int n8 = n3 - n5;
        if (n7 > 3) {
            bl = false;
            f = Float.parseFloat(this.generateOpAsString(n, byArray));
        } else {
            int n9;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            if (n7 > 2) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f6 = 100.0f;
                        break;
                    }
                    case 2: {
                        f6 = 200.0f;
                        break;
                    }
                    case 3: {
                        f6 = 300.0f;
                        break;
                    }
                    case 4: {
                        f6 = 400.0f;
                        break;
                    }
                    case 5: {
                        f6 = 500.0f;
                        break;
                    }
                    case 6: {
                        f6 = 600.0f;
                        break;
                    }
                    case 7: {
                        f6 = 700.0f;
                        break;
                    }
                    case 8: {
                        f6 = 800.0f;
                        break;
                    }
                    case 9: {
                        f6 = 900.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 1) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f5 = 10.0f;
                        break;
                    }
                    case 2: {
                        f5 = 20.0f;
                        break;
                    }
                    case 3: {
                        f5 = 30.0f;
                        break;
                    }
                    case 4: {
                        f5 = 40.0f;
                        break;
                    }
                    case 5: {
                        f5 = 50.0f;
                        break;
                    }
                    case 6: {
                        f5 = 60.0f;
                        break;
                    }
                    case 7: {
                        f5 = 70.0f;
                        break;
                    }
                    case 8: {
                        f5 = 80.0f;
                        break;
                    }
                    case 9: {
                        f5 = 90.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 0) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f4 = 1.0f;
                        break;
                    }
                    case 2: {
                        f4 = 2.0f;
                        break;
                    }
                    case 3: {
                        f4 = 3.0f;
                        break;
                    }
                    case 4: {
                        f4 = 4.0f;
                        break;
                    }
                    case 5: {
                        f4 = 5.0f;
                        break;
                    }
                    case 6: {
                        f4 = 6.0f;
                        break;
                    }
                    case 7: {
                        f4 = 7.0f;
                        break;
                    }
                    case 8: {
                        f4 = 8.0f;
                        break;
                    }
                    case 9: {
                        f4 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f7 = 0.1f;
                        break;
                    }
                    case 2: {
                        f7 = 0.2f;
                        break;
                    }
                    case 3: {
                        f7 = 0.3f;
                        break;
                    }
                    case 4: {
                        f7 = 0.4f;
                        break;
                    }
                    case 5: {
                        f7 = 0.5f;
                        break;
                    }
                    case 6: {
                        f7 = 0.6f;
                        break;
                    }
                    case 7: {
                        f7 = 0.7f;
                        break;
                    }
                    case 8: {
                        f7 = 0.8f;
                        break;
                    }
                    case 9: {
                        f7 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f8 = 0.01f;
                        break;
                    }
                    case 2: {
                        f8 = 0.02f;
                        break;
                    }
                    case 3: {
                        f8 = 0.03f;
                        break;
                    }
                    case 4: {
                        f8 = 0.04f;
                        break;
                    }
                    case 5: {
                        f8 = 0.05f;
                        break;
                    }
                    case 6: {
                        f8 = 0.06f;
                        break;
                    }
                    case 7: {
                        f8 = 0.07f;
                        break;
                    }
                    case 8: {
                        f8 = 0.08f;
                        break;
                    }
                    case 9: {
                        f8 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f9 = 0.001f;
                        break;
                    }
                    case 2: {
                        f9 = 0.002f;
                        break;
                    }
                    case 3: {
                        f9 = 0.003f;
                        break;
                    }
                    case 4: {
                        f9 = 0.004f;
                        break;
                    }
                    case 5: {
                        f9 = 0.005f;
                        break;
                    }
                    case 6: {
                        f9 = 0.006f;
                        break;
                    }
                    case 7: {
                        f9 = 0.007f;
                        break;
                    }
                    case 8: {
                        f9 = 0.008f;
                        break;
                    }
                    case 9: {
                        f9 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f10 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f10 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f10 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f10 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f10 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f10 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f10 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f10 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f10 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f11 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f11 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f11 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f11 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f11 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f11 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f11 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f11 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f11 = 9.0E-5f;
                    }
                }
            }
            f2 = f7 + f8 + f9 + f10 + f11;
            f3 = f6 + f5 + f4;
            f = f3 + f2;
        }
        if (bl) {
            return -f;
        }
        return f;
    }

    private final void TM() {
        this.currentTextState.setTMAtLineStart();
        this.multipleTJs = false;
        this.moveCommand = 1;
    }

    private final void H() {
        this.currentDrawShape.closeShape();
    }

    private final void TR(int n) {
        if (n == 0) {
            n = 2;
        } else if (n == 1) {
            n = 1;
        } else if (n == 2) {
            n = 3;
        } else if (n == 3) {
            n = 4;
            if (showInvisibleText) {
                n = 2;
            }
        } else if (n == 7) {
            n = 7;
        }
        this.currentGraphicsState.setTextRenderType(n);
        if (this.renderPage && !this.renderDirectly) {
            this.current.drawTR(n);
        }
    }

    private final void Q(boolean bl) {
        if (bl) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
            String string = this.currentTextState.getFontID();
            Object v = this.fonts.get(string);
            if (v != null) {
                this.currentFontData = (PdfFont)v;
            }
        }
    }

    private final int ID(byte[] byArray, int n) throws Exception {
        this.isMask = false;
        BufferedImage bufferedImage = null;
        boolean bl = this.customImageHandler != null;
        String string = null;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "/DeviceRGB";
        int n2 = n + 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = byArray.length;
        while ((n7 - n6 <= 3 || byArray[n6] != 32 && byArray[n6] != 10 && byArray[n6] != 13 || byArray[n6 + 1] != 69 || byArray[n6 + 2] != 73 || byArray[n6 + 3] != 32 && byArray[n6 + 3] != 10 && byArray[n6 + 3] != 13) && ++n6 != n7) {
        }
        if (this.renderImages | this.finalImagesExtracted | this.clippedImagesExtracted | this.rawImagesExtracted) {
            String string4;
            Cloneable cloneable;
            Object object;
            int n8;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.operandCount > 0) {
                int n9;
                String[] stringArray = new String[50];
                object2 = new int[50];
                int[] nArray = new int[50];
                n8 = 0;
                for (n9 = this.currentOp - 1; n9 > -1; --n9) {
                    object2[n8] = this.opStart[n9];
                    nArray[n8] = this.opEnd[n9];
                    if (n8 == this.operandCount) {
                        n9 = -1;
                    }
                    ++n8;
                }
                if (n8 == this.operandCount) {
                    --this.currentOp;
                    for (n9 = 50 - 1; n9 > this.currentOp; --n9) {
                        object2[n8] = this.opStart[n9];
                        nArray[n8] = this.opEnd[n9];
                        if (n8 == this.operandCount) {
                            n9 = this.currentOp;
                        }
                        ++n8;
                    }
                    ++this.currentOp;
                }
                this.opStart = (int[])object2;
                this.opEnd = nArray;
            }
            int n10 = this.operandCount;
            object2 = new StringBuffer();
            for (int i = 0; i < n10; ++i) {
                n8 = this.generateOpAsString(i, byArray).indexOf("<<");
                if (n8 > 0) {
                    ((StringBuffer)object2).append(this.generateOpAsString(i, byArray).substring(0, n8));
                    ((StringBuffer)object2).append(' ');
                    ((StringBuffer)object2).append(this.generateOpAsString(i, byArray).substring(n8));
                } else {
                    n8 = this.generateOpAsString(i, byArray).indexOf(">>");
                    if (n8 != -1 && this.generateOpAsString(i, byArray).indexOf(" >>") == -1) {
                        ((StringBuffer)object2).append(this.generateOpAsString(i, byArray).substring(0, n8));
                        ((StringBuffer)object2).append(' ');
                        ((StringBuffer)object2).append(this.generateOpAsString(i, byArray).substring(n8));
                    } else {
                        ((StringBuffer)object2).append(this.generateOpAsString(i, byArray));
                    }
                }
                ((StringBuffer)object2).append(' ');
            }
            StringTokenizer stringTokenizer = new StringTokenizer(((StringBuffer)object2).toString().trim(), "[]/ ", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5.equals("/")) {
                    arrayList.add(string5 + stringTokenizer.nextToken());
                    continue;
                }
                if (string5.equals("[")) {
                    while (string5.indexOf(93) == -1) {
                        String string6 = stringTokenizer.nextToken();
                        if (string6.equals("/")) {
                            string5 = string5 + ' ' + string6;
                            continue;
                        }
                        string5 = string5 + string6;
                    }
                    arrayList.add(string5);
                    continue;
                }
                if (string5.equals(" ")) continue;
                arrayList.add(string5);
            }
            ArrayList<String> arrayList2 = arrayList;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            n10 = arrayList2.size();
            for (int i = 0; i < n10; ++i) {
                String string7 = (String)arrayList2.get(i);
                if (string7.equals("/W") || string7.equals("/Width")) {
                    n3 = Integer.parseInt((String)arrayList2.get(++i));
                    if (!bl) continue;
                    hashtable.put("Width", arrayList2.get(i));
                    continue;
                }
                if (string7.equals("/IM")) {
                    if (((String)arrayList2.get(++i)).indexOf("true") != -1) {
                        bl2 = true;
                        this.isMask = true;
                    }
                    if (!bl) continue;
                    hashtable.put("ImageMask", arrayList2.get(i));
                    continue;
                }
                if (string7.equals("/D") || string7.equals("/Decode")) {
                    string2 = (String)arrayList2.get(++i);
                    if (!bl) continue;
                    hashtable.put("Decode", arrayList2.get(i));
                    continue;
                }
                if (string7.equals("/H") || string7.equals("/Height")) {
                    n4 = Integer.parseInt((String)arrayList2.get(++i));
                    if (!bl) continue;
                    hashtable.put("Height", arrayList2.get(i));
                    continue;
                }
                if (string7.equals("/BPC") || string7.equals("/BitsPerComponent")) {
                    n5 = Integer.parseInt((String)arrayList2.get(++i));
                    if (!bl) continue;
                    hashtable.put("BitsPerComponent", arrayList2.get(i));
                    continue;
                }
                if (string7.equals("/CS") || string7.equals("/ColorSpace")) {
                    if ((string3 = (String)arrayList2.get(++i)).startsWith("[")) {
                        while (!string3.endsWith("]")) {
                            string3 = string3 + arrayList2.get(i);
                            ++i;
                        }
                        string3 = Strip.removeArrayDeleminators(string3);
                    }
                    if (!bl) continue;
                    hashtable.put("ColorSpace", string3);
                    continue;
                }
                if (string7.equals("/F") || string7.equals("/Filter")) {
                    string = "";
                    if ((string = (String)arrayList2.get(++i)).indexOf(91) != -1) {
                        while (string.indexOf(93) == -1) {
                            object = (String)arrayList2.get(++i);
                            string = string + ' ' + (String)object;
                        }
                        string = Strip.removeArrayDeleminators(string);
                    }
                    if (!bl) continue;
                    hashtable.put("Filter", string);
                    continue;
                }
                if (!string7.equals("/DP") && !string7.equals("/DecodeParms")) continue;
                object = (String)arrayList2.get(++i);
                cloneable = new Hashtable();
                if (((String)object).startsWith("[")) {
                    while (((String)object).indexOf(93) == -1) {
                        object = (String)object + ' ' + arrayList2.get(++i);
                    }
                    hashtable.put("DecodeParms", object);
                }
                if (!((String)object).startsWith("<<")) continue;
                ++i;
                while (!(string4 = (String)arrayList2.get(i)).equals(">>")) {
                    if (string4.startsWith("/")) {
                        cloneable.put(string4.substring(1), arrayList2.get(i + 1));
                        ++i;
                    }
                    ++i;
                }
                hashtable.put("DecodeParms", cloneable);
            }
            String string8 = string;
            String string9 = this.fileName + "-IN-" + this.tokenNumber;
            object = new byte[n6 - n2];
            System.arraycopy(byArray, n2, object, 0, n6 - n2);
            if (this.customImageHandler != null) {
                hashtable.put("Stream", object);
                bufferedImage = this.customImageHandler.processImageData(hashtable, this.currentGraphicsState);
            }
            if (string8 != null && !string8.startsWith("/JPXDecode") && !string8.startsWith("/DCT")) {
                object = this.currentPdfFile.decodeFilters((byte[])object, string8, hashtable, n3, n4, false, null);
            }
            cloneable = new GenericColorSpace();
            if (string3 != null) {
                Object object3;
                string4 = null;
                if (string3.startsWith("/")) {
                    string4 = string3.substring(1);
                }
                cloneable = (object3 = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, string4)) == null ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string3, null, this.currentPdfFile) : (object3 instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)object3, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, (Map)object3, this.currentPdfFile));
            }
            if (object != null) {
                boolean bl3 = !this.isType3Font && this.useHiResImageForDisplay && this.current.isImageCached(this.pageNum);
                this.optionsApplied = 0;
                if (!bl3 && (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler())) {
                    bufferedImage = this.processImage((GenericColorSpace)cloneable, string3, (byte[])object, string9, n3, n4, n5, string8, string2, bl2, this.createScaledVersion, hashtable);
                }
                this.currentImage = string9;
                if (bufferedImage != null || bl3) {
                    if (this.renderDirectly | this.useHiResImageForDisplay) {
                        this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                        this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                        } else {
                            this.current.drawImage(this.pageNum, bufferedImage, this.currentGraphicsState, bl3, string9, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(bufferedImage, string9);
                    } else {
                        this.generateTransformedImageSingle(bufferedImage, string9);
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                }
            }
        }
        n = n6 + 3;
        return n;
    }

    private final void TS(float f) {
        this.currentTextState.setTextRise(f);
    }

    private final void double_quote(byte[] byArray, int n, int n2, float f, float f2) {
        this.currentTextState.setCharacterSpacing(f);
        this.currentTextState.setWordSpacing(f2);
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading());
        this.moveCommand = 0;
        this.multipleTJs = false;
    }

    private final void K(boolean bl, byte[] byArray) {
        boolean bl2;
        this.current.resetOnColorspaceChange();
        boolean bl3 = bl2 = !bl;
        if (this.operandCount > 3) {
            String[] stringArray = this.getValues(this.operandCount, byArray);
            if (bl2) {
                if (this.strokeColorSpace.getID() != 3) {
                    this.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.strokeColorSpace.setColor(stringArray, this.operandCount);
            } else {
                if (this.nonstrokeColorSpace.getID() != 3) {
                    this.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.nonstrokeColorSpace.setColor(stringArray, this.operandCount);
            }
        }
    }

    private String[] getValues(int n, byte[] byArray) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.generateOpAsString(i, byArray);
        }
        return stringArray;
    }

    private final void W(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.isClip = true;
    }

    private final void width(float f) {
        this.currentGraphicsState.setLineWidth(f);
    }

    private final void one_quote(byte[] byArray, int n, int n2) {
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void N() {
        if (this.isClip) {
            this.currentDrawShape.closeShape();
            this.currentGraphicsState.updateClip(new Area(this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, false, null, false, null, 0.0f, 0.0f)));
            this.currentGraphicsState.checkWholePageClip(this.pageData.getMediaBoxHeight(this.pageNum) + this.pageData.getMediaBoxY(this.pageNum));
            this.isClip = false;
            if (this.renderPage) {
                if (this.renderDirectly) {
                    Stroke stroke = this.currentGraphicsState.getStroke();
                    this.g2.setStroke(stroke);
                    this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.currentGraphicsState);
                }
            }
        }
        this.currentDrawShape.resetPath();
    }

    private final void sh(String string) {
        if (!runningStoryPad && !shadingMessageDisplayed) {
            JOptionPane.showMessageDialog(null, "Shading is Not displayed in the GPL version of JPedal");
            shadingMessageDisplayed = true;
        }
    }

    private final void TW(float f) {
        this.currentTextState.setWordSpacing(f);
    }

    private final void CS(boolean bl, String string) {
        Map map;
        String string2;
        boolean bl2;
        Object object;
        this.current.resetOnColorspaceChange();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((object = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, string)) == null) {
            object = string;
        }
        boolean bl3 = bl2 = !bl;
        GenericColorSpace genericColorSpace = object instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)object, null, this.currentPdfFile) : ((string2 = (String)(map = (Map)object).get("rawValue")) == null || string2.indexOf("<<") == -1 ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, map, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, string2, null, this.currentPdfFile));
        if (genericColorSpace.getID() == 9) {
            genericColorSpace.setPattern(this.currentPatternValues, this.pageH);
            genericColorSpace.setGS(this.currentGraphicsState);
        }
        if (bl2) {
            this.strokeColorSpace = genericColorSpace;
        } else {
            this.nonstrokeColorSpace = genericColorSpace;
        }
    }

    private final void V(float f, float f2, float f3, float f4) {
        this.currentDrawShape.addBezierCurveV(f3, f4, f, f2);
    }

    private final void TF(float f, String string) {
        this.currentTextState.setFontTfs(f);
        Object v = this.fonts.get(string);
        if (v != null) {
            this.currentFontData = (PdfFont)v;
        }
        this.currentFont = this.currentFontData.getFontName();
        this.currentTextState.setFont(this.currentFont, string);
        this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
    }

    private final int processToken(int n, byte[] byArray, int n2, int n3) throws Exception {
        if (this.operandCount > 0) {
            int n4;
            int[] nArray = new int[50];
            int[] nArray2 = new int[50];
            int n5 = 0;
            for (n4 = this.currentOp - 1; n4 > -1; --n4) {
                nArray[n5] = this.opStart[n4];
                nArray2[n5] = this.opEnd[n4];
                if (n5 == this.operandCount) {
                    n4 = -1;
                }
                ++n5;
            }
            if (n5 == this.operandCount) {
                --this.currentOp;
                for (n4 = 50 - 1; n4 > this.currentOp; --n4) {
                    nArray[n5] = this.opStart[n4];
                    nArray2[n5] = this.opEnd[n4];
                    if (n5 == this.operandCount) {
                        n4 = this.currentOp;
                    }
                    ++n5;
                }
                ++this.currentOp;
            }
            this.opStart = nArray;
            this.opEnd = nArray2;
        }
        boolean bl = true;
        if (this.renderText || this.textExtracted) {
            bl = false;
            switch (n) {
                case 21603: {
                    this.TC(this.parseFloat(0, byArray));
                    break;
                }
                case 21623: {
                    this.TW(this.parseFloat(0, byArray));
                    break;
                }
                case 21626: {
                    this.TZ(this.parseFloat(0, byArray));
                    break;
                }
                case 21580: {
                    this.TL(this.parseFloat(0, byArray));
                    break;
                }
                case 21606: {
                    this.TF(this.parseFloat(0, byArray), this.generateOpAsString(1, byArray).substring(1));
                    break;
                }
                case 21618: {
                    this.TR(Integer.parseInt(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 21619: {
                    this.TS(this.parseFloat(0, byArray));
                    break;
                }
                case 21572: {
                    this.TD(false, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 21604: {
                    this.TD(true, this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 21613: {
                    this.currentTextState.Tm[0][0] = this.parseFloat(5, byArray);
                    this.currentTextState.Tm[0][1] = this.parseFloat(4, byArray);
                    this.currentTextState.Tm[0][2] = 0.0f;
                    this.currentTextState.Tm[1][0] = this.parseFloat(3, byArray);
                    this.currentTextState.Tm[1][1] = this.parseFloat(2, byArray);
                    this.currentTextState.Tm[1][2] = 0.0f;
                    this.currentTextState.Tm[2][0] = this.parseFloat(1, byArray);
                    this.currentTextState.Tm[2][1] = this.parseFloat(0, byArray);
                    this.currentTextState.Tm[2][2] = 1.0f;
                    this.TM();
                    break;
                }
                case 21546: {
                    this.TSTAR();
                    break;
                }
                case 21610: {
                    this.TJ(byArray, n2, n3);
                    break;
                }
                case 21578: {
                    this.TJ(byArray, n2, n3);
                    break;
                }
                case 39: {
                    this.one_quote(byArray, n2, n3);
                    break;
                }
                case 34: {
                    this.double_quote(byArray, n2, n3, this.parseFloat(1, byArray), this.parseFloat(2, byArray));
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (this.renderPage || this.textColorExtracted || this.colorExtracted) {
            bl = false;
            switch (n) {
                case 29287: {
                    this.RG(true, byArray);
                    break;
                }
                case 21063: {
                    this.RG(false, byArray);
                    break;
                }
                case 5456718: {
                    this.SCN(false, byArray);
                    break;
                }
                case 7562094: {
                    this.SCN(true, byArray);
                    break;
                }
                case 21315: {
                    this.SCN(false, byArray);
                    break;
                }
                case 29539: {
                    this.SCN(true, byArray);
                    break;
                }
                case 25459: {
                    this.CS(true, this.generateOpAsString(0, byArray));
                    break;
                }
                case 17235: {
                    this.CS(false, this.generateOpAsString(0, byArray));
                    break;
                }
                case 103: {
                    this.G(true, byArray);
                    break;
                }
                case 71: {
                    this.G(false, byArray);
                    break;
                }
                case 107: {
                    this.K(true, byArray);
                    break;
                }
                case 75: {
                    this.K(false, byArray);
                    break;
                }
                case 29544: {
                    this.sh(this.generateOpAsString(0, byArray).substring(1));
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            switch (n) {
                case 18756: {
                    n3 = this.ID(byArray, n3);
                    break;
                }
                case 66: {
                    this.B(false, false);
                    break;
                }
                case 98: {
                    this.B(false, true);
                    break;
                }
                case 25130: {
                    this.B(true, true);
                    break;
                }
                case 16938: {
                    this.B(true, false);
                    break;
                }
                case 99: {
                    float f = this.parseFloat(1, byArray);
                    float f2 = this.parseFloat(0, byArray);
                    float f3 = this.parseFloat(3, byArray);
                    float f4 = this.parseFloat(2, byArray);
                    float f5 = this.parseFloat(5, byArray);
                    float f6 = this.parseFloat(4, byArray);
                    this.currentDrawShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
                    break;
                }
                case 100: {
                    this.D(byArray);
                    break;
                }
                case 70: {
                    this.F(false);
                    break;
                }
                case 102: {
                    this.F(false);
                    break;
                }
                case 17962: {
                    this.F(true);
                    break;
                }
                case 26154: {
                    this.F(true);
                    break;
                }
                case 104: {
                    this.H();
                    break;
                }
                case 108: {
                    this.L(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 109: {
                    this.M(this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 110: {
                    this.N();
                    break;
                }
                case 83: {
                    this.S(false);
                    break;
                }
                case 115: {
                    this.S(true);
                    break;
                }
                case 118: {
                    this.V(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 22314: {
                    this.W(true);
                    break;
                }
                case 87: {
                    this.W(false);
                    break;
                }
                case 121: {
                    this.Y(this.parseFloat(1, byArray), this.parseFloat(0, byArray), this.parseFloat(3, byArray), this.parseFloat(2, byArray));
                    break;
                }
                case 29285: {
                    this.RE(this.parseFloat(3, byArray), this.parseFloat(2, byArray), this.parseFloat(1, byArray), this.parseFloat(0, byArray));
                    break;
                }
                case 25453: {
                    float[][] fArray = new float[3][3];
                    fArray[0][0] = this.parseFloat(5, byArray);
                    fArray[0][1] = this.parseFloat(4, byArray);
                    fArray[0][2] = 0.0f;
                    fArray[1][0] = this.parseFloat(3, byArray);
                    fArray[1][1] = this.parseFloat(2, byArray);
                    fArray[1][2] = 0.0f;
                    fArray[2][0] = this.parseFloat(1, byArray);
                    fArray[2][1] = this.parseFloat(0, byArray);
                    fArray[2][2] = 1.0f;
                    this.CM(fArray);
                    break;
                }
                case 26483: {
                    this.gs(this.gs_state.get(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 105: {
                    this.I();
                    break;
                }
                case 74: {
                    this.J(false, Integer.parseInt(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 106: {
                    this.J(true, Integer.parseInt(this.generateOpAsString(0, byArray)));
                    break;
                }
                case 113: {
                    this.Q(true);
                    break;
                }
                case 81: {
                    this.Q(false);
                    break;
                }
                case 19792: {
                    this.MP();
                    break;
                }
                case 17488: {
                    this.DP(n2, n3, byArray, this.generateOpAsString(0, byArray));
                    break;
                }
                case 0x424443: {
                    this.BDC(n2, n3, byArray, this.generateOpAsString(0, byArray));
                    break;
                }
                case 4345155: {
                    this.BMC(this.generateOpAsString(0, byArray));
                    break;
                }
                case 25648: {
                    this.d0((int)this.parseFloat(0, byArray), (int)this.parseFloat(1, byArray));
                    break;
                }
                case 25649: {
                    this.d1(this.parseFloat(1, byArray), this.parseFloat(3, byArray), this.parseFloat(5, byArray), this.parseFloat(0, byArray), this.parseFloat(2, byArray), this.parseFloat(4, byArray));
                    break;
                }
                case 4541763: {
                    this.EMC();
                    break;
                }
                case 16980: {
                    this.BT();
                    break;
                }
                case 17748: {
                    this.ET();
                    break;
                }
                case 17519: {
                    this.DO(this.generateOpAsString(0, byArray));
                    break;
                }
                case 77: {
                    this.mm((int)this.parseFloat(0, byArray));
                    break;
                }
                case 119: {
                    this.width(this.parseFloat(0, byArray));
                }
            }
        }
        this.currentOp = 0;
        this.operandCount = 0;
        ++this.tokenNumber;
        return n3;
    }

    private void gs(Object object) {
        this.currentGraphicsState.setMode(object);
        this.current.setGraphicsState(2, this.currentGraphicsState.getNonStrokeAlpha());
        this.current.setGraphicsState(1, this.currentGraphicsState.getStrokeAlpha());
    }

    private final void DO(String string) throws PdfException {
        block34: {
            Map map;
            Object object;
            string = string.substring(1);
            if (this.rejectSuperimposedImages) {
                if (this.imposedImages == null) {
                    this.imposedImages = new HashMap();
                }
                if (this.imposedImages.get(object = (int)this.currentGraphicsState.CTM[2][0] + "-" + (int)this.currentGraphicsState.CTM[2][1] + '-' + (int)this.currentGraphicsState.CTM[0][0] + '-' + (int)this.currentGraphicsState.CTM[1][1] + '-' + (int)this.currentGraphicsState.CTM[0][1] + '-' + (int)this.currentGraphicsState.CTM[1][0]) == null) {
                    this.imposedImages.put(object, "x");
                } else {
                    return;
                }
            }
            this.currentImage = this.fileName + '-' + string;
            object = this.localXObjects.get(string);
            if (object == null) {
                object = this.currentXObjectValues.get(string);
            }
            String string2 = null;
            if (object == null) {
                map = null;
            } else if (object instanceof Map) {
                map = (Map)object;
            } else {
                string2 = (String)object;
                map = this.currentPdfFile.readObject(string2, false, null);
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            try {
                if (map == null) break block34;
                String string3 = (String)map.get("Subtype");
                if (string3.equals("/Form")) {
                    Object object2;
                    if (this.xFormMetadata) {
                        Object object3;
                        this.lastFormID = string;
                        object2 = new HashMap();
                        String[] stringArray = new String[]{"OPI", "BBox", "Matrix"};
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            object3 = map.get(stringArray[i]);
                            if (object3 == null) continue;
                            object2.put(stringArray[i], object3);
                        }
                        HashMap hashMap = new HashMap();
                        object3 = new HashMap();
                        object3.put((String)"F", (String)"x");
                        this.currentPdfFile.flattenValuesInObject(false, false, (Map)object2, hashMap, (Map)object3, null, string2);
                        this.pdfImages.setXformData(this.lastFormID, hashMap);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(true);
                    }
                    object2 = this.currentPdfFile.readStream(map, string2, true, true, this.keepRaw, false);
                    this.currentOp = 0;
                    this.operandCount = 0;
                    if (object2 != null) {
                        this.processXForm(map, (byte[])object2);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(false);
                    }
                    this.lastFormID = null;
                    break block34;
                }
                if (string3.equals("/Image")) {
                    byte[] byArray;
                    if (!this.markedContentExtracted && this.contentHandler != null) {
                        this.contentHandler.setImageName(string);
                    }
                    if (!(this.renderImages | this.clippedImagesExtracted | this.finalImagesExtracted | this.rawImagesExtracted) || (byArray = this.currentPdfFile.readStream(map, string2, true, true, this.keepRaw, false)) == null) break block34;
                    boolean bl = this.useHiResImageForDisplay && this.current.isImageCached(this.pageNum);
                    BufferedImage bufferedImage = null;
                    this.optionsApplied = 0;
                    if (!bl) {
                        bufferedImage = this.processImageXObject(string, map, this.createScaledVersion, byArray);
                    }
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    if (bufferedImage == null && !bl) break block34;
                    if (this.renderDirectly || this.useHiResImageForDisplay) {
                        if (PdfDecoder.isRunningOnMac && !bl) {
                            bufferedImage = this.clipForMac(bufferedImage);
                        }
                        if (this.requestExit) {
                            this.exited = true;
                            return;
                        }
                        this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                        this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                        } else if (bufferedImage != null || bl) {
                            this.current.drawImage(this.pageNum, bufferedImage, this.currentGraphicsState, bl, string, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(bufferedImage, string);
                    } else {
                        try {
                            this.generateTransformedImageSingle(bufferedImage, string);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception " + exception + " on tansforming image in file");
                        }
                    }
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    break block34;
                }
                LogWriter.writeLog("[PDF] " + string3 + " not supported");
            }
            catch (Error error) {
                error.printStackTrace();
                this.imagesProcessedFully = false;
                this.addPageFailureMessage("Error " + error + " in DO with image " + map + " isPrinting=" + this.isPrinting + " useHiResImageForDisplay=" + this.useHiResImageForDisplay);
            }
        }
    }

    private void processXForm(Map map, byte[] byArray) throws PdfException {
        Object object;
        Object object2;
        String string = this.currentPdfFile.getValue((String)map.get("Matrix"));
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[6];
        boolean bl = true;
        if (string != null) {
            object2 = new StringTokenizer(string, "[ ]");
            for (int i = 0; i < 6; ++i) {
                float f;
                fArray2[i] = f = Float.parseFloat(object2.nextToken());
                if (f == fArray[i]) continue;
                bl = false;
            }
        }
        object2 = null;
        if (string != null && !bl) {
            this.scalings.put(new Integer(this.formLevel), object2);
            object2 = this.currentGraphicsState.CTM;
            Object object3 = new float[][]{{fArray2[0], fArray2[1], 0.0f}, {fArray2[2], fArray2[3], 0.0f}, {fArray2[4], fArray2[5], 1.0f}};
            object3 = Matrix.multiply(object3, object2);
            this.currentGraphicsState.CTM = object3;
        }
        ++this.formLevel;
        GenericColorSpace genericColorSpace = (GenericColorSpace)this.strokeColorSpace.clone();
        GenericColorSpace genericColorSpace2 = (GenericColorSpace)this.nonstrokeColorSpace.clone();
        Map map2 = this.gs_state;
        this.gs_state = new HashMap();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.gs_state.put(object, map2.get(object));
        }
        object = this.fonts;
        this.fonts = new HashMap();
        Map map3 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
        if (map3 != null) {
            this.readResources(false, map3, false);
        }
        if (byArray.length > 0) {
            this.decodeStreamIntoObjects(byArray);
        }
        --this.formLevel;
        object2 = (float[][])this.scalings.get(new Integer(this.formLevel));
        if (object2 != null) {
            this.currentGraphicsState.CTM = object2;
        }
        if (this.formLevel == 0) {
            this.localXObjects.clear();
        }
        this.strokeColorSpace = genericColorSpace;
        this.nonstrokeColorSpace = genericColorSpace2;
        this.fonts = object;
        this.gs_state = map2;
    }

    private final void generateTransformedImageSingle(BufferedImage bufferedImage, String string) {
        LogWriter.writeMethod("{generateTransformedImageSingle}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            boolean bl;
            Area area = this.currentGraphicsState.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, true, PdfDecoder.isDraft);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            f = imageTransformer.getImageX();
            f2 = imageTransformer.getImageY();
            f3 = imageTransformer.getImageW();
            f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && this.customImageHandler != null && !this.customImageHandler.imageHasBeenScaled() && !(bl = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            bufferedImage = imageTransformer.getImage();
            imageTransformer = null;
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (bufferedImage != null) {
                if (this.finalImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4, this.lastFormID);
                    if (this.includeImagesInData) {
                        float f5 = f;
                        float f6 = f2;
                        if (area != null) {
                            int n = (int)area.getBounds().getMinX();
                            int n2 = (int)area.getBounds().getMaxX();
                            int n3 = (int)area.getBounds().getMinY();
                            int n4 = (int)area.getBounds().getMaxY();
                            if (f5 > 0.0f && f5 < (float)n || f5 < 0.0f) {
                                f5 = n;
                            }
                            float f7 = f5 + f3;
                            if (f5 < 0.0f) {
                                f7 = f3;
                            }
                            if ((float)n2 < f7) {
                                f3 = (float)n2 - f5;
                            }
                            if (f6 > 0.0f && f6 < (float)n3) {
                                f6 = n3;
                            }
                            if ((float)n4 < f6 + f4) {
                                f4 = (float)n4 - f6;
                            }
                        }
                        this.pdfData.addImageElement(f5, f6, f3, f4, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                    this.currentGraphicsState.x = f;
                    this.currentGraphicsState.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, bufferedImage, this.currentGraphicsState, false, string, this.optionsApplied);
                    }
                }
                if (this.isPageContent & this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed() && !runningStoryPad) {
                    String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private BufferedImage addBackgroundToMask(BufferedImage bufferedImage) {
        if (this.isMask) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private final BufferedImage clipForMac(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{clipForMac}", 0);
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, this.createScaledVersion, false);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            imageTransformerDouble.doubleScaleTransformShear(true);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            bufferedImage = imageTransformerDouble.getImage();
        }
        return bufferedImage;
    }

    private final void generateTransformedImage(BufferedImage bufferedImage, String string) {
        LogWriter.writeMethod("{generateTransformedImage}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, this.createScaledVersion, true);
            imageTransformerDouble.doubleScaleTransformShear(false);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            bufferedImage = imageTransformerDouble.getImage();
            String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
            if (string2 == null) {
                string2 = "tif";
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2)) {
                this.addPageFailureMessage("Problem saving " + bufferedImage);
            }
            if (this.finalImagesExtracted | this.renderImages) {
                imageTransformerDouble.doubleScaleTransformScale();
            }
            imageTransformerDouble.completeImage();
            f = imageTransformerDouble.getImageX();
            f2 = imageTransformerDouble.getImageY();
            f3 = imageTransformerDouble.getImageW();
            f4 = imageTransformerDouble.getImageH();
            bufferedImage = imageTransformerDouble.getImage();
            imageTransformerDouble = null;
            if (bufferedImage != null) {
                if (this.finalImagesExtracted | this.clippedImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, f, f2, f3, f4, this.lastFormID);
                    if (this.includeImagesInData) {
                        this.pdfData.addImageElement(f, f2, f3, f4, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && bufferedImage != null) {
                    this.currentGraphicsState.x = f;
                    this.currentGraphicsState.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, bufferedImage, this.currentGraphicsState, false, string, this.optionsApplied);
                    }
                }
                if (!this.renderDirectly && this.isPageContent && this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed()) {
                    string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(bufferedImage), false, false, string2);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final StringBuffer processTextArray(byte[] byArray, int n, int n2) {
        float f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        while (byArray[n] == 91 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            if (byArray[n] == 91) {
                bl2 = true;
            }
            ++n;
        }
        float f2 = currentThreshold;
        if (f2 < 0.0f) {
            Float f3 = (Float)currentThresholdValues.get(this.currentFontData.getFontName());
            f2 = f3 == null ? -f2 : f3.floatValue();
        }
        this.textLength = 0;
        int n3 = this.currentGraphicsState.getTextRenderType();
        int n4 = 0;
        boolean bl4 = true;
        boolean bl5 = false;
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        float[][] fArray3 = new float[3][3];
        char c = ' ';
        char c2 = ' ';
        char c3 = ' ';
        char c4 = 'x';
        int n5 = 0;
        int n6 = 0;
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        String string = "";
        float f9 = f = this.currentTextState.getTfs();
        if (f < 0.0f) {
            f = -f;
        }
        int n7 = this.currentFontData.getFontType();
        float f10 = this.currentFontData.getCurrentFontSpaceWidth();
        String string2 = "";
        this.textData = new StringBuffer(50);
        float f11 = 0.0f;
        boolean bl6 = this.currentFontData.isCIDFont();
        if (this.renderText && n3 != 4) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        }
        int n8 = 2;
        if (bl6) {
            n8 = 4;
        }
        fArray = Matrix.multiply(this.currentTextState.Tm, this.currentGraphicsState.CTM);
        fArray[0][0] = fArray[0][0];
        fArray[0][1] = fArray[0][1];
        fArray[1][0] = fArray[1][0];
        fArray[1][1] = fArray[1][1];
        if (f9 < 0.0f) {
            fArray[2][0] = fArray[2][0] - fArray[0][0] / 2.0f;
            fArray[2][1] = fArray[2][1] - fArray[1][1] / 2.0f;
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f;
        float f12 = this.currentTextState.getWordSpacing() / f;
        if (this.multipleTJs) {
            fArray[2][0] = this.currentTextState.Tm[2][0];
            fArray[2][1] = this.currentTextState.Tm[2][1];
        }
        fArray2[0][0] = f9 * this.currentTextState.getHorizontalScaling();
        fArray2[1][1] = f9;
        fArray2[2][1] = this.currentTextState.getTextRise();
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        if (bl2 && byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93) {
            float f13 = 0.0f;
            while (byArray[n] != 40) {
                StringBuffer stringBuffer = new StringBuffer();
                while (byArray[n] != 40 && byArray[n] != 32) {
                    stringBuffer.append((char)byArray[n]);
                    ++n;
                }
                f13 += Float.parseFloat(stringBuffer.toString());
                while (byArray[n] == 32) {
                    ++n;
                }
            }
            f13 = fArray[0][0] * f13 / 1000.0f;
            fArray[2][0] = fArray[2][0] - f13;
        }
        this.multipleTJs = true;
        if (fArray[1][1] != 0.0f) {
            bl4 = true;
            n4 = 0;
            n5 = Math.round(fArray[1][1]);
            if (n5 == 0) {
                n5 = Math.round(fArray[0][1]);
            }
            f5 = fArray[0][0];
        } else {
            bl4 = false;
            n5 = Math.round(fArray[1][0]);
            if (n5 == 0) {
                n5 = Math.round(fArray[0][0]);
            }
            if (n5 < 0) {
                n5 = -n5;
                n4 = 3;
            } else {
                n4 = 2;
            }
            f5 = fArray[0][1];
        }
        if (n5 == 0) {
            n5 = 1;
        }
        Font font = null;
        if ((useTextPrintingForNonEmbeddedFonts || this.textPrint != 0) && this.isPrinting) {
            font = this.currentFontData.getJavaFontX(n5);
        }
        float f14 = fArray[2][0];
        float f15 = fArray[2][1];
        float f16 = n5;
        if (n7 == 3 && n5 > 10) {
            f16 = 10.0f;
        }
        if (bl6) {
            f16 = fArray[1][1];
        }
        int n9 = 0;
        for (int i = n; i < n2; ++i) {
            int n10;
            while (true) {
                c2 = c2 == '\\' && c == '\\' ? (char)'x' : c;
                n6 = byArray[i];
                if (n6 < 0) {
                    n6 = 256 + n6;
                }
                if ((c = (char)((char)n6)) == '\\' && byArray[i + 1] == 13 | byArray[i + 1] == 10) {
                    if ((n6 = byArray[++i]) < 0) {
                        n6 = 256 + n6;
                    }
                    c = (char)n6;
                }
                if (c != '\n' & c != '\r') break;
                ++i;
            }
            if (bl5) {
                if (c2 != '\\' && (c == '(' || c == ')')) {
                    if (c == '(') {
                        ++n9;
                    } else if (c == ')') {
                        if (n9 <= 0) {
                            bl5 = false;
                        } else {
                            --n9;
                        }
                    }
                } else if (c3 == '<' && c == '>') {
                    bl5 = false;
                }
            }
            if (bl5) {
                float f17;
                Object object;
                block191: {
                    int n11;
                    Serializable serializable;
                    c4 = c;
                    if (c3 == '<') {
                        serializable = new StringBuffer(4);
                        ((StringBuffer)serializable).append(c);
                        for (n11 = 1; n11 < n8; ++n11) {
                            n10 = byArray[i + n11];
                            if (n10 == 62) {
                                n11 = 4;
                                n8 = 2;
                                continue;
                            }
                            if (n10 == 10 | n10 == 13) {
                                ++i;
                                --n11;
                                continue;
                            }
                            if (n10 < 0) {
                                n10 = 256 + n10;
                            }
                            c = (char)n10;
                            ((StringBuffer)serializable).append(c);
                        }
                        i = i + n8 - 1;
                        n6 = Integer.parseInt(((StringBuffer)serializable).toString(), 16);
                        c = (char)n6;
                        string = this.currentFontData.getGlyphValue(n6);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n6);
                        }
                    } else if (bl6 && this.currentFontData.isDoubleByte()) {
                        int n12;
                        if (c == '\\') {
                            while (true) {
                                if ((n6 = byArray[i]) < 0) {
                                    n6 = 256 + n6;
                                }
                                c = (char)n6;
                                if (n6 < 0) {
                                    n6 = 256 + n6;
                                }
                                c = (char)n6;
                                if (n6 == 92) {
                                    if ((c = (char)(n6 = byArray[++i])) == 'n') {
                                        n6 = 10;
                                    } else if (c == 'b') {
                                        n6 = 8;
                                    } else if (c == 't') {
                                        n6 = 9;
                                    } else if (c == 'r') {
                                        n6 = 13;
                                    } else if (c == 'f') {
                                        n6 = 12;
                                    } else if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                                        int n13 = 1;
                                        if (Character.isDigit((char)byArray[i + 1])) {
                                            ++n13;
                                            if (Character.isDigit((char)byArray[i + 2])) {
                                                ++n13;
                                            }
                                        }
                                        n6 = this.readEscapeValue(i, n13, 8, byArray);
                                        i = i + n13 - 1;
                                    }
                                }
                                if (c != '\n' & c != '\r') break;
                                ++i;
                            }
                        }
                        if ((n12 = byArray[++i]) < 0) {
                            n12 = 256 + n12;
                        }
                        if (n12 == 92) {
                            if ((c = (char)((char)(n12 = byArray[++i]))) == 'n') {
                                n12 = 10;
                            } else if (c == 'b') {
                                n12 = 8;
                            } else if (c == 't') {
                                n12 = 9;
                            } else if (c == 'r') {
                                n12 = 13;
                            } else if (c == 'f') {
                                n12 = 12;
                            } else if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                                int n14 = 1;
                                if (Character.isDigit((char)byArray[i + 1])) {
                                    ++n14;
                                    if (Character.isDigit((char)byArray[i + 2])) {
                                        ++n14;
                                    }
                                }
                                n12 = this.readEscapeValue(i, n14, 8, byArray);
                                i = i + n14 - 1;
                            }
                        }
                        n6 = n6 * 256 + n12;
                        c = (char)n6;
                        string = String.valueOf(c);
                        string2 = this.currentFontData.getUnicodeValue(string, n6);
                        if (c == '\\') {
                            c = 'x';
                        }
                    } else if (c == '\\') {
                        c2 = c;
                        n6 = byArray[++i];
                        c = (char)n6;
                        if (byArray.length > i + 2 && Character.isDigit((char)byArray[i])) {
                            int n15 = 1;
                            if (Character.isDigit((char)byArray[i + 1])) {
                                ++n15;
                                if (Character.isDigit((char)byArray[i + 2])) {
                                    ++n15;
                                }
                            }
                            n6 = this.readEscapeValue(i, n15, 8, byArray);
                            i = i + n15 - 1;
                            if (n6 > 255) {
                                n6 -= 256;
                            }
                            string = this.currentFontData.getGlyphValue(n6);
                            if (this.textExtracted) {
                                string2 = this.currentFontData.getUnicodeValue(string, n6);
                            }
                            if ((c = (char)((char)n6)) == '\\') {
                                c = 'x';
                            }
                        } else {
                            n6 = byArray[i];
                            c = (char)n6;
                            if (c == 'u') {
                                n6 = this.readEscapeValue(i + 1, 4, 16, byArray);
                                i += 4;
                                string = this.currentFontData.getGlyphValue(n6);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n6);
                                }
                            } else {
                                if (c == 'n') {
                                    n6 = 10;
                                    c = '\n';
                                } else if (c == 'b') {
                                    n6 = 8;
                                    c = '\b';
                                } else if (c == 't') {
                                    n6 = 9;
                                    c = '\t';
                                } else if (c == 'r') {
                                    n6 = 13;
                                    c = '\r';
                                } else if (c == 'f') {
                                    n6 = 12;
                                    c = '\f';
                                }
                                string = this.currentFontData.getGlyphValue(n6);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n6);
                                }
                                if (string.length() > 0) {
                                    c = string.charAt(0);
                                }
                            }
                        }
                    } else if (bl6) {
                        string2 = string = String.valueOf(c);
                    } else {
                        string = this.currentFontData.getGlyphValue(n6);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n6);
                        }
                    }
                    fArray2[0][0] = 1.0f;
                    fArray2[0][1] = 0.0f;
                    fArray2[0][2] = 0.0f;
                    fArray2[1][0] = 0.0f;
                    fArray2[1][1] = 1.0f;
                    fArray2[1][2] = 0.0f;
                    fArray2[2][0] = f7 + f8;
                    fArray2[2][1] = 0.0f;
                    fArray2[2][2] = 1.0f;
                    fArray = Matrix.multiply(fArray2, fArray);
                    if (c == ' ' && c2 != ' ') {
                        fArray3 = fArray;
                    }
                    f8 = 0.0f;
                    serializable = this.currentFontData.getGlyphData();
                    n11 = n6;
                    if (this.currentFontData.isCIDFont() && !((PdfJavaGlyphs)serializable).isIdentity() && (n10 = ((PdfJavaGlyphs)serializable).getConvertedGlyph(n6)) != -1) {
                        n11 = n10;
                    }
                    f7 = this.currentFontData.getWidth(n11);
                    if (this.renderText && n3 != 4) {
                        if (this.isPrinting && font != null && (this.textPrint == 2 || useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                            Area area;
                            if (n3 == 7 && (area = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getBaseFontName()) ? ((PdfJavaGlyphs)serializable).getStandardGlyph(fArray, n6, string, f7) : ((PdfJavaGlyphs)serializable).getApproximateGlyph(fArray, n6, string, f7)) != null) {
                                this.currentGraphicsState.addClip(area);
                            }
                            if (string != null && !string.startsWith("&#")) {
                                this.current.drawText(fArray, string, this.currentGraphicsState, fArray[2][0], -fArray[2][1], font);
                            }
                        } else if ((this.textPrint != 1 || font == null) && this.currentFontData.isFontEmbedded) {
                            String string3 = "notdef";
                            try {
                                Area area;
                                float f18;
                                if (!this.currentFontData.isCIDFont()) {
                                    string3 = this.currentFontData.getMappedChar(n6, false);
                                }
                                object = null;
                                object = ((PdfJavaGlyphs)serializable).getEmbeddedGlyph(this.factory, string3, fArray, n6, string, f7, this.currentFontData.getEmbeddedChar(n6));
                                if (n7 == 3) {
                                    if (object != null && object.getmaxWidth() == 0.0f) {
                                        object = null;
                                    } else if (object != null && object.ignoreColors()) {
                                        object.lockColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                                    }
                                }
                                if (object == null) break block191;
                                Object object2 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {fArray[2][0], fArray[2][1], 1.0f}};
                                float[][] fArrayArray = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                                object2 = Matrix.multiply(object2, fArrayArray);
                                object2[2][0] = fArray[2][0];
                                object2[2][1] = fArray[2][1];
                                if (object2[1][0] < 0.0f && object2[0][1] < 0.0f) {
                                    object2[1][0] = -object2[1][0];
                                    object2[0][1] = -object2[0][1];
                                }
                                if (n7 == 3) {
                                    f18 = 0.0f;
                                    if (object2[1][1] != 0.0f) {
                                        f18 = (float)n5 * object2[1][1];
                                    } else if (object2[0][0] != 0.0f) {
                                        f18 = (float)n5 * object2[0][0];
                                    } else if (object2[1][0] != 0.0f) {
                                        f18 = (float)n5 * object2[1][0];
                                    }
                                    if (f18 < 0.0f) {
                                        f18 = -f18;
                                    }
                                    if (f18 > f16) {
                                        f16 = f18;
                                    }
                                }
                                if ((f18 = 0.0f) > 0.0f) {
                                    if (f18 > 0.0f) {
                                        Matrix.show(this.currentGraphicsState.CTM);
                                        System.out.println(f18 + " " + string + "------------------" + fArray[0][0] + ' ' + fArray[0][1] + ' ' + fArray[1][0] + ' ' + fArray[1][1] + ' ' + " width=" + this.currentGraphicsState.getLineWidth() + " type=" + this.currentGraphicsState.getTextRenderType() + ' ' + this.currentFontData.FontMatrix[0] + ' ' + this.currentFontData.FontMatrix[1] + ' ' + this.currentFontData.FontMatrix[2] + ' ' + this.currentFontData.FontMatrix[3]);
                                    }
                                } else {
                                    f18 = 0.0f;
                                }
                                AffineTransform affineTransform = new AffineTransform(object2[0][0], object2[0][1], object2[1][0], object2[1][1], object2[2][0], object2[2][1]);
                                int n16 = n7;
                                if (n7 == 6) {
                                    n16 = 5;
                                    float f19 = 1000.0f / object.getmaxWidth();
                                    affineTransform.scale(f7 * f19, 1.0);
                                } else {
                                    n16 = n7 == 2 || n7 == 5 || this.currentFontData.isFontSubstituted() ? 4 : (n7 == 3 ? 6 : 5);
                                }
                                if (this.generateGlyphOnRender) {
                                    n16 = -n16;
                                }
                                if (n3 == 7 && (area = object.getShape()) != null) {
                                    area.transform(affineTransform);
                                    this.currentGraphicsState.addClip(area);
                                }
                                if (this.renderDirectly) {
                                    PdfPaint pdfPaint = null;
                                    PdfPaint pdfPaint2 = null;
                                    int n17 = this.currentGraphicsState.getTextRenderType();
                                    if ((n17 & 2) == 2) {
                                        pdfPaint2 = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((n17 & 1) == 1) {
                                        pdfPaint = this.currentGraphicsState.getStrokeColor();
                                    }
                                    Stroke stroke = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke(stroke);
                                    this.current.renderEmbeddedText(this.currentGraphicsState, n17, object, n16, this.g2, affineTransform, false, pdfPaint, pdfPaint2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha(), null, (int)f18);
                                    break block191;
                                }
                                this.current.drawEmbeddedText(fArray, n5, (PdfGlyph)object, n16, this.currentGraphicsState, affineTransform, f18);
                            }
                            catch (Exception exception) {
                                this.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                            }
                        } else if (string.length() > 0 && !string.startsWith("&#")) {
                            if (string.equals("...")) {
                                string = ellipsis;
                            }
                            Area area = null;
                            Object object3 = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getBaseFontName()) ? ((PdfJavaGlyphs)serializable).getStandardGlyph(fArray, n6, string, f7) : ((PdfJavaGlyphs)serializable).getApproximateGlyph(fArray, n6, string, f7);
                            if (object3 != null) {
                                AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray[2][0], fArray[2][1]);
                                ((Area)object3).transform(affineTransform);
                                if (n3 == 7) {
                                    this.currentGraphicsState.addClip((Area)object3);
                                }
                            }
                            if ((area = object3) != null) {
                                if (this.renderDirectly) {
                                    object3 = null;
                                    PdfPaint pdfPaint = null;
                                    int n18 = this.currentGraphicsState.getTextRenderType();
                                    if ((n18 & 2) == 2) {
                                        pdfPaint = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((n18 & 1) == 1) {
                                        object3 = this.currentGraphicsState.getStrokeColor();
                                    }
                                    Stroke stroke = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke(stroke);
                                    this.current.renderText(n18, area, this.g2, false, (PdfPaint)object3, pdfPaint, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha(), null);
                                } else {
                                    this.current.drawText(fArray, area, this.currentGraphicsState);
                                }
                            }
                        }
                    }
                }
                if (this.legacyTextMode && this.textExtracted && !bl6 && f16 < (f17 = PdfDecoder.currentHeightLookupData.getCharHeight(c, n5))) {
                    f16 = f17;
                }
                f7 += this.charSpacing;
                int n19 = n10 = runningStoryPad && this.charSpacing / f10 > 1.0f ? 1 : 0;
                if (c == ' ') {
                    f7 += f12;
                }
                f11 = f4 + this.charSpacing - f6;
                object = "";
                if (f11 > 0.0f & f6 > 0.0f) {
                    float f20 = f11 * f5;
                    if (runningStoryPad && f20 > 160.0f && n5 > 11) {
                        this.calcCoordinates(f14, fArray, bl4, f16, n5, f15);
                        if (bl4) {
                            this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2 - f20, this.y2, this.moveCommand, this.textData, this.tokenNumber, this.textLength, this.currentColor);
                        }
                        this.textData = new StringBuffer();
                        this.textLength = -1;
                        f4 = 0.0f;
                        f14 = this.x2;
                    } else {
                        object = this.getSpaces(f11, f10, f2);
                    }
                }
                ++this.textLength;
                f6 = f4 += f7;
                if (this.textExtracted && string2.length() > 0) {
                    if (PdfDecoder.embedWidthData) {
                        if (n10 != 0 && ((String)object).length() > 0) {
                            this.textData.append(StoryData.marker);
                            if (bl4 | PdfGroupingAlgorithms.oldTextExtraction) {
                                this.textData.append(fArray[2][0] - this.charSpacing * f5);
                            } else {
                                this.textData.append(fArray[2][1] - this.charSpacing * f5);
                            }
                            this.textData.append(StoryData.marker);
                            this.textData.append(this.charSpacing * f5);
                            this.textData.append(StoryData.marker);
                        }
                        this.textData.append((String)object);
                        if (bl4 | PdfGroupingAlgorithms.oldTextExtraction) {
                            this.textData.append(StoryData.marker);
                            this.textData.append(fArray[2][0]);
                            this.textData.append(StoryData.marker);
                        } else {
                            this.textData.append(StoryData.marker);
                            this.textData.append(fArray[2][1]);
                            this.textData.append(StoryData.marker);
                        }
                        if (n10 != 0) {
                            this.textData.append((f7 - this.charSpacing) * f5);
                        } else {
                            this.textData.append(f7 * f5);
                        }
                        this.textData.append(StoryData.marker);
                    } else {
                        this.textData.append((String)object);
                    }
                    String string4 = string2;
                    int n20 = string4.length();
                    for (int j = 0; j < n20; ++j) {
                        char c5 = string4.charAt(j);
                        if (!runningStoryPad || c5 != ' ' && c5 != '\n' && c5 != '\r') {
                            bl = true;
                        }
                        if (PdfDecoder.isXMLExtraction() && c5 == '<') {
                            this.textData.append("&lt;");
                            continue;
                        }
                        if (PdfDecoder.isXMLExtraction() && c5 == '>') {
                            this.textData.append("&gt;");
                            continue;
                        }
                        if (c5 > '\u001f') {
                            this.textData.append(c5);
                            continue;
                        }
                        this.textData.append(hex[c5]);
                    }
                    continue;
                }
                this.textData.append((String)object);
                continue;
            }
            if (c == '(' | c == '<') {
                bl5 = true;
                c3 = c;
                continue;
            }
            if (c != ')' && (c != '>' || c3 != '<') && (bl5 || c != '-' && (c < 48 || c > 57))) continue;
            float f21 = 0.0f;
            ++i;
            while (byArray[i] == 32) {
                ++i;
            }
            char c6 = (char)byArray[i];
            if (c6 == '(' | c6 == '<') {
                --i;
            } else if (c6 != '\'' && c6 != '\"' && c6 != '(' && c6 != ']' && c6 != '<') {
                StringBuffer stringBuffer = new StringBuffer(6);
                n10 = i;
                boolean bl7 = false;
                boolean bl8 = false;
                while (!bl7) {
                    c = c6;
                    if (c != '\n' && c != '\r') {
                        stringBuffer.append(c);
                    }
                    if ((c6 = (char)byArray[i + 1]) == ' ') {
                        bl8 = true;
                    }
                    if (c6 == '(' | c6 == '<') break;
                    if (!(c6 == '-' | c6 == '.' | c6 == ' ' | Character.isDigit(c6))) {
                        bl7 = true;
                    }
                    ++i;
                }
                if (bl7) {
                    i = n10;
                } else if (bl8) {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
                    f21 = 0.0f;
                    while (stringTokenizer.hasMoreTokens()) {
                        f21 += Float.parseFloat(stringTokenizer.nextToken());
                    }
                    f21 = -f21 / 1000.0f;
                } else if (stringBuffer.length() > 0) {
                    f21 = -Float.parseFloat(stringBuffer.toString()) / 1000.0f;
                }
            }
            f4 += f21;
            f8 += f21;
        }
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f7 + f8;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        this.currentTextState.Tm[2][0] = fArray[2][0];
        this.currentTextState.Tm[2][1] = fArray[2][1];
        if (this.textExtracted) {
            f4 -= this.charSpacing;
            if (c4 == ' ') {
                fArray = fArray3;
            }
            this.calcCoordinates(f14, fArray, bl4, f16, n5, f15);
            if (this.textData.length() == 0 || !bl) {
                this.textData = null;
            }
            this.currentTextState.writingMode = n4;
            if (n5 != this.lastFontSize || this.font_as_string == null) {
                this.currentTextState.setCurrentFontSize(Math.abs(n5));
                this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
                this.lastFontSize = n5;
            }
            if (runningStoryPad && !bl4) {
                this.textData = null;
            }
            return this.textData;
        }
        return null;
    }

    private void calcCoordinates(float f, float[][] fArray, boolean bl, float f2, int n, float f3) {
        this.x1 = f;
        this.x2 = fArray[2][0] - this.charSpacing * fArray[0][0];
        if (bl) {
            if (fArray[1][0] < 0.0f) {
                this.x1 = f + fArray[1][0] - this.charSpacing * fArray[0][0];
                this.x2 = fArray[2][0];
            } else if (fArray[1][0] > 0.0f) {
                this.x1 = f;
                this.x2 = fArray[2][0];
            }
        } else if (fArray[1][0] > 0.0f) {
            this.x1 = fArray[2][0];
            this.x2 = f + fArray[1][0] - this.charSpacing * fArray[0][0];
        } else if (fArray[1][0] < 0.0f) {
            this.x2 = fArray[2][0];
            this.x1 = f + fArray[1][0] - this.charSpacing * fArray[0][0];
        }
        if (bl) {
            float f4 = 1.0f;
            if (this.legacyTextMode || this.currentFontData.getFontType() == 3) {
                f4 = f2 / (float)n;
            }
            if (fArray[0][1] != 0.0f) {
                this.y1 = fArray[2][1] - fArray[0][1] + (fArray[0][1] + fArray[1][1]) * f4;
                this.y2 = f3;
            } else {
                this.y1 = f3 + fArray[1][1] * f4;
                this.y2 = fArray[2][1];
            }
        } else if (fArray[0][1] <= 0.0f) {
            this.y2 = fArray[2][1];
            this.y1 = f3;
        } else if (fArray[0][1] > 0.0f) {
            this.y1 = fArray[2][1];
            this.y2 = f3;
        }
    }

    private final String getSpaces(float f, float f2, float f3) {
        String string = "";
        if (f2 > 0.0f) {
            if (f > f2) {
                while (f >= f2) {
                    string = ' ' + string;
                    f -= f2;
                }
            } else if (f > f2 * f3) {
                string = string + ' ';
            }
        }
        return string;
    }

    private final int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)byArray[n + i]);
        }
        return Integer.parseInt(stringBuffer.toString(), n3);
    }

    public static String getFontsInFile() {
        return fontsInFile;
    }

    public void setDirectRendering(Graphics2D graphics2D) {
        this.renderDirectly = true;
        this.g2 = graphics2D;
        this.defaultClip = graphics2D.getClip();
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void includeImages() {
        this.includeImagesInData = true;
    }

    public PageLines getPageLines() {
        this.pageLines.lookForCompositeLines();
        return this.pageLines;
    }

    public boolean isPageSuccessful() {
        return this.pageSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void addPageFailureMessage(String string) {
        this.pageSuccessful = false;
        this.pageErrorMessages = this.pageErrorMessages + string + '\n';
    }

    public Map getFontMap() {
        return this.fonts;
    }

    public StringBuffer getlastTextStreamDecoded() {
        return this.textData;
    }

    public DynamicVectorRenderer getRenderer() {
        return this.current;
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public boolean exitedDecoding() {
        return this.exited;
    }

    public void terminateDecoding() {
        this.exited = false;
    }

    public static boolean isFormSupportAvailable() {
        return true;
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public void setExternalImageRender(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
        if (this.customImageHandler != null) {
            this.keepRaw = true;
        }
        if (imageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(imageHandler);
        }
    }

    public void setMapForMarkedContent(Object object) {
        this.markedContentExtracted = true;
        this.contentHandler = new StructuredContentHandler(object);
    }

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
        ellipsis = String.valueOf((char)Integer.parseInt("2026", 16));
        runningStoryPad = false;
        shadingMessageDisplayed = false;
        showInvisibleText = false;
        useTextPrintingForNonEmbeddedFonts = false;
    }
}

