/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.InterpAverage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class SubsampleAverageOpImage
extends GeometricOpImage {
    protected double scaleX;
    protected double scaleY;
    protected int blockX;
    protected int blockY;
    protected int sourceMinX;
    protected int sourceMinY;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, double d, double d2, ImageLayout imageLayout) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAverageOpImage0"));
        }
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("SubsampleAverageOpImage1"));
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX((int)Math.floor((double)renderedImage.getMinX() * d));
        imageLayout2.setMinY((int)Math.floor((double)renderedImage.getMinY() * d2));
        imageLayout2.setWidth((int)((double)renderedImage.getWidth() * d));
        imageLayout2.setHeight((int)((double)renderedImage.getHeight() * d2));
        return imageLayout2;
    }

    public SubsampleAverageOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, double d, double d2) {
        super(OpImage.vectorize(renderedImage), SubsampleAverageOpImage.layoutHelper(renderedImage, d, d2, imageLayout), map, true, null, new InterpAverage((int)Math.ceil(1.0 / d), (int)Math.ceil(1.0 / d2)), null);
        this.scaleX = d;
        this.scaleY = d2;
        this.blockX = (int)Math.ceil(1.0 / d);
        this.blockY = (int)Math.ceil(1.0 / d2);
        this.sourceMinX = renderedImage.getMinX();
        this.sourceMinY = renderedImage.getMinY();
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("destPt == null!");
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)this.sourceMinX + (point2D.getX() - (double)this.minX) / this.scaleX, (double)this.sourceMinY + (point2D.getY() - (double)this.minY) / this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("sourcePt == null!");
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)this.minX + (point2D.getX() - (double)this.sourceMinX) * this.scaleX, (double)this.minY + (point2D.getY() - (double)this.sourceMinY) * this.scaleY);
        return point2D2;
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.sourceMinX + (int)Math.floor((double)(rectangle.x - this.minX) / this.scaleX + 0.5);
        int n3 = this.sourceMinY + (int)Math.floor((double)(rectangle.y - this.minY) / this.scaleY + 0.5);
        int n4 = n2 + (rectangle.width - 1) * this.blockX;
        int n5 = n3 + (rectangle.height - 1) * this.blockY;
        return new Rectangle(n2, n3, n4 - n2 + 1, n5 - n3 + 1);
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(this.minX + (int)Math.floor((double)(rectangle.x - this.sourceMinX) * this.scaleX), this.minY + (int)Math.floor((double)(rectangle.y - this.sourceMinY) * this.scaleY), (int)Math.ceil((double)rectangle.width * this.scaleX), (int)Math.ceil((double)rectangle.height * this.scaleY));
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic3"));
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        float f = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < this.blockY) {
                        int n20 = n17;
                        int n21 = 0;
                        while (n21 < this.blockX) {
                            n18 += byArray4[n20] & 0xFF;
                            n20 += n6;
                            ++n21;
                        }
                        n17 += n7;
                        ++n19;
                    }
                    byArray3[n15] = ImageUtil.clampRoundByte((float)n18 / f);
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        float f = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    long l = 0L;
                    int n18 = 0;
                    while (n18 < this.blockY) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.blockX) {
                            l += (long)(sArray4[n19] & 0xFFFF);
                            n19 += n6;
                            ++n20;
                        }
                        n17 += n7;
                        ++n18;
                    }
                    sArray3[n15] = ImageUtil.clampRoundUShort((float)l / f);
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        float f = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    long l = 0L;
                    int n18 = 0;
                    while (n18 < this.blockY) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.blockX) {
                            l += (long)sArray4[n19];
                            n19 += n6;
                            ++n20;
                        }
                        n17 += n7;
                        ++n18;
                    }
                    sArray3[n15] = ImageUtil.clampRoundShort((float)l / f);
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        float f = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            int[] nArray5 = nArray[n10];
            int[] nArray6 = nArray3[n10];
            int n11 = nArray4[n10];
            int n12 = nArray2[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    double d = 0.0;
                    int n18 = 0;
                    while (n18 < this.blockY) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.blockX) {
                            d += (double)nArray6[n19];
                            n19 += n6;
                            ++n20;
                        }
                        n17 += n7;
                        ++n18;
                    }
                    nArray5[n15] = ImageUtil.clampRoundInt(d / (double)f);
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        float f = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            float[] fArray3 = fArray[n10];
            float[] fArray4 = fArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    double d = 0.0;
                    int n18 = 0;
                    while (n18 < this.blockY) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.blockX) {
                            d += (double)fArray4[n19];
                            n19 += n6;
                            ++n20;
                        }
                        n17 += n7;
                        ++n18;
                    }
                    fArray3[n15] = ImageUtil.clampFloat(d / (double)f);
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = (int)Math.floor(1.0 / this.scaleX) * n6;
        int n9 = (int)Math.floor(1.0 / this.scaleY) * n7;
        double d = this.blockX * this.blockY;
        int n10 = 0;
        while (n10 < n3) {
            double[] dArray3 = dArray[n10];
            double[] dArray4 = dArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n14;
                    double d2 = 0.0;
                    int n18 = 0;
                    while (n18 < this.blockY) {
                        int n19 = n17;
                        int n20 = 0;
                        while (n20 < this.blockX) {
                            d2 += dArray4[n19];
                            n19 += n6;
                            ++n20;
                        }
                        n17 += n7;
                        ++n18;
                    }
                    dArray3[n15] = d2 / d;
                    n14 += n8;
                    n15 += n4;
                    ++n16;
                }
                n11 += n9;
                n12 += n5;
                ++n13;
            }
            ++n10;
        }
    }
}

