/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends DERObject {
    String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERObjectIdentifier.getInstance(aSN1TaggedObject.getObject());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (n2 != byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            n = n * 128 + (n3 & 0x7F);
            if ((n3 & 0x80) == 0) {
                if (bl) {
                    switch (n / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            n -= 40;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            n -= 80;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(Integer.toString(n));
                n = 0;
            }
            ++n2;
        }
        this.identifier = stringBuffer.toString();
    }

    public DERObjectIdentifier(String string) {
        this.identifier = string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream outputStream, int n) throws IOException {
        if (n >= 128) {
            if (n >= 16384) {
                if (n >= 0x200000) {
                    if (n >= 0x10000000) {
                        outputStream.write(n >> 28 | 0x80);
                    }
                    outputStream.write(n >> 21 | 0x80);
                }
                outputStream.write(n >> 14 | 0x80);
            }
            outputStream.write(n >> 7 | 0x80);
        }
        outputStream.write(n & 0x7F);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
        while (oIDTokenizer.hasMoreTokens()) {
            this.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()));
        }
        dEROutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)object).identifier);
    }
}

