/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jreepad.JreepadNode;

public class JreepadSearcher {
    JreepadNode root;
    private JreepadSearchResult[] searchResults;
    private Vector searchResultsVec;
    private Object foundObject;
    private static final int articleQuoteMaxLen = 40;

    public JreepadSearcher(JreepadNode root) {
        this.root = root;
    }

    public boolean performSearch(String inNodes, String inArticles, TreePath pathToSearchStart, boolean orNotAnd, boolean caseSensitive, int maxResults) {
        this.searchResults = null;
        this.searchResultsVec = new Vector();
        this.recursiveSearchNode(inNodes, inArticles, (JreepadNode)pathToSearchStart.getLastPathComponent(), pathToSearchStart, orNotAnd, caseSensitive, maxResults);
        this.searchResults = new JreepadSearchResult[this.searchResultsVec.size()];
        for (int i = 0; i < this.searchResults.length; ++i) {
            this.foundObject = this.searchResultsVec.get(i);
            this.searchResults[i] = (JreepadSearchResult)this.foundObject;
        }
        return true;
    }

    private void recursiveSearchNode(String inNodes, String inArticles, JreepadNode thisNode, TreePath pathSoFar, boolean orNotAnd, boolean caseSensitive, int maxResults) {
        boolean itMatches;
        boolean articleMatches;
        if (this.searchResultsVec.size() >= maxResults) {
            return;
        }
        String casedInNodes = caseSensitive ? inNodes : inNodes.toUpperCase();
        String casedInArticles = caseSensitive ? inArticles : inArticles.toUpperCase();
        String casedNode = caseSensitive ? thisNode.getTitle() : thisNode.getTitle().toUpperCase();
        String casedArticle = caseSensitive ? thisNode.getContent() : thisNode.getContent().toUpperCase();
        boolean nodeMatches = inNodes.equals("") || casedNode.indexOf(casedInNodes) != -1;
        boolean bl = articleMatches = inArticles.equals("") || casedArticle.indexOf(casedInArticles) != -1;
        if (inNodes.equals("") && inArticles.equals("")) {
            itMatches = false;
        } else if (inNodes.equals("")) {
            itMatches = articleMatches;
        } else if (inArticles.equals("")) {
            itMatches = nodeMatches;
        } else if (orNotAnd) {
            itMatches = nodeMatches || articleMatches;
        } else {
            boolean bl2 = itMatches = nodeMatches && articleMatches;
        }
        if (itMatches) {
            String quoteText;
            if (!articleMatches) {
                quoteText = thisNode.getContent().length() > 40 ? thisNode.getContent().substring(0, 40) + "..." : thisNode.getContent();
            } else {
                quoteText = "";
                int start = casedArticle.indexOf(casedInArticles);
                if (start > 0) {
                    quoteText = quoteText + "...";
                } else {
                    start = 0;
                }
                String substring = thisNode.getContent();
                quoteText = substring.length() > 40 ? quoteText + substring.substring(0, 40) + "..." : quoteText + thisNode.getContent().substring(start);
            }
            this.searchResultsVec.add(new JreepadSearchResult(pathSoFar, quoteText, thisNode));
        }
        Enumeration<TreeNode> getKids = thisNode.children();
        while (getKids.hasMoreElements()) {
            JreepadNode thisKid = (JreepadNode)getKids.nextElement();
            this.recursiveSearchNode(inNodes, inArticles, thisKid, pathSoFar.pathByAddingChild(thisKid), orNotAnd, caseSensitive, maxResults);
        }
    }

    public JreepadSearchResult[] getSearchResults() {
        return this.searchResults;
    }

    public class JreepadSearchResult {
        private TreePath treePath;
        private String articleQuote;
        private JreepadNode node;

        public JreepadSearchResult(TreePath treePath, String articleQuote, JreepadNode node) {
            this.treePath = treePath;
            this.articleQuote = articleQuote;
            this.node = node;
        }

        public String getArticleQuote() {
            return this.articleQuote;
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public JreepadNode getNode() {
            return this.node;
        }
    }
}

