/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import jreepad.JreepadArticle;
import jreepad.JreepadNode;
import jreepad.JreepadPrefs;
import jreepad.JreepadSearcher;
import jreepad.JreepadTreeModel;
import jreepad.JreepadViewer;
import jreepad.TreeView;
import jreepad.editor.ArticleView;
import jreepad.editor.ContentChangeListener;
import jreepad.editor.EditPopupHandler;
import jreepad.editor.HtmlViewer;
import jreepad.editor.PlainTextEditor;
import jreepad.editor.TableViewer;
import jreepad.editor.TextTransferHandler;
import jreepad.editor.TextileViewer;
import jreepad.ui.FontHelper;

public class JreepadView
extends Box {
    private static JreepadPrefs prefs;
    private JreepadNode root;
    private JreepadNode currentNode;
    private JreepadTreeModel treeModel;
    private TreeView tree;
    private JScrollPane treeView;
    private JScrollPane articlePane;
    private PlainTextEditor editorPanePlainText;
    private HtmlViewer editorPaneHtml;
    private TextileViewer editorPaneTextile;
    private TableViewer editorPaneCsv;
    private EditPopupHandler editPopupHandler = new EditPopupHandler();
    private TextTransferHandler textTransferHandler = new TextTransferHandler();
    private ArticleView currentArticleView;
    private JSplitPane splitPane;
    private JreepadSearcher searcher;
    public static final int CHANGE_ARTICLE_FONT = 1;
    public static final int CHANGE_TREE_FONT = 2;

    public JreepadView() {
        this(new JreepadTreeModel());
    }

    public JreepadView(JreepadTreeModel treeModel) {
        super(0);
        this.treeView = new JScrollPane();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.5);
        if (JreepadView.getPrefs().dividerLocation > 0) {
            this.splitPane.setDividerLocation(JreepadView.getPrefs().dividerLocation);
        }
        this.splitPane.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JreepadView.getPrefs().dividerLocation = JreepadView.this.splitPane.getDividerLocation();
            }
        });
        this.treeModel = treeModel;
        this.root = (JreepadNode)treeModel.getRoot();
        treeModel.addTreeModelListener(new JreepadTreeModelListener());
        this.tree = new TreeView(treeModel);
        this.searcher = new JreepadSearcher(this.root);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JreepadNode node = (JreepadNode)JreepadView.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                JreepadView.this.setCurrentNode(node);
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent kee) {
                int key = kee.getKeyCode();
                switch (key) {
                    case 10: {
                        JreepadView.this.addNodeBelow();
                        break;
                    }
                    case 113: {
                        JreepadView.this.editNodeTitleAction();
                    }
                }
            }
        });
        this.treeView.setViewportView(this.tree);
        this.initEditPopupHandler();
        this.editorPanePlainText = new PlainTextEditor(this.root.getArticle());
        this.initTextComponent((JTextComponent)this.editorPanePlainText.getComponent());
        this.editorPaneHtml = new HtmlViewer(this.root.getArticle());
        this.initTextComponent((JTextComponent)this.editorPaneHtml.getComponent());
        this.editorPaneTextile = new TextileViewer(this.root.getArticle());
        this.initTextComponent((JTextComponent)this.editorPaneTextile.getComponent());
        this.editorPaneCsv = new TableViewer(this.root.getArticle());
        this.currentArticleView = this.editorPanePlainText;
        this.editorPanePlainText.setContentChangeListener(new ContentChangeListener(){

            public void contentChanged() {
                JreepadView.this.treeModel.setContentSaved(false);
            }
        });
        this.articlePane = new JScrollPane(this.editorPanePlainText.getComponent(), 20, 30);
        this.setCurrentNode(this.root);
        this.setViewBoth();
        this.tree.setSelectionRow(0);
    }

    private void initEditPopupHandler() {
        ResourceBundle lang = ResourceBundle.getBundle("jreepad.lang.JreepadStrings");
        this.editPopupHandler.addActionItem(new DefaultEditorKit.CopyAction(), lang.getString("MENUITEM_COPY"), "copy");
        this.editPopupHandler.addActionItem(new DefaultEditorKit.CutAction(), lang.getString("MENUITEM_CUT"), "cut");
        this.editPopupHandler.addActionItem(new DefaultEditorKit.PasteAction(), lang.getString("MENUITEM_PASTE"), "paste");
    }

    private void initTextComponent(JTextComponent textComp) {
        textComp.addMouseListener(this.editPopupHandler);
        textComp.setTransferHandler(this.textTransferHandler);
        textComp.setDragEnabled(true);
    }

    public void changeFont(int direction, int comptype) {
        if (comptype == 1 && this.currentArticleView != null) {
            this.currentArticleView.updateFont(direction);
        }
        if (comptype == 2 && this.tree != null) {
            FontHelper.updateFont(this.tree, direction);
        }
    }

    public void setViewMode(int mode) {
        switch (mode) {
            case 0: {
                this.setViewBoth();
                break;
            }
            case 1: {
                this.setViewTreeOnly();
                break;
            }
            case 2: {
                this.setViewArticleOnly();
                break;
            }
            default: {
                System.err.println("Invalid argument to JreepadView.setViewMode()!");
                return;
            }
        }
        this.setSize(this.getSize());
        this.currentArticleView.getComponent().setPreferredSize(this.articlePane.getViewport().getExtentSize());
        this.currentArticleView.getComponent().setSize(this.articlePane.getViewport().getExtentSize());
        this.validate();
        this.repaint();
    }

    private void setViewBoth() {
        this.ensureCorrectArticleRenderMode();
        this.splitPane.setLeftComponent(this.treeView);
        this.splitPane.setRightComponent(this.articlePane);
        this.add(this.splitPane);
        JreepadView.getPrefs().viewWhich = 0;
    }

    private void setViewTreeOnly() {
        this.remove(this.splitPane);
        this.remove(this.articlePane);
        this.add(this.treeView);
        this.treeView.setSize(this.getSize());
        JreepadView.getPrefs().viewWhich = 1;
    }

    private void setViewArticleOnly() {
        this.remove(this.splitPane);
        this.remove(this.treeView);
        this.ensureCorrectArticleRenderMode();
        this.add(this.articlePane);
        this.articlePane.setSize(this.getSize());
        JreepadView.getPrefs().viewWhich = 2;
    }

    private void setCurrentNode(JreepadNode n) {
        if (this.currentNode == n) {
            return;
        }
        ArticleView oldView = this.currentArticleView;
        oldView.lockEdits();
        this.currentNode = n;
        this.ensureCorrectArticleRenderMode();
        oldView.unlockEdits();
    }

    public JTree getTree() {
        return this.tree;
    }

    public JreepadNode getCurrentNode() {
        return this.currentNode;
    }

    public String getTreepadNodeUrl() {
        StringBuffer ret = new StringBuffer("\"node:/");
        Object[] p = this.tree.getLeadSelectionPath().getPath();
        for (int i = 0; i < p.length; ++i) {
            ret.append("/" + ((JreepadNode)p[i]).getTitle());
        }
        return ret.toString() + "\"";
    }

    public void indentCurrentNode() {
        if (this.currentNode.equals(this.root)) {
            this.notForRootNode();
            return;
        }
        TreePath parentPath = this.tree.getSelectionPath().getParentPath();
        int pos = this.currentNode.getIndex();
        if (pos < 1) {
            return;
        }
        JreepadNode newParent = (JreepadNode)this.currentNode.getParent().getChildAt(pos - 1);
        if (this.currentNode.indent()) {
            this.treeModel.reload(this.currentNode.getParent().getParent());
            parentPath = parentPath.pathByAddingChild(newParent);
            TreePath myPath = parentPath.pathByAddingChild(this.currentNode);
            this.tree.scrollPathToVisible(myPath);
            this.tree.setSelectionPath(myPath);
        }
    }

    public void outdentCurrentNode() {
        if (this.currentNode.equals(this.root)) {
            this.notForRootNode();
            return;
        }
        TreePath parentPath = this.tree.getSelectionPath().getParentPath();
        if (parentPath == null) {
            return;
        }
        TreePath parentParentPath = parentPath.getParentPath();
        if (parentParentPath == null) {
            return;
        }
        if (this.currentNode.outdent()) {
            TreePath myPath = parentParentPath.pathByAddingChild(this.currentNode);
            this.treeModel.reload(this.currentNode.getParent());
            this.tree.scrollPathToVisible(myPath);
            this.tree.setSelectionPath(myPath);
        }
    }

    public void moveCurrentNodeUp() {
        TreePath nodePath = this.tree.getSelectionPath();
        if (this.currentNode.equals(this.root)) {
            this.notForRootNode();
            return;
        }
        this.currentNode.moveUp();
        this.treeModel.reload(this.currentNode.getParent());
        this.tree.setSelectionPath(nodePath);
    }

    public void moveCurrentNodeDown() {
        TreePath nodePath = this.tree.getSelectionPath();
        if (this.currentNode.equals(this.root)) {
            this.notForRootNode();
            return;
        }
        this.currentNode.moveDown();
        this.treeModel.reload(this.currentNode.getParent());
        this.tree.setSelectionPath(nodePath);
    }

    private void notForRootNode() {
        if (!this.root.isLeaf()) {
            return;
        }
        JOptionPane.showMessageDialog(this, JreepadViewer.lang.getString("MSG_ONLY_ON_CHILDNODES"), JreepadViewer.lang.getString("TITLE_ONLY_ON_CHILDNODES"), 1);
    }

    public void insertDate() {
        if (this.currentNode.getArticle().getArticleMode() != 1) {
            return;
        }
        String theDate = JreepadArticle.getCurrentDate();
        this.editorPanePlainText.insertText(theDate);
    }

    public JreepadNode addNodeAbove() {
        int index = this.currentNode.getIndex();
        if (index == -1) {
            this.notForRootNode();
            return null;
        }
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        TreePath parentPath = this.tree.getSelectionPath().getParentPath();
        JreepadNode parent = this.currentNode.getParentNode();
        JreepadNode ret = parent.addChild(index);
        this.treeModel.nodesWereInserted(parent, new int[]{index});
        TreePath newPath = parentPath.pathByAddingChild(ret);
        if (newPath != null) {
            this.tree.startEditingAtPath(newPath);
        }
        return ret;
    }

    public JreepadNode addNodeBelow() {
        int index = this.currentNode.getIndex();
        if (index == -1) {
            this.notForRootNode();
            return null;
        }
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        TreePath parentPath = this.tree.getSelectionPath().getParentPath();
        JreepadNode parent = this.currentNode.getParentNode();
        JreepadNode ret = parent.addChild(index + 1);
        this.treeModel.nodesWereInserted(parent, new int[]{index + 1});
        this.tree.startEditingAtPath(parentPath.pathByAddingChild(ret));
        return ret;
    }

    public JreepadNode addNode() {
        JreepadNode ret = this.currentNode.addChild();
        TreePath nodePath = this.tree.getSelectionPath();
        this.treeModel.nodesWereInserted(this.currentNode, new int[]{this.currentNode.getIndex(ret)});
        this.tree.scrollPathToVisible(nodePath.pathByAddingChild(ret));
        this.tree.startEditingAtPath(nodePath.pathByAddingChild(ret));
        return ret;
    }

    public JreepadNode removeNode() {
        JreepadNode parent = (JreepadNode)this.currentNode.getParent();
        TreePath parentPath = this.tree.getSelectionPath().getParentPath();
        if (parent != null) {
            int index = parent.getIndex(this.currentNode);
            JreepadNode ret = parent.removeChild(index);
            this.tree.setSelectionPath(parentPath);
            this.treeModel.nodesWereRemoved(parent, new int[]{index}, new Object[]{ret});
            this.repaint();
            return ret;
        }
        return null;
    }

    public void sortChildren() {
        this.currentNode.sortChildren();
        this.treeModel.reload(this.currentNode);
    }

    public void sortChildrenRecursive() {
        this.currentNode.sortChildrenRecursive();
        this.treeModel.reload(this.currentNode);
    }

    public void returnFocusToTree() {
        this.tree.requestFocus();
    }

    public void expandAllCurrentNode() {
        this.tree.expandAll(this.currentNode, this.tree.getLeadSelectionPath());
    }

    public void collapseAllCurrentNode() {
        this.tree.collapseAll(this.currentNode, this.tree.getLeadSelectionPath());
    }

    public TreePath[] getAllExpandedPaths() {
        return this.tree.getAllExpandedPaths();
    }

    public void expandPaths(TreePath[] paths) {
        this.tree.expandPaths(paths);
    }

    public boolean performSearch(String inNodes, String inArticles, int searchWhat, boolean orNotAnd, boolean caseSensitive, int maxResults) {
        switch (searchWhat) {
            case 0: {
                this.searcher.performSearch(inNodes, inArticles, this.tree.getSelectionPath(), orNotAnd, caseSensitive, maxResults);
                break;
            }
            default: {
                this.searcher.performSearch(inNodes, inArticles, new TreePath(this.root), orNotAnd, caseSensitive, maxResults);
            }
        }
        return true;
    }

    public JreepadSearcher.JreepadSearchResult[] getSearchResults() {
        return this.searcher.getSearchResults();
    }

    public void addChildrenFromTextFiles(File[] inFiles) throws IOException {
        for (int i = 0; i < inFiles.length; ++i) {
            this.getCurrentNode().addChildFromTextFile(new InputStreamReader((InputStream)new FileInputStream(inFiles[i]), JreepadView.getPrefs().getEncoding()), inFiles[i].getName());
        }
        this.treeModel.reload(this.currentNode);
        this.tree.expandPath(this.tree.getSelectionPath());
    }

    public void addChild(JreepadNode newKid) {
        this.getCurrentNode().add(newKid);
        this.treeModel.reload(this.currentNode);
        this.tree.expandPath(this.tree.getSelectionPath());
    }

    public void addChildrenFromListTextFile(InputStreamReader inFile) throws IOException {
        String curLine;
        BufferedReader bReader = new BufferedReader(inFile);
        while ((curLine = bReader.readLine()) != null) {
            if (curLine.trim().length() <= 0) continue;
            this.getCurrentNode().add(new JreepadNode(curLine.trim(), ""));
        }
        this.treeModel.reload(this.currentNode);
        this.tree.expandPath(this.tree.getSelectionPath());
    }

    public static JreepadPrefs getPrefs() {
        return prefs;
    }

    public static void setPrefs(JreepadPrefs thesePrefs) {
        prefs = thesePrefs;
        prefs.save();
    }

    public void webSearchTextSelectedInArticle() {
        String url = this.currentArticleView.getSelectedText();
        if (url == null || url.length() == 0) {
            url = this.currentNode.getTitle();
        }
        if (url == null && this.currentNode.getArticle().getArticleMode() == 1) {
            url = this.editorPanePlainText.selectWordUnderCursor();
        }
        if (url == null || url.length() <= 0) {
            url = this.currentNode.getTitle();
        }
        this.webSearchText(url);
    }

    public void webSearchText(String text) {
        this.openURL("http://" + JreepadView.getPrefs().webSearchPrefix + text + JreepadView.getPrefs().webSearchPostfix);
    }

    public void openURLSelectedInArticle() {
        String url = this.currentArticleView.getSelectedText();
        if (url == null && this.currentNode.getArticle().getArticleMode() == 1) {
            url = this.editorPanePlainText.selectWordUnderCursor();
        }
        this.openURL(url);
    }

    public static boolean isPureWord(String in) {
        char[] c = in.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != ':' && c[i] != '/' && c[i] != '[' && c[i] != ']') continue;
            return false;
        }
        return true;
    }

    public static boolean isWikiWord(String in) {
        if (in.length() > 4 && in.startsWith("[[") && in.endsWith("]]")) {
            return true;
        }
        char[] c = in.toCharArray();
        int uppers = 0;
        boolean currentlyUpper = false;
        for (int i = 0; i < c.length; ++i) {
            if (!Character.isLetter(c[i])) {
                return false;
            }
            if (i == 0 && !Character.isUpperCase(c[i])) {
                return false;
            }
            if (currentlyUpper && Character.isLowerCase(c[i])) {
                currentlyUpper = false;
                ++uppers;
                continue;
            }
            if (currentlyUpper || !Character.isUpperCase(c[i])) continue;
            currentlyUpper = true;
        }
        return uppers > 1;
    }

    public void openURL(String url) {
        if (url == null || url == "") {
            return;
        }
        if (JreepadView.isWikiWord(url = url.trim())) {
            this.followWikiLink(url, JreepadView.prefs.wikiBehaviourActive);
            return;
        }
        if (JreepadView.isPureWord(url)) {
            if (JreepadView.prefs.defaultSearchMode == 0) {
                this.webSearchText(url);
            } else {
                this.followWikiLink(url, false);
            }
            return;
        }
        if (url.length() > 2 && url.startsWith("\"") && url.endsWith("\"")) {
            url = url.substring(1, url.length() - 1);
        }
        if (url.startsWith("node://")) {
            if (!this.followTreepadInternalLink(url)) {
                JOptionPane.showMessageDialog(this, JreepadViewer.lang.getString("MSG_NODE_NOT_FOUND"), JreepadViewer.lang.getString("TITLE_NODE_NOT_FOUND"), 0);
            }
            return;
        }
        char[] curl = url.toCharArray();
        StringBuffer surl = new StringBuffer();
        for (int i = 0; i < curl.length; ++i) {
            if (curl[i] == ' ') {
                surl.append("%20");
                continue;
            }
            surl.append(curl[i]);
        }
        try {
            new BrowserLauncher(null).openURLinBrowser(surl.toString());
        }
        catch (BrowserLaunchingInitializingException e) {
            this.displayBrowserLauncherException(e, surl.toString());
        }
        catch (BrowserLaunchingExecutionException e) {
            this.displayBrowserLauncherException(e, surl.toString());
        }
        catch (UnsupportedOperatingSystemException e) {
            this.displayBrowserLauncherException(e, surl.toString());
        }
    }

    private void displayBrowserLauncherException(Exception e, String url) {
        JOptionPane.showMessageDialog(this, "Error while opening URL:\n" + url + "\n" + e.getMessage() + "\n\n" + "The \"BrowserLauncher\" used to open a URL is an open-source Java library \n" + "separate from Jreepad itself - i.e. a separate Sourceforge project. \n" + "It may be a good idea to submit a bug report to\n" + "http://browserlaunch2.sourceforge.net/\n\n" + "If you do, please remember to supply information about the operating system\n" + "you are using - which type, and which version.", "Error", 0);
    }

    public boolean followTreepadInternalLink(String url) {
        url = url.substring(7);
        Vector<String> pathNames = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        char[] curl = url.toCharArray();
        for (int i = 0; i < curl.length; ++i) {
            if (curl[i] == '/') {
                pathNames.add(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            buf.append(curl[i]);
        }
        if (buf.length() > 0) {
            pathNames.add(buf.toString());
        }
        if (pathNames.size() < 1 || !((String)pathNames.get(0)).equals(this.root.getTitle())) {
            return false;
        }
        TreePath goTo = new TreePath(this.root);
        JreepadNode nextNode = this.root;
        for (int i = 1; i < pathNames.size(); ++i) {
            if ((nextNode = nextNode.getChildByTitle((String)pathNames.get(i))) == null) {
                return false;
            }
            goTo = goTo.pathByAddingChild(nextNode);
        }
        this.tree.setSelectionPath(goTo);
        this.tree.scrollPathToVisible(goTo);
        return true;
    }

    public void followWikiLink(String text, boolean noNeedToConfirm) {
        TreePath tp;
        if (text.length() > 4 && text.startsWith("[[") && text.endsWith("]]")) {
            text = text.substring(2, text.length() - 2);
        }
        if ((tp = this.findNearestNodeTitled(text)) == null) {
            if (noNeedToConfirm || JOptionPane.showConfirmDialog(this, JreepadViewer.lang.getString("TITLE_NODE_NOT_FOUND_PROMPT_CREATE"), JreepadViewer.lang.getString("MSG_NODE_NOT_FOUND"), 0, 0) == 0) {
                JreepadNode newNode = new JreepadNode(text, "");
                this.addChild(newNode);
                TreePath leadPath = this.tree.getLeadSelectionPath();
                TreePath newPath = leadPath != null ? leadPath.pathByAddingChild(newNode) : new TreePath(newNode);
                this.tree.setSelectionPath(newPath);
                this.tree.scrollPathToVisible(newPath);
            }
        } else {
            this.tree.setSelectionPath(tp);
        }
    }

    public TreePath findNearestNodeTitled(String text) {
        for (TreePath curPath = this.tree.getLeadSelectionPath(); curPath != null && curPath.getPathCount() > 0; curPath = curPath.getParentPath()) {
            TreePath tp = this.findChildTitled(text, curPath);
            if (tp == null) continue;
            return tp;
        }
        return null;
    }

    public TreePath findChildTitled(String text) {
        return this.findChildTitled(text, this.tree.getLeadSelectionPath());
    }

    public TreePath findChildTitled(String text, TreePath pathToNode) {
        JreepadNode myNode = (JreepadNode)pathToNode.getLastPathComponent();
        for (int i = 0; i < myNode.getChildCount(); ++i) {
            JreepadNode myChild = (JreepadNode)myNode.getChildAt(i);
            TreePath childPath = pathToNode.pathByAddingChild(myChild);
            if (myChild.getTitle().equals(text)) {
                return childPath;
            }
            if ((childPath = this.findChildTitled(text, childPath)) == null) continue;
            return childPath;
        }
        return null;
    }

    public void wrapContentToCharWidth(int charWidth) {
        this.currentNode.getArticle().wrapContentToCharWidth(charWidth);
        this.currentArticleView.reloadArticle();
    }

    public void stripAllTags() {
        this.currentNode.getArticle().stripAllTags();
        this.currentArticleView.reloadArticle();
    }

    public void setArticleMode(int newMode) {
        ArticleView oldView = this.currentArticleView;
        oldView.lockEdits();
        this.currentNode.getArticle().setArticleMode(newMode);
        this.ensureCorrectArticleRenderMode();
        this.currentArticleView.getComponent().repaint();
        oldView.unlockEdits();
    }

    public void ensureCorrectArticleRenderMode() {
        switch (this.currentNode.getArticle().getArticleMode()) {
            case 1: {
                this.currentArticleView = this.editorPanePlainText;
                break;
            }
            case 2: {
                this.currentArticleView = this.editorPaneHtml;
                break;
            }
            case 4: {
                this.currentArticleView = this.editorPaneTextile;
                break;
            }
            case 3: {
                this.currentArticleView = this.editorPaneCsv;
                break;
            }
            default: {
                System.err.println("getEditorPaneComponent() says: JreepadNode.getArticleMode() returned an unrecognised value");
                this.currentArticleView = null;
            }
        }
        this.currentArticleView.setArticle(this.currentNode.getArticle());
        this.articlePane.setViewportView(this.currentArticleView.getComponent());
    }

    public void editNodeTitleAction() {
        if (JreepadView.getPrefs().viewWhich == 2) {
            this.setViewMode(0);
        }
        this.tree.startEditingAtPath(this.tree.getSelectionPath());
    }

    class JreepadTreeModelListener
    implements TreeModelListener {
        JreepadTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            JreepadView.this.treeModel.setContentSaved(false);
            JreepadView.this.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            JreepadView.this.treeModel.setContentSaved(false);
            JreepadView.this.tree.expandPath(e.getTreePath());
            JreepadView.this.tree.scrollPathToVisible(e.getTreePath());
            JreepadView.this.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            JreepadView.this.treeModel.setContentSaved(false);
            JreepadView.this.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            JreepadView.this.treeModel.setContentSaved(false);
            JreepadView.this.tree.repaint();
        }
    }
}

