/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadWriter;

public class TreepadWriter
implements JreepadWriter {
    private String encoding;

    public TreepadWriter(String encoding) {
        this.encoding = encoding;
    }

    public void write(OutputStream out, JreepadTreeModel document) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.encoding);
        writer.write("<Treepad version 2.7>\n");
        this.writeNode(writer, document.getRootNode(), 0);
        ((Writer)writer).close();
    }

    private void writeNode(Writer writer, JreepadNode node, int depth) throws IOException {
        writer.write("dt=Text\n<node>\n");
        writer.write(node.getTitle());
        writer.write("\n");
        writer.write(depth + "\n");
        writer.write(node.getContent());
        writer.write("\n");
        writer.write("<end node> 5P9i0s8y19Z\n");
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            this.writeNode(writer, (JreepadNode)kids.nextElement(), depth + 1);
        }
    }
}

