/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.testing;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.BrowserLauncherRunner;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.testing.TestAppLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BrowserLauncherTestApp
extends JFrame {
    private static final String debugResources = "edu.stanford.ejalbert.resources.Debugging";
    private TestAppLogger logger;
    private JPanel urlPanel = new JPanel();
    private JComboBox browserBox = new JComboBox();
    private JButton browseButton = new JButton();
    private JLabel enterUrlLabel = new JLabel();
    private JLabel debugLevelLabel = new JLabel();
    private JButton loggingLevelBttn = new JButton();
    private JLabel loggingLevelTxtFld = new JLabel();
    private JTextField urlTextField = new JTextField();
    private BrowserLauncher launcher;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextArea debugTextArea = new JTextArea();
    private JPanel debugTextBttnPanel = new JPanel();
    private BoxLayout bttnBoxLayout = new BoxLayout(this.debugTextBttnPanel, 0);
    private JScrollPane debugTextScrollPane = new JScrollPane();
    private JButton copyButton = new JButton();
    private ResourceBundle bundle;
    private BorderLayout urlPaneLayout = new BorderLayout();

    public BrowserLauncherTestApp() {
        try {
            this.bundle = ResourceBundle.getBundle(debugResources);
            String[] levelLabels = this.bundle.getString("logging.level.labels").split(";");
            this.logger = new TestAppLogger(this.debugTextArea, levelLabels, this.bundle.getString("logging.dateformat"));
            this.loggingLevelTxtFld.setText(this.logger.getLevelText());
            super.setTitle(this.bundle.getString("label.app.title"));
            this.jbInit();
            this.populateDebugInfo(this.bundle, this.debugTextArea);
            this.launcher = new BrowserLauncher(this.logger);
            DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(this.launcher.getBrowserList().toArray());
            this.browserBox.setModel(cbModel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BrowserLauncherTestApp app = new BrowserLauncherTestApp();
        app.pack();
        app.setVisible(true);
    }

    private void populateDebugInfo(ResourceBundle bundle, JTextArea debugTextArea) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println(bundle.getString("debug.mssg"));
        printWriter.println();
        StringTokenizer tokenizer = new StringTokenizer(bundle.getString("debug.propnames"), ";", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int pipeSymbol = token.indexOf(124);
            String display = token.substring(0, pipeSymbol);
            String property = token.substring(pipeSymbol + 1);
            printWriter.print(display);
            printWriter.println(System.getProperty(property));
        }
        printWriter.close();
        debugTextArea.append(stringWriter.toString());
    }

    private void jbInit() throws Exception {
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.browseButton_actionPerformed(e);
            }
        });
        this.browseButton.setText(this.bundle.getString("bttn.browse"));
        this.enterUrlLabel.setText(this.bundle.getString("label.url"));
        this.urlTextField.setText(this.bundle.getString("url.default"));
        this.urlTextField.setColumns(25);
        this.urlPanel.setLayout(this.urlPaneLayout);
        this.urlPanel.add((Component)this.enterUrlLabel, "Before");
        this.urlPanel.add((Component)this.urlTextField, "Center");
        this.urlPanel.add((Component)this.browseButton, "After");
        this.debugTextArea.setEditable(false);
        this.debugTextArea.setLineWrap(true);
        this.debugTextArea.setWrapStyleWord(true);
        this.debugTextArea.setText("");
        this.debugTextScrollPane.getViewport().add(this.debugTextArea);
        this.debugLevelLabel.setText(this.bundle.getString("label.logging.level"));
        this.loggingLevelBttn.setText(this.bundle.getString("bttn.set.logging"));
        this.loggingLevelBttn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.loggingLevelBttn_actionPerformed(e);
            }
        });
        this.copyButton.setText(this.bundle.getString("bttn.copy"));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.copyButton_actionPerformed(e);
            }
        });
        this.debugTextBttnPanel.setLayout(this.bttnBoxLayout);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        this.debugTextBttnPanel.add(this.browserBox);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        this.debugTextBttnPanel.add(this.debugLevelLabel);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(3));
        this.debugTextBttnPanel.add(this.loggingLevelTxtFld);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(5));
        this.debugTextBttnPanel.add(Box.createHorizontalGlue());
        this.debugTextBttnPanel.add(this.loggingLevelBttn);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(3));
        this.debugTextBttnPanel.add(this.copyButton);
        this.debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.debugTextScrollPane, "Center");
        this.getContentPane().add((Component)this.urlPanel, "North");
        this.getContentPane().add((Component)this.debugTextBttnPanel, "South");
        this.getRootPane().setDefaultButton(this.browseButton);
        this.setDefaultCloseOperation(3);
    }

    private static void updateDebugTextArea(Exception exception, JTextArea debugTextArea) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println();
        exception.printStackTrace(printWriter);
        printWriter.println();
        printWriter.close();
        debugTextArea.append(stringWriter.toString());
    }

    private void browseButton_actionPerformed(ActionEvent e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("browse button clicked");
        }
        try {
            String urlString = this.urlTextField.getText();
            if (urlString == null || urlString.trim().length() == 0) {
                throw new MalformedURLException("You must specify a url.");
            }
            new URL(urlString);
            TestAppErrorHandler errorHandler = new TestAppErrorHandler(this.debugTextArea);
            String targetBrowser = this.browserBox.getSelectedItem().toString();
            this.logger.debug(targetBrowser);
            BrowserLauncherRunner runner = new BrowserLauncherRunner(this.launcher, targetBrowser, urlString, errorHandler);
            Thread launcherThread = new Thread(runner);
            launcherThread.start();
        }
        catch (Exception ex) {
            BrowserLauncherTestApp.updateDebugTextArea(ex, this.debugTextArea);
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error Message", 0);
        }
    }

    private void copyButton_actionPerformed(ActionEvent e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("copy button clicked");
        }
        this.debugTextArea.selectAll();
        this.debugTextArea.copy();
        this.debugTextArea.select(0, 0);
    }

    private void loggingLevelBttn_actionPerformed(ActionEvent e) {
        Object[] levels = this.logger.getLevelOptions();
        int levelIndex = this.logger.getLevel();
        String level = (String)JOptionPane.showInputDialog(this, this.bundle.getString("logging.level.select.message"), this.bundle.getString("logging.level.select.title"), 3, null, levels, levels[levelIndex]);
        if (level != null && level.length() > 0) {
            levelIndex = -1;
            int max = levels.length;
            for (int idx = 0; idx < max && levelIndex == -1; ++idx) {
                if (!level.equals(levels[idx])) continue;
                levelIndex = idx;
            }
            this.logger.setLevel(levelIndex);
            this.loggingLevelTxtFld.setText(this.logger.getLevelText());
        }
    }

    private static class TestAppErrorHandler
    implements BrowserLauncherErrorHandler {
        private JTextArea debugTextArea;

        TestAppErrorHandler(JTextArea debugTextArea) {
            this.debugTextArea = debugTextArea;
        }

        public void handleException(Exception ex) {
            BrowserLauncherTestApp.updateDebugTextArea(ex, this.debugTextArea);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "Error Message", 0);
        }
    }
}

