/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public abstract class AbstractListTableModel<T>
extends AbstractTableModel
implements Iterable<T>,
Lockable,
UI.EventsControl {
    private boolean eventsEnabled = true;
    private boolean locked;
    private boolean undoInProgress;
    private ColumnInfo[] columnInfo;
    private int columnCount;
    private List<T> backend;
    private UndoableEditSupport undoSupport;

    public AbstractListTableModel(int n) {
        this(n, new ArrayList(100));
    }

    public AbstractListTableModel(int n, List<T> list) {
        this.columnCount = n;
        this.backend = TK.checkNull(list, "backend");
    }

    public AbstractListTableModel(ColumnInfo ... columnInfoArray) {
        this(new ArrayList(100), columnInfoArray);
    }

    public AbstractListTableModel(List<T> list, ColumnInfo ... columnInfoArray) {
        this(columnInfoArray.length, list);
        this.setColumnInfo(columnInfoArray);
    }

    public void addRow(T t) {
        this.backend.add(t);
        if (this.eventsEnabled) {
            int n = this.backend.size() - 1;
            T t2 = this.createCopyForUndo(t);
            this.fireTableRowsInserted(n, n);
            if (t2 != null) {
                this.fireUndoableEditHappened(new InsertUndo(t2, n));
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this.undoSupport == null) {
            this.undoSupport = new UndoableEditSupport();
        }
        this.undoSupport.addUndoableEditListener(undoableEditListener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        if (this.undoSupport != null) {
            return this.undoSupport.getUndoableEditListeners();
        }
        return MUndoManager.EMPTY_UNDOABLE_EDIT_LISTENER_ARRAY;
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this.undoSupport != null) {
            this.undoSupport.removeUndoableEditListener(undoableEditListener);
        }
    }

    public void clear() {
        if (this.backend.isEmpty()) {
            return;
        }
        int n = this.backend.size();
        List<T> list = this.eventsEnabled ? this.createCopyForUndo(0, n) : null;
        this.backend.clear();
        if (this.eventsEnabled) {
            this.fireTableRowsDeleted(0, n - 1);
            if (list != null) {
                this.fireUndoableEditHappened(new RemoveUndo(list, 0));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnInfo == null ? super.getColumnClass(n) : this.columnInfo[n].getColumnClass();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public ColumnInfo[] getColumnInfo() {
        if (this.columnInfo == null) {
            return new ColumnInfo[0];
        }
        return TK.copyOf(this.columnInfo);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnInfo == null ? super.getColumnName(n) : this.columnInfo[n].getName();
    }

    @Override
    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    @Override
    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    public T getRowAt(int n) {
        return this.backend.get(n);
    }

    @Override
    public int getRowCount() {
        return this.backend.size();
    }

    public List<T> getRows() {
        return this.backend;
    }

    public void insertRow(int n, T t) {
        this.backend.add(n, t);
        if (this.eventsEnabled) {
            T t2 = this.createCopyForUndo(t);
            this.fireTableRowsInserted(n, n);
            if (t2 != null) {
                this.fireUndoableEditHappened(new InsertUndo(t2, n));
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.locked) {
            return false;
        }
        return this.columnInfo == null ? true : this.columnInfo[n2].isEditable();
    }

    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    public void removeRow(int n) {
        List<T> list = this.eventsEnabled ? this.createCopyForUndo(n, 1) : null;
        this.backend.remove(n);
        if (this.eventsEnabled) {
            this.fireTableRowsDeleted(n, n);
            if (list != null) {
                this.fireUndoableEditHappened(new RemoveUndo(list, n));
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.backend.iterator();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    protected T createCopyForUndo(T t) {
        return t;
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        if (this.undoInProgress) {
            return;
        }
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(undoableEdit);
        }
    }

    protected void setColumnInfo(ColumnInfo ... columnInfoArray) {
        if (columnInfoArray.length == 0) {
            throw new IllegalArgumentException("Empty \"columnInfo\" array");
        }
        this.columnCount = columnInfoArray.length;
        this.columnInfo = new ColumnInfo[columnInfoArray.length];
        for (int i = 0; i < columnInfoArray.length; ++i) {
            this.columnInfo[i] = columnInfoArray[i];
            this.columnInfo[i].setModelIndex(i);
        }
    }

    private List<T> createCopyForUndo(int n, int n2) {
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.createCopyForUndo(this.backend.get(n3)));
            ++n3;
        }
        return arrayList;
    }

    private void doChange(RedoAction redoAction) {
        try {
            this.undoInProgress = true;
            redoAction.redo();
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            throw new CannotRedoException();
        }
        finally {
            this.undoInProgress = false;
        }
    }

    private void doChange(UndoAction undoAction) {
        try {
            this.undoInProgress = true;
            undoAction.undo();
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            throw new CannotUndoException();
        }
        finally {
            this.undoInProgress = false;
        }
    }

    private static interface UndoAction {
        public void undo();
    }

    private static interface RedoAction {
        public void redo();
    }

    public final class RemoveUndo
    extends AbstractUndoableEdit {
        private final int row;
        private final List<T> data;

        public RemoveUndo(List<T> list, int n) {
            this.data = list;
            this.row = n;
        }

        @Override
        public void redo() {
            super.redo();
            AbstractListTableModel.this.doChange(new RedoAction(){

                @Override
                public void redo() {
                    int n = RemoveUndo.this.data.size();
                    for (int i = RemoveUndo.this.row + n - 1; i >= RemoveUndo.this.row; --i) {
                        AbstractListTableModel.this.removeRow(i);
                    }
                }
            });
        }

        @Override
        public void undo() {
            super.undo();
            AbstractListTableModel.this.doChange(new UndoAction(){

                @Override
                public void undo() {
                    int n = RemoveUndo.this.row;
                    for (Object e : RemoveUndo.this.data) {
                        AbstractListTableModel.this.insertRow(n, e);
                        ++n;
                    }
                }
            });
        }
    }

    public final class InsertUndo
    extends AbstractUndoableEdit {
        private final int row;
        private final T data;

        public InsertUndo(T t, int n) {
            this.data = t;
            this.row = n;
        }

        @Override
        public void redo() {
            super.redo();
            AbstractListTableModel.this.doChange(new RedoAction(){

                @Override
                public void redo() {
                    AbstractListTableModel.this.insertRow(InsertUndo.this.row, InsertUndo.this.data);
                }
            });
        }

        @Override
        public void undo() {
            super.undo();
            AbstractListTableModel.this.doChange(new UndoAction(){

                @Override
                public void undo() {
                    AbstractListTableModel.this.removeRow(InsertUndo.this.row);
                }
            });
        }
    }

    public final class ChangeUndo
    extends AbstractUndoableEdit {
        private final int row;
        private final T after;
        private final T before;

        public ChangeUndo(T t, T t2, int n) {
            this.before = t;
            this.after = t2;
            this.row = n;
        }

        @Override
        public void redo() {
            super.redo();
            AbstractListTableModel.this.doChange(new RedoAction(){

                @Override
                public void redo() {
                    AbstractListTableModel.this.backend.set(ChangeUndo.this.row, ChangeUndo.this.after);
                    AbstractListTableModel.this.fireTableRowsUpdated(ChangeUndo.this.row, ChangeUndo.this.row);
                }
            });
        }

        @Override
        public void undo() {
            super.undo();
            AbstractListTableModel.this.doChange(new UndoAction(){

                @Override
                public void undo() {
                    AbstractListTableModel.this.backend.set(ChangeUndo.this.row, ChangeUndo.this.before);
                    AbstractListTableModel.this.fireTableRowsUpdated(ChangeUndo.this.row, ChangeUndo.this.row);
                }
            });
        }
    }

    public static class ColumnInfo
    extends TableColumn {
        private final boolean editable;
        private final Class<?> columnClass;
        private final String name;

        public ColumnInfo(String string) {
            this(string, Object.class, true, null);
        }

        public ColumnInfo(String string, boolean bl) {
            this(string, Object.class, bl, null);
        }

        public ColumnInfo(String string, boolean bl, String string2) {
            this(string, Object.class, bl, string2);
        }

        public ColumnInfo(String string, Class<?> clazz) {
            this(string, clazz, true, null);
        }

        public ColumnInfo(String string, Class<?> clazz, boolean bl) {
            this(string, clazz, bl, null);
        }

        public ColumnInfo(String string, Class<?> clazz, boolean bl, String string2) {
            this.name = string;
            this.columnClass = TK.checkNull(clazz, "columnClass");
            this.editable = bl;
            if (string2 != null) {
                this.setIdentifier(string2);
            }
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

