/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.text.ParseException;
import org.makagiga.commons.Property;

public class BooleanProperty
extends Property<Boolean> {
    public BooleanProperty() {
        super(false);
    }

    public BooleanProperty(boolean bl) {
        super(bl);
    }

    public BooleanProperty(String string) throws ParseException {
        this.parse(string);
        this.setDefaultValue(this.get());
    }

    public boolean booleanValue() {
        return Boolean.TRUE.equals(this.get());
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    public void no() {
        this.set(false);
    }

    @Override
    public void parse(String string) throws ParseException {
        this.set(BooleanProperty.parseBoolean(string));
    }

    public static boolean parseBoolean(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("\"value\" is null", 0);
        }
        return string.equals("1") || Boolean.parseBoolean(string);
    }

    public void toggle() {
        this.set((Boolean)this.get() == false);
    }

    public void yes() {
        this.set(true);
    }
}

