/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import org.makagiga.commons.Args;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.FileScanner;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Item;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.OS;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public final class FS {
    public static final FileFilter DIRECTORY_FILTER = new DirectoryFilter();
    public static final int COPY_BUF_LENGTH = 4096;
    public static final int CREATE_DIR = 1;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final FileFilter FILE_FILTER = new RegularFileFilter();
    public static final int LIST_ALL_FILE_SYSTEMS = 1;
    public static final int LIST_MOUNTED_FILE_SYSTEMS = 2;
    public static final int LIST_EXCLUDE_SPECIAL = 4;
    private static boolean portable;
    private static String baseDir;
    private static String configDir;
    private static String profile;
    private static String userDir;
    static boolean restricted;

    public static void append(File file, String string) throws IOException {
        FS.write(new FileOutputStream(file, true), string);
    }

    public static boolean close(Closeable closeable) {
        if (closeable == null) {
            return false;
        }
        try {
            closeable.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void copyChars(Reader reader, Writer writer) throws IOException {
        FS.copyChars(reader, writer, 4096);
    }

    public static void copyChars(Reader reader, Writer writer, int n) throws IOException {
        int n2;
        char[] cArray = new char[n];
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FS.copyFile(file, file2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, ProgressListener progressListener) throws IOException {
        BufferedFileOutput bufferedFileOutput;
        BufferedFileInput bufferedFileInput;
        block3: {
            bufferedFileInput = null;
            bufferedFileOutput = null;
            try {
                bufferedFileInput = new BufferedFileInput(file);
                bufferedFileOutput = new BufferedFileOutput(file2);
                if (progressListener == null) {
                    FS.copyStream(bufferedFileInput, bufferedFileOutput);
                    break block3;
                }
                FS.copyStream(bufferedFileInput, bufferedFileOutput, 4096, file.length(), progressListener);
            }
            catch (Throwable throwable) {
                FS.close(bufferedFileInput);
                FS.close(bufferedFileOutput);
                throw throwable;
            }
        }
        FS.close(bufferedFileInput);
        FS.close(bufferedFileOutput);
    }

    public static void copyFile(String string, String string2) throws IOException {
        FS.copyFile(new File(string), new File(string2));
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        FS.copyStream(inputStream, outputStream, 4096, -1L, null);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n, long l, ProgressListener progressListener) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            if (outputStream != null) {
                outputStream.write(byArray, 0, n2);
            }
            if (progressListener == null || progressListener.updateProgress(l2 += (long)n2, l)) continue;
            break;
        }
    }

    public static File createUniqueFile(File file, String string) throws IOException {
        File file2;
        String string2 = TK.createRandomUUID();
        if (!TK.isEmpty(string)) {
            string2 = string2 + string;
        }
        if (!(file2 = new File(file, string2)).createNewFile()) {
            throw new IOException("Cannot create unique file");
        }
        return file2;
    }

    public static boolean deleteDir(File file, boolean bl) {
        final BooleanProperty booleanProperty = new BooleanProperty(true);
        try {
            new FileScanner.Simple(file, null){

                @Override
                public void processFile(File file) throws Exception {
                    if (!file.delete()) {
                        booleanProperty.no();
                    }
                }

                @Override
                public void processParentDir(Object object, File file) throws Exception {
                    if (!file.delete()) {
                        booleanProperty.no();
                    }
                }
            };
            if (bl && !file.delete()) {
                booleanProperty.no();
            }
            return (Boolean)booleanProperty.get();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean deleteDir(String string, boolean bl) {
        return FS.deleteDir(new File(string), bl);
    }

    public static boolean deleteFile(String string) {
        return new File(string).delete();
    }

    public static boolean deleteFiles(File file, RegExp regExp) {
        File[] fileArray;
        for (File file2 : fileArray = FS.listFiles(file)) {
            if (regExp != null && !regExp.matches(file2.getName()) || file2.delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteFiles(String string, RegExp regExp) {
        return FS.deleteFiles(new File(string), regExp);
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static synchronized String getBaseDir() {
        if (baseDir != null) {
            return baseDir;
        }
        ProtectionDomain protectionDomain = FS.class.getProtectionDomain();
        if (protectionDomain == null) {
            baseDir = "";
            return baseDir;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            baseDir = "";
            return baseDir;
        }
        try {
            URL uRL = codeSource.getLocation();
            if (uRL == null) {
                baseDir = "";
                return baseDir;
            }
            File file = new File(codeSource.getLocation().toURI());
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            baseDir = file == null ? "" : file.getPath();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MLogger.exception(illegalArgumentException);
            baseDir = "";
        }
        catch (URISyntaxException uRISyntaxException) {
            MLogger.exception(uRISyntaxException);
            baseDir = "";
        }
        return baseDir;
    }

    public static String getBaseName(String string) {
        if (TK.isEmpty(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    public static synchronized String getConfigDir() {
        if (restricted) {
            throw new IllegalStateException("Restricted mode");
        }
        if (configDir == null) {
            Object object;
            portable = Args.isSet("portable");
            if (portable) {
                configDir = FS.getBaseDir();
                if (configDir.isEmpty()) {
                    MMessage.error(null, "Could not initialize \"portable\" folder");
                    portable = false;
                } else {
                    object = new File(configDir, "portable");
                    ((File)object).mkdirs();
                    if (!((File)object).exists() || !((File)object).canWrite()) {
                        MMessage.error(null, "Could not initialize \"portable\" folder\n" + object);
                        portable = false;
                    }
                    configDir = ((File)object).getPath();
                }
            }
            if (!portable) {
                configDir = FS.makePath(FS.getUserDir(), "." + MApplication.getInternalName());
                object = new File(configDir);
                ((File)object).mkdirs();
                if (!((File)object).exists()) {
                    String string = "Could not initialize configuration directory\n" + configDir;
                    MMessage.error(null, string);
                    throw new WTFError(string);
                }
            }
            if (TK.isEmpty((String)(object = Args.getOption("user-files")))) {
                object = System.getenv("MAKAGIGA_USER_FILES");
            }
            File file = TK.isEmpty((String)object) ? null : new File((String)object);
            boolean bl = false;
            if (file != null) {
                if (file.exists()) {
                    if (file.isDirectory()) {
                        bl = true;
                    } else {
                        MMessage.error(null, "Directory expected\n" + file);
                    }
                } else {
                    MMessage.error(null, String.format("Directory \"%s\"\ndoes not exist", file.getPath()));
                }
            }
            if (bl) {
                profile = configDir = file.getPath();
            } else {
                profile = Args.getOption("profile");
                if (TK.isEmpty(profile)) {
                    profile = System.getenv("MAKAGIGA_PROFILE");
                }
                if (TK.isEmpty(profile)) {
                    profile = null;
                } else {
                    if (profile.contains("\\") || profile.contains("/") || profile.contains(".")) {
                        MMessage.error(null, "Invalid profile name: " + profile);
                        profile = null;
                        return configDir;
                    }
                    File file2 = new File(FS.makePath(FS.makePath(configDir, "profiles"), profile));
                    file2.mkdirs();
                    if (file2.exists()) {
                        MLogger.info("core", "Profile directory: \"%s\"", file2.getPath());
                        configDir = file2.getPath();
                    } else {
                        profile = null;
                    }
                }
            }
            MLogger.info("core", "Configuration root directory: \"%s\"", configDir);
        }
        return configDir;
    }

    public static synchronized void setConfigDir(String string) {
        if (configDir != null) {
            throw new IllegalStateException("Configuration directory already set");
        }
        if (!FS.exists(configDir)) {
            throw new IllegalArgumentException(String.format("Directory \"%s\"\ndoes not exist", string));
        }
        configDir = string;
        restricted = false;
    }

    public static String getExtension(File file) {
        return FS.getExtension(file.getPath());
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n == 0) {
            return null;
        }
        if (string.charAt(n - 1) == File.separatorChar) {
            return null;
        }
        return n == string.length() - 1 ? null : string.substring(n + 1);
    }

    public static String getInstallPrefix(String string) {
        String string2;
        if (OS.isLinux() && !(string2 = FS.getBaseDir()).isEmpty()) {
            File file = new File(string2);
            if ((file = file.getParentFile()) != null && (file = file.getParentFile()) != null) {
                MLogger.debug("fs", "Found Install Prefix: %s", file);
                return file.getPath();
            }
        }
        return string;
    }

    public static String getPlatformConfigPath(String string) {
        String string2 = string;
        string2 = string2.replace('\\', File.separatorChar);
        string2 = string2.replace('/', File.separatorChar);
        string2 = FS.makeConfigPath(string2);
        return string2;
    }

    public static String getPortableConfigPath(String string) {
        String string2 = FS.getConfigDir();
        if (string.startsWith(string2)) {
            string = string.substring(string2.length() + 1);
        }
        return string.replace('\\', '/');
    }

    public static String getProfile() {
        return profile;
    }

    public static synchronized String getUserDir() {
        if (userDir == null) {
            userDir = FS.getAbsolute(System.getProperty("user.home"));
            MLogger.info("core", "User directory: \"%s\"", userDir);
        }
        return userDir;
    }

    public static TextReader getUTF8Reader(File file) throws FileNotFoundException {
        return FS.getUTF8Reader(new FileInputStream(file));
    }

    public static TextReader getUTF8Reader(InputStream inputStream) {
        try {
            return new TextReader(inputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            return null;
        }
    }

    public static TextReader getUTF8Reader(String string) throws FileNotFoundException {
        return FS.getUTF8Reader(new FileInputStream(string));
    }

    public static TextWriter getUTF8Writer(File file) throws FileNotFoundException {
        return FS.getUTF8Writer(new FileOutputStream(file));
    }

    public static TextWriter getUTF8Writer(OutputStream outputStream) {
        try {
            return new TextWriter(outputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            return null;
        }
    }

    public static TextWriter getUTF8Writer(String string) throws FileNotFoundException {
        return FS.getUTF8Writer(new FileOutputStream(string));
    }

    public static synchronized boolean isPortable() {
        return portable;
    }

    public static synchronized boolean isRestricted() {
        return restricted;
    }

    public static File[] listFiles(File file) {
        File[] fileArray = file.listFiles();
        return fileArray == null ? EMPTY_FILE_ARRAY : fileArray;
    }

    public static File[] listFiles(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles(fileFilter);
        return fileArray == null ? EMPTY_FILE_ARRAY : fileArray;
    }

    public static File[] listFiles(String string) {
        return FS.listFiles(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Info> listFileSystems(int n) {
        Flags flags = new Flags(n);
        ArrayList<Info> arrayList = new ArrayList<Info>();
        if (OS.isWindows()) {
            for (File file : File.listRoots()) {
                arrayList.add(new Info(file));
            }
        } else {
            Object object = null;
            try {
                String string = flags.isSet(1L) ? "/etc/fstab" : "/etc/mtab";
                boolean bl = flags.isSet(4L);
                Set<String> set = null;
                if (bl) {
                    set = TK.newHashSet("binfmt_misc", "devpts", "proc", "securityfs", "sysfs", "tmpfs");
                }
                object = new TextReader(new BufferedFileInput(string), "ISO-8859-1");
                Iterator<String> iterator = ((TextReader)object).iterator();
                block11: while (iterator.hasNext()) {
                    String object2 = iterator.next();
                    object2 = object2.trim();
                    if (object2.isEmpty() || object2.charAt(0) == '#') continue;
                    int n2 = 0;
                    Scanner scanner = new Scanner(object2);
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    while (scanner.hasNext()) {
                        switch (n2) {
                            case 0: {
                                string3 = scanner.next();
                                break;
                            }
                            case 1: {
                                string4 = scanner.next();
                                break;
                            }
                            case 2: {
                                string5 = scanner.next();
                            }
                        }
                        if (++n2 != 3) continue;
                        if (bl && string5 != null && set.contains(string5)) continue block11;
                        arrayList.add(new Info(new File(string4), string3, string5));
                        continue block11;
                    }
                }
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                for (File file : File.listRoots()) {
                    arrayList.add(new Info(file));
                }
            }
            finally {
                FS.close((Closeable)object);
            }
        }
        if (MLogger.isDebug("fs")) {
            for (Info info : arrayList) {
                MLogger.debug("fs", info.toString());
                MLogger.debug("fs", "mountPoint=\"%s\",device=\"%s\",type=\"%s\"", info.getValue(), info.getDevice(), info.getType());
            }
        }
        return arrayList;
    }

    public static String[] listNames(File file) {
        String[] stringArray = file.list();
        return stringArray == null ? TK.EMPTY_STRING_ARRAY : stringArray;
    }

    public static String[] listNames(String string) {
        return FS.listNames(new File(string));
    }

    public static File makeConfigFile(String string) {
        return FS.makeConfigFile(string, 0);
    }

    public static File makeConfigFile(String string, int n) {
        File file = new File(FS.getConfigDir(), string);
        if (n == 1) {
            file.mkdirs();
        }
        return file;
    }

    public static String makeConfigPath(String string) {
        return FS.makeConfigPath(string, 0);
    }

    public static String makeConfigPath(String string, int n) {
        String string2 = FS.makePath(FS.getConfigDir(), string);
        if (n == 1) {
            FS.mkdirs(string2);
        }
        return string2;
    }

    public static String makePath(String string, String string2) {
        if (TK.isEmpty(string)) {
            return string2;
        }
        if (TK.isEmpty(string2)) {
            return string;
        }
        return string + File.separator + string2;
    }

    public static boolean mkdir(String string) {
        return new File(string).mkdir();
    }

    public static boolean mkdirs(String string) {
        return new File(string).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String string) throws IOException {
        String string2;
        BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new BufferedFileInput(file);
            string2 = FS.read(bufferedFileInput, string, (int)file.length());
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
        return string2;
    }

    public static String read(InputStream inputStream, String string) throws IOException {
        return FS.read(inputStream, string, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream inputStream, String string, int n) throws IOException {
        String string2;
        TextReader textReader = null;
        try {
            String string3;
            textReader = new TextReader(inputStream, string);
            StringBuilder stringBuilder = new StringBuilder(Math.max(n, 0));
            while ((string3 = textReader.readLine()) != null) {
                stringBuilder.append(string3).append('\n');
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            FS.close(textReader);
            throw throwable;
        }
        FS.close(textReader);
        return string2;
    }

    public static String read(String string, String string2) throws IOException {
        return FS.read(new File(string), string2);
    }

    public static void readLines(BufferedReader bufferedReader, StringBuilder stringBuilder) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readLines(InputStream inputStream, String string, boolean bl) throws IOException {
        TextReader textReader = null;
        try {
            textReader = new TextReader(inputStream, string);
            StringBuilder stringBuilder = new StringBuilder(Math.max(inputStream.available(), 4096));
            FS.readLines(textReader, stringBuilder);
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        finally {
            if (bl) {
                FS.close(textReader);
            }
        }
    }

    public static boolean rename(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return file.renameTo(file2);
    }

    public static String replaceUnsafeCharacters(String string) {
        return string.replaceAll("(\\?|\\*|\\\\|/|\\:|\\\"|\\'|\\`)", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
        byte[] byArray = new byte[1024];
        try {
            SecureRandom secureRandom = new SecureRandom();
            long l = randomAccessFile.length();
            long l2 = 0L;
            while (l2 < l) {
                secureRandom.nextBytes(byArray);
                randomAccessFile.write(byArray);
                randomAccessFile.seek(l2 += (long)byArray.length);
            }
            FileDescriptor fileDescriptor = randomAccessFile.getFD();
            if (fileDescriptor != null) {
                fileDescriptor.sync();
            }
        }
        finally {
            FS.close(randomAccessFile);
        }
        if (!file.delete()) {
            throw new IOException("Could not delete file");
        }
    }

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL toURL(String string) {
        return FS.toURL(new File(string));
    }

    public static void write(File file, String string) throws IOException {
        FS.write(new FileOutputStream(file), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream outputStream, String string) throws IOException {
        TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(outputStream);
            if (string != null) {
                textWriter.write(string);
            }
            if (textWriter.checkError()) {
                throw new IOException("Text write error");
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    public static void write(String string, String string2) throws IOException {
        FS.write(new FileOutputStream(string), string2);
    }

    private FS() {
    }

    private static String getAbsolute(String string) {
        if (string.contains("../") || string.contains("..\\")) {
            return new File(string).getAbsolutePath();
        }
        return string;
    }

    static {
        restricted = true;
    }

    private static final class RegularFileFilter
    implements FileFilter {
        private RegularFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    private static final class LineIterator
    implements Iterator<String> {
        private boolean eof;
        private final BufferedReader reader;
        private String next;

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.eof) {
                throw new NoSuchElementException("EOF");
            }
            String string = this.next;
            this.readNextLine();
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private LineIterator(BufferedReader bufferedReader) {
            this.reader = bufferedReader;
            this.readNextLine();
        }

        private void readNextLine() {
            try {
                this.next = this.reader.readLine();
                this.eof = this.next == null;
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
            }
        }
    }

    private static final class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    public static final class TextWriter
    extends PrintWriter {
        private FileOutputStream fileOutputStream;

        public TextWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
            super(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
            if (outputStream instanceof FileOutputStream) {
                this.fileOutputStream = (FileOutputStream)outputStream;
            }
        }

        @Override
        public void close() {
            super.close();
            FS.close(this.fileOutputStream);
        }

        public boolean sync() {
            if (this.fileOutputStream != null) {
                try {
                    this.flush();
                    FileDescriptor fileDescriptor = this.fileOutputStream.getFD();
                    if (fileDescriptor != null) {
                        fileDescriptor.sync();
                    }
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return false;
        }
    }

    public static final class TextReader
    extends BufferedReader
    implements Iterable<String> {
        private FileInputStream fileInputStream;

        public TextReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
            super(new InputStreamReader(inputStream, string));
            if (inputStream instanceof FileInputStream) {
                this.fileInputStream = (FileInputStream)inputStream;
            }
        }

        public TextReader(Reader reader) {
            super(reader);
        }

        public TextReader(String string) {
            super(new StringReader(string));
        }

        @Override
        public void close() throws IOException {
            super.close();
            FS.close(this.fileInputStream);
        }

        @Override
        public Iterator<String> iterator() {
            return new LineIterator(this);
        }
    }

    public static interface ProgressListener {
        public boolean updateProgress(long var1, long var3);
    }

    public static final class Info
    extends Item<File> {
        private final String device;
        private final String type;

        public Info(File file) {
            this(file, null, null);
        }

        public Info(File file, String string, String string2) {
            super(TK.checkNull(file, "mountPoint"));
            this.device = string;
            this.type = string2;
            String string3 = file.getPath();
            if (string2 != null) {
                string3 = string3 + " (" + string2 + ")";
            }
            this.setText(string3);
        }

        public String getDevice() {
            return this.device;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class FileNameRegExpFilter
    implements FileFilter {
        private final RegExp regExp;

        public FileNameRegExpFilter(String string) {
            this.regExp = new RegExp(string);
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && this.regExp.matches(file.getName());
        }
    }

    public static final class FileExtensionFilter
    implements FileFilter {
        private final String[] extensions;

        public FileExtensionFilter(String ... stringArray) {
            this.extensions = TK.copyOf(stringArray);
        }

        @Override
        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            String string = FS.getExtension(file);
            for (String string2 : this.extensions) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class BufferedFileOutput
    extends BufferedOutputStream {
        public BufferedFileOutput(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
        }

        public BufferedFileOutput(File file, boolean bl) throws FileNotFoundException {
            super(new FileOutputStream(file, bl));
        }

        public BufferedFileOutput(String string) throws FileNotFoundException {
            super(new FileOutputStream(string));
        }

        public BufferedFileOutput(String string, boolean bl) throws FileNotFoundException {
            super(new FileOutputStream(string, bl));
        }

        public boolean sync() {
            if (this.out instanceof FileOutputStream) {
                try {
                    this.flush();
                    FileOutputStream fileOutputStream = (FileOutputStream)this.out;
                    FileDescriptor fileDescriptor = fileOutputStream.getFD();
                    if (fileDescriptor != null) {
                        fileDescriptor.sync();
                    }
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return false;
        }
    }

    public static final class BufferedFileInput
    extends BufferedInputStream {
        public BufferedFileInput(File file) throws FileNotFoundException {
            super(new FileInputStream(file));
        }

        public BufferedFileInput(String string) throws FileNotFoundException {
            super(new FileInputStream(string));
        }
    }
}

