/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.BasicPermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;

public final class Gettext {
    private static List<Object> catalogs;
    private static Map<String, String> cache;
    private static String language;
    private static String language_COUNTRY;

    public static boolean addCatalogFromClassPath(String string) {
        Gettext.checkPermission("addCatalogFromClassPath");
        return Gettext.loadClass(string, language) || Gettext.loadClass(string, language_COUNTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addCatalogFromProperties(String string) {
        Gettext.checkPermission("addCatalogFromProperties");
        try {
            MProperties mProperties;
            File file = new File(string, "i18n.jar");
            if (!file.exists()) {
                return false;
            }
            JarFile jarFile = new JarFile(file);
            InputStream inputStream = Gettext.getInput(jarFile, "i18n/" + language + ".properties");
            if (inputStream != null) {
                mProperties = new MProperties();
                mProperties.loadUTF8(inputStream);
            } else {
                inputStream = Gettext.getInput(jarFile, "i18n/" + language_COUNTRY + ".properties");
                if (inputStream != null) {
                    mProperties = new MProperties();
                    mProperties.loadUTF8(inputStream);
                } else {
                    return false;
                }
            }
            Class<Gettext> clazz = Gettext.class;
            synchronized (Gettext.class) {
                if (catalogs == null) {
                    catalogs = new ArrayList<Object>();
                }
                catalogs.add(mProperties);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return true;
            }
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return false;
        }
    }

    public static String getMetaInfo(String string) {
        String string2 = Gettext.translate("");
        if (string2 == null) {
            return null;
        }
        String string3 = string + ":";
        for (String string4 : TK.fastSplit(string2, '\n')) {
            if (string4 == null || !string4.startsWith(string3)) continue;
            return string4.substring(string3.length()).trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String string) {
        if (catalogs == null) {
            return string;
        }
        if (string == null) {
            MLogger.error("core", "Text to translate is null. Fix your code.");
            try {
                if (MLogger.isDeveloper()) {
                    MLogger.trace();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return string;
        }
        Class<Gettext> clazz = Gettext.class;
        synchronized (Gettext.class) {
            String string2 = cache.get(string);
            // ** MonitorExit[clazz] (shouldn't be in output)
            if (string2 != null) {
                return string2;
            }
            for (Object e : catalogs) {
                Object object;
                if (e instanceof ResourceBundle) {
                    try {
                        object = (ResourceBundle)e;
                        if (!((ResourceBundle)object).containsKey(string)) continue;
                        string2 = ((ResourceBundle)object).getString(string);
                        Class<Gettext> clazz2 = Gettext.class;
                        synchronized (Gettext.class) {
                            cache.put(string, string2);
                            // ** MonitorExit[clazz2] (shouldn't be in output)
                            return string2;
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!(e instanceof MProperties)) continue;
                try {
                    string2 = ((MProperties)MProperties.class.cast(e)).getProperty(string);
                    if (string2 == null) continue;
                    object = Gettext.class;
                    synchronized (Gettext.class) {
                        cache.put(string, string2);
                        // ** MonitorExit[object] (shouldn't be in output)
                        return string2;
                    }
                }
                catch (Exception exception) {
                }
            }
            return string;
        }
    }

    private Gettext() {
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private static InputStream getInput(JarFile jarFile, String string) {
        ZipEntry zipEntry = jarFile.getEntry(string);
        try {
            return zipEntry == null ? null : jarFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadClass(String string, String string2) {
        try {
            Class<Gettext> clazz = Gettext.class;
            synchronized (Gettext.class) {
                URL[] uRLArray = new URL[]{FS.toURL(string + "/i18n.jar")};
                Class<?> clazz2 = URLClassLoader.newInstance(uRLArray, Gettext.class.getClassLoader()).loadClass("Messages_" + string2);
                ResourceBundle resourceBundle = (ResourceBundle)clazz2.newInstance();
                if (catalogs == null) {
                    catalogs = new ArrayList<Object>();
                }
                catalogs.add(resourceBundle);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                MLogger.info("core", "Using UI language: %s", string2);
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    static String _(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(Gettext.translate(string), objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MLogger.error("core", "Invalid text/message format: \"%s\"", string);
            MLogger.exception(illegalArgumentException);
            return MessageFormat.format(string, objectArray);
        }
    }

    static {
        cache = new HashMap<String, String>(256);
        Locale locale = OS.getLocale();
        language = locale.getLanguage();
        if ("iw".equals(language)) {
            language = "he";
        }
        language_COUNTRY = language + "_" + locale.getCountry();
        try {
            if (!language_COUNTRY.equals("en_US")) {
                if (!Gettext.addCatalogFromClassPath(FS.getBaseDir())) {
                    Gettext.addCatalogFromClassPath(FS.getConfigDir());
                }
            } else {
                MLogger.info("core", "Using default UI language");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

