/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.ObjectView;
import org.makagiga.commons.FS;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.request.AbstractRequestManager;
import org.makagiga.commons.request.RequestInfo;
import org.makagiga.commons.request.RequestProperties;
import org.makagiga.commons.request.RequestSource;

public class HTMLViewFactory
implements ViewFactory {
    private boolean loadsSynchronously;
    private ImageDownloader imageDownloader;
    private ViewFactory impl;

    public HTMLViewFactory(ViewFactory viewFactory) {
        this(viewFactory, null);
    }

    public HTMLViewFactory(ViewFactory viewFactory, ImageDownloader imageDownloader) {
        this.impl = viewFactory;
        this.imageDownloader = imageDownloader;
    }

    @Override
    public View create(Element element) {
        View view = this.impl.create(element);
        if (view instanceof ImageView) {
            CachedImageView cachedImageView = new CachedImageView(element, this.imageDownloader);
            cachedImageView.setLoadsSynchronously(this.getLoadsSynchronously());
            return cachedImageView;
        }
        if (view instanceof ObjectView) {
            return new NoObjectView(element);
        }
        return view;
    }

    @Deprecated
    public boolean getHandleMakagigaIconProtocol() {
        return false;
    }

    public ImageDownloader getImageDownloader() {
        return this.imageDownloader;
    }

    public boolean getLoadsSynchronously() {
        return this.loadsSynchronously;
    }

    public void setLoadsSynchronously(boolean bl) {
        this.loadsSynchronously = bl;
    }

    private static final class NoObjectView
    extends ObjectView {
        @Override
        protected Component createComponent() {
            Element element = this.getElement();
            AttributeSet attributeSet = element.getAttributes();
            for (Object t : TK.iterable(attributeSet.getAttributeNames())) {
                Object object;
                if (!"movie".equals(t) || (object = attributeSet.getAttribute(t)) == null) continue;
                try {
                    URI uRI = new URI(object.toString());
                    MLinkButton mLinkButton = new MLinkButton(uRI, "<object/> " + uRI.getHost());
                    mLinkButton.setIcon(MIcon.small("player/start"));
                    return mLinkButton;
                }
                catch (URISyntaxException uRISyntaxException) {
                }
            }
            MLabel mLabel = MLabel.createSmall("<object/>", MIcon.small("ui/error"));
            mLabel.setToolTipText(UI._("Unsupported HTML Element"));
            return mLabel;
        }

        private NoObjectView(Element element) {
            super(element);
        }
    }

    public static interface ImageFactory {
        public Image getImage(ImageDownloader var1, URL var2) throws Exception;
    }

    public static class ImageDownloader
    extends AbstractRequestManager<Image> {
        private ImageFactory imageFactory;
        private final int downloadOptions;

        public ImageDownloader() {
            this(2);
        }

        public ImageDownloader(int n) {
            super(1, 0L);
            this.downloadOptions = n;
        }

        public ImageFactory getImageFactory() {
            return this.imageFactory;
        }

        public void setImageFactory(ImageFactory imageFactory) {
            this.imageFactory = imageFactory;
        }

        @Override
        protected Image getResult(RequestInfo<Image> requestInfo) throws Exception {
            URL uRL = requestInfo.getProperty("url", null);
            Image image = null;
            if (this.imageFactory != null) {
                image = this.imageFactory.getImage(this, uRL);
            }
            if (image != null) {
                return image;
            }
            return ImageIO.read(ImageDownloader.download(uRL, this.downloadOptions));
        }

        private static URL download(URL uRL, int n) {
            Net.DownloadInfo downloadInfo = new Net.DownloadInfo(uRL, ".image", n);
            try {
                downloadInfo.startDownload();
                return FS.toURL(downloadInfo.getFile());
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                return uRL;
            }
        }

        private void startDownload(RequestSource<Image> requestSource, URL uRL) {
            RequestProperties requestProperties = new RequestProperties();
            requestProperties.put("url", uRL);
            this.startRequest(requestSource, requestProperties);
        }
    }

    public static class CachedImageView
    extends ImageView
    implements RequestSource<Image> {
        private boolean borderColorAvailable = true;
        private boolean downloading;
        private Image image;
        private final WeakReference<ImageDownloader> imageDownloaderRef;

        public CachedImageView(Element element, ImageDownloader imageDownloader) {
            super(element);
            this.imageDownloaderRef = new WeakReference<ImageDownloader>(imageDownloader);
        }

        @Override
        public Image getImage() {
            return this.image != null ? this.image : super.getImage();
        }

        @Override
        public URL getImageURL() {
            String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            if (string == null) {
                return null;
            }
            URL uRL = super.getImageURL();
            if (uRL == null) {
                return null;
            }
            if ("file".equals(uRL.getProtocol())) {
                return uRL;
            }
            ImageDownloader imageDownloader = (ImageDownloader)this.imageDownloaderRef.get();
            if (imageDownloader != null && !this.getLoadsSynchronously()) {
                if (!this.downloading) {
                    this.downloading = true;
                    imageDownloader.startDownload(this, uRL);
                }
                return null;
            }
            return ImageDownloader.download(uRL, 2);
        }

        @Override
        public Icon getNoImageIcon() {
            return this.downloading ? this.getLoadingImageIcon() : super.getNoImageIcon();
        }

        @Override
        public void requestDone(RequestInfo<Image> requestInfo, Image image) {
            this.downloading = false;
            this.image = image;
            if (image != null) {
                this.setSize(this.image.getWidth(null), this.image.getHeight(null));
                try {
                    Field field = ImageView.class.getDeclaredField("width");
                    field.setAccessible(true);
                    field.setInt(this, this.image.getWidth(null));
                    Field field2 = ImageView.class.getDeclaredField("height");
                    field2.setAccessible(true);
                    field2.setInt(this, this.image.getHeight(null));
                    Method method = ImageView.class.getDeclaredMethod("updateImageSize", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (Exception exception) {
                    MLogger.exception(exception);
                }
                this.preferenceChanged(this, true, true);
            }
        }

        @Override
        protected void setPropertiesFromAttributes() {
            super.setPropertiesFromAttributes();
            if (this.borderColorAvailable) {
                try {
                    Field field = ImageView.class.getDeclaredField("borderColor");
                    field.setAccessible(true);
                    field.set(this, null);
                }
                catch (Exception exception) {
                    this.borderColorAvailable = false;
                    MLogger.exception(exception);
                }
            }
        }
    }
}

